<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Theme info
$theme["modif-date"] = "2007-12-16";
$theme["page-title"] = _("Paper details");

if (!isset($_POST["num-entries"]))
{
  die (_("No query passed to the page."));
}

$query_string = "INSERT INTO ".$config["ddDBPrefix"]."citation (source,destination) VALUES";
$source = db_encode($_POST["source"]);
for ($i = 0; $i < $_POST["num-entries"]; $i++)
{
  if (isset($_POST["guess-$i"]) && $_POST["guess-$i"] == "on")
  {
    $destination = db_encode($_POST["reference-$i"]);
    $query_string .= "('$source','$destination'),";
  }
}
$query_string = substr($query_string, 0, strlen($query_string) - 1);
$query_string .= " ON DUPLICATE KEY UPDATE source=source;\n";
// Adds the records
if ($query_string != "")
{
  $result = db_query($db, $query_string);
  if (!$result)
  {
    show_theme_part("page-header");
    show_theme_part("page-upper-body");
    echo _("No result; maybe key does not exist?  See below if MySQL says something.");
    echo db_error($db);
    close_page();
  }
}

// Automatically redirects to paper page
header("Location: ".paper_url($_POST["source-index"]));

// :folding=explicit:wrap=none:
?>
