<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `key` = ".$_GET["key"]." LIMIT 1;");
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}
$row = db_fetch_assoc_array($result);

// Checks if user has proper credentials for this operation
if ($config["mustLogin"])
{
  if (!isset($_SESSION["canEditPaper"]) || (!($_SESSION["canEditPaper"] === "all" || $row["ownerLogin"] == null ||
     ($_SESSION["canEditPaper"] === "onlymine" && $row["ownerLogin"] === $_SESSION["username"]))))
  {
    header("Location: permission-denied");
    exit();
  }
}

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Edit paper");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
  <h1><?php echo _("Edit paper");?></h1>
  <form name="getbibtex" method="post" action="<?php echo menu_url("paper-modify", $_GET["key"]); ?>">
  
  <table border="0" cellspacing="5">
  <tr>
    <td><b><?php echo _("Field name");?></b></td>
    <td><b><?php echo _("Value");?></b></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("BibTeX type");?></td>
    <td><select name="typeBibtex">
<?php
  if ($row["typeBibtex"] == "article")
    echo "<option value=\"article\" selected>article</option>\n";
  else
    echo "<option value=\"article\">article</option>\n";
  if ($row["typeBibtex"] == "book")
    echo "<option value=\"book\" selected>book</option>\n";
  else
    echo "<option value=\"book\">book</option>\n";
  if ($row["typeBibtex"] == "booklet")
    echo "<option value=\"booklet\" selected>booklet</option>\n";
  else
    echo "<option value=\"booklet\">booklet</option>\n";
  if ($row["typeBibtex"] == "conference")
    echo "<option value=\"conference\" selected>conference</option>\n";
  else
    echo "<option value=\"conference\">conference</option>\n";
  if ($row["typeBibtex"] == "inbook")
    echo "<option value=\"inbook\" selected>inbook</option>\n";
  else
    echo "<option value=\"inbook\">inbook</option>\n";
  if ($row["typeBibtex"] == "incollection")
    echo "<option value=\"incollection\" selected>incollection</option>\n";
  else
    echo "<option value=\"incollection\">incollection</option>\n";
  if ($row["typeBibtex"] == "inproceedings")
    echo "<option value=\"inproceedings\" selected>inproceedings</option>\n";
  else
    echo "<option value=\"inproceedings\">inproceedings</option>\n";
  if ($row["typeBibtex"] == "manual")
    echo "<option value=\"manual\" selected>manual</option>\n";
  else
    echo "<option value=\"manual\">manual</option>\n";
  if ($row["typeBibtex"] == "mastersthesis")
    echo "<option value=\"mastersthesis\" selected>mastersthesis</option>\n";
  else
    echo "<option value=\"mastersthesis\">mastersthesis</option>\n";
  if ($row["typeBibtex"] == "misc")
    echo "<option value=\"misc\" selected>misc</option>\n";
  else
    echo "<option value=\"misc\">misc</option>\n";
  if ($row["typeBibtex"] == "phdthesis")
    echo "<option value=\"phdthesis\" selected>phdthesis</option>\n";
  else
    echo "<option value=\"phdthesis\">phdthesis</option>\n";
  if ($row["typeBibtex"] == "proceedings")
    echo "<option value=\"proceedings\" selected>proceedings</option>\n";
  else
    echo "<option value=\"proceedings\">proceedings</option>\n";
  if ($row["typeBibtex"] == "phdthesis")
    echo "<option value=\"phdthesis\" selected>phdthesis</option>\n";
  else
    echo "<option value=\"phdthesis\">phdthesis</option>\n";
  if ($row["typeBibtex"] == "techreport")
    echo "<option value=\"techreport\" selected>techreport</option>\n";
  else
    echo "<option value=\"techreport\">techreport</option>\n";
  if ($row["typeBibtex"] == "unpublished")
    echo "<option value=\"unpublished\" selected>unpublished</option>\n";
  else
    echo "<option value=\"unpublished\">unpublished</option>\n";
  if ($row["typeBibtex"] == "collection")
    echo "<option value=\"collection\" selected>collection</option>\n";
  else
    echo "<option value=\"collection\">collection</option>\n";
  if ($row["typeBibtex"] == "patent")
    echo "<option value=\"patent\" selected>patent</option>\n";
  else
    echo "<option value=\"patent\">patent</option>\n";
?>
    </select></td>
  </tr>
  <?php if (trim($row["identifierBibtex"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("BibTeX identifier");?></td>
    <td><input type="text" name="identifierBibtex" value="<?php echo db_decode($row["identifierBibtex"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAbstract"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Abstract");?></td>
    <td><textarea name="bibtexAbstract" rows="5" cols="80"><?php echo db_decode($row["bibtexAbstract"]);?></textarea></td>
  </tr>
  <?php } if (trim($row["bibtexAddress"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Address");?></td>
    <td><input type="text" name="bibtexAddress" value="<?php echo db_decode($row["bibtexAddress"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAffiliation"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Affiliation");?></td>
    <td><input type="text" name="bibtexAffiliation" value="<?php echo db_decode($row["bibtexAffiliation"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAnnote"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Annote");?></td>
    <td><input type="text" name="bibtexAnnote" value="<?php echo db_decode($row["bibtexAnnote"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAuthor"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Author(s)");?></td>
    <td><input type="text" name="bibtexAuthor" value="<?php echo db_decode($row["bibtexAuthor"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexBibsource"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Bibsource");?></td>
    <td><input type="text" name="bibtexBibsource" value="<?php echo db_decode($row["bibtexBibsource"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexBooktitle"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Book title");?></td>
    <td><input type="text" name="bibtexBooktitle" value="<?php echo db_decode($row["bibtexBooktitle"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["categoryPath"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Category");?></td>
    <td><input type="text" name="categoryPath" value="<?php echo db_decode($row["categoryPath"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexChapter"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Chapter");?></td>
    <td><input type="text" name="bibtexChapter" value="<?php echo db_decode($row["bibtexChapter"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexContents"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Contents");?></td>
    <td><input type="text" name="bibtexContents" value="<?php echo db_decode($row["bibtexContents"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexCopyright"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Copyright");?></td>
    <td><input type="text" name="bibtexCopyright" value="<?php echo db_decode($row["bibtexCopyright"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexCrossref"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Cross-reference");?></td>
    <td><input type="text" name="bibtexCrossref" value="<?php echo db_decode($row["bibtexCrossref"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexEdition"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Edition");?></td>
    <td><input type="text" name="bibtexEdition" value="<?php echo db_decode($row["bibtexEdition"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexEditor"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Editor(s)");?></td>
    <td><input type="text" name="bibtexEditor" value="<?php echo db_decode($row["bibtexEditor"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexEe"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("EE");?></td>
    <td><input type="text" name="bibtexEe" value="<?php echo htmlentities(db_decode($row["bibtexEe"]));?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexHowpublished"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("How published");?></td>
    <td><input type="text" name="bibtexHowpublished" value="<?php echo db_decode($row["bibtexHowpublished"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexInstitution"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Institution");?></td>
    <td><input type="text" name="bibtexInstitution" value="<?php echo db_decode($row["bibtexInstitution"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexIsbn"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("ISBN");?></td>
    <td><input type="text" name="bibtexIsbn" value="<?php echo db_decode($row["bibtexIsbn"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexIssn"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("ISSN");?></td>
    <td><input type="text" name="bibtexIssn" value="<?php echo db_decode($row["bibtexIssn"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexJournal"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Journal");?></td>
    <td><input type="text" name="bibtexJournal" value="<?php echo db_decode($row["bibtexJournal"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexKey"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Key");?></td>
    <td><input type="text" name="bibtexKey" value="<?php echo db_decode($row["bibtexKey"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexKeywords"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Keywords");?></td>
    <td><input type="text" name="bibtexKeywords" value="<?php echo db_decode($row["bibtexKeywords"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexLanguage"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Language");?></td>
    <td><input type="text" name="bibtexLanguage" value="<?php echo db_decode($row["bibtexLanguage"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexLccn"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("LCCN");?></td>
    <td><input type="text" name="bibtexLccn" value="<?php echo db_decode($row["bibtexLccn"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["localUrlpdf"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Local PDF file");?>*</td>
    <td><input type="text" name="localUrlpdf" value="<?php echo db_decode($row["localUrlpdf"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["localUrlps"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Local PS file");?>*</td>
    <td><input type="text" name="localUrlps" value="<?php echo db_decode($row["localUrlps"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexLocation"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Location");?></td>
    <td><input type="text" name="bibtexLocation" value="<?php echo db_decode($row["bibtexLocation"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexMonth"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Month");?></td>
    <td><input type="text" name="bibtexMonth" value="<?php echo db_decode($row["bibtexMonth"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexNote"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Note");?></td>
    <td><input type="text" name="bibtexNote" value="<?php echo db_decode($row["bibtexNote"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexNumber"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Number");?></td>
    <td><input type="text" name="bibtexNumber" value="<?php echo db_decode($row["bibtexNumber"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexOrganization"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Organization");?></td>
    <td><input type="text" name="bibtexOrganization" value="<?php echo db_decode($row["bibtexOrganization"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexPages"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Pages");?></td>
    <td><input type="text" name="bibtexPages" value="<?php echo db_decode($row["bibtexPages"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["fullpapertext"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Plain text");?>*</td>
    <td><textarea name="fullpapertext" rows="10" cols="80"><?php echo htmlentities(db_decode($row["fullpapertext"]));?></textarea></td>
  </tr>  
  <?php } if (trim($row["bibtexPrice"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Price");?></td>
    <td><input type="text" name="bibtexPrice" value="<?php echo db_decode($row["bibtexPrice"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexPublisher"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Publisher");?></td>
    <td><input type="text" name="bibtexPublisher" value="<?php echo db_decode($row["bibtexPublisher"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexSchool"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("School");?></td>
    <td><input type="text" name="bibtexSchool" value="<?php echo db_decode($row["bibtexSchool"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexSeries"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Series");?></td>
    <td><input type="text" name="bibtexSeries" value="<?php echo db_decode($row["bibtexSeries"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexSize"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Size");?></td>
    <td><input type="text" name="bibtexSize" value="<?php echo db_decode($row["bibtexSize"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexTitle"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Title");?></td>
    <td><input type="text" name="bibtexTitle" value="<?php echo db_decode($row["bibtexTitle"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexType"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Type");?></td>
    <td><input type="text" name="bibtexType" value="<?php echo db_decode($row["bibtexType"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexUrl"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("URL");?></td>
    <td><input type="text" name="bibtexUrl" value="<?php echo htmlentities(db_decode($row["bibtexUrl"]));?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexVolume"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Volume");?></td>
    <td><input type="text" name="bibtexVolume" value="<?php echo db_decode($row["bibtexVolume"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexYear"]) != "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Year");?></td>
    <td><input type="text" name="bibtexYear" value="<?php echo db_decode($row["bibtexYear"]);?>" size="80" /></td>
  </tr>
  <?php } ?>

  <?php if (trim($row["identifierBibtex"]) == "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("BibTeX identifier");?></td>
    <td><input type="text" name="identifierBibtex" value="<?php echo db_decode($row["identifierBibtex"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAbstract"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Abstract");?></td>
    <td><textarea name="bibtexAbstract" rows="5" cols="80"><?php echo db_decode($row["bibtexAbstract"]);?></textarea></td>
  </tr>
  <?php } if (trim($row["bibtexAddress"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Address");?></td>
    <td><input type="text" name="bibtexAddress" value="<?php echo db_decode($row["bibtexAddress"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAffiliation"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Affiliation");?></td>
    <td><input type="text" name="bibtexAffiliation" value="<?php echo db_decode($row["bibtexAffiliation"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAnnote"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Annote");?></td>
    <td><input type="text" name="bibtexAnnote" value="<?php echo db_decode($row["bibtexAnnote"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexAuthor"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Author(s)");?></td>
    <td><input type="text" name="bibtexAuthor" value="<?php echo db_decode($row["bibtexAuthor"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexBibsource"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Bibsource");?></td>
    <td><input type="text" name="bibtexBibsource" value="<?php echo db_decode($row["bibtexBibsource"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexBooktitle"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Book title");?></td>
    <td><input type="text" name="bibtexBooktitle" value="<?php echo db_decode($row["bibtexBooktitle"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["categoryPath"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Category");?></td>
    <td><input type="text" name="categoryPath" value="<?php echo db_decode($row["categoryPath"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexChapter"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Chapter");?></td>
    <td><input type="text" name="bibtexChapter" value="<?php echo db_decode($row["bibtexChapter"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexContents"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Contents");?></td>
    <td><input type="text" name="bibtexContents" value="<?php echo db_decode($row["bibtexContents"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexCopyright"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Copyright");?></td>
    <td><input type="text" name="bibtexCopyright" value="<?php echo db_decode($row["bibtexCopyright"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexCrossref"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Cross-reference");?></td>
    <td><input type="text" name="bibtexCrossref" value="<?php echo db_decode($row["bibtexCrossref"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexEdition"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Edition");?></td>
    <td><input type="text" name="bibtexEdition" value="<?php echo db_decode($row["bibtexEdition"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexEditor"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Editor(s)");?></td>
    <td><input type="text" name="bibtexEditor" value="<?php echo db_decode($row["bibtexEditor"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexEe"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("EE");?></td>
    <td><input type="text" name="bibtexEe" value="<?php echo db_decode($row["bibtexEe"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexHowpublished"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("How published");?></td>
    <td><input type="text" name="bibtexHowpublished" value="<?php echo db_decode($row["bibtexHowpublished"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexInstitution"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Institution");?></td>
    <td><input type="text" name="bibtexInstitution" value="<?php echo db_decode($row["bibtexInstitution"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexIsbn"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("ISBN");?></td>
    <td><input type="text" name="bibtexIsbn" value="<?php echo db_decode($row["bibtexIsbn"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexIssn"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("ISSN");?></td>
    <td><input type="text" name="bibtexIssn" value="<?php echo db_decode($row["bibtexIssn"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexJournal"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Journal");?></td>
    <td><input type="text" name="bibtexJournal" value="<?php echo db_decode($row["bibtexJournal"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexKey"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Key");?></td>
    <td><input type="text" name="bibtexKey" value="<?php echo db_decode($row["bibtexKey"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexKeywords"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Keywords");?></td>
    <td><input type="text" name="bibtexKeywords" value="<?php echo db_decode($row["bibtexKeywords"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexLanguage"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Language");?></td>
    <td><input type="text" name="bibtexLanguage" value="<?php echo db_decode($row["bibtexLanguage"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexLccn"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("LCCN");?></td>
    <td><input type="text" name="bibtexLccn" value="<?php echo db_decode($row["bibtexLccn"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["localUrlpdf"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Local PDF file");?>*</td>
    <td><input type="text" name="localUrlpdf" value="<?php echo db_decode($row["localUrlpdf"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["localUrlps"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Local PS file");?>*</td>
    <td><input type="text" name="localUrlps" value="<?php echo db_decode($row["localUrlps"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexLocation"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Location");?></td>
    <td><input type="text" name="bibtexLocation" value="<?php echo db_decode($row["bibtexLocation"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexMonth"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Month");?></td>
    <td><input type="text" name="bibtexMonth" value="<?php echo db_decode($row["bibtexMonth"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexNote"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Note");?></td>
    <td><input type="text" name="bibtexNote" value="<?php echo db_decode($row["bibtexNote"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexNumber"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Number");?></td>
    <td><input type="text" name="bibtexNumber" value="<?php echo db_decode($row["bibtexNumber"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexOrganization"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Organization");?></td>
    <td><input type="text" name="bibtexOrganization" value="<?php echo db_decode($row["bibtexOrganization"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexPages"]) == "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Pages");?></td>
    <td><input type="text" name="bibtexPages" value="<?php echo db_decode($row["bibtexPages"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["fullpapertext"]) == "") { ?>
  <tr>
    <td valign="top" align="right"><?php echo _("Plain text");?>*</td>
    <td><textarea name="fullpapertext" rows="10" cols="80"><?php echo htmlentities(db_decode($row["fullpapertext"]));?></textarea></td>
  </tr>
  <?php } if (trim($row["bibtexPrice"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Price");?></td>
    <td><input type="text" name="bibtexPrice" value="<?php echo db_decode($row["bibtexPrice"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexPublisher"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Publisher");?></td>
    <td><input type="text" name="bibtexPublisher" value="<?php echo db_decode($row["bibtexPublisher"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexSchool"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("School");?></td>
    <td><input type="text" name="bibtexSchool" value="<?php echo db_decode($row["bibtexSchool"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexSeries"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Series");?></td>
    <td><input type="text" name="bibtexSeries" value="<?php echo db_decode($row["bibtexSeries"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexSize"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Size");?></td>
    <td><input type="text" name="bibtexSize" value="<?php echo db_decode($row["bibtexSize"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexTitle"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Title");?></td>
    <td><input type="text" name="bibtexTitle" value="<?php echo db_decode($row["bibtexTitle"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexType"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Type");?></td>
    <td><input type="text" name="bibtexType" value="<?php echo db_decode($row["bibtexType"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexUrl"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("URL");?></td>
    <td><input type="text" name="bibtexUrl" value="<?php echo db_decode($row["bibtexUrl"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexVolume"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Volume");?></td>
    <td><input type="text" name="bibtexVolume" value="<?php echo db_decode($row["bibtexVolume"]);?>" size="80" /></td>
  </tr>
  <?php } if (trim($row["bibtexYear"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right"><?php echo _("Year");?></td>
    <td><input type="text" name="bibtexYear" value="<?php echo db_decode($row["bibtexYear"]);?>" size="80" /></td>
  </tr>
  <?php } ?>
  </table>
  
  <p><input type="submit" value="Submit"/> <input type="reset" value="Reset"/></p>
  </form>
  <p>* <?php echo _("Indicates unofficial BibTeX fields");?></p>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
