<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Gets the row
$row = db_fetch_assoc_array($result);

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Paper full text");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Paper full text");?></h1>

<?php
if (isset($_GET["markdown"]) && $_GET["markdown"] != "0")
{
  echo "<p><a href=\"paper-full-text?key=".$_GET["key"].($_GET["full-text-query"] != "" ? "&amp;full-text-query=".$_GET["full-text-query"] : "")."\">Display as plain text</a></p>\n";
}
else
{
  echo "<p><a href=\"paper-full-text?markdown&amp;key=".$_GET["key"].($_GET["full-text-query"] != "" ? "&amp;full-text-query=".$_GET["full-text-query"] : "")."\">Display as Markdown</a></p>\n";
}
?>

<?php
if (isset($_GET["markdown"]) && $_GET["markdown"] != "0")
{
  $out = markdown(htmlentities(db_decode($row["fullpapertext"])));
}
else
{
  $out = (htmlentities(db_decode($row["fullpapertext"])));
}

// Highlights keywords if any
if (isset($_GET["full-text-query"]))
{
  $keywords = explode(" ", $_GET["full-text-query"]);
  if (count($keywords) > 0)
  {
    echo "<p>"._("Full text words").": ";
    $i = 0;
    foreach ($keywords as $k)
    {
      echo "<span class=\"highlight-$i\">$k</span> ";
      $out = preg_replace("/(".$k.")/i", "<span class=\"highlight-$i\" href>\$1</span>", $out);
      $i++;
    }
    echo "</p>\n\n";
  }
}

if (isset($_GET["markdown"]) && $_GET["markdown"] != "0")
{
  echo $out;
}
else
{
  echo "<pre>\n".wordwrap($out, 80)."\n</pre>\n";
}
?>

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-09";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
