<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

/**
 * Dumps the content of a text file into an string
 * @param $filename The name of the file
 * @return A string with the contents of the file, or false if file could
 *  not be opened.
 */
function readTheFile($filename) // {{{
{
  $theData = false;
  $fh = fopen($filename, "r");
  if ($fh)
  {
    $theData = fread($fh, filesize($filename));
    fclose($fh);
  }
  return $theData;
} // }}}

// Verifies if a GET request has been sent
if (!$_GET["key"] && !$_GET["name"])
{
  echo _("No author key or name passed to the page.");
  close_page();
}

$paper_key = false;
$paper_name_key = false;

if (isset($_GET["key"]))
{
  $paper_key = $_GET["key"];
  $paper_url_field = $paper_key;
}
else
{
  $paper_name_key = urldecode($_GET["name"]);
  $paper_url_field = $paper_name_key;
}

if ($_GET["type"] == "ps")
  $filetype = "ps";
else
  $filetype = "pdf";

// Fetches records from the database
if ($paper_key != false)
{
  $result = db_query($db, "SELECT localUrl$filetype as url FROM ".$config["ddDBPrefix"]."publication WHERE `key` = $paper_key LIMIT 1;");
}
else
{
  $result = db_query($db, "SELECT localUrl$filetype as url FROM ".$config["ddDBPrefix"]."publication WHERE `identifierBibtex` = '$paper_name_key' LIMIT 1;");
}
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}

// Gets the row
$row = db_fetch_assoc_array($result);

// Gets the filename
$filename = db_decode($row["url"]);

// Generates POST request
$crlf = "\r\n";
$host = $config["ddHost"];
$port = 80;
$request  = "GET ".$config["ddBaseDir"].$config["pub-dir"].encode_filename($filename)." HTTP/1.1".$crlf;
$request .= "Host: $host".$crlf;
$request .= "Keep-Alive: 300".$crlf;
$request .= "Connection: keep-alive".$crlf.$crlf;

// Retrieves the file
$contents = downloadToString($request, $host, $port);

// Reads the file and outputs it
if ($contents)
{
  if ($filetype == "ps")
    header("Content-type: application/postscript");
  else
    header("Content-type: application/pdf");
  echo $contents;
}
exit();
// :folding=explicit:
?>
