<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"] && !$_GET["name"])
{
  echo _("No author key or name passed to the page.");
  close_page();
}

$paper_key = false;
$paper_name_key = false;

if (isset($_GET["key"]))
{
  $paper_key = $_GET["key"];
  $paper_url_field = $paper_key;
}
else
{
  $paper_name_key = urldecode($_GET["name"]);
  $paper_url_field = $paper_name_key;
}

/**
 * Changes all href="p:key" URLs by URLs to the actual index.
 * Eventually, this function should be moved to a library file, but for
 * the moment this is the only page where it is used.
 */
function process_references($text) // {{{
{
  global $db, $config;
  $matches = array();
  $find_array = array();
  $replace_array = array();
  $num_matches = preg_match_all("/href\\s*?=\\s*?\"p:([^\"]*?)\"/i", $text, $matches, PREG_PATTERN_ORDER);
  foreach ($matches[1] as $inner_key)
  {
    array_push($find_array, "p:".$inner_key);
    array_push($replace_array, paper_url($inner_key));
  }
  $text = str_replace($find_array, $replace_array, $text);
  return $text;
} // }}}


// Fetches records from the database
if ($paper_key != false)
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `key` = $paper_key LIMIT 1;");
else
{
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `identifierBibtex` = '$paper_name_key' LIMIT 1;");
}
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}

// Gets the row
$row = db_fetch_assoc_array($result);

// Gets the BibTeX key
$source_key = db_decode($row["identifierBibtex"]);

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Paper details");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Paper details");?></h1>

<ul id="paper-details-buttons">
<li id="paper-details-button-edit"><a class="submenubar" href="<?php echo menu_url("paper-edit", $paper_key);?>"><?php echo _("Edit");?></a></li>
<li id="paper-details-button-export"><a class="submenubar" href="<?php echo menu_url("export-bibtex", $paper_key);?>"><?php echo _("Export BibTeX reference");?></a></li>

<?php
// Shows buttons about local PDF/PS files {{{
// Checks if user has proper credentials for this operation
if (!$config["mustLogin"] || isset($_SESSION["canSeeFile"]))
{
 if (!$config["mustLogin"] || ($_SESSION["canSeeFile"] === "all" || $row["ownerLogin"] == null ||
   ($_SESSION["canSeeFile"] === "onlymine" && $row["ownerLogin"] === $_SESSION["username"])))
 {
  // Url to local PS file if any
  if ($row["localUrlps"] != "")
  {
    echo "<li id=\"paper-details-button-view-ps\"><a class=\"submenubar\" target=\"_blank\" href=\"".menu_url("local-url-ps", $paper_key)."\">"._("View PS")."</a></li>\n";
  }
  ?>
  <?php
  // Url to local PDF file if any
  if ($row["localUrlpdf"] != "")
  {
    echo "<li id=\"paper-details-button-view-pdf\"><a class=\"submenubar\" target=\"_blank\" href=\"".menu_url("local-url-pdf", $paper_key)."\">"._("View PDF")."</a></li>\n";
  }
  ?>
  <?php
  // Url to full ASCII text if any
  if ($row["fullpapertext"] != "")
  {
    if (strlen($row["fullpapertext"]) > $config["min-paper-length"])
    {
      echo "<li id=\"paper-details-button-view-text\"><a class=\"submenubar\" href=\"".
        menu_url("paper-full-text", $paper_key, $_GET["full-text-query"])."\">"._("View plain text")."</a> (".number_format(strlen($row["fullpapertext"]) / 1024, 0)." kb)</li>\n";
      // Since a full paper text is available, we can manage citations
      echo "<li id=\"paper-details-button-citations\"><a class=\"submenubar\" href=\"".menu_url("paper-citations", $paper_key)."\">"._("Manage/discover citations")."</a></li>\n";
    }
    else // Text is too short to be the real text: announce it unavailable
    {
      echo "<li id=\"paper-details-button-view-text\">"._("Plain text unavailable")."</li>\n";
    }
  }
 }
} // }}}
?>
<li><a href="<?php echo menu_url("experimental", $row["identifierBibtex"]);?>">Show experimental</a></li>
</ul>

<div style="clear:both"/>

<table class="details" cellpadding="5" cellspacing="0">
<?php
// Displays the table with the paper details {{{
$count = 0;
$modulo = 2;
$out = "";
if ($row["bibtexTitle"] != "")
{
  $out .= "<tr id=\"table-head-bibtexTitle\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The work's title, typed as explained in the LaTeX book.\">Title</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(strip_accolades(db_decode($row["bibtexTitle"])))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAuthor"] != "")
{
  $out .= "<tr id=\"table-bibtexAuthor\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name(s) of the author(s), in the format described in the LaTeX book.\">Author(s)</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  // Process author list and back-references authors listed in the database
  $out .= format_author_list($db, db_decode($row["bibtexAuthor"]));
  $out .= "</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexEditor"] != "")
{
  $out .= "<tr id=\"table-bibtexEditor\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name(s) of the editor(s), in the format described in the LaTeX book.\">Editor(s)</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  // Process author list and back-references authors listed in the database
  $out .= format_author_list($db, db_decode($row["bibtexEditor"]));
  $out .= "</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}

if ($row["bibtexYear"] != "")
{
  $out .= "<tr id=\"table-bibtexYear\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The year of publication or, for an unpublished work, the year it was written.\">Year of publication</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexYear"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}

if ($row["categoryPath"] != "")
{
  $out .= "<tr id=\"table-categoryPath\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The category in which the entry is put.\">Category</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  $cats = explode(CAT_SEPARATOR, $row["categoryPath"]);
  foreach ($cats as $cat)
  {
    $caption = htmlentities(db_decode($cat));
    $out .= "<a href=\"".categories_url($cat)."\">".substr($caption, strlen(CAT_PATH), strlen($caption) - 2 * strlen(CAT_PATH))."</a><br/>";
  }
  $out .= "</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}

if ($row["bibtexCrossref"] != "")
{
  // Finds cross-reference in database if it exists
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE identifierBibtex = '".$row["bibtexCrossref"]."';");
  if (!$result)
    echo db_error($db);
  $row2 = db_fetch_assoc_array($result);
  if ($row2)
  {
    // The cross-reference is in the database
    $out .= "<tr id=\"table-bibtexCrossref\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The database key of the entry being cross referenced. Any fields that are missing from the current record are inherited from the field being cross referenced.\">Cross-reference</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".paper_url($row2["key"])."\">".htmlentities(db_decode($row["bibtexCrossref"]))."</a></td></tr>\n";
  }
  else
  {
    // The cross-reference is not in the database
    $out .= "<tr id=\"table-bibtexCrossref\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The database key of the entry being cross referenced. Any fields that are missing from the current record are inherited from the field being cross referenced.\">Cross-reference</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexCrossref"]))."</td></tr>\n";
  }
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexPages"] != "")
{
  $out .= "<tr id=\"table-bibtexPages\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"One or more page numbers or range of numbers.\">Pages</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexPages"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAddress"] != "")
{
  $out .= "<tr id=\"table-bibtexAddress\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Usually the address of the publisher or other type of institution. For major publishing houses, van Leunen recommends omitting the information entirely. For small publishers, on the other hand, you can help the reader by giving the complete address.\">Address</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexAddress"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAffiliation"] != "")
{
  $out .= "<tr id=\"table-bibtexAffiliation\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The authors affiliation.\">Affiliation</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexAffiliation"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAnnote"] != "")
{
  $out .= "<tr id=\"table-bibtexAnnote\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"An annotation. It is not used by the standard bibliography styles, but may be used by others that produce an annotated bibliography.\">Annote</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexAnnote"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexBooktitle"] != "")
{
  $out .= "<tr id=\"table-bibtexBooktitle\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Title of a book, part of which is being cited. See the LaTeX book for how to type titles. For book entries, use the title field instead.\">Booktitle</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"conference-details.php?key=".urlencode(htmlentities(db_decode($row["bibtexBooktitle"])))."\">".htmlentities(db_decode($row["bibtexBooktitle"]))."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexChapter"] != "")
{
  $out .= "<tr id=\"table-bibtexChapter\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"A chapter (or section or whatever) number.\"><abbr=\"\">Chapter</abbr></abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexChapter"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexCopyright"] != "")
{
  $out .= "<tr id=\"table-bibtexCopyright\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Copyright information.\">Copyright</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexCopyright"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexEdition"] != "")
{
  $out .= "<tr id=\"table-bibtexEdition\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The edition of a book---for example, \'Second\'.\">Edition</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexEdition"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexEe"] != "")
{
  if (strlen($row["bibtexEe"]) <= 80)
    $out .= "<tr id=\"table-bibtexEe\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"DOI reference\">EE</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".htmlentities(db_decode($row["bibtexEe"]))."\">".htmlentities(db_decode($row["bibtexEe"]))."</a></td></tr>\n";
  else
    $out .= "<tr id=\"table-bibtexEe\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"DOI reference\">EE</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".htmlentities(db_decode($row["bibtexEe"]))."\">".htmlentities(substr(db_decode($row["bibtexEe"]), 0, 80))."...</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexHowpublished"] != "")
{
  $out .= "<tr id=\"table-bibtexHowpublished\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"How something strange has been published. The first word should be capitalized.\">How published</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexHowpublished"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["identifierBibtex"] != "")
{
  $out .= "<tr id=\"table-identifierBibtex\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The identifier used by BibTeX.\">BibTeX identifier</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  $out .= "<a href=\"".menu_url("export-bibtex", $paper_key)."\">";
  $out .= htmlentities(db_decode($row["identifierBibtex"]))."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexInstitution"] != "")
{
  $out .= "<tr id=\"table-bibtexInstitution\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The sponsoring institution of a technical report.\">Institution</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexInstitution"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexIsbn"] != "")
{
  $out .= "<tr id=\"table-bibtexIsbn\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The International Standard Book Number.\">ISBN</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexIsbn"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexIssn"] != "")
{
  $out .= "<tr id=\"table-bibtexIssn\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The International Standard Serial Number. Used to identify a journal.\">ISSN</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexIssn"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexJournal"] != "")
{
  $out .= "<tr id=\"table-bibtexJournal\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"A journal name. Abbreviations are provided for many journals.\">Journal</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"journal.php?key=".urlencode(db_decode($row["bibtexJournal"]))."\">".htmlentities(db_decode($row["bibtexJournal"]))."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexKey"] != "")
{
  $out .= "<tr id=\"table-bibtexKey\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"BibTeX Key.\">BibTeX Key</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexKey"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexKeywords"] != "")
{
  $out .= "<tr id=\"table-bibtexKeywords\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Key words used for searching or possibly for annotation.\">Keywords</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexKeywords"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexLanguage"] != "")
{
  $out .= "<tr id=\"table-bibtexLanguage\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The language the document is in.\">Language</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  switch (strtolower(db_decode($row["bibtexLanguage"])))
  {
    case "english":
      $out .= "<div class=\"flag-uk\"><span>"._("English")."</span></div>";
      break;
    case "french":
      $out .= "<div class=\"flag-fr\"><span>"._("French")."</span></div>";
      break;
    case "italian":
      $out .= "<div class=\"flag-it\"><span>"._("Italian")."</span></div>";
      break;
    case "russian":
      $out .= "<div class=\"flag-ru\"><span>"._("Russian")."</span></div>";
      break;
    case "arabic":
      $out .= "<div class=\"flag-sa\"><span>"._("Arabic")."</span></div>";
      break;
    case "spanish":
      $out .= "<div class=\"flag-es\"><span>"._("Spanish")."</span></div>";
      break;
    case "german":
      $out .= "<div class=\"flag-de\"><span>"._("German")."</span></div>";
      break;
    case "chinese":
      $out .= "<div class=\"flag-kn\"><span>"._("Korean")."</span></div>";
      break;
    default:
      $out .= db_decode($row["bibtexLanguage"]);
      break;
  }
  $out .= "</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexLccn"] != "")
{
  $out .= "<tr id=\"table-bibtexLccn\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The Library of Congress Call Number. I've also seen this as lib-congress.\">LCCN</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexLccn"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexLocation"] != "")
{
  $out .= "<tr id=\"table-bibtexLocation\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"A location associated with the entry, such as the city in which a conference took place.\">Location</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexLocation"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexMonth"] != "")
{
  $out .= "<tr id=\"table-bibtexMonth\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The month in which the work was published or, for an unpublished work, in which it was written.\">Month</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexMonth"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexNumber"] != "")
{
  $out .= "<tr id=\"table-bibtexNumber\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The number of a journal, magazine, technical report, or of a work in a series.\">Number</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  $out .= "<a href=\"journal.php?key=".urlencode($row["bibtexJournal"])."&amp;volume=".$row["bibtexVolume"]."&amp;number=".$row["bibtexNumber"]."\">";
  $out .= htmlentities(db_decode($row["bibtexNumber"]))."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexOrganization"] != "")
{
  $out .= "<tr id=\"table-bibtexOrganization\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The organization that sponsors a conference or that publishes a manual.\">Organization</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexOrganization"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexPrice"] != "")
{
  $out .= "<tr id=\"table-bibtexPrice\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The price of the document.\">Price</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexPrice"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexPublisher"] != "")
{
  $out .= "<tr id=\"table-bibtexPublisher\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The publisher's name.\">Publisher</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexPublisher"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexSchool"] != "")
{
  $out .= "<tr id=\"table-bibtexSchool\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name of the school where a thesis was written.\">School</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexSchool"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexSeries"] != "")
{
  $out .= "<tr id=\"table-bibtexSeries\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name of a series or set of books.\">Series</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexSeries"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexSize"] != "")
{
  $out .= "<tr id=\"table-bibtexSize\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The physical dimensions of a work.\">Size</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexSize"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexType"] != "")
{
  $out .= "<tr id=\"table-bibtexType\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The type of a technical report---for example, \'Research Note\'.\">Type</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["bibtexType"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexVolume"] != "")
{
  $out .= "<tr id=\"table-bibtexVolume\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The volume of a journal or multi-volume book.\">Volume</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  $out .= "<a href=\"journal.php?key=".urlencode($row["bibtexJournal"])."&amp;volume=".$row["bibtexVolume"]."\">";
  $out .= htmlentities(db_decode($row["bibtexVolume"]))."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexUrl"] != "")
{
  if (strlen($row["bibtexUrl"]) <= 80)
    $out .= "<tr id=\"table-bibtexUrl\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The WWW Universal Resource Locator that points to the item being referenced.\">URL</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".htmlentities(db_decode($row["bibtexUrl"]))."\">".htmlentities(db_decode($row["bibtexUrl"]))."</a></td></tr>\n";
  else
    $out .= "<tr id=\"table-bibtexUrl\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The WWW Universal Resource Locator that points to the item being referenced.\">URL</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".htmlentities(db_decode($row["bibtexUrl"]))."\">".htmlentities(substr(db_decode($row["bibtexUrl"]), 0, 80))."...</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}

// Prints addition date/time
if ($row["insertionDate"] != "")
{
  $out .= "<tr id=\"table-bibtexDate\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The date this entry was added to the database.\">Creation date</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["insertionDate"]))." ".htmlentities(db_decode($row["insertionTime"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}

// Prints modification date/time
if ($row["lastEditiondate"] != "")
{
  $out .= "<tr id=\"table-bibtexEditiondate\"><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The date this entry was last modified.\">Last modified</abbr></td><td class=\"details-row-text-mod-".$count."\">".htmlentities(db_decode($row["lastEditiondate"]))." ".htmlentities(db_decode($row["lastEditiontime"]))."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
echo $out;
// }}}
?>
</table>

<?php
// Checks if paper is cross-referenced by other papers, and gives the list {{{
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE bibtexCrossref = '".$row["identifierBibtex"]."';");
if (!$result)
{
  echo db_error($db);
}
if (db_num_rows($result) > 0)
{
  echo "<h2>"._("Cross-references")."</h2>\n";
  echo "<p>"._("This paper is the BibTeX cross-reference for the following ").db_num_rows($result)._(" entrie(s).  This probably means the paper is a conference proceedings, or a book containing chapters.")."</p>\n";
  echo "<ul class=\"paperbullet\">\n";
  while ($row2 = db_fetch_assoc_array($result))
  {
    if ($row2["localUrlpdf"] || $row2["localUrlps"])
      echo "<li class=\"paperbullet\">\n";
    else
      echo "<li class=\"paperbullethollow\">\n";
    echo format_paper_entry($db, $row2, PRESENTATION_REGULAR)."\n</li>\n";
  }
  echo "</ul>\n";
} // }}}

// Shows abstract if any {{{
if ($row["bibtexAbstract"] != "")
{
  echo "<h2 id=\"header-abstract\" class=\"collapsible\" onclick=\"toggleCollapsible('abstract', 'header-abstract')\" title=\"Click on title to expand/collapse section\">"._("Paper abstract")."</h2>\n";
  echo "<div id=\"abstract\">\n";
  echo Markdown(urldecode($row["bibtexAbstract"]));
  echo "</div>\n";
} // }}}

// Shows references if any {{{
echo "<h2 id=\"header-citations\" class=\"collapsible\" onclick=\"toggleCollapsible('citations', 'header-citations')\" title=\"Click on title to expand/collapse section\">"._("Citations")."</h2>\n";
echo "<div id=\"citations\">\n";
echo "<p>"._("This section shows citation relations between entries in the database.")."</p>\n";
$dbpub = $config["ddDBPrefix"]."publication";
$dbcit = $config["ddDBPrefix"]."citation";
$query_string = "SELECT $dbpub.key, $dbpub.bibtexAuthor, $dbpub.bibtexTitle, $dbpub.bibtexYear, $dbpub.bibtexBooktitle FROM $dbcit, $dbpub WHERE $dbcit.source = '".$source_key."' AND $dbcit.destination = $dbpub.identifierBibtex ORDER BY $dbpub.bibtexYear;";
$result = db_query($db, $query_string);
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}
if (db_num_rows($result) > 0)
{
  echo "<h3>"._("Articles cited by this paper")."</h3>\n";
  echo "<ul class=\"paperbullet\">\n";
  while ($row2 = db_fetch_assoc_array($result))
  {
    echo "<li class=\"paperbullet\">\n";
    echo format_paper_entry($db, $row2);
    echo "</li>\n";
  }
  echo "</ul>\n";
}
$query_string = "SELECT $dbpub.key, $dbpub.bibtexAuthor, $dbpub.bibtexTitle, $dbpub.bibtexYear, $dbpub.bibtexBooktitle FROM $dbcit, $dbpub WHERE $dbcit.destination = '".$source_key."' AND $dbcit.source = $dbpub.identifierBibtex ORDER BY $dbpub.bibtexYear;";
$result = db_query($db, $query_string);
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}
if (db_num_rows($result) > 0)
{
  echo "<h3>"._("Articles that cite this paper")."</h3>\n";
  echo "<ul class=\"paperbullet\">\n";
  while ($row2 = db_fetch_assoc_array($result))
  {
    echo "<li class=\"paperbullet\">\n";
    echo format_paper_entry($db, $row2);
    echo "</li>\n";
  }
  echo "</ul>\n";
}
echo "</div>\n";
// }}}
?>

<h2 id="header-comments" class="collapsible" onclick="toggleCollapsible('comments', 'header-comments')" title="Click on title to expand/collapse section"><?php echo _("Comments");?></h2>

<p><a href="comment-add.php?paperKey=<?php echo $paper_key;?>"><?php echo _("Add a comment");?></a></p>

<?php
// Plain-text comments if any {{{
// Checks if user has proper credentials for this operation
if (!$config["mustLogin"] || isset($_SESSION["canSeeComments"]))
{
  $query_string = "SELECT * FROM ".$config["ddDBPrefix"]."comment WHERE paperKey = $paper_key";
  if (!$config["mustLogin"] && $_SESSION["canSeeComments"] === "onlymine" && $row["ownerLogin"] != null)
  {
    $query_string .= " AND commentAuthor = '".$_SESSION["username"]."'";
  }
  $query_string .= " ORDER BY commentDate DESC;";
  $result = db_query($db, $query_string);
  if (!$result)
  {
    echo _("No result; maybe key does not exist?  See below if MySQL says something.");
    echo db_error($db);
    close_page();
  }
  if (db_num_rows($result) > 0)
  {
    echo "<div id=\"comments\">\n";
    echo "<dl class=\"comment-entries\">\n";
    while ($row2 = db_fetch_assoc_array($result))
    {
      echo "<dt>";
      echo "<a name=\"comment-".$row2["commentKey"]."\"></a>";
      
      if ($row2["commentType"] === "summary")
        echo "<span class=\"summary\">";
      else
        echo "<span>";
      echo $row2["commentDate"];
      if ($row2["commentAuthor"] !== null)
      {
        echo " "._("by")." ".$row2["commentAuthor"];
      }
      echo "</span>\n";
      echo "<a class=\"button-delete-comment\" href=\"comment-deleted.php?commentKey=".$row2["commentKey"]."&amp;paperKey=$paper_key\" title=\""._("Delete comment")."\"><span>"._("Delete")."</span></a>\n";
      echo "<a class=\"button-edit-comment\" href=\"comment-edit.php?commentKey=".$row2["commentKey"]."&amp;paperKey=$paper_key\" title=\""._("Edit comment")."\"><span>"._("Edit")."</span></a>\n";
      echo "</dt>\n";
      echo "<dd>\n";
      $comments_text = Markdown(urldecode(db_decode($row2["commentText"])));
      $comments_text = process_references($comments_text);
      echo $comments_text;
      echo "</dd>\n";
    }
    echo "</dl>\n";
    echo "</div>\n";
  }
} // }}}
?>

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-16";
show_theme_part("page-lower-body");
// :folding=explicit:
?>
