/*
 *  libdoclone - library for cloning GNU/Linux systems
 *  Copyright (C) 2015 Joan Lledó <joanlluislledo@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DOMERRORHANDLER_H_
#define DOMERRORHANDLER_H_

#include <stdint.h>

#include <vector>

#include <xercesc/dom/DOMErrorHandler.hpp>

#include <xercesc/util/XMLString.hpp>

XERCES_CPP_NAMESPACE_USE

namespace Doclone {

/**
 * \class XMLErrorHandler
 *
 * \brief XML parsing error management.
 *
 * \date June, 2015
 */
class XMLErrorHandler : public DOMErrorHandler {
public:
	XMLErrorHandler();

	bool handleError(const DOMError& domError);
	void resetErrors();

	bool getErrors();
private:
	///If an error have occurred
	bool _errors;
};

}

#endif /* DOMERRORHANDLER_H_ */
