/*
 * Color.cs - Color values.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Curses
{

/// <summary>
/// <para>The <see cref="T:Curses.Color"/> type represents curses
/// color values.</para>
/// </summary>
public enum Color
{
	/// <summary>
	/// <para>The default color value.</para>
	/// </summary>
	///
	/// <remarks>
	/// <para>When the application is started, the terminal may already
	/// have certain colors configured by the user as the default foreground
	/// and background colors.  The application can adapt its display
	/// to these color values so that it appears the way the user may
	/// have intended for the terminal.</para>
	/// </remarks>
	Default	= -1,

	/// <summary>
	/// <para>The black color value.</para>
	/// </summary>
	Black	=  0,

	/// <summary>
	/// <para>The red color value.</para>
	/// </summary>
	Red		=  1,

	/// <summary>
	/// <para>The green color value.</para>
	/// </summary>
	Green	=  2,

	/// <summary>
	/// <para>The yellow color value.</para>
	/// </summary>
	Yellow	=  3,

	/// <summary>
	/// <para>The blue color value.</para>
	/// </summary>
	Blue	=  4,

	/// <summary>
	/// <para>The magenta color value.</para>
	/// </summary>
	Magenta	=  5,

	/// <summary>
	/// <para>The cyan color value.</para>
	/// </summary>
	Cyan	=  6,

	/// <summary>
	/// <para>The white color value.</para>
	/// </summary>
	White	=  7

} // enum Color

} // namespace Curses
