#inv.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file controls the inventory screen.
from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import tkMessageBox
import g
import main

global listbox_array
listbox_array = []

#these variables hold the name of the wielded equipment
weapon_name = StringVar()
armor_name = StringVar()
shield_name = StringVar()
helmet_name = StringVar()
gloves_name = StringVar()
boots_name = StringVar()

help_text = StringVar()

#currently selected button. 0=Drop, 1=Wear/Use, 2=Save, 3=Remove, 4=Leave
cur_button = 0


#distance from the left of the button canvas each button should be placed.
#Values are added in init_window. drop is not needed; always zero.
use_height = 0
remove_height = 0
save_height = 0
leave_height = 0


#called when "Save" is pressed
def inv_savegame():
	g.savegame(g.name)
	main.print_message("** Game Saved **")
	help_text.set("Game Saved")

#called when "Leave" is pressed
def leave_inv():
	try:
		window_inv.destroy()
	except TclError:
		pass

#puts a worn item into the inventory. Called from the remove button.
def rm_equip():
	if (len(listbox_equip.curselection()) > 0):
		try: item_num = map(int, listbox_equip.curselection())
		except ValueError: pass
		if g.equip[item_num[0]] != -1:
			if -1 != g.take_inv_item(g.equip[item_num[0]]):
				main.print_message("You take off your " +
					g.item[g.equip[item_num[0]]][0])
				g.equip[item_num[0]] = -1
	refresh_inv()

#takes an item from the inventory, and wears it.
def wear_item():
	#put the item[] index of the item into item_value
	try:
		item_num = map(int, listbox_inv.curselection())
	except ValueError: pass

	try:
		item_value = listbox_array[item_num[0]]
	except IndexError:
		return 0

	#put the equip slot into item_loc
	item_loc = g.item[item_value][1]

	#if item is equipment
	if item_loc < 6:
		#trade the item and whatever's in the equip slot
		temp = g.equip[item_loc]
		g.equip[item_loc] = item_value
		g.drop_inv_item(item_num[0])
		g.take_inv_item(temp)
		main.print_message("You equip yourself with your " + 
			g.item[g.equip[item_loc]][0] + ".")
		refresh_inv()

#drops an item from the inventory. Uses the
#position of the listbox_inv listbox
def drop_item():
	try: item_num = map(int, listbox_inv.curselection())
	except ValueError: pass
	try:
		item_to_delete = g.find_inv_item(listbox_array[item_num[0]])
	except IndexError: return 0

	if tkMessageBox.askyesno("Drop?", "Drop your " +
			g.item[g.inv[item_to_delete]][0] + "?", parent=window_inv):
		main.print_message("You drop your " + g.item[g.inv[item_num[0]]][0])
		g.drop_inv_item(item_num[0])

	refresh_inv()

#called when "Use" is pressed
def use_item():
	#put the item[] index of the item into item_value
	try: item_num = map(int, listbox_inv.curselection())
	except ValueError: pass

	try: item_value = listbox_array[item_num[0]]
	except IndexError: return 0

	#put the equip slot into item_loc
	item_loc = g.item[item_value][1]

	main.print_message("You use your " + g.item[item_value][0])
	#if item is healing
	if item_loc == 11:
		#heal the player, delete the item
		g.hp=g.hp + g.item[item_value][2]
		g.drop_inv_item(item_num[0])
		if g.hp >= g.maxhp: g.hp = g.maxhp

	refresh_inv()


#refresh buttons.
def refresh_buttons(event=0):
	canvas_buttons.delete(ALL)
	if (cur_button == 0):
		canvas_buttons.create_image(0, 0, anchor=NW, image=drop_button_sel)
		help_text.set("Drop item")
	else: canvas_buttons.create_image(0, 0, anchor=NW, image=drop_button)
	if (cur_button == 1):
		#switch between equip and use, based on the current item.
		try: item_num = map(int, listbox_inv.curselection())
		except ValueError: pass
		try:
			item_value = listbox_array[item_num[0]]
			item_loc = g.item[item_value][1]
		except IndexError: item_loc = 50

		if (item_loc <= 6):
			canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=equip_button_sel)
			help_text.set("Equip item")
		else:
			canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=use_button_sel)
			help_text.set("Use item")
	else:
		try: item_num = map(int, listbox_inv.curselection())
		except ValueError: pass
		try:
			item_value = listbox_array[item_num[0]]
			item_loc = g.item[item_value][1]
		except IndexError: item_loc = 50

		if (item_loc <= 6): canvas_buttons.create_image(use_height, 0,
					anchor=NW, image=equip_button)
		else: canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=use_button)
	if (cur_button == 2):
		canvas_buttons.create_image(save_height, 0,
					anchor=NW, image=save_button_sel)
		help_text.set("Save game")
	else: canvas_buttons.create_image(save_height, 0, anchor=NW,
							image=save_button)
	if (cur_button == 3):
		canvas_buttons.create_image(remove_height, 0,
					anchor=NW, image=remove_button_sel)
		help_text.set("Remove equipment")
	else: canvas_buttons.create_image(remove_height, 0, anchor=NW,
							image=remove_button)
	if (cur_button == 4):
		canvas_buttons.create_image(leave_height, 0,
					anchor=NW, image=leave_button_sel)
		help_text.set("Leave inventory")
	else: canvas_buttons.create_image(leave_height, 0, anchor=NW,
							image=leave_button)

#refresh this screen. Call after moving around items.
def refresh_inv():
	#place current position into item_num[0], for restoring position.
	try: item_num = map(int, listbox_inv.curselection())
	except ValueError: pass
	try: equip_num = map(int, listbox_equip.curselection())
	except ValueError: pass
	#clear and rebuild listbox_inv
	listbox_inv.delete(0, END)
	listbox_array[0:len(listbox_array)] = []
	for i in g.inv:
		if i != -1:
			listbox_array.append(i)
			listbox_inv.insert(END, g.item[i][0])

	#rebuild the equipment display
	listbox_equip.delete(0, END)
	temp = g.item[g.equip[0]][0]
	if g.equip[0] == -1: temp = ""
	listbox_equip.insert(END, "Weapon: " + temp)

	temp = g.item[g.equip[1]][0]
	if g.equip[1] == -1: temp = ""
	listbox_equip.insert(END, "Armor: " + temp)

	temp = g.item[g.equip[2]][0]
	if g.equip[2] == -1: temp = ""
	listbox_equip.insert(END, "Shield: " + temp)

	temp = g.item[g.equip[3]][0]
	if g.equip[3] == -1: temp = ""
	listbox_equip.insert(END, "Helmet: " + temp)

	temp = g.item[g.equip[4]][0]
	if g.equip[4] == -1: temp = ""
	listbox_equip.insert(END, "Gloves: " + temp)

	temp = g.item[g.equip[5]][0]
	if g.equip[5] == -1: temp = ""
	listbox_equip.insert(END, "Boots: " + temp)

	#restore the position.
	if (cur_button == 3): #equipment
		try:
			if (equip_num[0] < listbox_equip.size()):
				listbox_equip.selection_set(equip_num[0])
			else:
				if (listbox_equip.size() > 0):
					listbox_equip.selection_set(equip_num[0] - 1)
		except IndexError:
			listbox_equip.selection_set(0)
	else: #inventory
		try:
			if (item_num[0] < listbox_inv.size()):
				listbox_inv.selection_set(item_num[0])
			else:
				if (listbox_inv.size() > 0):
					listbox_inv.selection_set(item_num[0] - 1)
		except IndexError:
			listbox_inv.selection_set(0)
	main.recalc_stats()


#All keypresses in window_inv pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	if (key_name == "esc"):
		leave_inv()
		return 0
	elif (key_name == "right"):
		cur_button += 1
		if (cur_button == 5): cur_button = 0
		if (cur_button == 0): #switch to items
			listbox_equip.select_clear(0, END)
			if (len(listbox_inv.curselection()) == 0):
				listbox_inv.selection_set(0)
		if (cur_button == 3): #switch to equipment
			listbox_inv.select_clear(0, END)
			if (len(listbox_equip.curselection()) == 0):
				listbox_equip.selection_set(0)
	elif (key_name == "left"):
		cur_button -= 1
		if (cur_button == -1): cur_button = 4
		if (cur_button == 1): #switch to items
			listbox_equip.select_clear(0, END)
			if (len(listbox_inv.curselection()) == 0):
				listbox_inv.selection_set(0)
		if (cur_button == 3): #switch to equipment
			listbox_inv.select_clear(0, END)
			if (len(listbox_equip.curselection()) == 0):
				listbox_equip.selection_set(0)
	elif (key_name == "up"):
		try: item_num = map(int, listbox_inv.curselection())
		except ValueError: pass
		try: #inv listbox
			if (item_num[0] != 0):
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(item_num[0] - 1)
			else:
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(END)
		except IndexError: #equip listbox
			try:
				try: item_num = map(int, listbox_equip.curselection())
				except ValueError: pass
				if (item_num[0] != 0):
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(item_num[0] - 1)
				else:
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(END)
			except IndexError: pass
	elif (key_name == "down"):
		try: item_num = map(int, listbox_inv.curselection())
		except ValueError: pass
		try:
			if (item_num[0] != listbox_inv.size() - 1):
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(item_num[0] + 1)
			else:
				listbox_inv.select_clear(0, END)
				listbox_inv.selection_set(0)
		except IndexError:
			try: item_num = map(int, listbox_equip.curselection())
			except ValueError: pass
			try:
				if (item_num[0] != listbox_equip.size() - 1):
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(item_num[0] + 1)
				else:
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(0)
			except IndexError: pass
	elif (key_name == "return"):
		if (cur_button == 0): drop_item()
		elif (cur_button == 1):
			if (help_text.get() == "Equip item"): wear_item()
			else: use_item()
		elif (cur_button == 2):
			inv_savegame()
			return 0
		elif (cur_button == 3): rm_equip()
		elif (cur_button == 4):
			leave_inv()
			return 0
	refresh_buttons()

def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

def mouse_handler_click(event=0):
	key_handler("return")

def mouse_handler_move(event=0):
	global cur_button
	if (event.x < use_height):
		cur_button = 0
		listbox_equip.select_clear(0, END)
		if (len(listbox_inv.curselection()) == 0):
			listbox_inv.selection_set(0)
	elif (event.x < save_height):
		cur_button = 1
		listbox_equip.select_clear(0, END)
		if (len(listbox_inv.curselection()) == 0):
			listbox_inv.selection_set(0)
	elif (event.x < remove_height): cur_button = 2
	elif (event.x < leave_height):
		cur_button = 3
		listbox_inv.select_clear(0, END)
		if (len(listbox_equip.curselection()) == 0):
			listbox_equip.selection_set(0)
	else: cur_button = 4
	refresh_buttons()

def init_window_inv():
	#create the window
	global window_inv
	global bgcolour
	bgcolour = "lightgrey"
	window_inv = Frame(main.top, bd=2, relief=SUNKEN, bg=bgcolour)
	window_inv.grid(row=1, column=5, columnspan=13, rowspan=13, sticky=E)


	#fill in inventory boxs. The .grid on the separate line is important.
	global listbox_inv
	listbox_inv = Listbox(window_inv, height=10, takefocus=0, bg=bgcolour)
	listbox_inv.grid(row=2, column=1, rowspan=10, sticky=N+W+E)
	global listbox_equip
	listbox_equip = Listbox(window_inv, height=10, takefocus=0, bg=bgcolour)
	listbox_equip.grid(row=2, column=2, rowspan=10, sticky=N+W+E)


	#Button pictures, both selected and normal.
	global drop_button; global drop_button_sel
	global wear_button; global wear_button_sel
	global use_button; global use_button_sel
	global equip_button; global equip_button_sel
	global save_button; global save_button_sel
	global remove_button; global remove_button_sel
	global leave_button; global leave_button_sel

	drop_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/drop.png")
	wear_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip.png")
	use_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use.png")
	equip_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip.png")
	save_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/save.png")
	remove_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/remove.png")
	leave_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave.png")

	drop_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/drop_sel.png")
	wear_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip_sel.png")
	use_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use_sel.png")
	equip_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip_sel.png")
	save_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/save_sel.png")
	remove_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/remove_sel.png")
	leave_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave_sel.png")

	#location of the various buttons.
	global use_height; use_height = drop_button.width()
	global save_height; save_height = use_height + use_button.width()
	global remove_height; remove_height = save_height + save_button.width()
	global leave_height; leave_height = remove_height + remove_button.width()

	#Button canvas.
	global canvas_buttons
	canvas_buttons = Canvas(window_inv, height=leave_button_sel.height(),
		width=leave_height+leave_button.width(), bg=bgcolour)
	canvas_buttons.grid(column=1, row=13, columnspan=2)


	#bindings
	main.window_main.bind("<Escape>", key_handler_esc)
	main.window_main.bind("<Return>", key_handler_return)
	main.window_main.bind("<Up>", key_handler_up)
	main.window_main.bind("<Down>", key_handler_down)
	main.window_main.bind("<Left>", key_handler_left)
	main.window_main.bind("<Right>", key_handler_right)
	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)
	listbox_inv.bind("<ButtonRelease-1>", refresh_buttons)

	label_help = Label(window_inv, bg=bgcolour,
		textvariable=help_text).grid(row=1, column=1, columnspan=2)

	listbox_inv.select_set(0)
	refresh_inv()
	refresh_buttons()

	window_inv.master.wait_window(window_inv)
