#file: shop.py
#Copyright (C) 2005 Free Software Foundation
#see GPL.txt for license.

#This file controls the town shops.


from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import main
import g
import item



#location of the store in the g.shops[] array
global store_num
store_num = 0

#width/height of inv and shop windows, in tiles.
# (g.tilesize + the 3 pixel border)
shop_width = 4
shop_height = 7

#Currently selected item number
curr_item = 0
#If inv (0) or shop (1) has focus.
curr_focus = 1

#currently selected button: 0=sell 1=leave 2=buy
cur_button=2

leave_height=0
buy_height=0
sell_height=0

#array containing the item[] index of all inventory items.
#Used to determine which item to sell/drop
#global listbox_inv_array
#listbox_inv_array = []

#variables for the middle info display
item_name  = StringVar()
item_cost  = StringVar()
item_power = StringVar()
item_desc  = StringVar()
curr_gold  = StringVar()
curr_skill = StringVar()

#refresh the button canvas
def refresh_buttons(event=0):
	canvas_buttons.delete(ALL)
	if (cur_button == 0):
	    canvas_buttons.create_image(0, 0, anchor=NW, image=sell_button_sel)
	else:
	    canvas_buttons.create_image(sell_height, 0, anchor=NW, image=sell_button)

	if (cur_button == 1):
	    canvas_buttons.create_image(leave_height, 0, anchor=NW, image=leave_button_sel)
	else:
	    canvas_buttons.create_image(leave_height, 0, anchor=NW, image=leave_button)

	if (cur_button == 2):
	    canvas_buttons.create_image(buy_height, 0, anchor=NW, image=buy_button_sel)
	else:
    	    canvas_buttons.create_image(buy_height, 0, anchor=NW, image=buy_button)


#refresh the inventory canvas
def refresh_inv():
	canvas_inv.delete("item")
	invpos = 0
	#if the inv is selected, draw a selection box around the current item.
	if curr_focus == 0:
		canvas_inv.create_rectangle(
				(curr_item%shop_width)*g.tilesize +
							2 * ((curr_item%shop_width)+1),
				(curr_item/shop_width)*g.tilesize +
							2 * ((curr_item/shop_width)+1),
				((curr_item%shop_width)+1)*(g.tilesize + 2),
				((curr_item/shop_width)+1)*(g.tilesize + 2),
							fill=g.fill_sel_colour, tags="item")

	#draw the item pictures.
	for i in range(len(item.inv)):
		if item.inv[i] != -1:
			canvas_inv.create_image((i%shop_width)*g.tilesize + 2 *
												((i%shop_width)+1),
				(i/shop_width)*g.tilesize + 2 * ((i/shop_width)+1),
				image=g.tiles[item.item[item.inv[i]].picturename],
				anchor="nw", tags="item")
			invpos += 1

	#set gold and skillpoints
	curr_gold.set("Gold: " + str(g.gold))
	curr_skill.set("Skillpoints: " + str(g.skillpoints))
	main.recalc_stats()

#Actually sets the info in the middle of the shop screen.
def set_details(name, cost, costtype, power, description):
	item_name.set(name)
	if cost != "": item_cost.set("Cost: " + str(cost) + " " + costtype)
	else: item_cost.set("")
	if power == "" or power == "-1": item_power.set("")
	else: item_power.set("Power: " + str(power))
	canvas_desc.delete("all")
	canvas_desc.create_text(1, 5, anchor=NW,
		text=description, width=142)

#show info for a selected item in the middle of the window.
def show_details(event=0, sel_item=-1):
	#The use of sel_item gives the ability to look at an item without selecting
	#it, while working normally the rest of the time.
	if sel_item == -1: sel_item = curr_item
	if curr_focus == 0:  #inv
		if sel_item < len(item.inv):
			if item.inv[sel_item] != -1:
				tempitem = item.item[item.inv[sel_item]]
				set_details(tempitem.name, tempitem.price, "gold",
									tempitem.quality, tempitem.description)
		#if there is no item selected, blank details.
			else: set_details("", "", "", "", "")
		else: set_details("", "", "", "", "")

	else:  #shop
		if sel_item < len(g.shops[store_num].itemlist):
			tempitem = g.shops[store_num].itemlist[sel_item]
			set_details(tempitem.item_name, tempitem.cost, tempitem.buytype,
										tempitem.power, tempitem.description)
		else: set_details("", "", "", "", "")

#place appropriate items into the store.
def refresh_shop():
	canvas_shop.delete("item")
	invpos = 0
	#if the shop is selected, draw a selection box around the current item.
	if curr_focus == 1:
		canvas_shop.create_rectangle(
				(curr_item%shop_width)*g.tilesize + 2 *
												((curr_item%shop_width)+1),
				(curr_item/shop_width)*g.tilesize + 2 *
												((curr_item/shop_width)+1),
				((curr_item%shop_width)+1)*(g.tilesize + 2),
				((curr_item/shop_width)+1)*(g.tilesize + 2),
												fill=g.fill_sel_colour, tags="item")

	#draw the item pictures.
	for i in range(len(g.shops[store_num].itemlist)):
		if i != -1:
			canvas_shop.create_image((invpos%shop_width)*g.tilesize + 2 *
													((invpos%shop_width)+1),
				(invpos/shop_width)*g.tilesize + 2 * ((invpos/shop_width)+1),
				image=g.tiles[g.shops[store_num].itemlist[i].picture],
				anchor="nw", tags="item")
			invpos += 1

#called upon pressing "Sell". Uses the selected item.
def sell_item():
	if curr_focus != 0: return 0
	if curr_item > len(item.inv): return 0
	if item.inv[curr_item] == -1: return 0

	if item.item[item.inv[curr_item]].price == 0:
		main.print_message("You feel attached to your " +
			item.item[item.inv[curr_item]].name)
		return 0
	#give the player money
	#note that all stores have a 5 year, money-back guarantee,
	#and accept returns from other stores as well.
	#This means there is no need to doublecheck intent. ;)
	main.print_message("You sell your " + item.item[item.inv[curr_item]].name
		+ ".")
	g.gold = int(g.gold) + item.item[item.inv[curr_item]].price

	#remove the item
	item.drop_inv_item(curr_item)
	refresh_inv()
	refresh_shop()
	show_details()


#Call on pressing "Buy". Uses the selected item.
def buy_item():
	if curr_focus != 1: return 0
	if curr_item >= len(g.shops[store_num].itemlist): return 0

	if (g.shops[store_num].itemlist[curr_item].buytype == "gold"):
		#if enough gold
		if int(g.shops[store_num].itemlist[curr_item].cost) <= int(g.gold):
			#if no actions were given
			if (len(g.shops[store_num].itemlist[curr_item].actions) == 0):
				#if given successfully.
				if (main.action.activate_line(0, 0, 0, "item " +
						g.shops[store_num].itemlist[curr_item].item_name)
						== 1):
					main.print_message("You buy a " +
					g.shops[store_num].itemlist[curr_item].item_name + ".")
					g.gold = int(g.gold) - \
					int(g.shops[store_num].itemlist[curr_item].cost)
				else: #not enough room
					main.print_message("Your inventory is full.")
			else:
				for script_line in \
						g.shops[store_num].itemlist[curr_item].actions:
					temp = main.action.activate_line(0, 0, 0, script_line)
					if temp == "end" or main.dead_yet() == 1:
						show_details()
						refresh_inv()
						return
				g.gold = int(g.gold) - \
				int(g.shops[store_num].itemlist[curr_item].cost)
	else: #skillpoints
		#if enough skillpoints
		if int(g.shops[store_num].itemlist[curr_item].cost) <= \
													int(g.skillpoints):
			#if no actions were given
			if (len(g.shops[store_num].itemlist[curr_item].actions) == 0):
				#if given successfully.
				if (main.action.activate_line(0, 0, 0, "item " +
						g.shops[store_num].itemlist[curr_item].item_name)
						== 1):
					main.print_message("You buy a " +
					g.shops[store_num].itemlist[curr_item].item_name + ".")
					g.skillpoints = int(g.skillpoints) - \
					int(g.shops[store_num].itemlist[curr_item].cost)
			else:
				for script_line in \
						g.shops[store_num].itemlist[curr_item].actions:
					temp = main.action.activate_line(0, 0, 0, script_line)
					if temp == "end" or main.dead_yet() == 1:
						show_details()
						refresh_inv()
						return
				g.skillpoints = int(g.skillpoints) - \
				int(g.shops[store_num].itemlist[curr_item].cost)

	refresh_inv()
	refresh_shop()
	show_details()

#Used in mouse_sel_inv and mouse_sel_shop. Takes x y coordinates, and returns
#the selected box, or -1 for none.
def which_box(x, y):
	if x < 3: return -1
	tempx = x - 3
	likelyx = tempx / (g.tilesize + 2)
	tempx = tempx - (likelyx * (g.tilesize + 2))
	if tempx >= g.tilesize - 1: return -1

	if y < 3: return -1
	tempy = y - 3
	likelyy = tempy / (g.tilesize + 2)
	tempy = tempy - (likelyy * (g.tilesize + 2))
	if tempy >= g.tilesize - 1: return -1

	return likelyy * shop_width + likelyx

#called when the user releases the mouse in the inv canvas.
def mouse_sel_inv(event=0):
	#decide if the mouse is within one of the boxes.
	global curr_item
	global curr_focus
	temp_num =  which_box(event.x, event.y)
	if temp_num == -1: return
	curr_item = temp_num
	curr_focus = 0
	refresh_inv()
	refresh_shop()
	show_details()

#called when the user releases the mouse in the shop canvas.
def mouse_sel_shop(event=0):
	#decide if the mouse is within one of the boxes.
	global curr_item
	global curr_focus
	temp_num =  which_box(event.x, event.y)
	if temp_num == -1: return
	curr_item = temp_num
	curr_focus = 1
	refresh_inv()
	refresh_shop()
	show_details()


def leave_shop(event=0):
	try:
		window_shop.destroy()
	except TclError:
		pass

def mouse_handler_click(event=0):
	key_handler("return")

def mouse_handler_move(event=0):
        global cur_button
        if (event.x < leave_height):
                cur_button = 0
        elif (event.x < buy_height):
                cur_button = 1
        else: cur_button = 2
        refresh_buttons()

#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(switch):
	global curr_item
	global cur_button
	global curr_focus
	#switch based on keycode
	if (switch == "esc"):
		leave_shop()
		return
	elif (switch == "return"):
		if(curr_focus == 1 and cur_button == 2): buy_item()
		elif(curr_focus !=1 and cur_button == 0): sell_item()
		elif(cur_button == 1):
		    leave_shop()
		    return
	elif (switch == "left"):
		if (curr_item % shop_width == 0):  #move between lists
			if curr_focus == 0:
				curr_focus = 1
				cur_button = 2
			else:
				curr_focus = 0
				cur_button = 0
			curr_item += shop_width
		curr_item -= 1
	elif (switch == "right"):
		if (curr_item % shop_width == shop_width - 1):  #move between lists
			if curr_focus == 0:
				curr_focus = 1
				cur_button = 2
			else:
				curr_focus = 0
				cur_button = 0
			curr_item -= shop_width
		curr_item += 1
	elif (switch == "up"):
		curr_item = curr_item - shop_width
		if curr_item < 0:
			curr_item += shop_width * shop_height
	elif (switch == "down"):
		curr_item = curr_item + shop_width
		if curr_item >= shop_width * shop_height:
			curr_item -= shop_width * shop_height

	refresh_inv()
	refresh_shop()
	refresh_buttons()
	show_details()

#Python does not appear to allow arguments in callbacks. Grumble.
# Yes, I think it does.  take a look at the use of lambda in the
# map editor.
def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

#create window_shop
def init_window_shop(store_type_input):
	global window_shop
	global bgcolour
	bgcolour = "lightgrey"
	window_shop = Frame(main.top, bd=2, relief=SUNKEN, bg=bgcolour)
	window_shop.grid(row=1, column=5, columnspan=13, sticky=E)

	global curr_item
	curr_item = 0
	global curr_focus
	curr_focus = 1
	global cur_button
	cur_button = 2

	global store_num
	for i in range(len(g.shops)):
		if (g.shops[i].name == store_type_input):
			store_num = i
			break

	#Inventory canvas
	temp_canvas_width=(g.tilesize*shop_width)+ ((shop_width+1)*2) + 1
	temp_canvas_height=(g.tilesize*shop_height)+ ((shop_height+1)*2) + 1
	global canvas_inv
	canvas_inv = Canvas(window_shop, width=temp_canvas_width,
		height=temp_canvas_height, highlightthickness=0, bg=g.outline_colour)
	canvas_inv.grid(column=1, row=3, columnspan=2, rowspan=16)
	#outside border
	canvas_inv.create_rectangle(0,0, temp_canvas_width-1, temp_canvas_height-1)
	#per-item borders
	for y in range(shop_height):
		for x in range(shop_width):
			canvas_inv.create_rectangle(x*g.tilesize + 2 * (x+1),
										y*g.tilesize + 2 * (y+1),
										(x+1)*(g.tilesize + 2),
										(y+1)*(g.tilesize + 2), fill=g.fill_colour)

	#Shop canvas
	global canvas_shop
	canvas_shop = Canvas(window_shop, width=temp_canvas_width,
		height=temp_canvas_height, highlightthickness=0, bg=g.outline_colour)
	canvas_shop.grid(column=6, row=3, columnspan=2, rowspan=16)
	#outside border
	canvas_shop.create_rectangle(0,0, temp_canvas_width-1, temp_canvas_height-1)
	#per-item borders
	for y in range(shop_height):
		for x in range(shop_width):
			canvas_shop.create_rectangle(x*g.tilesize + 2 * (x+1),
										y*g.tilesize + 2 * (y+1),
										(x+1)*(g.tilesize + 2),
										(y+1)*(g.tilesize + 2), fill=g.fill_colour)

	#Info labels
	label_name = Label(window_shop, textvar=item_name,
		wraplength=143, bg=bgcolour).grid(row=8, column=3, sticky=W)
	label_cost = Label(window_shop,
		textvar=item_cost, bg=bgcolour).grid(row=9, column=3, sticky=W)
	label_power = Label(window_shop,
		textvar=item_power, bg=bgcolour).grid(row=11, column=3, sticky=W)

	global canvas_desc
	canvas_desc = Canvas(window_shop, width=143, highlightthickness=0,
			bg=bgcolour)
	canvas_desc.grid(row=12, column=3, rowspan=8, sticky=NSEW)

	label_skill = Label(window_shop, textvar=curr_skill, anchor=SW,
		bg=bgcolour).grid(row=18, column=3, sticky=SW)
	label_gold = Label(window_shop, textvar=curr_gold, anchor=NW,
		bg=bgcolour).grid(row=19, column=3, sticky=W)


	#Buttons
	global sell_button; global sell_button_sel
	global buy_button; global buy_button_sel
	global leave_button; global leave_button_sel


	sell_button =  ImageTk.PhotoImage(file=g.mod_directory + \
	                "/images/buttons/sell.png")
	sell_button_sel =  ImageTk.PhotoImage(file=g.mod_directory + \
	                "/images/buttons/sell_sel.png")
	buy_button =  ImageTk.PhotoImage(file=g.mod_directory + \
	                "/images/buttons/buy.png")
	buy_button_sel =  ImageTk.PhotoImage(file=g.mod_directory + \
	                "/images/buttons/buy_sel.png")
	leave_button =  ImageTk.PhotoImage(file=g.mod_directory + \
	                "/images/buttons/leave_shop.png")
	leave_button_sel =  ImageTk.PhotoImage(file=g.mod_directory + \
	                "/images/buttons/leave_shop_sel.png")

	global leave_height; leave_height = sell_button.width()
	global buy_height; buy_height = leave_height + leave_button.width()

	global canvas_buttons
	canvas_buttons = Canvas(window_shop, height=buy_button_sel.height(),
		width=buy_height+buy_button.width(), bg=bgcolour)
	canvas_buttons.grid(column=1, row=29, columnspan=8)


#	global button_sell
#	button_sell = Button(window_shop, text="Sell", command=sell_item,
#		bg=bgcolour)
#	button_sell.grid(row=28, column=1)
#	global button_buy
#	button_buy  = Button(window_shop, text="Buy",  command=buy_item,
#		bg=bgcolour)
#	button_buy.grid(row=28, column=6)
#	button_leave= Button(window_shop, text="Leave",
#		command=leave_shop, bg=bgcolour).grid(row=28, column=3)

	#get data in listboxes
	refresh_inv()
	refresh_shop()
	refresh_buttons()

	#bindings
	canvas_shop.bind("<ButtonRelease-1>", mouse_sel_shop)
	canvas_inv.bind("<ButtonRelease-1>",  mouse_sel_inv)
	main.window_main.bind(g.binding_cancel, key_handler_esc)
	main.window_main.bind(g.binding_left, key_handler_left)
	main.window_main.bind(g.binding_right, key_handler_right)
	main.window_main.bind(g.binding_up, key_handler_up)
	main.window_main.bind(g.binding_down, key_handler_down)
	main.window_main.bind(g.binding_action, key_handler_return)
	main.window_main.bind(g.binding_inv, key_handler)
	main.window_main.bind(g.binding_save, key_handler)
	main.window_main.bind(g.binding_quit, key_handler)
	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
        canvas_buttons.bind("<Motion>", mouse_handler_move)

	show_details()
	window_shop.master.wait_window(window_shop)


