#battle.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#this file controls the battle window.

from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import g
import main
import action
import monster
import inv

from player import *

mon_index = 0

#mon_hp = StringVar()
hp = StringVar()
ep = StringVar()
monstername = StringVar()
monsterattack = StringVar()
monsterdefense = StringVar()

back_to_main = StringVar()

help_text = StringVar()
return_from_dialog = StringVar()

#location of the various buttons. (Pixels from the left of the canvas)
attack_button_loc = 0
item_button_loc = 0
skill_button_loc = 0
inspect_button_loc = 0
run_button_loc = 0
final_button_loc = 0

button_y_start = 0
button_height = 0

#did you run from this battle? Used for scripting.
did_run = 0

#currently selected button. 0=attack, 1=run/leave, 2=use item, 3=use skill
cur_button = 0

#Copy of monster.monster_groups[mon_index].monster_list.
#Used to reduce line length.
monster_list = []

#Number of times you've tried to run from this monster.
#Used to allow better chances after a while.
run_attempts = 0

#x location of the monster hp bar per monster. Used to redraw it.
base_mon_hp_start = []
base_mon_hp_width = []
#y location of the monster hp bar per monster. Used to redraw it.
base_mon_hp_y_start = []
base_mon_hp_height = []

#the currently selected monster.
active_button = -1

#gem usage stuff
used_gem = 0
num_dice = 1
old_attack = 0

#upper-left of the background/monster display.
monster_start = (0, 0)



#refreshes the battle view. Call after changing anything.
def refresh():
	#hp/ep bars
	for i in range(len(monster_list)):
		main.canvas_map.itemconfig("mon_hp"+str(i),
			text=str(monster_list[i].hp) + "/" +
			str(monster_list[i].maxhp))

		temp_width = base_mon_hp_width[i]*int(monster_list[i].hp) / \
											int(monster_list[i].maxhp)
		if temp_width < 0: temp_width=0
		main.canvas_map.coords("monster_hp_rect"+str(i),
				base_mon_hp_start[i],
				base_mon_hp_y_start[i],
				base_mon_hp_start[i] + temp_width,
				base_mon_hp_y_start[i]+5)

	#refresh the player hp bar
	main.canvas_map.itemconfig("player_hp",
		text=str(player.hp) + "/" + str(player.adj_maxhp))

	temp_width = base_mon_hp_width[0]*int(player.hp) / \
											int(player.adj_maxhp)
	if temp_width < 0: temp_width=0
	main.canvas_map.coords("player_hp_bar",
			monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2,
			monster_start[1]+background_pic.height()-hero_pic.height()*3/2-2,
			monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2+temp_width,
			monster_start[1]+background_pic.height()-hero_pic.height()*3/2+3,)

	#refresh the player ep bar
	main.canvas_map.itemconfig("player_ep",
		text=str(player.ep) + "/" + str(player.adj_maxep))

	temp_width = base_mon_hp_width[0]*int(player.ep) / \
											int(player.adj_maxep)
	if temp_width < 0: temp_width=0
	main.canvas_map.coords("player_ep_bar",
			monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2,
			monster_start[1]+background_pic.height()-hero_pic.height(),
			monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2+temp_width,
			monster_start[1]+background_pic.height()-hero_pic.height()+5)

	#Draw the monster selection arrow if needed.
	main.canvas_map.delete("monster_arrow")
	global active_button
	if active_button != -1:
		main.canvas_map.create_image(
			base_mon_hp_start[active_button],
			base_mon_hp_y_start[active_button]-20,
			anchor=N, image=g.buttons["sword_pointer.png"],
			tags=("monster_arrow", "battle"))
	main.recalc_stats()



#attack button was pressed
def attack(event=0):
	global active_button
	if can_leave() == 1: return 0
	if active_button == -1: last_mon_num = select_monster()
	else: last_mon_num = active_button
	if last_mon_num == -1: return 0
	global cur_button
	cur_button = 0
	clear_slashes()

	#Both hp's *should* be over 0. Just a precaution.
	if monster_list[last_mon_num].hp > 0 and player.hp > 0:
		attack_monster(last_mon_num, player.adj_attack)
	global used_gem
	global num_dice
	if used_gem == 1:
	   player.adj_attack = old_attack
	   main.recalc_stats()
	   num_dice = 1
	   used_gem = 0
	attack_player()
	if can_leave() == 0:
		active_button = -1
		monster_mouse_move(event)
		refresh()
		refresh_buttons()


#Returns the array location in monster_list of the monster the player wants to
#attack, or -1 on cancel. If more than one monster exists, displays a selection
#arrow.
def select_monster():
	#find out if we need to make the player select a monster.
	num_of_monsters = 0
	last_mon_num = 0
	for i in range(len(monster_list)):
		if monster_list[i].hp > 0:
			num_of_monsters += 1
			last_mon_num = i

	#If there is only one living monster, last_mon_num holds the array location
	#in monster_list[]. Otherwise, ask the player which monster to attack.
	if num_of_monsters == 1: return last_mon_num
	action.has_dialog = 1
	global active_button
	for i in range(len(monster_list)):
		if monster_list[i].hp > 0:
			active_button = i
			break
	else:
		print "BUG: select_monster called when all monsters were dead"
		return -1

	global return_from_dialog
	return_from_dialog.set("0")

	#bindings
	bind_attack_keys()

	#Don't want an inv box in the way:
	inv.leave_inner()
	if main.canvas_map.winfo_exists():
		main.canvas_map.delete("skill")
		main.canvas_map.delete("use")

	refresh()
	#wait. Continue after activate_yesno() is run.
	g.window_main.wait_variable(return_from_dialog)
	#cleanup
	if return_from_dialog.get() == "2":
		return -1
	else:
		bind_keys()

		action.has_dialog = 0
		refresh()
		return active_button

#Cycle through the various monsters when attacking. Used by the keyboard.
def choose_monster_prev(event=None):
	global active_button
	i = active_button
	while 1==1:
		i -= 1
		if i == -1:
			i = len(monster_list) - 1
		if monster_list[i].hp > 0:
			active_button = i
			break
		if i == active_button:
			print "choose_monster_prev couldn't find a monster."
			active_button = -1
			return -1
	help_text.set("Attack the " + monster_list[active_button].name)
	set_description_text(active_button)
	refresh()

def choose_monster_next(event=None):
	global active_button
	i = active_button
	while 1==1:
		i += 1
		if i == len(monster_list):
			i = 0
		if monster_list[i].hp > 0:
			active_button = i
			break
		if i == active_button:
			print "choose_monster_next couldn't find a monster."
			active_button = -1
			return -1
	help_text.set("Attack the " + monster_list[active_button].name)
	set_description_text(active_button)
	refresh()

#called on Return when the yesno dialog box is active.
def choose_monster(event=None):
	global return_from_dialog
	return_from_dialog.set("1")

#Cancels the monster selection. Called on Esc.
def cancel_monster(event=None):
	global active_button
	active_button = -1
	global return_from_dialog
	return_from_dialog.set("1")

#Called whenever the mouse moves in the monster canvas. Used to select the
#proper monster, given the x and y location of the mouse.
def monster_mouse_move(event=None):
	try:
		global active_button
		for i in range(len(monster_list)):
			if monster_list[i].hp > 0:
				if event.x >= base_mon_hp_start[i] and \
				event.x <= base_mon_hp_start[i] + base_mon_hp_width[i] and \
				event.y >= base_mon_hp_y_start[i] - base_mon_hp_height[i] and \
				event.y <= base_mon_hp_y_start[i]:
					active_button = i
					help_text.set("Attack the " + monster_list[i].name)
					set_description_text(i)
					refresh()
	except AttributeError:
		active_button = -1

#attack the i'th monster in monster_list[], with an attack of power attack_power.
def attack_monster(i, attack_power):
	if i == -1: return
	global cur_mon_hp
	#find the damage done
	global num_dice
	damage = g.die_roll(num_dice, attack_power + 2)
	damage = damage - g.die_roll(1, monster_list[i].defense + 2)
	if damage > 0:
		if monster_hurt(i, damage) == 1:
			return 0
	else:
		main.print_message("You miss the " +
				monster_list[i].name + ".")

#Make all monsters attack the player.
def attack_player():
	for i in range(len(monster_list)):
		if monster_list[i].hp > 0 and player.hp > 0:
			attack_player_per_monster(i)


#Make the i'th monster attack you
def attack_player_per_monster(i):
	damage = g.die_roll(1, monster_list[i].attack + 2)
	damage = damage - g.die_roll(1, player.adj_defense + 2)
	if damage > 0:
		main.print_message("The " + monster_list[i].name +
		" hits you for " + str(damage) + " damage.")
		player.give_stat("hp", -1*damage)
		monster_slashed("h")
		#you dead yet?
		if player.hp <= 0:
			player.hp = 0
			main.print_message("The " + monster_list[i].name +
			" kills you.")
			cur_button = 1
			refresh()
			refresh_buttons()

	elif monster_list[i].hp > 0:
		main.print_message("The " + monster_list[i].name +
		" misses you.")


#places a slash mark over the i'th monster, to indicate a hit, or "h" for the
#hero.
def monster_slashed(i):
	if len(main.canvas_map.find_withtag("hit"+str(i))) == 0:
		if str(i) == "h":
			x, y = main.canvas_map.coords("hero")
			main.canvas_map.create_image(
				x, y+g.tiles["people/hero_n.png"].height()/2,
				anchor=E, image=g.buttons["slash_attack.png"],
				tags=("hit"+str(i), "battle"))
		else:
			main.canvas_map.create_image(
				base_mon_hp_start[i]+base_mon_hp_width[i]/2,
				base_mon_hp_y_start[i]-10,
				anchor=S, image=g.buttons["slash_attack.png"],
				tags=("hit"+str(i), "battle"))

#clears slashmarks for all monsters, and the hero.
def clear_slashes():
	for i in range(len(monster_list)):
		main.canvas_map.delete("hit"+str(i))
	main.canvas_map.delete("hith")

#Hurts monster i for damage points. Kills it if the damage is great enough.
def monster_hurt(i, damage):
	monster_list[i].hp = monster_list[i].hp - damage
	if damage > 0:
		monster_slashed(i)
		main.print_message("The " + monster_list[i].name
			+ " is hit for " + str(damage) + " damage")
	#you kill it?
	if monster_list[i].hp <= 0:
		monster_dead(i)
		return 1
	return 0

#use to reward the player for killing a monster
def monster_dead(i):
	global active_button
	#make the display look better
	monster_list[i].hp = 0
	#add info to listbox_move; add gold and xp
	main.print_message("The " + monster_list[i].name +
	" dies.")

	if len(monster_list[i].on_death) == 0:
		gold = monster_list[i].gold
		player.give_stat("gold", gold)
		main.print_message("You find " + str(gold) + " "+g.gold_name.lower()+",")

		exp = monster_list[i].exp
		main.print_message("and get " + str(exp) + " "+g.exp_name.lower()+".")
		player.add_exp(exp)
	else:
		action.activate_lines(g.xgrid, g.ygrid, g.zgrid,
					monster_list[i].on_death)

	#finish up
	if can_leave() == 1:
		main.canvas_map.delete("battle")
		back_to_main.set("2")
		g.cur_window = "main"
		global did_run
		did_run = 0
	else:
		for i in range(len(monster_list)):
			if monster_list[i].hp > 0:
				active_button = i
				break
		refresh()

#returns 1 if battle is finished, (one of the parties is dead) or 0 if not.
def can_leave():
#	if window_battle.winfo_exists() == 0: return 1
	if player.hp <= 0:
		return 1
	for i in range(len(monster_list)):
		if monster_list[i].hp > 0:
			return 0
	return 1


#run/leave/quit button was pressed
def runaway():
	global run_attempts
	global did_run
	clear_slashes()
	try:
		#leave/quit
		if can_leave() == 1:
			main.canvas_map.delete("battle")
			back_to_main.set("2")
		#Attempt to run. Testers get better chance.
		else:
			if g.die_roll(1, 10+run_attempts) > 7 or \
					(player.name == "testing123" and g.die_roll(1, 10) > 5):
				main.canvas_map.delete("battle")
				back_to_main.set("2")
				main.print_message("You coward! You ran away from the "
					+ monster.monster_groups[mon_index].name + ".")
				did_run = 1
			else:
				run_attempts += 1
				main.print_message("You fail to run away.")
				attack_player()
				refresh()
	except TclError:
		pass


#The use item button was pressed in the battle window. Open the
#item display.
def open_item_menu():
	#don't do anything if battle is over.
	if can_leave() == 1:
		return 0
	inv.open_inner_menu("use")
	bind_item_keys()
	inv.inner_cur_button = 0
#	g.window_main.update_idletasks()
	inv.refresh_inv_display("use")
	inv.refresh_inner_buttons("use")
	g.window_main.wait_variable(inv.back_to_inv)
	if main.canvas_map.winfo_exists():
		main.canvas_map.delete("use")
		bind_keys()

#The use skill button was pressed in the battle window. Open the
#skill display.
def open_skill_menu():
	#don't do anything if battle is over.
	if can_leave() == 1:
		return 0
	inv.open_inner_menu("skill")
	bind_skill_keys()
	inv.inner_cur_button = 0
#	g.window_main.update_idletasks()
	refresh_skill_display("skill")
	inv.refresh_inner_buttons("skill")
	g.window_main.wait_variable(inv.back_to_inv)
	if main.canvas_map.winfo_exists():
		main.canvas_map.delete("skill")
		bind_keys()

#This is a modification of inv.refresh_inv_display() in order to display
#the skill list.
def refresh_skill_display(screen_str):
	main.canvas_map.delete("item")
	#Draw a selection box around the current item.
	x = inv.tmp_x_base
	y = inv.tmp_y_base
	tmp_item = inv.curr_item
	if (tmp_item != -1 and tmp_item < inv.inv_width * inv.inv_height):
		main.canvas_map.create_rectangle(
		x+(tmp_item%inv.inv_width)*g.tilesize + 2 * ((tmp_item%inv.inv_width)+1),
		y+(tmp_item/inv.inv_width)*g.tilesize + 2 * ((tmp_item/inv.inv_width)+1),
		x+((tmp_item%inv.inv_width)+1)*(g.tilesize + 2),
		y+((tmp_item/inv.inv_width)+1)*(g.tilesize + 2),
		fill=g.fill_sel_colour, tags=("item", "inv", screen_str))

	#draw the skill pictures.
	for i in range(len(player.skill)):
		if player.skill[i][5] != 0:
			inv.draw_item(player.skill[i][7],
						i%inv.inv_width, i/inv.inv_width, x, y, screen_str)

	#draw the help text
	if len(player.skill) <= tmp_item: helptext = ""
	elif tmp_item == -1 or player.skill[tmp_item][5] == 0: helptext = ""
	else: helptext = (player.skill[tmp_item][0] + " ("+
			str(player.skill[tmp_item][2]) + " EP)")
	main.canvas_map.create_text(inv.tmp_menu_x_base+inv.tmp_menu_width/2,
		inv.tmp_menu_y_base+inv.tmp_menu_height+1, anchor=N, text=helptext,
		tags=("item", "inv", screen_str, "helptext"))

#Use a given item. item_index is the location in the item.item[] array.
#If leave_item==1, the item will not be removed from the inventory.
def useitem(item_index, leave_item=0):
	global active_button
	#don't do anything if battle is over.
	if can_leave() == 1 or item_index==-1:
		return 0
	clear_slashes()
	item_value = item_index
	item_type = g.item.item[item_value].type

	#if item is healing
	if item_type == 11:
		#heal the player, delete the item
		player.give_stat("hp", g.item.item[item_value].quality)
		main.print_message("You are healed for " +
					str(g.item.item[item_value].quality) + " "+g.hp_name+".")
		if leave_item == 0:
			g.item.drop_inv_item(g.item.find_inv_item(item_value))
			attack_player()

	#if item is a gem
	if item_type == 14:
		global old_attack
		old_attack = player.adj_attack
		gem_power = g.item.item[item_value].quality
		#gem power increases attack strength potential
		player.give_stat("adj_attack", gem_power * 0.75)
		#gem power increases num_dice (ie. chance to hit and total damage)
		global num_dice
		num_dice = num_dice + gem_power/4
		main.print_message("The " + g.item.item[item_value].name +
			    " focuses the power of your "+g.attack_name.lower()+".")
		main.recalc_stats()
		if leave_item == 0: g.item.drop_inv_item(g.item.find_inv_item(item_value))
		global used_gem
		used_gem=1
		if leave_item == 0: attack()

	#if item is explosive
	if item_type == 12:
		sel_mon = select_monster()
		if sel_mon == -1: return 0
		#if monster is still alive
		if monster_list[sel_mon].hp > 0:
			damage = int(g.item.item[item_value].quality)
			if leave_item == 0:
				g.item.drop_inv_item(g.item.find_inv_item(item_value))
			monster_hurt(sel_mon, damage)
			if can_leave() == 0 and leave_item == 0:
				attack_player()
		active_button = -1

	#If item is scripted:
	if item_type == 15 or item_type == 17:
		#If the scripting ends with an "end" command,
		if action.activate_lines(g.xgrid, g.ygrid, g.zgrid,
								g.item.item[item_value].scripting) == 1:
			if leave_item == 0:
				g.item.drop_inv_item(g.item.find_inv_item(item_value))
		if can_leave() == 0 and leave_item == 0:
			attack_player()
		active_button = -1

	#If item is equippable:
	if item_type < 6:
		#trade the item and whatever's in the equip slot
		temp = player.equip[item_type]
		player.equip[item_type] = item_index
		g.item.drop_inv_item(g.item.find_inv_item(item_index))
		g.item.take_inv_item(temp)
		main.print_message("You equip yourself with your " +
			g.item.item[player.equip[item_type]].name + ".")
		player.reset_stats()
		if can_leave() == 0 and leave_item == 0:
			attack_player()

	if can_leave() == 1:
		inv.leave_inner()
		return 0
	refresh()

	#back to battle
	if leave_item == 0:
		inv.leave_inner()
		refresh_buttons()


#Use a skill. Called upon hitting the right button; uses skill_index.
#(skill_index is position in player.skill[])
def useskill(skill_index, free_skill=0):
	global active_button
	#don't do anything if monster is dead.
	if can_leave() == 1:
		return 0

	clear_slashes()
# 	#get the skill index.
# 	if skill_index == -1:
# 		if (len(listbox_skill.curselection()) == 0): return 0
#
# 		try: skill_num = map(int, listbox_skill.curselection())
# 		except ValueError: pass
#
# 		skill_raw_name = listbox_skill.get(skill_num[0])
# 		skill_array_name = skill_raw_name.split(":", 1)
#
# 		#get the skill[] index
# 		skill_index = g.findskill(skill_array_name[0])
#
# 		#make sure we can use that skill, just in case. . .
# 		if player.skill[skill_index][5] == 0 or player.skill[skill_index][2] > player.ep:
# 			return 0
# 		free_skill=0
# 	else:
# 		free_skill=1


	#sanity checks
	if skill_index >= len(player.skill): return 0

	if free_skill == 0:
		if player.skill[skill_index][5] == 0: return 0
		if player.skill[skill_index][2] > player.ep: return 0

	#actually use the skill.
	if player.skill[skill_index][1] == 0: #rage
		if free_skill == 0:
			#pay for the skill
			player.give_stat("ep", -1*player.skill[skill_index][2])
		main.print_message("You fly into a rage.")
		#increase attack ability
		player.give_stat("adj_attack", (1 + int(player.level)/4))
		main.recalc_stats()
		attack_player()

	elif player.skill[skill_index][1] == 1: #Sneak away
		if free_skill == 0:
			#pay for the skill
			player.give_stat("ep", -1*player.skill[skill_index][2])
		global run_attempts
		if g.die_roll(1, 10 + int(player.level) + run_attempts) > 4:
			main.print_message("You coward! You ran away from the " +
				monster.monster_groups[mon_index].name + ".")
			main.canvas_map.delete("battle")
			back_to_main.set("2")
			global did_run
			did_run = 1
		else:
			run_attempts += 3
			main.print_message("You fail to sneak away.")
			attack_player()
	elif player.skill[skill_index][1] == 2: #Frenzy
		if free_skill == 0:
			#pay for the skill
			player.give_stat("ep", -1*player.skill[skill_index][2])
		mon_num = select_monster()
		for i in range(2 + int(player.level)/4):
			if monster_list[mon_num].hp < 1:
				mon_num = select_monster()
			if mon_num == -1: return 0
			attack_monster(mon_num, player.adj_attack)
			if can_leave() == 1:
				break
			active_button = -1
			monster_mouse_move()
			refresh()
		if can_leave() == 0: attack_player()
	elif player.skill[skill_index][1] == 3: #Dismember
		if free_skill == 0:
			#pay for the skill
			player.give_stat("ep", -1*player.skill[skill_index][2])
		mon_num = select_monster()
		if mon_num == -1: return 0
		damage = (player.adj_attack)
		monster_hurt(mon_num, damage)
		if can_leave() == 0:
			attack_player()
	elif player.skill[skill_index][1] == 4: #Scripted
		#If the scripting ends with an "end" command,
		if action.activate_lines(g.xgrid, g.ygrid, g.zgrid,
								player.skill[skill_index][6]) == 1:
			if free_skill == 0:
				#pay for the skill
				player.give_stat("ep", -1*player.skill[skill_index][2])
		if can_leave() == 0:
			attack_player()
		main.recalc_stats()

	if can_leave() == 1:
		inv.leave_inner()
		return 0
	active_button = -1
	monster_mouse_move()
	refresh()

	#replace the cursor
	if free_skill == 0:
		inv.leave_inner()
		refresh_buttons()

#The inspect button was pressed in the battle window.
def inspect_monst():
	#don't do anything if battle is over.
	if can_leave() == 1:
		return 0
	tmp = select_monster()
	if tmp == -1: return 0
	display_text = monster_list[tmp].name + "\n"
	display_text += "Attack: " + str(monster_list[tmp].attack) + "           "
	display_text += "Defense: " + str(monster_list[tmp].defense) + "\n"
	display_text += monster_list[tmp].description
	main.show_dialog(display_text)


#Refresh the buttons in the main battle view.
def refresh_buttons():
	if (cur_button == 0):
		main.canvas_map.itemconfigure("battle_attack",
						image=g.buttons["attack_sel.png"])
	else:
		main.canvas_map.itemconfigure("battle_attack",
						image=g.buttons["attack.png"])
	if (cur_button == 1):
		main.canvas_map.itemconfigure("battle_use",
						image=g.buttons["use_sel.png"])
	else:
		main.canvas_map.itemconfigure("battle_use",
						image=g.buttons["use.png"])
	if (cur_button == 2):
		main.canvas_map.itemconfigure("battle_skill",
						image=g.buttons["skill_sel.png"])
	else:
		main.canvas_map.itemconfigure("battle_skill",
						image=g.buttons["skill.png"])
	if (cur_button == 3):
		main.canvas_map.itemconfigure("battle_inspect",
						image=g.buttons["inspect_sel.png"])
	else:
		main.canvas_map.itemconfigure("battle_inspect",
						image=g.buttons["inspect.png"])
	if (cur_button == 4):
		main.canvas_map.itemconfigure("battle_run",
						image=g.buttons["quit_battle_sel.png"])
	else:
		main.canvas_map.itemconfigure("battle_run",
						image=g.buttons["quit_battle.png"])


	#main.canvas_map.delete(ALL)

# 	if (cur_button == 0):
# 		main.canvas_map.create_image(attack_button_loc, 0, anchor=NW,
# 					image=g.buttons["attack_sel.png"])
# 		help_text.set("Attack the " + monster_list[cur_button].name)
# 	else: main.canvas_map.create_image(attack_button_loc, 0, anchor=NW,
# 					image=g.buttons["attack.png"])
# 	if (cur_button == 1):
# 		if player.hp <= 0:
# 			main.canvas_map.create_image(run_button_loc, 0, anchor=NW,
# 				image=g.buttons["quit_sel.png"])
# 			help_text.set("Quit")
# 		elif can_leave() == 0:
# 			main.canvas_map.create_image(run_button_loc, 0, anchor=NW,
# 				image=g.buttons["run_sel.png"])
# 			help_text.set("Run away")
# 		else:
# 			main.canvas_map.create_image(run_button_loc, 0, anchor=NW,
# 				image=g.buttons["leave_sel.png"])
# 			help_text.set("Leave")
# 	elif player.hp <= 0: main.canvas_map.create_image(run_button_loc, 0, anchor=NW,
# 			image=g.buttons["quit.png"])
# 	elif can_leave == 0:
# 		main.canvas_map.create_image(run_button_loc,
# 			0, anchor=NW, image=g.buttons["run.png"])
# 	else: main.canvas_map.create_image(run_button_loc, 0, anchor=NW,
# 			image=g.buttons["leave.png"])
#
# 	if (cur_button == 2):
# 		listbox_skill.select_clear(0, END)
# 		main.canvas_map.create_image(item_button_loc, 0,
# 			anchor=NW, image=g.buttons["use_sel.png"])
# # 		if (len(listbox_item.curselection()) == 0):
# # 			help_text.set("No items")
# # 		else:
# # 			try: item_num = map(int, listbox_item.curselection())
# # 			except ValueError: pass
# # 			item_name = listbox_item.get(item_num[0])
# # 			help_text.set("Use your " + item_name)
# 	else: main.canvas_map.create_image(item_button_loc, 0,
# 			anchor=NW, image=g.buttons["use.png"])
#
# 	if (cur_button == 3):
# # 		listbox_item.select_clear(0, END)
# 		main.canvas_map.create_image(skill_button_loc, 0,
# 			anchor=NW, image=g.buttons["skill_sel.png"])
# 		if (len(listbox_skill.curselection()) == 0):
# 			help_text.set("No useable skills")
# 		else:
# 			try: skill_num = map(int, listbox_skill.curselection())
# 			except ValueError: pass
# 			skill_name = listbox_skill.get(skill_num[0])
# 			help_text.set("Use " + skill_name)
# 	else: main.canvas_map.create_image(skill_button_loc, 0,
# 			anchor=NW, image=g.buttons["skill.png"])


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	if (key_name == "esc"):
		runaway()
		return 0
	elif (key_name == "right" or key_name == "down"):
		cur_button += 1
		if (cur_button >= 5): cur_button = 0
# 		if (cur_button == 2): #switch to items
# 			if (len(listbox_item.curselection()) == 0):
# 				listbox_item.selection_set(0)
# 		if (cur_button == 3): #switch to skills
# 			listbox_item.select_clear(0, END)
# 			if (len(listbox_skill.curselection()) == 0):
# 				listbox_skill.selection_set(0)
# 		if (cur_button == 4): #switch to run
# 			cur_button = 1
# 			listbox_skill.select_clear(0, END)
	elif (key_name == "left" or key_name == "up"):
		cur_button -= 1
		if (cur_button <= -1): cur_button = 4 #loop around

	elif (key_name == "return"):
		if (cur_button == 0):
			attack()
		elif (cur_button == 1):
			open_item_menu()
		elif (cur_button == 2):
			open_skill_menu()
		elif (cur_button == 3):
			inspect_monst()
		elif (cur_button == 4):
			runaway()
		return 0

	refresh_buttons()

def item_key_handler(key_name):
	tmp = inv.inner_key_handler(key_name)
	if tmp == 2: useitem(g.item.inv[inv.curr_item])
	if tmp == 0: inv.refresh_inv_display("use")

def skill_key_handler(key_name):
	tmp = inv.inner_key_handler(key_name)
	if tmp == 2: useskill(inv.curr_item)
	if tmp == 0: refresh_skill_display("skill")


def item_mouse_click(event=0):
	tmp = inv.inner_mouse_click(event, "use")
	if tmp == 2: useitem(g.item.inv[inv.curr_item])
	if tmp == 0: inv.refresh_inv_display("use")

def skill_mouse_click(event=0):
	tmp = inv.inner_mouse_click(event, "skill")
	if tmp == 2: useskill(inv.curr_item)
	if tmp == 0: refresh_skill_display("skill")

def item_mouse_dbl_click(event=0):
	if inv.inner_mouse_dbl_click(event):
		useitem(g.item.inv[inv.curr_item])
	inv.refresh_inv_display("use")

def skill_mouse_dbl_click(event=0):
	if inv.inner_mouse_dbl_click(event):
		useskill(g.item.inv[inv.curr_item])
	refresh_skill_display("skill")

def item_mouse_move(event=0):
	if inv.inner_mouse_move(event, "use"):
		inv.refresh_inner_buttons("use")

def skill_mouse_move(event=0):
	if inv.inner_mouse_move(event, "skill"):
		inv.refresh_inner_buttons("skill")

def mouse_handler_click(event=0):
	mouse_handler_move(event)
	key_handler("return")

def mouse_handler_move(event=0):
	global cur_button
	if (event.x < attack_button_loc or event.y < button_y_start or
			event.y > button_y_start + button_height):
		cur_button = -1
	elif (event.x < item_button_loc):
		cur_button = 0
	elif (event.x < skill_button_loc):
		cur_button = 1
	elif (event.x < inspect_button_loc):
		cur_button = 2
	elif (event.x < run_button_loc):
		cur_button = 3
	elif (event.x < final_button_loc):
		cur_button = 4
	else:
		cur_button = -1
	refresh_buttons()



#Sets the description to the left of the battle view to that of
#the i'th monster

# BUGBUGBUG

def set_description_text(i):
	return 1
	canvas_desc.delete(ALL)
	canvas_desc.create_text(1, 5, anchor=NW,
			text=monster_list[i].description, width=195)
	monstername.set(monster_list[i].name)
	monsterattack.set(g.attack_name+": " +
	str(monster_list[i].attack))
	monsterdefense.set(g.defense_name+": " +
	str(monster_list[i].defense))

#start a battle.
def begin(mon_index_input):

# 	global window_battle
	global bgcolour
	bgcolour = "lightgrey"
# 	window_battle = Frame(g.window_main, bd=4, relief=GROOVE, bg=bgcolour)
# 	window_battle.grid(row=0, column=0)
	global mon_index
	mon_index = mon_index_input
	global monster_list
	monster_list = []
	for line in monster.monster_groups[mon_index].monster_list:
		monster_list.append(monster.copy_monster(
				monster.monsters[monster.monster_name_to_index(line)]))
	for i in range(len(monster_list)):
		monster_list[i].reset()
		if g.difficulty == 0:
			monster_list[i].hp -= monster_list[i].hp/5
			monster_list[i].maxhp -= monster_list[i].maxhp/5
			monster_list[i].attack -= monster_list[i].attack/5
			monster_list[i].defense -= monster_list[i].defense/5
		if g.difficulty == 2:
			monster_list[i].hp += monster_list[i].hp/5
			monster_list[i].maxhp += monster_list[i].maxhp/5
			monster_list[i].attack += monster_list[i].attack/5
			monster_list[i].defense += monster_list[i].defense/5

	global did_run
	did_run = 0
	global cur_button
	cur_button = 0
	global run_attempts
	run_attempts = 0
	global active_button
	active_button = -1

	# Set the current window
	g.cur_window = "battle"

# 	global canvas_desc
# 	canvas_desc = Canvas(window_battle, width=200, height=190,
# 		highlightthickness=0, bg=bgcolour)
# 	canvas_desc.grid(row=2, column=1, sticky=NSEW)

# 	pic_frame = Frame(window_battle, bd=2, relief=SUNKEN, bg="#327a22")
# 	pic_frame.grid(row=1, column=2, columnspan=3, rowspan=6, sticky=E)

	global canvas_mon_pic
	global background_pic
	background_pic = g.maps[g.zgrid].battle_background
# 	canvas_mon_pic = Canvas(pic_frame,
# 		height=background_pic.height(),
# 		width=background_pic.width())
# 	canvas_mon_pic.grid(column=2, row=1, rowspan=5, sticky=NW)
	main.canvas_map.create_rectangle(
		main.tilesize*main.half_mapx-background_pic.width()/2-1,
		main.tilesize*main.half_mapy-background_pic.height()/2-1,
		main.tilesize*main.half_mapx+background_pic.width()/2,
		main.tilesize*main.half_mapy+background_pic.height()/2, tags="battle")
	main.canvas_map.create_image(main.tilesize*main.half_mapx,
			main.tilesize*main.half_mapy, image=background_pic, tags="battle")
	monster_pic = []
	global base_mon_hp_start
	base_mon_hp_start = []
	global base_mon_hp_width
	base_mon_hp_width = []
	global base_mon_hp_y_start
	base_mon_hp_y_start = []

	global monster_start
	monster_start=(main.tilesize*main.half_mapx-background_pic.width()/2,
					main.tilesize*main.half_mapy-background_pic.height()/2)
	for i in range(len(monster_list)):
		try:monster_pic.append(g.tiles[
							"monsters/" + monster_list[i].name + ".png"])
		except KeyError: monster_pic.append(g.tiles["monsters/generic.png"])

		#if x and y positions were given, use them; otherwise, start at the
		#middle, and go right. This works for 1 or two monsters, but xy
		#coords are recommended for more.
		if len(monster.monster_groups[mon_index].x_pos) > i:
			xstart = monster_start[0]+monster.monster_groups[mon_index].x_pos[i]
		else: xstart = monster_start[0]+background_pic.width()/2+i*40
		if len(monster.monster_groups[mon_index].y_pos) > i:
			ystart = monster_start[1]+monster.monster_groups[mon_index].y_pos[i]
		else: ystart = monster_start[1]+10

		main.canvas_map.create_image(xstart, ystart,
					anchor=N, image=monster_pic[i], tags="battle")

		base_mon_hp_start.append(xstart - monster_pic[i].width()/2)
		base_mon_hp_width.append(monster_pic[i].width())
		base_mon_hp_height.append(monster_pic[i].height())
		base_mon_hp_y_start.append(ystart + 5+monster_pic[i].height())
		#Under (red) part of the monster hp display
		main.canvas_map.create_rectangle(base_mon_hp_start[i], base_mon_hp_y_start[i],
				base_mon_hp_start[i]+base_mon_hp_width[i],
				base_mon_hp_y_start[i]+5, fill="#EE0505", tags="battle")
		#Over (green) part of the monster hp display
		main.canvas_map.create_rectangle(base_mon_hp_start[i], base_mon_hp_y_start[i],
				base_mon_hp_start[i]+base_mon_hp_width[i],
				base_mon_hp_y_start[i]+5, fill="#05BB05",
				tags=("monster_hp_rect"+ str(i), "battle"))
		main.canvas_map.create_text(xstart, base_mon_hp_y_start[i]+6,
				anchor=N, text="", tags=("mon_hp"+str(i), "battle"))

	global hero_pic
	try: hero_pic = g.tiles["people/hero_n" + g.maps[g.zgrid].hero_suffix + ".png"]
	except KeyError: hero_pic = ImageTk.PhotoImage("RGB", (32, 32))
	main.canvas_map.create_image(
				background_pic.width()/2+monster_start[0],
				background_pic.height()-hero_pic.height()*5/2+monster_start[1],
				anchor=N, image=hero_pic, tags=("hero", "battle"))
	#Under (red) part of the player hp display
	main.canvas_map.create_rectangle(
		monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height()*3/2-2,
		monster_start[0]+(background_pic.width()+base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height()*3/2+3,
		fill="#EE0505", tags="battle")
	#Over (green) part of the player hp display
	main.canvas_map.create_rectangle(
		monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height()*3/2-2,
		monster_start[0]+(background_pic.width()+base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height()*3/2+3,
		fill="#05BB05", tags=("player_hp_bar", "battle"))
	main.canvas_map.create_text(monster_start[0]+background_pic.width()/2,
		monster_start[1]+background_pic.height()-hero_pic.height()*3/2+4,
		anchor=N, text="", tags=("player_hp", "battle"))

	#Under (red) part of the player ep display
	main.canvas_map.create_rectangle(
		monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height(),
		monster_start[0]+(background_pic.width()+base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height()+5,
		fill="#EE0505", tags="battle")
	#Over (green) part of the player ep display
	main.canvas_map.create_rectangle(
		monster_start[0]+(background_pic.width()-base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height(),
		monster_start[0]+(background_pic.width()+base_mon_hp_width[0])/2,
		monster_start[1]+background_pic.height()-hero_pic.height()+5,
		fill="#0505EE", tags=("player_ep_bar", "battle"))
	main.canvas_map.create_text(monster_start[0]+background_pic.width()/2,
		monster_start[1]+background_pic.height()-hero_pic.height()+6,
		anchor=N, text="", tags=("player_ep", "battle"))


	#formatting for the labels.
# 	label_formatting = Label(window_battle,
# 			textvariable=monstername, bg=bgcolour).grid(row=1,
# 			column=1, columnspan=2)


# 	label_attack = Label(window_battle, textvariable=monsterattack,
# 			 bg=bgcolour).grid(row=4, column=1, sticky=W)
# 	label_defend = Label(window_battle, textvariable=monsterdefense,
# 			bg=bgcolour).grid(row=4, column=1, sticky=E)

	#help text
# 	label_text = Label(window_battle,
# 		textvariable=help_text, bg=bgcolour)
# 	label_text.grid(column=1, row=5, columnspan=2)
# 	window_battle.update_idletasks()
# 	window_battle.columnconfigure(1, minsize=canvas_mon_pic.winfo_width())


# 	button_frame = Frame(window_battle, bg=bgcolour)
# 	button_frame.grid(row=14, column=1, columnspan=2, sticky="NSEW")


	global attack_button_loc
	global item_button_loc
	global skill_button_loc
	global inspect_button_loc
	global run_button_loc
	global final_button_loc
	global button_y_start
	global button_height
	attack_button_loc = main.tilesize*main.half_mapx - \
		g.buttons["attack.png"].width()-g.buttons["use.png"].width() - \
		g.buttons["skill.png"].width()/2
	item_button_loc = attack_button_loc + g.buttons["attack.png"].width()
	skill_button_loc = item_button_loc + g.buttons["use.png"].width()
	inspect_button_loc = skill_button_loc + g.buttons["skill.png"].width()
	run_button_loc = inspect_button_loc + g.buttons["inspect.png"].width()
	final_button_loc = run_button_loc + g.buttons["quit.png"].width()

	button_y_start = main.tilesize*main.half_mapy+background_pic.height()/2
	button_height = g.buttons["attack.png"].height()

	main.canvas_map.create_rectangle(attack_button_loc, button_y_start,
		final_button_loc, button_y_start+button_height,
		fill=g.outline_colour, tags="battle")

	main.canvas_map.create_image(attack_button_loc, button_y_start, anchor=NW,
			image=g.buttons["attack.png"],
			tags=("battle_attack", "battle_button", "battle"))
	main.canvas_map.create_image(item_button_loc, button_y_start, anchor=NW,
			image=g.buttons["use.png"],
			tags=("battle_use", "battle_button", "battle"))
	main.canvas_map.create_image(skill_button_loc, button_y_start, anchor=NW,
			image=g.buttons["skill.png"],
			tags=("battle_skill", "battle_button", "battle"))
	main.canvas_map.create_image(inspect_button_loc, button_y_start, anchor=NW,
			image=g.buttons["inspect.png"],
			tags=("battle_inspect", "battle_button", "battle"))
	main.canvas_map.create_image(run_button_loc, button_y_start, anchor=NW,
			image=g.buttons["quit.png"],
			tags=("battle_run", "battle_button", "battle"))




# 	global canvas_buttons
# 	canvas_buttons = Canvas(button_frame, bg="#b3b3b3",
# 		height=g.buttons["attack.png"].height(),
# 		width=run_button_loc + g.buttons["run.png"].width())
# 	canvas_buttons.grid(column=1, row=1, sticky="NSEW")

	#use item listbox
# 	item_label = Label(window_battle, text='Items', bg=bgcolour)
# 	item_label.grid(row=9, column=1, sticky=N)

# 	global listbox_item
# 	listbox_item = Listbox(window_battle, height=5, bg=bgcolour)
# 	listbox_item.grid(row=9, column=1, rowspan=5, sticky=N+S+E+W)
# 	global item_scroll
# 	item_scroll = Scrollbar(window_battle, command=listbox_item.yview,
# 		bg=bgcolour)
# 	item_scroll.grid(row=9, column=1, rowspan=5, sticky=N+S+E)
# 	listbox_item.config(yscrollcommand=item_scroll.set)


# 	skill_label = Label(window_battle, text='Skills', bg=bgcolour)
# 	skill_label.grid(row=9, column=2, sticky=N)

# 	global listbox_skill
# 	listbox_skill = Listbox(window_battle, height=5, bg=bgcolour)
# 	listbox_skill.grid(row=9, column=2, rowspan=5, sticky="NSEW")
# 	global skill_scroll
# 	skill_scroll = Scrollbar(window_battle, command=listbox_skill.yview,
# 		bg=bgcolour)
# 	skill_scroll.grid(row=9, column=2, rowspan=5, sticky=N+S+E)
# 	listbox_skill.config(yscrollcommand=skill_scroll.set)
# 	window_battle.update_idletasks()
# 	window_battle.columnconfigure(2, minsize=pic_frame.winfo_width())


	#bindings
	bind_keys()

	main.print_message(monster.monster_groups[mon_index].attack_message)
	set_description_text(0)

	refresh()
	refresh_buttons()

	#keep the window_main window asleep until this one is closed.
	g.window_main.wait_variable(back_to_main)
	if player.hp <= 0: did_run = "end"
	return did_run


#bind the keys. Called upon window creation and return from a yes/no box
def bind_keys():
	g.cur_window = "battle"
	g.window_main.bind(g.binding_attack, attack)
	g.window_main.bind(g.binding_cancel, lambda e: key_handler("esc"))
	g.window_main.bind(g.binding_action, lambda e: key_handler("return"))
	g.window_main.bind(g.binding_up, lambda e: key_handler("up"))
	g.window_main.bind(g.binding_down, lambda e: key_handler("down"))
	g.window_main.bind(g.binding_left, lambda e: key_handler("left"))
	g.window_main.bind(g.binding_right, lambda e: key_handler("right"))
	g.window_main.unbind(g.binding_inv)
	g.window_main.unbind(g.binding_save)
	g.window_main.unbind(g.binding_quit)

	g.window_main.bind("<ButtonRelease-1>", mouse_handler_click)
	g.window_main.bind("<Motion>", mouse_handler_move)
	g.window_main.unbind("<Double-Button-1>")
# 	listbox_item.bind("<ButtonRelease-1>", mouse_handler_item)
# 	listbox_skill.bind("<ButtonRelease-1>", mouse_handler_skill)
# 	canvas_mon_pic.bind("<ButtonRelease-1>", attack)
# 	canvas_mon_pic.bind("<Motion>", monster_mouse_move)
# 	main.canvas_map.unbind("<Motion>")
# 	main.canvas_map.unbind("<Button-1>")


#keybindings when choosing a monster to attack.
def bind_attack_keys():
	g.cur_window = "battle_attack"
	g.window_main.bind(g.binding_attack, choose_monster)
	g.window_main.bind(g.binding_cancel, cancel_monster)
	g.window_main.bind(g.binding_action, choose_monster)
	g.window_main.bind(g.binding_up, choose_monster_prev)
	g.window_main.bind(g.binding_down, choose_monster_next)
	g.window_main.bind(g.binding_left, choose_monster_prev)
	g.window_main.bind(g.binding_right, choose_monster_next)
	g.window_main.unbind(g.binding_inv)
	g.window_main.unbind(g.binding_save)
	g.window_main.unbind(g.binding_quit)

	g.window_main.bind("<Motion>", monster_mouse_move)
	g.window_main.bind("<ButtonRelease-1>", choose_monster)

def bind_item_keys():
	g.cur_window = "battle_item"
	g.window_main.unbind(g.binding_attack)
	g.window_main.bind(g.binding_cancel, lambda e:item_key_handler("esc"))
	g.window_main.bind(g.binding_action, lambda e:item_key_handler("return"))
	g.window_main.bind(g.binding_up, lambda e:item_key_handler("up"))
	g.window_main.bind(g.binding_down, lambda e:item_key_handler("down"))
	g.window_main.bind(g.binding_left, lambda e:item_key_handler("left"))
	g.window_main.bind(g.binding_right, lambda e:item_key_handler("right"))
	g.window_main.bind("<ButtonRelease-1>", item_mouse_click)
	g.window_main.bind("<Double-Button-1>", item_mouse_dbl_click)
	g.window_main.bind("<Motion>", item_mouse_move)

def bind_skill_keys():
	g.cur_window = "battle_skill"
	g.window_main.unbind(g.binding_attack)
	g.window_main.bind(g.binding_cancel, lambda e:skill_key_handler("esc"))
	g.window_main.bind(g.binding_action, lambda e:skill_key_handler("return"))
	g.window_main.bind(g.binding_up, lambda e:skill_key_handler("up"))
	g.window_main.bind(g.binding_down, lambda e:skill_key_handler("down"))
	g.window_main.bind(g.binding_left, lambda e:skill_key_handler("left"))
	g.window_main.bind(g.binding_right, lambda e:skill_key_handler("right"))
	g.window_main.bind("<ButtonRelease-1>", skill_mouse_click)
	g.window_main.bind("<Double-Button-1>", skill_mouse_dbl_click)
	g.window_main.bind("<Motion>", skill_mouse_move)
