#file: rpg.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file is the first file accessed upon game start.
#It allows the player to select the module, or, if there is only one,
#automatically selects for the player.

from Tkinter import *
from os import listdir

#Load other windows after starting the main one,
#to prevent Tk trouble.
unused_window = Tk()
unused_window.withdraw()
import g
g.window_main = Toplevel()
g.window_main.title("Loading")
g.window_main.resizable(0, 0)
g.window_main.maxsize(1000, 1000)
g.window_main.wm_geometry("%dx%d%+d%+d" % (736, 544, 20, 20))
g.window_main.protocol("WM_DELETE_WINDOW", g.main.cleanup)


import new_game

global array_mods
array_mods = []

global module_pos
module_pos = 0

global cur_button
cur_button = 0

global prevent_dbl_load
prevent_dbl_load = 0

#take the selected module, and send to sel_mod
def sel_list_mod():
	if module_pos < 0 or module_pos >= len(array_mods): return 0
	mod_name = array_mods[module_pos]
	sel_mod(mod_name)

#given a certain mod, run it.
def sel_mod(selected_mod):
	global prevent_dbl_load
	if prevent_dbl_load == 1: return 0
	prevent_dbl_load = 1
	g.mod_directory = "../modules/" + selected_mod
#	loading_window = Toplevel(window_sel_game)

# 	templbl = Label(g.window_main, text="Loading " + selected_mod)
# 	templbl.grid()
	g.main.canvas_map.create_rectangle(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3, g.tilesize*g.main.mapsizex*3/4,
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load.png"].height(),
		fill="#e3e3e3", tags="loadgame")
	g.main.canvas_map.create_text(g.tilesize*g.main.mapsizex/2,
		g.tilesize*g.main.mapsizey/2, text="Loading. Please wait")
	g.window_main.title("Loading")
# 	loading_window.resizable(0, 0)
# 	loading_window.maxsize(1000, 1000)
# 	loading_window.wm_geometry("+%d+%d" % (20, 20))
	g.window_main.update_idletasks()
	g.init_data()
#	loading_window.withdraw()
#	templbl.grid_remove()
	new_game.init_window()
	quit_game()

def quit_game():
	raise SystemExit

def refresh_module_info():
	tmp = module_pos - (module_pos % 5)
	for i in range(5):
		if i == module_pos % 5:
			g.main.canvas_map.itemconfigure("module_rect"+str(i), fill="#b9e5ad")
		else:
			g.main.canvas_map.itemconfigure("module_rect"+str(i), fill="#e3e3e3")
		if len(array_mods) <= tmp+i: savetext = ""
		else: savetext = array_mods[tmp+i]
		g.main.canvas_map.itemconfigure("load_module"+str(i), text=savetext)

#All keypresses pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(switch):
	global module_pos
	if (switch == "esc"): quit_game()
	elif (switch == "left" or switch == "right"):
		global cur_button
		if cur_button == 0: cur_button = 1
		else: cur_button = 0
		refresh_buttons()
	elif (switch == "up"):
		module_pos -= 1
		if module_pos <= -1: module_pos = len(array_mods) - 1
#		if (listbox_saves.size() == 0): return
#		try: item_num = map(int, listbox_saves.curselection())
#		except ValueError: pass
#		if (item_num[0] != 0):
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(item_num[0] - 1)
# 		else:
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(END)
		refresh_module_info()
	elif (switch == "down"):
		module_pos += 1
		if module_pos >= len(array_mods): module_pos = 0
# 		if (listbox_saves.size() == 0): return
# 		try: item_num = map(int, listbox_saves.curselection())
# 		except ValueError: pass
# 		if (item_num[0] != listbox_saves.size() - 1):
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(item_num[0] + 1)
# 		else:
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(0)
		refresh_module_info()
	elif (switch == "return"):
		if cur_button == 0: sel_list_mod()
		else: quit_game()


def mouse_over(event, x1, y1, x2, y2):
	if event.x >= x1 and event.x <= x2 and event.y >= y1 and event.y <= y2:
		return 1
	return 0

def mouse_handler_move(event=0):
	global cur_button
	#up arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3,
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height()):
		g.main.canvas_map.itemconfigure("loadgame_up",
				image=g.buttons["loadgame_up_sel.png"])
	else:
		g.main.canvas_map.itemconfigure("loadgame_up",
				image=g.buttons["loadgame_up.png"])

	#down arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_down.png"].width(),
		g.tilesize*g.main.mapsizey/3+140):
		g.main.canvas_map.itemconfigure("loadgame_down",
				image=g.buttons["loadgame_down_sel.png"])
	else:
		g.main.canvas_map.itemconfigure("loadgame_down",
				image=g.buttons["loadgame_down.png"])

	#load button:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load.png"].height()):
		cur_button = 0

	#leave button:
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4+g.buttons["load.png"].width(),
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load.png"].width()+
		g.buttons["quit.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["quit.png"].height()):
		cur_button = 1
	refresh_buttons()

def mouse_handler_down(event=0):
	global cur_button
	global module_pos
	#up arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3,
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height()):

		tmp = module_pos - (module_pos % 5) - 5
		if tmp < 0:
			module_pos = len(array_mods) - (len(array_mods)%5) + (module_pos%5)
			if module_pos >= len(array_mods):
				module_pos = len(array_mods) - 1
		else:
			module_pos -= 5
		refresh_module_info()

	#down arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_down.png"].width(),
		g.tilesize*g.main.mapsizey/3+140):

		tmp = module_pos - (module_pos % 5) + 5
		if tmp >= len(array_mods):
			module_pos = (module_pos % 5)
		else:
			module_pos += 5
			if module_pos >= len(array_mods):
				module_pos = len(array_mods) - 1
		refresh_module_info()

	#load button:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load.png"].height()):
		cur_button = 0
		key_handler("return")

	#leave button:
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4+g.buttons["load.png"].width(),
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load.png"].width()+
		g.buttons["quit.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["quit.png"].height()):
		cur_button = 1
		key_handler("return")

	#save "listbox"
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height()):

		base_y = (event.y -
			g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height())
		base_y -= 40
		if base_y % 20 < 2 or base_y % 20 > 18: return
		tmp = module_pos - (module_pos % 5) + (base_y / 20)
		if tmp >= len(array_mods): return
		else: module_pos = tmp
		refresh_module_info()

def mouse_handler_double(event=0):
	global module_pos
	#save "listbox"
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height()):

		sel_list_mod()

def refresh_buttons():
	#canvas_map.delete("loadgame_buttons")
	if (cur_button == 0):
		g.main.canvas_map.itemconfigure("module_load", image=g.buttons["load_sel.png"])
		g.main.canvas_map.itemconfigure("module_quit", image=g.buttons["quit.png"])
	else:
		g.main.canvas_map.itemconfigure("module_load", image=g.buttons["load.png"])
		g.main.canvas_map.itemconfigure("module_quit", image=g.buttons["quit_sel.png"])


def init_window():
	g.window_main.protocol("WM_DELETE_WINDOW", quit_game)
	global array_mods
	array_mods = listdir("../modules/")
	#remove CVS directory
	i = 0
	while i < len(array_mods):
		if array_mods[i] == "CVS":
			array_mods.pop(i)
		elif array_mods[i] == "default":
			array_mods.pop(i)
		else:
			i += 1

	g.main.canvas_map = Canvas(g.window_main, width=g.tilesize*g.main.mapsizex,
		height=g.tilesize*g.main.mapsizey, highlightthickness=0,
		background="#606090")
	g.main.canvas_map.grid(column=0, row=0)

	g.load_buttons()

	#if there is only one module, run it.
	if (len(array_mods) == 1):
		sel_mod(array_mods[0])
		return 0

	#global window_sel_game

	g.window_main.title("Select module")
	g.mod_directory = "../modules/default/"


# 	window_sel_game.resizable(0, 0)
# 	window_sel_game.maxsize(900, 900)
# 	window_sel_game.wm_geometry("+%d+%d" % (20, 20))

	#black bar
	g.main.canvas_map.create_rectangle(0,
		g.tilesize*g.main.mapsizey/2,
		g.tilesize*g.main.mapsizex,
		g.tilesize*g.main.mapsizey/2+30,
		fill="#000000", tags="loadgame")
	g.main.canvas_map.create_text(g.tilesize*g.main.mapsizex/2,
		g.tilesize*g.main.mapsizey/2+15,
		text="You have multiple modules installed. Pick one to play.",
		anchor=W, tags=("module"), fill="#FFFFFF")

	#box for listbox
	g.main.canvas_map.create_rectangle(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3,
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load.png"].height(),
		fill="#e3e3e3", tags="loadgame")


	#add the saves images
	g.main.canvas_map.create_image(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3, anchor=NW,
		image=g.buttons["loadgame_up.png"], tags=("module_up", "module"))
	g.main.canvas_map.create_image(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140, anchor=SW,
		image=g.buttons["loadgame_down.png"], tags=("module_down", "module"))

	#add the button images
	g.main.canvas_map.create_image(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140, anchor=NW,
		image=g.buttons["load.png"],
		tags=("module_load", "module_buttons", "module"))
	g.main.canvas_map.create_image(g.tilesize*g.main.mapsizex/4+
		g.buttons["load.png"].width(), g.tilesize*g.main.mapsizey/3+140,
		anchor=NW, image=g.buttons["quit.png"],
		tags=("module_quit", "module_buttons", "module"))

	#list of the actual savegames
	for i in range(5):
		g.main.canvas_map.create_rectangle(g.tilesize*g.main.mapsizex/4+2,
			g.tilesize*g.main.mapsizey/3+
			g.buttons["loadgame_down.png"].height()+1+i*20,
			g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_down.png"].width()-3,
			g.tilesize*g.main.mapsizey/3+
			g.buttons["loadgame_down.png"].height()+18+i*20,
			fill="#e3e3e3", tags=("module_rect"+str(i), "module"))
		g.main.canvas_map.create_text(g.tilesize*g.main.mapsizex/4+5,
			g.tilesize*g.main.mapsizey/3+
			g.buttons["loadgame_down.png"].height()+11+i*20,
			text=str(i), anchor=W, tags=("load_module"+str(i), "module"))

# 	global listbox_mods
# 	listbox_mods = Listbox(g.window_main, height=10)
# 	listbox_mods.grid(row=1, column=1, rowspan=10, sticky=N+W+E)
#
# 	global button_sel
# 	button_sel = Button(g.window_main, text="Select mod",
# 		command=sel_list_mod)
# 	button_sel.grid(row=1, column=0)
#
# 	global button_quit
# 	button_quit = Button(g.window_main, text="Quit", command=quit_game)
# 	button_quit.grid(row=2, column=0)
#
# 	for modname in array_mods:
# 		g.mod_directory = "../modules/" + modname
# 		listbox_mods.insert(END, g.read_game_name())
# 		global dirnames
# 		dirnames.append(modname)
	g.window_main.bind("<Double-Button-1>", mouse_handler_double)
	g.window_main.bind("<ButtonRelease-1>", mouse_handler_down)
	g.window_main.bind("<Motion>", mouse_handler_move)

	g.window_main.bind("<Escape>", lambda e:key_handler("etc"))
	g.window_main.bind("<Left>", lambda e:key_handler("left"))
	g.window_main.bind(g.binding_right, lambda e:key_handler("right"))
	g.window_main.bind("<Up>", lambda e:key_handler("up"))
	g.window_main.bind("<Down>", lambda e:key_handler("down"))
	g.window_main.bind("<Return>", lambda e:key_handler("return"))
	refresh_module_info()
	refresh_buttons()
	g.window_main.mainloop()

init_window()
