#!/bin/bash

SCREENSHOTS=../../screenshots

update_if_newer()  {
    if [ -f $1 ]; then
        if [ $1 -nt $2 ]; then
            echo "creating $2"
            convert -crop 640x416+0+0 -scale 120x78 $1 $2
        fi
    fi
}

update_for_subdir() {
    if [ -d $1 ]; then
        if [ -d $SCREENSHOTS/$1 ]; then
            for bmp in $SCREENSHOTS/$1/*.bmp; do
                base=`basename $bmp .bmp`
                png="$1/$base.png"
                update_if_newer $bmp $png
            done
        fi
    else
        echo "Error: no such directory '$1'"
    fi
}

if [ -d $SCREENSHOTS ]; then
    for bmp in $SCREENSHOTS/*.bmp; do
        base=`basename $bmp .bmp`
        png="$base.png"
        update_if_newer $bmp $png
    done

    update_for_subdir Sokoban
    update_for_subdir m_tutor
fi

NEWPREVIEWS=`find . -name "*.png" -cmin -5`
COUNT=`echo $NEWPREVIEWS | wc -w`

if [ $COUNT = 0 ]; then
    echo "All existing previews were up-to-date."
else
    # if pngcrush is installed crush previews
    if [ -x /usr/local/bin/pngcrush ] ; then
        ./04crushprevievs.sh $NEWPREVIEWS
    fi

    echo "$COUNT preview(s) updated."
fi
