/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include "library.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void initialize_c_library(){
#ifdef DEBUG
  fprintf(stderr, "Initializing the C-library random.c... ");
#endif

  /* We don't need dynamic libraries here, since the random numbers
     functionality is built into the C library: no nothing. */

#ifdef DEBUG
  fprintf(stderr, "done.\n");
#endif
}

/* The following functions are exported to epsilon: */

word_t e_random_seed(){
  /* Seed the pseudo-random number generator: */
  srand(time(NULL));
  return NULL; /* unused */
}

/* Return a float x in [0.0, 1.0) */
word_t e_random_float(){
  return float_to_word((float_t)rand() / (float_t)RAND_MAX);
}

/* Return an integer x in [0, max_succ) */
word_t e_random_integer(word_t max_succ){
  return (word_t)((integer_t)rand() % (integer_t)max_succ);
}

word_t e_random_integer_from_to(word_t from_to){
  integer_t from = ((integer_t*)from_to)[0];
  integer_t to = ((integer_t*)from_to)[1];

  //  printf("> "INTEGER_T_FORMAT" "INTEGER_T_FORMAT"\n", from, to);
  return (word_t)(((integer_t)rand() % (to - from + (integer_t)1)) + from);
}
