/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include "../config.h"
#include "../common/command_line.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* Simple malloc() and realloc() replacements for broken systems: */
     
#include <sys/types.h>

#if HAVE_MALLOC == 0
/* We don't have a good malloc() */

#undef malloc
#undef realloc

void *malloc (size_t size);
void *realloc (void* pointer, size_t new_size);
     
/* Allocate an N-byte block of memory from the heap.
   If N is zero, allocate a 1-byte block.  */
     
void *
rpl_malloc (size_t n)
{
  if (n == 0)
    n = 1;
  return malloc (n);
}

/* (Re-)allocate an N-byte block of memory from the heap.
   If N is zero, allocate a 1-byte block.  */
void *
rpl_realloc (void* old_pointer, size_t n)
{
  if (n == 0)
    n = 1;
  return realloc (old_pointer, n);
}
#endif /* #if */

/* Commodity versions of malloc() and realloc() which abort instead of
   returning NULL when memory is exhausted: */
void* xmalloc(size_t size){
  /* Try and allocate: */
  void* r = malloc(size);

  /* Check and return: */
  if(r == NULL)
    fatal("xmalloc(): memory exhausted");
  else
    return r;
}

void* xrealloc(void* old_pointer, size_t new_size){
  /* Try and allocate: */
  void* r = realloc(old_pointer, new_size);

  /* Check and return: */
  if(r == NULL)
    fatal("xrealloc(): memory exhausted");
  else
    return r;
}
