/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include "../config.h"

//
//#undef HAVE_LIBREADLINE
//

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* If the real readline() is available then we don't need this replacement: */
#ifndef HAVE_LIBREADLINE


#define INITIAL_BUFFER_SIZE     256

int
is_the_stop_character (int c)
{
  return (c == EOF) || ((char) c == '\n');
}

/* A rough replacement of readline(), used if the real one is not available.

   The returned buffer is malloc()ed, and must be free()ed by
   the caller. */
char *
readline (char *prompt)
{
  size_t buffer_dimension = INITIAL_BUFFER_SIZE * sizeof (char),
    string_dimension = 0;
  char *r = (char *) malloc (buffer_dimension);
  int c;

  printf("%s", prompt);

  /* Read a char and append it to r until \n or EOF: */
  while (!is_the_stop_character (c = getchar ()))
    {
      string_dimension++;

      /* Resize the buffer when it becomes full:
         I resize one character before the buffer
         gets full to reserve space for \0. */
      if (string_dimension == buffer_dimension - 1)
	r = (char *) realloc (r, buffer_dimension *= 2);

      r[string_dimension - 1] = (char) c;
    }				/* while */

  /* Add NULL-termination and return: */
  r[string_dimension] = '\0';
  return r;
}

/* Just a stub: */
void add_history (const char *text){
  /* Do nothing */
}

#endif /* #ifndef HAVE_LIBREADLINE */
