/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef SEARCH_PATH_H_
#define SEARCH_PATH_H_

#include "../config.h"

#define INITIAL_DIRECTORIES_NO 16 /* initial entries no. */
#define DIRECTORY_SEPARATORS ":"  /* separator characters in path
				     lists */
typedef struct search_path{
  char** directories;
  int directories_no;
  int directories_size;
}* search_path_t;

/* Create and destroy data structure: */
search_path_t create_search_path();
void destroy_search_path(search_path_t path);

/* Append a single directory: */
void append_directory_to_search_path(char* directory, search_path_t p);

/* Append a path made by directories separated by DIRECTORY_SEPARATORS :*/
void append_path_to_search_path(char* path, search_path_t p);

/* If file_name already contains a path then return a copy of file_name,
   without looking at path; else sarche for the first readable file (actual
   file, not directory) in each directory of the path, following the order
   in the structure.
   Returns a malloc()'d string holding the full path which the caller
   must free(), or NULL if no suitable file exists. */
char* search_for_file_in_search_path(char* file_name,
				     search_path_t path);

/* Calls search_for_file_in_search_path(), and aborts when 
   search_for_file_in_search_path() returns NULL; else 
   search_for_file_or_fail() returns the value returned by
   search_for_file_in_search_path() */
char* search_for_file_or_fail(char* file_name,
			      search_path_t path);

/* Returns a malloc()'d string holding the search directories, separated
   by DIRECTORY_SEPARATORS: */
char* search_path_to_string(search_path_t path);

/* Useful for debugging. */
void dump_search_path(search_path_t p);

#endif /* #ifndef SEARCH_PATH_H_ */
