/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef STRINGMAP_H_
#define STRINGMAP_H_

#include <stdlib.h>		/* for size_t */

/* A map from strings to any objects: 
   strings are compared according to their values; equality-by-identity
   does not hold here: */
struct string_map;

/*
This only works if value doesn't contain pointers!
*/

/* Keys can be large at will. */

struct string_map *create_string_map (size_t size_of_value);
void destroy_string_map (struct string_map *map);

void insert_into_string_map (struct string_map *map,
			     const char *key,
			     void *value);
void multinsert_into_string_map (struct string_map *map,
				 const char *key,
				 void *value);
void remove_from_string_map (struct string_map *map,
			     const char *key);
void *access_string_map (struct string_map *map,
			 const char *key);
int is_string_map_defined_on (struct string_map *map,
			      const char *key);

#endif /* #ifndef STRINGMAP_H_ */
