/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

%%
\\ { printf("\\\\"); /* convert \ into \\ */ }
\" { printf("\\\""); /* convert " into \" */ }
\' { printf("\\\'"); /* convert ' into \' */ }
\n { printf("\\n\"\n\""); /* join this line and the next */ }
\t { printf("\\t"); /* convert a tab into \t */ }
\v { printf("\\v"); /* convert a vertical tab into \v */ }
\f { printf("\\f"); /* convert a form feed into \f */ }
\r { printf("\\r"); /* convert a CR into \r */ }
.  { printf("%s",yytext); /* output the character as it is */ }
%%

/* Read a text from stdin and write a 'strigified' version of it to stdout: */
int main(){
  int r;

  printf("\""); /* Open quote */
  r = yylex();
  printf("\"\n"); /* Close quote and enter the final newline */

  return r;
}

int yywrap(){
  return 1;
}
