/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

%{
#include <stdio.h>
#include "epsilon.h"
#include "types.h"
#include "environment.h"
#include "multibuffer.h"
#include "epsilonparser.h"

#include "importedmodules.h"

#define PATH_SEPARATOR '/'

void make_child_of(int child, int parent);
int new_module(char* name);

/* The module we are loading now: */
int current_module;

char* append_extension(char* name, char* e);

%}

%option yylineno
%option noreject

/*IDENTIFIER {LETTER}({LETTER}|{DIGIT}|"_")* */
/*
IDENTIFIER [^\ \n\r()\\\:\.]+
*/

WHITESPACE       [\t \n\r]+

DIGIT            [0-9]
LOWER            [a-z]
UPPER            [A-Z]
LETTER           {LOWER}|{UPPER}

COMMA            \,
SEMICOLON        \;

CSTRING    \"([^\n\\"]|{CESCAPE})*\"
STRING     {CSTRING}
UNDERSCORE _
/* This definition must be kept synchronized with 'BARE_IDENTIFIER'
   in epsilon.l: */
IDENTIFIER ({LETTER}|{DIGIT}|{UNDERSCORE}|\<|\>|\`|\~|\!|\@|\#|\$|\%|\^|\&|\*|\_|\+|\-|\=|\\|\{|\}|\?|\/|\[|\])+

MODULE_IDENTIFIER {LETTER}({LETTER}|{DIGIT}|"_")*

/* This must be kept in sync with the definition in epsilon.h: */
MODULES_SEPARATOR  ":"
 
MODULE            {MODULE_IDENTIFIER}({MODULES_SEPARATOR}{MODULE_IDENTIFIER})*

QUALIFIED_IDENTIFIER {MODULE}{MODULES_SEPARATOR}{IDENTIFIER}

IMPORTATION          import{WHITESPACE}{MODULE}{WHITESPACE}?({COMMA}{WHITESPACE}?{MODULE}{WHITESPACE}?)*{SEMICOLON}

COMMENT    "/*"([^/]|"/"[^*])*"*/"|"//"(.)*(\n|\r)
/* An hack to recognize a C++ comment at the EOF without newline: */
CPLUSPLUSCOMMENT_AT_EOF "//"[^\n\r]*

%%

{WHITESPACE}|{COMMENT}  {}
{CPLUSPLUSCOMMENT_AT_EOF} { /* do nothing. This is a rough hack to accept
                               a C++-style comment at the EOF, without a nnewline */ }
{QUALIFIED_IDENTIFIER}  {
                          int i,length=strlen(yytext),
			      last_separator_found;
			  char module[MODULES_PATH_LENGTH];

		          for(i=0;i<length;i++)
			    if(yytext[i]==':'){
			      yytext[i]=PATH_SEPARATOR;
			      last_separator_found=i;
			    }
			  yytext[last_separator_found]='\0';
			  strcpy(module,yytext);
			  strcpy(module+last_separator_found,".epi");
			  
			  //printf("<MODULE %s>\n",yytext);
                          make_child_of(new_module(module),current_module);
                        }
{IMPORTATION} {
                int i,begin;
		begin=7;/* skip "import " */

		while(1){
		  for(i=begin;isspace(yytext[i])||(yytext[i]==',');i++)
		    /* do nothing */;

		  if((yytext[i]==';')||(yytext[i]=='\0'))
		    break;
                
		  begin=i;
		  for(;(yytext[i]!=';')&&(!isspace(yytext[i])&&(yytext[i]!=','));i++)
                    if(yytext[i]==':')
                      yytext[i]=PATH_SEPARATOR;
                  yytext[i]='\0';
                
		  //printf("<MODULE %s>\n",yytext+begin);
		  make_child_of(new_module(append_extension(yytext+begin,"epi")),current_module);
                  
		  begin=i+1;
		} /* while */ 
             }

.            {}


%%

char* append_extension(char* name, char* e){
  static char buffer[MODULES_PATH_LENGTH+5];
  static char extension[5];
  strcpy(extension+1,e);
  extension[0]='.';

  strcpy(buffer,name);
  strcat(buffer,extension);

  return buffer;
}

int yywrap(){
  return 1;
}
