/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef BYTECODE_H_
#define BYTECODE_H_


#include "eam_types.h"

typedef struct
{
  integer_t opcode;
  /* parameter_[1-3] are also used for addresses of immediate string, global
     and exception parameters, and for register parameters */
  word_t parameter_1;
  word_t parameter_2;
  word_t parameter_3;
  wide_integer_t wide_integer_parameter;
  float_t float_parameter;
  wide_float_t wide_float_parameter;
  wide_wide_float_t wide_wide_float_parameter;
  integer_t label_parameter;
}
instruction_t;

typedef struct
{
  char* symbol_name;
  integer_t library_index;
}
c_symbol_t;

struct epsilon_executable
{
  char bytecode_version[5];
  integer_t pragmas;

  integer_t word_registers_no;
  integer_t wide_integer_registers_no;
  integer_t float_registers_no;
  integer_t wide_float_registers_no;
  integer_t wide_wide_float_registers_no;
  
  instruction_t *instructions;
  integer_t instructions_no;
  
  char **string_constants;
  integer_t string_constants_no;
  
  integer_t globals_no;

  char **exceptions;
  integer_t exceptions_no;

  char **c_libraries;
  integer_t c_libraries_no;

  c_symbol_t *c_symbols;
  integer_t c_symbols_no;
};

struct epsilon_module
{
  char bytecode_version[5];
  integer_t pragmas;

  char *name;

  integer_t needed_modules_no;
  char **needed_modules;

  integer_t word_registers_no;
  integer_t wide_integer_registers_no;
  integer_t float_registers_no;
  integer_t wide_float_registers_no;
  integer_t wide_wide_float_registers_no;
  
  instruction_t *instructions;
  integer_t instructions_no;
  
  char **string_constants;
  integer_t string_constants_no;
  
  char **globals;
  integer_t globals_no;
  
  char **exceptions;
  integer_t exceptions_no;

  char **c_libraries;
  integer_t c_libraries_no;

  c_symbol_t *c_symbols;
  integer_t c_symbols_no;
};

struct epsilon_library
{
  integer_t pragmas;

  integer_t modules_no;
  struct epsilon_module **modules;
};

void destroy_epsilon_executable (struct epsilon_executable *m);
void destroy_epsilon_module (struct epsilon_module *m);
void destroy_epsilon_library (struct epsilon_library *l);

/* These functions return NULL on failure */
struct epsilon_executable *read_epsilon_executable_file (const char *filename);
struct epsilon_module *read_epsilon_module_file (const char *filename);
struct epsilon_library *read_epsilon_library_file (const char *filename);

/* These functions return 0 on success: */
int write_epsilon_executable_file (const struct epsilon_executable *e,
				   const char *filename);
int write_epsilon_module_file (const struct epsilon_module *m,
			       const char *filename);
int write_epsilon_library_file (const struct epsilon_library *l,
				const char *filename);

#endif /* #ifndef BYTECODE_H_ */
