/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef EAM_TYPES_H_
#define EAM_TYPES_H_

#include "../config.h"

#ifndef HAVE_LONG_LONG
//#warning This architecture does not support C99 long long
  #define long_long long
  #undef SIZEOF_LONG_LONG
  #define SIZEOF_LONG_LONG SIZEOF_LONG
#else
  #define long_long long long
  /* SIZEOF_LONG_LONG is already defined */
#endif

#ifndef HAVE_LONG_DOUBLE
//#warning This architecture does not support long double
  #define long_double double
  #undef SIZEOF_LONG_DOUBLE
  #define SIZEOF_LONG_DOUBLE SIZEOF_DOUBLE
#else
  #define long_double long double
  /* SIZEOF_LONG_DOUBLE is already defined */
#endif

/* integer_t must be exactly wide as void*: */
#if SIZEOF_VOID_P == SIZEOF_SHORT
  #error void* is as wide as short... Is this a 16-bit machine?
#elif SIZEOF_VOID_P == SIZEOF_INT
  typedef int integer_t;
  typedef unsigned int unsigned_integer_t;
  #define SIZEOF_INTEGER_T SIZEOF_INT
  #define INTEGER_T_FORMAT "%i"
//#warning integer_t is an int
#elif SIZEOF_VOID_P == SIZEOF_LONG
  typedef long integer_t;
  typedef unsigned long unsigned_integer_t;
  #define SIZEOF_INTEGER_T SIZEOF_LONG
  #define INTEGER_T_FORMAT "%li"
//#warning integer_t is a long
#elif SIZEOF_VOID_P == SIZEOF_LONG_LONG
/* This can not happen if we don't really have long long: in this
   case long would have matched since the test is before this one */
  #warning This is strange, void* is as wide as long long...
  typedef long_long integer_t;
  typedef unsigned long_long unsigned_integer_t;
  #define SIZEOF_INTEGER_T SIZEOF_LONG_LONG
  #define INTEGER_T_FORMAT "%lli"
//#warning integer_t is a long long
#else
  /* This should not happen */
  #error There is no integer type as wide as void*
#endif

/* Let's define wide_integer_t: */
#if SIZEOF_LONG > SIZEOF_INTEGER_T
  typedef long wide_integer_t;
  #define SIZEOF_WIDE_INTEGER_T SIZEOF_LONG
  #define WIDE_INTEGER_T_FORMAT "%li"
//#warning wide_integer_t is a long
#elif SIZEOF_LONG_LONG > SIZEOF_INTEGER_T
/* This can not happen if we don't really have long long: in this
   case long would have matched since the test is before this one */
  typedef long_long wide_integer_t;
  #define SIZEOF_WIDE_INTEGER_T SIZEOF_LONG_LONG
  #define WIDE_INTEGER_T_FORMAT "%lli"
//#warning wide_integer_t is a long long
#else
//  #warning wide_integer_t is equal to integer_t
  typedef integer_t wide_integer_t;
  #define SIZEOF_WIDE_INTEGER_T SIZEOF_INTEGER_T
  #define WIDE_INTEGER_T_FORMAT INTEGER_T_FORMAT
#endif

/* float_t must be exactly wide as void*: */
#if SIZEOF_VOID_P == SIZEOF_FLOAT
//#warning float_t is a float
  typedef float float_t;
  #define SIZEOF_FLOAT_T SIZEOF_FLOAT
  #define FLOAT_T_FORMAT "%f"
#elif SIZEOF_VOID_P == SIZEOF_DOUBLE
//#warning float_t is a double
  typedef double float_t;
  #define SIZEOF_FLOAT_T SIZEOF_DOUBLE
  #define FLOAT_T_FORMAT "%lf"
#elif SIZEOF_VOID_P == SIZEOF_LONG_DOUBLE
/* This can not happen if we don't really have long dobule: in this
   case double would have matched since the test is before this one */
//  #warning This is strange, void* is as wide as long double...
  typedef long_double float_t;
  #define SIZEOF_FLOAT_T SIZEOF_LONG_DOUBLE
  #define FLOAT_T_FORMAT "%llf"
#endif

/* A void*, an integer_t or a float_t must fit exactly in a word_t: */
typedef void* word_t;

/* Let's define wide_float_t: */
#if SIZEOF_DOUBLE > SIZEOF_FLOAT_T
  typedef double wide_float_t;
  #define SIZEOF_WIDE_FLOAT_T SIZEOF_DOUBLE
  #define WIDE_FLOAT_T_FORMAT "%lf"
//#warning wide_float_t is a double
#elif SIZEOF_LONG_DOUBLE > SIZEOF_FLOAT_T
/* This can not happen if we don't really have long double: in this
   case double would have matched since the test is before this one */
  typedef long_double wide_float_t;
  #define SIZEOF_WIDE_FLOAT_T SIZEOF_LONG_DOUBLE
  #define WIDE_FLOAT_T_FORMAT "%llf"
//#warning wide_float_t is a long double
#else
//  #warning wide_float_t is equal to float_t
  typedef float_t wide_float_t;
  #define SIZEOF_WIDE_FLOAT_T SIZEOF_FLOAT_T
  #define WIDE_FLOAT_T_FORMAT FLOAT_T_FORMAT
#endif


/* Let's define wide_wide_float_t: */
#if SIZEOF_DOUBLE > SIZEOF_WIDE_FLOAT_T
  typedef double wide_wide_float_t;
  #define SIZEOF_WIDE_WIDE_FLOAT_T SIZEOF_DOUBLE
  #define WIDE_WIDE_FLOAT_T_FORMAT "%lf"
//#warning wide_wide_float_t is a double
#elif SIZEOF_LONG_DOUBLE > SIZEOF_WIDE_FLOAT_T
/* This can not happen if we don't really have long double: in this
   case double would have matched since the test is before this one */
  typedef long_double wide_wide_float_t;
  #define SIZEOF_WIDE_WIDE_FLOAT_T SIZEOF_LONG_DOUBLE
  #define WIDE_WIDE_FLOAT_T_FORMAT "%llf"
//#warning wide_wide_float_t is a long double
#else
//  #warning wide_wide_float_t is equal to wide_float_t
  typedef wide_float_t wide_wide_float_t;
  #define SIZEOF_WIDE_WIDE_FLOAT_T SIZEOF_WIDE_FLOAT_T
  #define WIDE_WIDE_FLOAT_T_FORMAT WIDE_FLOAT_T_FORMAT
#endif

#endif /* #ifndef EAM_TYPES_H_ */
