
/*  A Bison parser, made from eamlasparser.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	INTEGER_CONSTANT	257
#define	WIDE_INTEGER_CONSTANT	258
#define	FLOAT_CONSTANT	259
#define	WIDE_FLOAT_CONSTANT	260
#define	WIDE_WIDE_FLOAT_CONSTANT	261
#define	STRING_CONSTANT	262
#define	LABEL	263
#define	WORD_REGISTER	264
#define	WIDE_INTEGER_REGISTER	265
#define	FLOAT_REGISTER	266
#define	WIDE_FLOAT_REGISTER	267
#define	WIDE_WIDE_FLOAT_REGISTER	268
#define	INSTRUCTION_addi	269
#define	INSTRUCTION_addi_i	270
#define	INSTRUCTION_clargs	271
#define	INSTRUCTION_cpy	272
#define	INSTRUCTION_dfhn	273
#define	INSTRUCTION_divi	274
#define	INSTRUCTION_divi_i	275
#define	INSTRUCTION_dummy_register_integer_register	276
#define	INSTRUCTION_f_divi	277
#define	INSTRUCTION_gcin	278
#define	INSTRUCTION_hlt	279
#define	INSTRUCTION_inc	280
#define	INSTRUCTION_ini	281
#define	INSTRUCTION_ins	282
#define	INSTRUCTION_j	283
#define	INSTRUCTION_jde	284
#define	INSTRUCTION_lbl	285
#define	INSTRUCTION_ldci	286
#define	INSTRUCTION_muli	287
#define	INSTRUCTION_muli_i	288
#define	INSTRUCTION_nlcl	289
#define	INSTRUCTION_nln	290
#define	INSTRUCTION_nop	291
#define	INSTRUCTION_outi	292
#define	INSTRUCTION_pop	293
#define	INSTRUCTION_popf	294
#define	INSTRUCTION_popfn	295
#define	INSTRUCTION_popm	296
#define	INSTRUCTION_poptry	297
#define	INSTRUCTION_pshcf	298
#define	INSTRUCTION_pshci	299
#define	INSTRUCTION_pshcs	300
#define	INSTRUCTION_pshgl	301
#define	INSTRUCTION_pshnll	302
#define	INSTRUCTION_psho	303
#define	INSTRUCTION_pshtry	304
#define	INSTRUCTION_rthrw	305
#define	INSTRUCTION_s_addf	306
#define	INSTRUCTION_s_addi	307
#define	INSTRUCTION_s_addi_i	308
#define	INSTRUCTION_s_andi	309
#define	INSTRUCTION_s_barlt	310
#define	INSTRUCTION_s_cact	311
#define	INSTRUCTION_s_cactp	312
#define	INSTRUCTION_s_car	313
#define	INSTRUCTION_s_cctba	314
#define	INSTRUCTION_s_cdr	315
#define	INSTRUCTION_s_cfun	316
#define	INSTRUCTION_s_chst	317
#define	INSTRUCTION_s_cll	318
#define	INSTRUCTION_s_cls	319
#define	INSTRUCTION_s_clsr	320
#define	INSTRUCTION_s_cns	321
#define	INSTRUCTION_s_cobj	322
#define	INSTRUCTION_s_divf	323
#define	INSTRUCTION_s_divi	324
#define	INSTRUCTION_s_divi_i	325
#define	INSTRUCTION_s_eqf	326
#define	INSTRUCTION_s_eqi	327
#define	INSTRUCTION_s_eqi_i	328
#define	INSTRUCTION_s_eqs	329
#define	INSTRUCTION_s_f_divi	330
#define	INSTRUCTION_s_f_modi	331
#define	INSTRUCTION_s_fcll	332
#define	INSTRUCTION_s_filec	333
#define	INSTRUCTION_s_fileor	334
#define	INSTRUCTION_s_fileow	335
#define	INSTRUCTION_s_filerc	336
#define	INSTRUCTION_s_filewc	337
#define	INSTRUCTION_s_flin	338
#define	INSTRUCTION_s_frtoba	339
#define	INSTRUCTION_s_fscll	340
#define	INSTRUCTION_s_gl	341
#define	INSTRUCTION_s_gtef	342
#define	INSTRUCTION_s_gtei	343
#define	INSTRUCTION_s_gtei_i	344
#define	INSTRUCTION_s_gtes	345
#define	INSTRUCTION_s_gtf	346
#define	INSTRUCTION_s_gti	347
#define	INSTRUCTION_s_gti_i	348
#define	INSTRUCTION_s_gts	349
#define	INSTRUCTION_s_infl	350
#define	INSTRUCTION_s_jandi	351
#define	INSTRUCTION_s_jeqi	352
#define	INSTRUCTION_s_jeqi_i	353
#define	INSTRUCTION_s_jgtei	354
#define	INSTRUCTION_s_jgtei_i	355
#define	INSTRUCTION_s_jgti	356
#define	INSTRUCTION_s_jgti_i	357
#define	INSTRUCTION_s_jltei	358
#define	INSTRUCTION_s_jltei_i	359
#define	INSTRUCTION_s_jlti	360
#define	INSTRUCTION_s_jlti_i	361
#define	INSTRUCTION_s_jnandi	362
#define	INSTRUCTION_s_jneqi	363
#define	INSTRUCTION_s_jneqi_i	364
#define	INSTRUCTION_s_jnm	365
#define	INSTRUCTION_s_jnori	366
#define	INSTRUCTION_s_jnxori	367
#define	INSTRUCTION_s_jnz	368
#define	INSTRUCTION_s_jori	369
#define	INSTRUCTION_s_jxori	370
#define	INSTRUCTION_s_jz	371
#define	INSTRUCTION_s_lcl	372
#define	INSTRUCTION_s_lkp	373
#define	INSTRUCTION_s_lkp_i	374
#define	INSTRUCTION_s_lkpb	375
#define	INSTRUCTION_s_ltbar	376
#define	INSTRUCTION_s_ltef	377
#define	INSTRUCTION_s_ltei	378
#define	INSTRUCTION_s_ltei_i	379
#define	INSTRUCTION_s_ltes	380
#define	INSTRUCTION_s_ltf	381
#define	INSTRUCTION_s_lti	382
#define	INSTRUCTION_s_lti_i	383
#define	INSTRUCTION_s_lts	384
#define	INSTRUCTION_s_mka_i	385
#define	INSTRUCTION_s_mkba_i	386
#define	INSTRUCTION_s_modi	387
#define	INSTRUCTION_s_modi_i	388
#define	INSTRUCTION_s_mulf	389
#define	INSTRUCTION_s_muli	390
#define	INSTRUCTION_s_muli_i	391
#define	INSTRUCTION_s_neqi	392
#define	INSTRUCTION_s_neqi_i	393
#define	INSTRUCTION_s_neqs	394
#define	INSTRUCTION_s_nlcl	395
#define	INSTRUCTION_s_nll	396
#define	INSTRUCTION_s_nnll	397
#define	INSTRUCTION_s_noti	398
#define	INSTRUCTION_s_nxori	399
#define	INSTRUCTION_s_ori	400
#define	INSTRUCTION_s_outc	401
#define	INSTRUCTION_s_outec	402
#define	INSTRUCTION_s_outes	403
#define	INSTRUCTION_s_outf	404
#define	INSTRUCTION_s_outi	405
#define	INSTRUCTION_s_outs	406
#define	INSTRUCTION_s_popl	407
#define	INSTRUCTION_s_powf	408
#define	INSTRUCTION_s_powi	409
#define	INSTRUCTION_s_powi_i	410
#define	INSTRUCTION_s_pshf	411
#define	INSTRUCTION_s_pshl	412
#define	INSTRUCTION_s_ret	413
#define	INSTRUCTION_s_retn	414
#define	INSTRUCTION_s_scll	415
#define	INSTRUCTION_s_seto	416
#define	INSTRUCTION_s_subf	417
#define	INSTRUCTION_s_subi	418
#define	INSTRUCTION_s_subi_i	419
#define	INSTRUCTION_s_swp	420
#define	INSTRUCTION_s_thrw	421
#define	INSTRUCTION_s_umini	422
#define	INSTRUCTION_s_xori	423
#define	INSTRUCTION_setfp	424
#define	INSTRUCTION_subi	425
#define	INSTRUCTION_subi_i	426
#define	INSTRUCTION_swp	427

#line 23 "eamlasparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "../common/command_line.h"
#include "../common/string_map.h"

#include "../commontext.h"
#include "bytecode.h"
#include "instructions.h"

int yylex();

extern int yylineno;
extern char* yytext;
extern int yyleng;

extern FILE *yyin,*yyout;

void yyerror(const char *s);

struct epsilon_module this_module;
int needed_modules_size = 1; // To do: make this bigger

extern integer_t current_opcode;
extern integer_t current_integer;

/* The value, i.e. index, of the last register token: */
/* (defined in eamlasscanner_l.head) */
extern integer_t current_word_register;
extern integer_t current_wide_integer_register;
extern integer_t current_float_register;
extern integer_t current_wide_float_register;
extern integer_t current_wide_wide_float_register;

extern float_t current_float;

integer_t instructions_size = 1024;
integer_t string_constants_size = 128;
integer_t globals_size = 128;
integer_t exceptions_size = 128;
integer_t c_libraries_size = 128;
integer_t c_symbols_size = 128;

struct string_map* needed_modules_set;

/* These structures are used to keep track of the labels -> instruction no
   mapping, and for doing the final backpatch which resolves label uses: */
#define MAXIMUM_REASONABLE_SIZE_OF_STRING   (1001 * sizeof(char))
#define MAXIMUM_REASONABLE_SIZE_OF_INTEGER (11   * sizeof(char))
struct string_map* label_to_instruction_number;
struct backpatch_item{
  integer_t instruction_no;
  char label[MAXIMUM_REASONABLE_SIZE_OF_STRING];
}* instructions_to_backpatch;
integer_t instructions_to_backpatch_size=32;
integer_t instructions_to_backpatch_no=0;

void memoize_label(char* label, integer_t instruction){
  char instruction_as_string[MAXIMUM_REASONABLE_SIZE_OF_INTEGER / sizeof(char)];

  sprintf(instruction_as_string, "%i", instruction);
  if(access_string_map(label_to_instruction_number, label) != NULL)
    yyerror("label is defined twice");
  insert_into_string_map(label_to_instruction_number,
			 label,
			 instruction_as_string);
}

integer_t label_to_instruction_no(char* label){
  char* instruction_no_as_string;
  integer_t r;

  instruction_no_as_string = 
    access_string_map(label_to_instruction_number, label);
  if(instruction_no_as_string == NULL)
    yyerror("jump to undefined label");
  sscanf(instruction_no_as_string, INTEGER_T_FORMAT, &r);
  return r;
}

void memoize_label_use(integer_t instruction_no, char* label){
  if(++instructions_to_backpatch_no > instructions_to_backpatch_size){
    instructions_to_backpatch_size *= 2;
    instructions_to_backpatch = (struct backpatch_item*) 
      realloc(instructions_to_backpatch,
	      sizeof(struct backpatch_item) * instructions_to_backpatch_size);
  }
  instructions_to_backpatch[instructions_to_backpatch_no - 1].instruction_no =
    instruction_no;
  strcpy(instructions_to_backpatch[instructions_to_backpatch_no - 1].label,
	 label);
}

void backpatch(){
  integer_t i, instruction_no;
  char* label;

  for(i = 0; i < instructions_to_backpatch_no; i++){
    instruction_no = instructions_to_backpatch[i].instruction_no;
    label = instructions_to_backpatch[i].label;
    this_module.instructions[instruction_no].label_parameter =
      label_to_instruction_no(label);
  }
}

void add_instruction(integer_t opcode){
  if(++this_module.instructions_no > instructions_size){
    instructions_size *= 2;
    this_module.instructions = (instruction_t*) 
      realloc(this_module.instructions, sizeof(instruction_t) * instructions_size);
  }
  this_module.instructions[this_module.instructions_no - 1].opcode = opcode;
}

/* Non-reentrant */
char* qualified_identifier_to_module(const char* s){
  integer_t i, length_of_s = strlen(s), length_of_module_name;
  static char* static_string = NULL;
  static integer_t static_string_size = 0;

  //abc:ide1$
  //012345670

  for(i = length_of_s - 1; i >= 0; i--)
    if(s[i] == ':'){
      length_of_module_name = i;
      if(static_string_size < length_of_module_name + 1){
	static_string_size = length_of_module_name + 1;
	static_string = (char*)
	  realloc(static_string, sizeof(char) * static_string_size);
      }
      strncpy(static_string, s, length_of_module_name);
      static_string[length_of_module_name] = '\0';
      /* fprintf(stderr, ">>qualified_identifier_to_module(%s) is %s<<\n", s, static_string); */
      return static_string;
    }
  fprintf(stderr, "About the identifier \"%s\":\n", s);
  fatal("Non-qualified identifier in eAML module");
}

void add_dependency_for_qualified_identifier(char* s){
  char* module_name = qualified_identifier_to_module(s);
  static int unused;

  if((is_string_map_defined_on(needed_modules_set, module_name))
     ||(!strcmp(module_name, this_module.name)))
    return; /* We already stored module_name, or the identifier is
	       defined in this same module */
  else
    insert_into_string_map(needed_modules_set, module_name, &unused);

  /* Increment needed_modules_no, and expand buffer if needed: */
  if(++this_module.needed_modules_no > needed_modules_size){
    needed_modules_size *= 2;
    this_module.needed_modules = (char**)realloc(this_module.needed_modules,
						 sizeof(char*) * needed_modules_size);
  }
  
  /* Store the element: */
  this_module.needed_modules[this_module.needed_modules_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(module_name) + 1));
  strcpy(this_module.needed_modules[this_module.needed_modules_no - 1],
	 module_name);
}

void add_string_constant(char* x){
  /* There is no need that string constants are unique in the .eamo file. No
     set_of_string_constants is needed. */
  if(++this_module.string_constants_no > string_constants_size){
    string_constants_size *= 2;
    this_module.string_constants =
      (char**) realloc(this_module.string_constants,
		       sizeof(char*) * string_constants_size);
  }
  this_module.string_constants[this_module.string_constants_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(x) + 1));
  strcpy(this_module.string_constants[this_module.string_constants_no - 1], x);
}

struct string_map* set_of_globals;
integer_t add_global(char* x){
  if(is_string_map_defined_on(set_of_globals, x)){
    /* x is already defined */
    return *((integer_t*)access_string_map(set_of_globals, x));
  }
  else
    insert_into_string_map(set_of_globals, x, &this_module.globals_no);

  add_dependency_for_qualified_identifier(x);
  if(++this_module.globals_no > globals_size){
    globals_size *= 2;
    this_module.globals =
      (char**) realloc(this_module.globals,
		       sizeof(char*) * globals_size);
  }
  this_module.globals[this_module.globals_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(x) + 1));
  strcpy(this_module.globals[this_module.globals_no - 1], x);
  return this_module.globals_no - 1; /* index of the element we inserted */
}

struct string_map* set_of_exceptions;
integer_t add_exception(char* x){
  if(is_string_map_defined_on(set_of_exceptions, x)){
    /* x is already defined */
    return *((integer_t*)access_string_map(set_of_exceptions, x));
  }
  else
    insert_into_string_map(set_of_exceptions, x, &this_module.exceptions_no);
  
  add_dependency_for_qualified_identifier(x);
  if(++this_module.exceptions_no > exceptions_size){
    exceptions_size *= 2;
    this_module.exceptions =
      (char**) realloc(this_module.exceptions,
		       sizeof(char*) * exceptions_size);
  }
  this_module.exceptions[this_module.exceptions_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(x) + 1));
  strcpy(this_module.exceptions[this_module.exceptions_no - 1], x);
  return this_module.exceptions_no - 1; /* index of the element we inserted */
}

struct string_map* set_of_c_symbols_and_libraries;
struct string_map* set_of_c_libraries;
integer_t add_c_symbol(char* symbol_name, char* library_name){
  char* c_symbol_and_library = (char*)
    malloc(strlen(symbol_name) + strlen(library_name) + 2 /* space and '\0' */);
  sprintf(c_symbol_and_library, "%s %s", symbol_name, library_name);

  if(is_string_map_defined_on(set_of_c_symbols_and_libraries,
			      c_symbol_and_library)){ /* already defined */
    integer_t r = *((integer_t*)access_string_map(set_of_c_symbols_and_libraries,
						  c_symbol_and_library));
    free(c_symbol_and_library);
    return r;
  }
  else
    insert_into_string_map(set_of_c_symbols_and_libraries,
			   c_symbol_and_library,
			   &this_module.c_symbols_no);
  free(c_symbol_and_library); /* not needed any more */
  
  if(! is_string_map_defined_on(set_of_c_libraries, library_name)){
    insert_into_string_map(set_of_c_libraries,
			   library_name,
			   &this_module.c_libraries_no);
    if(++this_module.c_libraries_no > c_libraries_size){
      c_libraries_size *= 2;
      this_module.c_libraries =
	(char**) realloc(this_module.c_libraries,
			 sizeof(char*) * c_libraries_size);
    }
    this_module.c_libraries[this_module.c_libraries_no - 1] = 
      (char*) malloc(sizeof(char) * (strlen(library_name) + 1));
    strcpy(this_module.c_libraries[this_module.c_libraries_no - 1],
	   library_name);
  }

  if(++this_module.c_symbols_no > c_symbols_size){
    c_symbols_size *= 2;
    this_module.c_symbols =
      (c_symbol_t*) realloc(this_module.c_symbols,
			    sizeof(c_symbol_t) * c_symbols_size);
  }
  this_module.c_symbols[this_module.c_symbols_no - 1].symbol_name = 
    (char*) malloc(sizeof(char) * (strlen(symbol_name) + 1));
  strcpy(this_module.c_symbols[this_module.c_symbols_no - 1].symbol_name,
	 symbol_name);
  this_module.c_symbols[this_module.c_symbols_no - 1].library_index = 
    *(integer_t*)(access_string_map(set_of_c_libraries, library_name));
  //  fprintf(stderr, "<NAME is %s> ", this_module.c_symbols[this_module.c_symbols_no - 1].symbol_name);
  //  fprintf(stderr, "<index is "INTEGER_T_FORMAT">\n", this_module.c_symbols[this_module.c_symbols_no - 1].library_index);
  return this_module.c_symbols_no - 1; /* index of the element we inserted */
}

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		227
#define	YYFLAG		-32768
#define	YYNTBASE	174

#define YYTRANSLATE(x) ((unsigned)(x) <= 427 ? yytranslate[x] : 208)

static const short yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
    57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
    77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
    87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
    97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
   107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
   117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
   127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
   137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
   147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
   157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
   167,   168,   169,   170,   171,   172,   173
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     4,     6,     8,    10,    12,    14,    16,    18,
    20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
    40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
    60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
    80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
   100,   102,   104,   106,   108,   110,   112,   114,   116,   118,
   120,   122,   124,   126,   128,   130,   132,   134,   136,   138,
   140,   142,   144,   146,   148,   150,   152,   154,   156,   158,
   160,   162,   164,   166,   168,   170,   172,   174,   176,   178,
   180,   182,   184,   186,   188,   190,   192,   194,   196,   198,
   200,   202,   204,   206,   208,   210,   212,   214,   216,   218,
   220,   222,   224,   226,   228,   230,   232,   234,   236,   238,
   240,   242,   244,   246,   248,   250,   252,   254,   256,   258,
   260,   262,   264,   266,   268,   270,   272,   274,   276,   278,
   280,   282,   284,   286,   288,   290,   292,   294,   296,   298,
   300,   302,   304,   306,   308,   310,   312,   314,   316,   318,
   320,   323,   324,   329,   330,   331,   338,   339,   340,   347,
   348,   353,   354,   355,   362,   363,   364,   371,   374,   375,
   380,   383,   386,   387,   392,   393,   398,   401,   404,   405,
   410,   413,   414,   417
};

static const short yyrhs[] = {   167,
     0,    30,     0,    44,     0,    47,     0,    87,     0,    25,
     0,    42,     0,    45,     0,    54,     0,    64,     0,    71,
     0,    74,     0,    78,     0,    86,     0,    90,     0,    94,
     0,   118,     0,   120,     0,   125,     0,   129,     0,   131,
     0,   132,     0,   134,     0,   137,     0,   139,     0,   156,
     0,   157,     0,   158,     0,   161,     0,   165,     0,   141,
     0,    99,     0,   101,     0,   103,     0,   105,     0,   107,
     0,   110,     0,   111,     0,    29,     0,    50,     0,    65,
     0,    66,     0,    97,     0,    98,     0,   100,     0,   102,
     0,   104,     0,   106,     0,   108,     0,   109,     0,   112,
     0,   113,     0,   114,     0,   115,     0,   116,     0,   117,
     0,    17,     0,    18,     0,    19,     0,    24,     0,    26,
     0,    27,     0,    28,     0,    31,     0,    37,     0,    39,
     0,    40,     0,    41,     0,    43,     0,    48,     0,    49,
     0,    51,     0,    52,     0,    53,     0,    55,     0,    56,
     0,    59,     0,    60,     0,    61,     0,    63,     0,    67,
     0,    69,     0,    70,     0,    72,     0,    73,     0,    75,
     0,    76,     0,    77,     0,    79,     0,    80,     0,    81,
     0,    82,     0,    83,     0,    84,     0,    85,     0,    88,
     0,    89,     0,    91,     0,    92,     0,    93,     0,    95,
     0,    96,     0,   119,     0,   121,     0,   122,     0,   123,
     0,   124,     0,   126,     0,   127,     0,   128,     0,   130,
     0,   133,     0,   135,     0,   136,     0,   138,     0,   140,
     0,   142,     0,   143,     0,   144,     0,   145,     0,   146,
     0,   147,     0,   148,     0,   149,     0,   150,     0,   151,
     0,   152,     0,   153,     0,   154,     0,   155,     0,   159,
     0,   160,     0,   162,     0,   163,     0,   164,     0,   166,
     0,   168,     0,   169,     0,    38,     0,    32,     0,    35,
     0,    22,     0,   173,     0,    16,     0,    21,     0,    34,
     0,   172,     0,    15,     0,    20,     0,    23,     0,    33,
     0,   171,     0,    46,     0,   170,     0,    36,     0,    57,
     0,    58,     0,    62,     0,    68,     0,   182,     0,   183,
    10,     0,     0,   187,    10,   193,    10,     0,     0,     0,
   186,    10,   194,     3,   195,    10,     0,     0,     0,   189,
    10,   196,    10,   197,    10,     0,     0,   184,    10,   198,
     3,     0,     0,     0,   188,    10,   199,    10,   200,     3,
     0,     0,     0,   185,    10,   201,     3,   202,     3,     0,
   178,     3,     0,     0,   179,     3,   203,     3,     0,   177,
     8,     0,   174,     8,     0,     0,   175,     8,   204,     9,
     0,     0,   180,     3,   205,     9,     0,   176,     5,     0,
   190,     8,     0,     0,   191,     8,   206,     8,     0,   181,
     9,     0,     0,   207,     9,     0,   207,   192,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   472,   474,   476,   478,   479,   481,   482,   483,   484,   485,
   486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
   496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
   507,   509,   510,   511,   512,   513,   514,   515,   517,   518,
   519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
   529,   530,   531,   532,   533,   534,   536,   537,   538,   539,
   540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
   550,   551,   552,   553,   554,   555,   556,   557,   558,   559,
   560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
   570,   571,   572,   573,   574,   575,   576,   577,   578,   579,
   580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
   590,   591,   592,   593,   594,   595,   596,   597,   598,   599,
   600,   601,   602,   603,   604,   605,   606,   607,   608,   609,
   610,   611,   612,   613,   614,   615,   616,   617,   619,   621,
   623,   625,   627,   629,   630,   631,   632,   634,   635,   636,
   637,   638,   640,   641,   643,   644,   645,   646,   647,   671,
   675,   682,   690,   693,   701,   704,   707,   715,   718,   721,
   729,   732,   740,   743,   746,   754,   757,   760,   767,   774,
   777,   788,   798,   807,   811,   818,   822,   830,   840,   849,
   869,   876,   878,   883
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","INTEGER_CONSTANT",
"WIDE_INTEGER_CONSTANT","FLOAT_CONSTANT","WIDE_FLOAT_CONSTANT","WIDE_WIDE_FLOAT_CONSTANT",
"STRING_CONSTANT","LABEL","WORD_REGISTER","WIDE_INTEGER_REGISTER","FLOAT_REGISTER",
"WIDE_FLOAT_REGISTER","WIDE_WIDE_FLOAT_REGISTER","INSTRUCTION_addi","INSTRUCTION_addi_i",
"INSTRUCTION_clargs","INSTRUCTION_cpy","INSTRUCTION_dfhn","INSTRUCTION_divi",
"INSTRUCTION_divi_i","INSTRUCTION_dummy_register_integer_register","INSTRUCTION_f_divi",
"INSTRUCTION_gcin","INSTRUCTION_hlt","INSTRUCTION_inc","INSTRUCTION_ini","INSTRUCTION_ins",
"INSTRUCTION_j","INSTRUCTION_jde","INSTRUCTION_lbl","INSTRUCTION_ldci","INSTRUCTION_muli",
"INSTRUCTION_muli_i","INSTRUCTION_nlcl","INSTRUCTION_nln","INSTRUCTION_nop",
"INSTRUCTION_outi","INSTRUCTION_pop","INSTRUCTION_popf","INSTRUCTION_popfn",
"INSTRUCTION_popm","INSTRUCTION_poptry","INSTRUCTION_pshcf","INSTRUCTION_pshci",
"INSTRUCTION_pshcs","INSTRUCTION_pshgl","INSTRUCTION_pshnll","INSTRUCTION_psho",
"INSTRUCTION_pshtry","INSTRUCTION_rthrw","INSTRUCTION_s_addf","INSTRUCTION_s_addi",
"INSTRUCTION_s_addi_i","INSTRUCTION_s_andi","INSTRUCTION_s_barlt","INSTRUCTION_s_cact",
"INSTRUCTION_s_cactp","INSTRUCTION_s_car","INSTRUCTION_s_cctba","INSTRUCTION_s_cdr",
"INSTRUCTION_s_cfun","INSTRUCTION_s_chst","INSTRUCTION_s_cll","INSTRUCTION_s_cls",
"INSTRUCTION_s_clsr","INSTRUCTION_s_cns","INSTRUCTION_s_cobj","INSTRUCTION_s_divf",
"INSTRUCTION_s_divi","INSTRUCTION_s_divi_i","INSTRUCTION_s_eqf","INSTRUCTION_s_eqi",
"INSTRUCTION_s_eqi_i","INSTRUCTION_s_eqs","INSTRUCTION_s_f_divi","INSTRUCTION_s_f_modi",
"INSTRUCTION_s_fcll","INSTRUCTION_s_filec","INSTRUCTION_s_fileor","INSTRUCTION_s_fileow",
"INSTRUCTION_s_filerc","INSTRUCTION_s_filewc","INSTRUCTION_s_flin","INSTRUCTION_s_frtoba",
"INSTRUCTION_s_fscll","INSTRUCTION_s_gl","INSTRUCTION_s_gtef","INSTRUCTION_s_gtei",
"INSTRUCTION_s_gtei_i","INSTRUCTION_s_gtes","INSTRUCTION_s_gtf","INSTRUCTION_s_gti",
"INSTRUCTION_s_gti_i","INSTRUCTION_s_gts","INSTRUCTION_s_infl","INSTRUCTION_s_jandi",
"INSTRUCTION_s_jeqi","INSTRUCTION_s_jeqi_i","INSTRUCTION_s_jgtei","INSTRUCTION_s_jgtei_i",
"INSTRUCTION_s_jgti","INSTRUCTION_s_jgti_i","INSTRUCTION_s_jltei","INSTRUCTION_s_jltei_i",
"INSTRUCTION_s_jlti","INSTRUCTION_s_jlti_i","INSTRUCTION_s_jnandi","INSTRUCTION_s_jneqi",
"INSTRUCTION_s_jneqi_i","INSTRUCTION_s_jnm","INSTRUCTION_s_jnori","INSTRUCTION_s_jnxori",
"INSTRUCTION_s_jnz","INSTRUCTION_s_jori","INSTRUCTION_s_jxori","INSTRUCTION_s_jz",
"INSTRUCTION_s_lcl","INSTRUCTION_s_lkp","INSTRUCTION_s_lkp_i","INSTRUCTION_s_lkpb",
"INSTRUCTION_s_ltbar","INSTRUCTION_s_ltef","INSTRUCTION_s_ltei","INSTRUCTION_s_ltei_i",
"INSTRUCTION_s_ltes","INSTRUCTION_s_ltf","INSTRUCTION_s_lti","INSTRUCTION_s_lti_i",
"INSTRUCTION_s_lts","INSTRUCTION_s_mka_i","INSTRUCTION_s_mkba_i","INSTRUCTION_s_modi",
"INSTRUCTION_s_modi_i","INSTRUCTION_s_mulf","INSTRUCTION_s_muli","INSTRUCTION_s_muli_i",
"INSTRUCTION_s_neqi","INSTRUCTION_s_neqi_i","INSTRUCTION_s_neqs","INSTRUCTION_s_nlcl",
"INSTRUCTION_s_nll","INSTRUCTION_s_nnll","INSTRUCTION_s_noti","INSTRUCTION_s_nxori",
"INSTRUCTION_s_ori","INSTRUCTION_s_outc","INSTRUCTION_s_outec","INSTRUCTION_s_outes",
"INSTRUCTION_s_outf","INSTRUCTION_s_outi","INSTRUCTION_s_outs","INSTRUCTION_s_popl",
"INSTRUCTION_s_powf","INSTRUCTION_s_powi","INSTRUCTION_s_powi_i","INSTRUCTION_s_pshf",
"INSTRUCTION_s_pshl","INSTRUCTION_s_ret","INSTRUCTION_s_retn","INSTRUCTION_s_scll",
"INSTRUCTION_s_seto","INSTRUCTION_s_subf","INSTRUCTION_s_subi","INSTRUCTION_s_subi_i",
"INSTRUCTION_s_swp","INSTRUCTION_s_thrw","INSTRUCTION_s_umini","INSTRUCTION_s_xori",
"INSTRUCTION_setfp","INSTRUCTION_subi","INSTRUCTION_subi_i","INSTRUCTION_swp",
"opcode_exception","opcode_exception_label","opcode_float","opcode_global","opcode_integer",
"opcode_integer_integer","opcode_integer_label","opcode_label","opcode_nullary",
"opcode_register","opcode_register_integer","opcode_register_integer_integer",
"opcode_register_integer_register","opcode_register_register","opcode_register_register_integer",
"opcode_register_register_register","opcode_string","opcode_string_string","instruction",
"@1","@2","@3","@4","@5","@6","@7","@8","@9","@10","@11","@12","@13","@14","module", NULL
};
#endif

static const short yyr1[] = {     0,
   174,   175,   176,   177,   177,   178,   178,   178,   178,   178,
   178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
   178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
   179,   180,   180,   180,   180,   180,   180,   180,   181,   181,
   181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
   181,   181,   181,   181,   181,   181,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
   182,   182,   182,   182,   182,   182,   182,   182,   183,   184,
   185,   186,   187,   188,   188,   188,   188,   189,   189,   189,
   189,   189,   190,   190,   191,   191,   191,   191,   191,   192,
   192,   193,   192,   194,   195,   192,   196,   197,   192,   198,
   192,   199,   200,   192,   201,   202,   192,   192,   203,   192,
   192,   192,   204,   192,   205,   192,   192,   192,   206,   192,
   192,   207,   207,   207
};

static const short yyr2[] = {     0,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     2,     0,     4,     0,     0,     6,     0,     0,     6,     0,
     4,     0,     0,     6,     0,     0,     6,     2,     0,     4,
     2,     2,     0,     4,     0,     4,     2,     2,     0,     4,
     2,     0,     2,     2
};

static const short yydefact[] = {   192,
     0,   193,   148,   144,    57,    58,    59,   149,   145,   142,
   150,    60,     6,    61,    62,    63,    39,     2,    64,   140,
   151,   146,   141,   155,    65,   139,    66,    67,    68,     7,
    69,     3,     8,   153,     4,    70,    71,    40,    72,    73,
    74,     9,    75,    76,   156,   157,    77,    78,    79,   158,
    80,    10,    41,    42,    81,   159,    82,    83,    11,    84,
    85,    12,    86,    87,    88,    13,    89,    90,    91,    92,
    93,    94,    95,    14,     5,    96,    97,    15,    98,    99,
   100,    16,   101,   102,    43,    44,    32,    45,    33,    46,
    34,    47,    35,    48,    36,    49,    50,    37,    38,    51,
    52,    53,    54,    55,    56,    17,   103,    18,   104,   105,
   106,   107,    19,   108,   109,   110,    20,   111,    21,    22,
   112,    23,   113,   114,    24,   115,    25,   116,    31,   117,
   118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
   128,   129,   130,    26,    27,    28,   131,   132,    29,   133,
   134,   135,    30,   136,     1,   137,   138,   154,   152,   147,
   143,     0,     0,     0,     0,     0,     0,     0,     0,   160,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
   182,   183,   187,   181,   178,   179,   185,   191,   161,   170,
   175,   164,   162,   172,   167,   188,   189,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   184,   180,   186,
   171,   176,   165,   163,   173,   168,   190,     0,     0,     0,
     0,   177,   166,   174,   169,     0,     0
};

static const short yydefgoto[] = {   162,
   163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
   173,   174,   175,   176,   177,   178,   179,   180,   204,   203,
   219,   206,   221,   201,   205,   220,   202,   218,   199,   198,
   200,   207,     1
};

static const short yypact[] = {-32768,
     0,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    -7,    -6,    -2,    -4,     2,     3,     4,    -1,-32768,
     1,   164,   165,   166,   167,   168,   169,     5,     6,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   171,     7,   172,
     9,   179,   180,   174,   175,   176,   181,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   184,   178,   187,
   182,-32768,-32768,-32768,-32768,   191,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768
};


#define	YYLAST		192


static const short yytable[] = {   226,
   181,   182,   183,   184,   185,   186,   187,   188,     2,   209,
   189,   211,   196,   197,     3,     4,     5,     6,     7,     8,
     9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
    19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
    29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
    39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
    49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
    59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
    69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
    79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
    89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
    99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
   109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
   119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
   129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
   139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
   149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
   159,   160,   161,   190,   191,   192,   193,   194,   195,   208,
   210,   212,   213,   214,   215,   216,   222,   223,   217,   224,
   227,   225
};

static const short yycheck[] = {     0,
     8,     8,     5,     8,     3,     3,     3,     9,     9,     3,
    10,     3,     8,     8,    15,    16,    17,    18,    19,    20,
    21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
    31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
    41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
    51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
    61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
    71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
    81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
    91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
   101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
   111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
   121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
   131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
   141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
   151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
   161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
   171,   172,   173,    10,    10,    10,    10,    10,    10,     9,
     9,     3,     3,    10,    10,    10,     3,    10,     8,     3,
     0,    10
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/local/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 160:
#line 673 "eamlasparser.y"
{ add_instruction(current_opcode); ;
    break;}
case 161:
#line 678 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 162:
#line 686 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 163:
#line 690 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_word_register; ;
    break;}
case 164:
#line 697 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 165:
#line 701 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; ;
    break;}
case 166:
#line 704 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_word_register; ;
    break;}
case 167:
#line 711 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 168:
#line 715 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_word_register; ;
    break;}
case 169:
#line 718 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_word_register; ;
    break;}
case 170:
#line 725 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 171:
#line 729 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; ;
    break;}
case 172:
#line 736 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 173:
#line 740 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_word_register; ;
    break;}
case 174:
#line 743 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_integer; ;
    break;}
case 175:
#line 750 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; ;
    break;}
case 176:
#line 754 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; ;
    break;}
case 177:
#line 757 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_integer; ;
    break;}
case 178:
#line 763 "eamlasparser.y"
{ add_instruction(current_opcode); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_integer; ;
    break;}
case 179:
#line 770 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_integer; ;
    break;}
case 180:
#line 774 "eamlasparser.y"
{ this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; ;
    break;}
case 181:
#line 781 "eamlasparser.y"
{ integer_t global_index;
    yytext[yyleng - 1] = '\0'; yytext++;
    add_instruction(current_opcode);
    global_index = add_global(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)global_index; ;
    break;}
case 182:
#line 791 "eamlasparser.y"
{ integer_t exception_index;
    yytext[yyleng - 1] = '\0'; yytext++;
    add_instruction(current_opcode);
    exception_index = add_exception(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)exception_index; ;
    break;}
case 183:
#line 801 "eamlasparser.y"
{ integer_t exception_index;
    yytext[yyleng - 1] = '\0'; yytext++;
    add_instruction(current_opcode);
    exception_index = add_exception(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)exception_index; ;
    break;}
case 184:
#line 807 "eamlasparser.y"
{
    memoize_label_use(this_module.instructions_no - 1, yytext);
  ;
    break;}
case 185:
#line 813 "eamlasparser.y"
{
    add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_integer;
  ;
    break;}
case 186:
#line 818 "eamlasparser.y"
{
    memoize_label_use(this_module.instructions_no - 1, yytext);
  ;
    break;}
case 187:
#line 826 "eamlasparser.y"
{ add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].float_parameter =
      current_float; ;
    break;}
case 188:
#line 833 "eamlasparser.y"
{ yytext[yyleng - 1] = '\0'; yytext++;
    /* fprintf(stderr, "from eamlas.y: String constant without quotes: >%s<\n", yytext); */
    add_instruction(current_opcode);
    add_string_constant(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)(this_module.string_constants_no - 1); ;
    break;}
case 189:
#line 843 "eamlasparser.y"
{ yytext[yyleng - 1] = '\0'; yytext++; /* remove quotes */
    add_instruction(current_opcode);
    add_string_constant(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)(this_module.string_constants_no - 1); ;
    break;}
case 190:
#line 849 "eamlasparser.y"
{ yytext[yyleng - 1] = '\0'; yytext++; /* remove quotes */
    add_string_constant(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)(this_module.string_constants_no - 1); 
    switch(current_opcode){
    case s_cfun: case s_cobj: case s_cact: case s_cactp: {
      /* These instructions refer C symbols */
      /* parameter_3 is used to refer the C symbol as an index: */
      this_module.instructions[this_module.instructions_no - 1].parameter_3 =
        (word_t)add_c_symbol(
	   this_module.string_constants[this_module.string_constants_no - 2],
	   this_module.string_constants[this_module.string_constants_no - 1]);
      break;
    } /* case */
    default: {
      /* normal instructions: do nothing */
    } /* default */
    } /* switch */
  ;
    break;}
case 191:
#line 872 "eamlasparser.y"
{ add_instruction(current_opcode);
    memoize_label_use(this_module.instructions_no - 1, yytext); ;
    break;}
case 193:
#line 881 "eamlasparser.y"
{ add_instruction(lbl); /* See the definition of lbl; positron, 31-07-2003 */
    memoize_label(yytext, this_module.instructions_no); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/local/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 888 "eamlasparser.y"


void yyerror(const char *s){
  fprintf(stderr,
	  "Line %i: %s in assembly file near \"%s\"\n", yylineno, s, yytext);
  exit(EXIT_FAILURE);
}

int main(int argc, char **argv){
  integer_t strlen_of_argv_1;
  integer_t i;

  set_program_name("eamlas (" PACKAGE_NAME ")");
  set_general_help_message("Assembles the eAML file FILE.eaml generating the eAM module FILE.eamo.");
  set_synopsis_string("eamlas [OPTIONS] FILE.eaml");
  set_version_string(VERSION_STRING);
  set_copyright_string(COPYRIGHT_STRING);
  set_license_message(LICENSE_STRING);
  set_bug_reporting_message(BUG_REPORTING_MESSAGE);
  
  parse_command_line(&argc, argv);
  
  /* Parse command line: */
  if(argc != 2)
    show_help(); /* this halts the program */

  /* Test for correctness of filename: */
  strlen_of_argv_1 = strlen(argv[1]);
  if(strlen_of_argv_1 < 6){
    fprintf(stderr, "The filename XXXXXX.eaml must be at least 6 characters long\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  if(strcmp(".eaml", argv[1] + strlen_of_argv_1 - 5)){
    fprintf(stderr, "The filename extension must be .eaml\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  
  /* Open input file: */
  yyin = fopen(argv[1], "r");
  if(yyin == NULL){
    fprintf(stderr, "Could not read %s\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  
  /* Initialize backpatch structures: */
  label_to_instruction_number = 
    create_string_map(MAXIMUM_REASONABLE_SIZE_OF_INTEGER);
  instructions_to_backpatch = (struct backpatch_item*)
    malloc(sizeof(struct backpatch_item) * instructions_to_backpatch_size);
  
  /* Initialize sets of globals, exceptions, C libraries and C symbols: */
  set_of_globals = create_string_map(sizeof(integer_t) /* unique index */);
  set_of_exceptions = create_string_map(sizeof(integer_t) /* unique index */);
  set_of_c_symbols_and_libraries = 
    create_string_map(sizeof(integer_t) /* unique index */);
  set_of_c_libraries = 
    create_string_map(sizeof(integer_t) /* unique index */);
  
  /* Initialize module: */

  strcpy(this_module.bytecode_version, BYTECODE_VERSION);
  this_module.name = (char*) malloc(sizeof(char) * (1 + strlen(argv[1])));
  strcpy(this_module.name, argv[1]);
  /* Replace '/' with ':' in the name of the module: */
  for(i = 0; i < strlen_of_argv_1; i++)
    if(this_module.name[i] == '/')
      this_module.name[i] = ':';
  this_module.name[strlen_of_argv_1 - 5]='\0';
  this_module.needed_modules_no = 0;
  this_module.needed_modules = (char**)malloc(sizeof(char*) * needed_modules_size);

  /* Initialize needed_modules_set: */
  needed_modules_set =
    create_string_map(sizeof(integer_t) /* not used */);

  /* We assume there are 0 registers, initially: */
  this_module.word_registers_no = 0;
  this_module.wide_integer_registers_no = 0;
  this_module.float_registers_no = 0;
  this_module.wide_float_registers_no = 0;
  this_module.wide_wide_float_registers_no = 0;
  
  this_module.instructions = (instruction_t*)
    malloc(sizeof(instruction_t) * instructions_size);
  this_module.instructions_no = 0;
  this_module.string_constants = (char**)
    malloc(sizeof(char*) * string_constants_size);
  this_module.string_constants_no = 0;
  this_module.globals = (char**)
    malloc(sizeof(char*) * globals_size);
  this_module.globals_no = 0;
  this_module.exceptions = (char**)
    malloc(sizeof(char*) * exceptions_size);
  this_module.exceptions_no = 0;
  
  this_module.c_libraries = (char**)
    malloc(sizeof(char*) * c_libraries_size);
  this_module.c_libraries_no = 0;
  this_module.c_symbols = (c_symbol_t*)
    malloc(sizeof(c_symbol_t) * c_symbols_size);
  this_module.c_symbols_no = 0;
  
  /* Parse: */
  yyparse();  

  /* Add a final nop instruction, to allow jumping to a label at the end of
     the module: */
  add_instruction(nop);

  /* Backpatch: */
  backpatch();

  /* Store the output into a file and exit: */
  strcpy(argv[1] + strlen_of_argv_1 - 5, ".eamo");
  yyout = fopen(argv[1], "w");
  if(yyout == NULL){
    fprintf(stderr, "Could not write %s\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  write_epsilon_module_file(&this_module, argv[1]);

  return EXIT_SUCCESS;
}
