/* This file is automatically generated. Don't edit. */
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

%start module

%{
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "../common/command_line.h"
#include "../common/string_map.h"

#include "../commontext.h"
#include "bytecode.h"
#include "instructions.h"

int yylex();

extern int yylineno;
extern char* yytext;
extern int yyleng;

extern FILE *yyin,*yyout;

void yyerror(const char *s);

struct epsilon_module this_module;
int needed_modules_size = 1; // To do: make this bigger

extern integer_t current_opcode;
extern integer_t current_integer;

/* The value, i.e. index, of the last register token: */
/* (defined in eamlasscanner_l.head) */
extern integer_t current_word_register;
extern integer_t current_wide_integer_register;
extern integer_t current_float_register;
extern integer_t current_wide_float_register;
extern integer_t current_wide_wide_float_register;

extern float_t current_float;

integer_t instructions_size = 1024;
integer_t string_constants_size = 128;
integer_t globals_size = 128;
integer_t exceptions_size = 128;
integer_t c_libraries_size = 128;
integer_t c_symbols_size = 128;

struct string_map* needed_modules_set;

/* These structures are used to keep track of the labels -> instruction no
   mapping, and for doing the final backpatch which resolves label uses: */
#define MAXIMUM_REASONABLE_SIZE_OF_STRING   (1001 * sizeof(char))
#define MAXIMUM_REASONABLE_SIZE_OF_INTEGER (11   * sizeof(char))
struct string_map* label_to_instruction_number;
struct backpatch_item{
  integer_t instruction_no;
  char label[MAXIMUM_REASONABLE_SIZE_OF_STRING];
}* instructions_to_backpatch;
integer_t instructions_to_backpatch_size=32;
integer_t instructions_to_backpatch_no=0;

void memoize_label(char* label, integer_t instruction){
  char instruction_as_string[MAXIMUM_REASONABLE_SIZE_OF_INTEGER / sizeof(char)];

  sprintf(instruction_as_string, "%i", instruction);
  if(access_string_map(label_to_instruction_number, label) != NULL)
    yyerror("label is defined twice");
  insert_into_string_map(label_to_instruction_number,
			 label,
			 instruction_as_string);
}

integer_t label_to_instruction_no(char* label){
  char* instruction_no_as_string;
  integer_t r;

  instruction_no_as_string = 
    access_string_map(label_to_instruction_number, label);
  if(instruction_no_as_string == NULL)
    yyerror("jump to undefined label");
  sscanf(instruction_no_as_string, INTEGER_T_FORMAT, &r);
  return r;
}

void memoize_label_use(integer_t instruction_no, char* label){
  if(++instructions_to_backpatch_no > instructions_to_backpatch_size){
    instructions_to_backpatch_size *= 2;
    instructions_to_backpatch = (struct backpatch_item*) 
      realloc(instructions_to_backpatch,
	      sizeof(struct backpatch_item) * instructions_to_backpatch_size);
  }
  instructions_to_backpatch[instructions_to_backpatch_no - 1].instruction_no =
    instruction_no;
  strcpy(instructions_to_backpatch[instructions_to_backpatch_no - 1].label,
	 label);
}

void backpatch(){
  integer_t i, instruction_no;
  char* label;

  for(i = 0; i < instructions_to_backpatch_no; i++){
    instruction_no = instructions_to_backpatch[i].instruction_no;
    label = instructions_to_backpatch[i].label;
    this_module.instructions[instruction_no].label_parameter =
      label_to_instruction_no(label);
  }
}

void add_instruction(integer_t opcode){
  if(++this_module.instructions_no > instructions_size){
    instructions_size *= 2;
    this_module.instructions = (instruction_t*) 
      realloc(this_module.instructions, sizeof(instruction_t) * instructions_size);
  }
  this_module.instructions[this_module.instructions_no - 1].opcode = opcode;
}

/* Non-reentrant */
char* qualified_identifier_to_module(const char* s){
  integer_t i, length_of_s = strlen(s), length_of_module_name;
  static char* static_string = NULL;
  static integer_t static_string_size = 0;

  //abc:ide1$
  //012345670

  for(i = length_of_s - 1; i >= 0; i--)
    if(s[i] == ':'){
      length_of_module_name = i;
      if(static_string_size < length_of_module_name + 1){
	static_string_size = length_of_module_name + 1;
	static_string = (char*)
	  realloc(static_string, sizeof(char) * static_string_size);
      }
      strncpy(static_string, s, length_of_module_name);
      static_string[length_of_module_name] = '\0';
      /* fprintf(stderr, ">>qualified_identifier_to_module(%s) is %s<<\n", s, static_string); */
      return static_string;
    }
  fprintf(stderr, "About the identifier \"%s\":\n", s);
  fatal("Non-qualified identifier in eAML module");
}

void add_dependency_for_qualified_identifier(char* s){
  char* module_name = qualified_identifier_to_module(s);
  static int unused;

  if((is_string_map_defined_on(needed_modules_set, module_name))
     ||(!strcmp(module_name, this_module.name)))
    return; /* We already stored module_name, or the identifier is
	       defined in this same module */
  else
    insert_into_string_map(needed_modules_set, module_name, &unused);

  /* Increment needed_modules_no, and expand buffer if needed: */
  if(++this_module.needed_modules_no > needed_modules_size){
    needed_modules_size *= 2;
    this_module.needed_modules = (char**)realloc(this_module.needed_modules,
						 sizeof(char*) * needed_modules_size);
  }
  
  /* Store the element: */
  this_module.needed_modules[this_module.needed_modules_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(module_name) + 1));
  strcpy(this_module.needed_modules[this_module.needed_modules_no - 1],
	 module_name);
}

void add_string_constant(char* x){
  /* There is no need that string constants are unique in the .eamo file. No
     set_of_string_constants is needed. */
  if(++this_module.string_constants_no > string_constants_size){
    string_constants_size *= 2;
    this_module.string_constants =
      (char**) realloc(this_module.string_constants,
		       sizeof(char*) * string_constants_size);
  }
  this_module.string_constants[this_module.string_constants_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(x) + 1));
  strcpy(this_module.string_constants[this_module.string_constants_no - 1], x);
}

struct string_map* set_of_globals;
integer_t add_global(char* x){
  if(is_string_map_defined_on(set_of_globals, x)){
    /* x is already defined */
    return *((integer_t*)access_string_map(set_of_globals, x));
  }
  else
    insert_into_string_map(set_of_globals, x, &this_module.globals_no);

  add_dependency_for_qualified_identifier(x);
  if(++this_module.globals_no > globals_size){
    globals_size *= 2;
    this_module.globals =
      (char**) realloc(this_module.globals,
		       sizeof(char*) * globals_size);
  }
  this_module.globals[this_module.globals_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(x) + 1));
  strcpy(this_module.globals[this_module.globals_no - 1], x);
  return this_module.globals_no - 1; /* index of the element we inserted */
}

struct string_map* set_of_exceptions;
integer_t add_exception(char* x){
  if(is_string_map_defined_on(set_of_exceptions, x)){
    /* x is already defined */
    return *((integer_t*)access_string_map(set_of_exceptions, x));
  }
  else
    insert_into_string_map(set_of_exceptions, x, &this_module.exceptions_no);
  
  add_dependency_for_qualified_identifier(x);
  if(++this_module.exceptions_no > exceptions_size){
    exceptions_size *= 2;
    this_module.exceptions =
      (char**) realloc(this_module.exceptions,
		       sizeof(char*) * exceptions_size);
  }
  this_module.exceptions[this_module.exceptions_no - 1] = 
    (char*) malloc(sizeof(char) * (strlen(x) + 1));
  strcpy(this_module.exceptions[this_module.exceptions_no - 1], x);
  return this_module.exceptions_no - 1; /* index of the element we inserted */
}

struct string_map* set_of_c_symbols_and_libraries;
struct string_map* set_of_c_libraries;
integer_t add_c_symbol(char* symbol_name, char* library_name){
  char* c_symbol_and_library = (char*)
    malloc(strlen(symbol_name) + strlen(library_name) + 2 /* space and '\0' */);
  sprintf(c_symbol_and_library, "%s %s", symbol_name, library_name);

  if(is_string_map_defined_on(set_of_c_symbols_and_libraries,
			      c_symbol_and_library)){ /* already defined */
    integer_t r = *((integer_t*)access_string_map(set_of_c_symbols_and_libraries,
						  c_symbol_and_library));
    free(c_symbol_and_library);
    return r;
  }
  else
    insert_into_string_map(set_of_c_symbols_and_libraries,
			   c_symbol_and_library,
			   &this_module.c_symbols_no);
  free(c_symbol_and_library); /* not needed any more */
  
  if(! is_string_map_defined_on(set_of_c_libraries, library_name)){
    insert_into_string_map(set_of_c_libraries,
			   library_name,
			   &this_module.c_libraries_no);
    if(++this_module.c_libraries_no > c_libraries_size){
      c_libraries_size *= 2;
      this_module.c_libraries =
	(char**) realloc(this_module.c_libraries,
			 sizeof(char*) * c_libraries_size);
    }
    this_module.c_libraries[this_module.c_libraries_no - 1] = 
      (char*) malloc(sizeof(char) * (strlen(library_name) + 1));
    strcpy(this_module.c_libraries[this_module.c_libraries_no - 1],
	   library_name);
  }

  if(++this_module.c_symbols_no > c_symbols_size){
    c_symbols_size *= 2;
    this_module.c_symbols =
      (c_symbol_t*) realloc(this_module.c_symbols,
			    sizeof(c_symbol_t) * c_symbols_size);
  }
  this_module.c_symbols[this_module.c_symbols_no - 1].symbol_name = 
    (char*) malloc(sizeof(char) * (strlen(symbol_name) + 1));
  strcpy(this_module.c_symbols[this_module.c_symbols_no - 1].symbol_name,
	 symbol_name);
  this_module.c_symbols[this_module.c_symbols_no - 1].library_index = 
    *(integer_t*)(access_string_map(set_of_c_libraries, library_name));
  //  fprintf(stderr, "<NAME is %s> ", this_module.c_symbols[this_module.c_symbols_no - 1].symbol_name);
  //  fprintf(stderr, "<index is "INTEGER_T_FORMAT">\n", this_module.c_symbols[this_module.c_symbols_no - 1].library_index);
  return this_module.c_symbols_no - 1; /* index of the element we inserted */
}

%}

%token INTEGER_CONSTANT WIDE_INTEGER_CONSTANT
%token FLOAT_CONSTANT WIDE_FLOAT_CONSTANT WIDE_WIDE_FLOAT_CONSTANT
%token STRING_CONSTANT LABEL
%token WORD_REGISTER WIDE_INTEGER_REGISTER
%token FLOAT_REGISTER WIDE_FLOAT_REGISTER WIDE_WIDE_FLOAT_REGISTER

%token INSTRUCTION_addi
%token INSTRUCTION_addi_i
%token INSTRUCTION_clargs
%token INSTRUCTION_cpy
%token INSTRUCTION_dfhn
%token INSTRUCTION_divi
%token INSTRUCTION_divi_i
%token INSTRUCTION_dummy_register_integer_register
%token INSTRUCTION_f_divi
%token INSTRUCTION_gcin
%token INSTRUCTION_hlt
%token INSTRUCTION_inc
%token INSTRUCTION_ini
%token INSTRUCTION_ins
%token INSTRUCTION_j
%token INSTRUCTION_jde
%token INSTRUCTION_lbl
%token INSTRUCTION_ldci
%token INSTRUCTION_muli
%token INSTRUCTION_muli_i
%token INSTRUCTION_nlcl
%token INSTRUCTION_nln
%token INSTRUCTION_nop
%token INSTRUCTION_outi
%token INSTRUCTION_pop
%token INSTRUCTION_popf
%token INSTRUCTION_popfn
%token INSTRUCTION_popm
%token INSTRUCTION_poptry
%token INSTRUCTION_pshcf
%token INSTRUCTION_pshci
%token INSTRUCTION_pshcs
%token INSTRUCTION_pshgl
%token INSTRUCTION_pshnll
%token INSTRUCTION_psho
%token INSTRUCTION_pshtry
%token INSTRUCTION_rthrw
%token INSTRUCTION_s_addf
%token INSTRUCTION_s_addi
%token INSTRUCTION_s_addi_i
%token INSTRUCTION_s_andi
%token INSTRUCTION_s_barlt
%token INSTRUCTION_s_cact
%token INSTRUCTION_s_cactp
%token INSTRUCTION_s_car
%token INSTRUCTION_s_cctba
%token INSTRUCTION_s_cdr
%token INSTRUCTION_s_cfun
%token INSTRUCTION_s_chst
%token INSTRUCTION_s_cll
%token INSTRUCTION_s_cls
%token INSTRUCTION_s_clsr
%token INSTRUCTION_s_cns
%token INSTRUCTION_s_cobj
%token INSTRUCTION_s_divf
%token INSTRUCTION_s_divi
%token INSTRUCTION_s_divi_i
%token INSTRUCTION_s_eqf
%token INSTRUCTION_s_eqi
%token INSTRUCTION_s_eqi_i
%token INSTRUCTION_s_eqs
%token INSTRUCTION_s_f_divi
%token INSTRUCTION_s_f_modi
%token INSTRUCTION_s_fcll
%token INSTRUCTION_s_filec
%token INSTRUCTION_s_fileor
%token INSTRUCTION_s_fileow
%token INSTRUCTION_s_filerc
%token INSTRUCTION_s_filewc
%token INSTRUCTION_s_flin
%token INSTRUCTION_s_frtoba
%token INSTRUCTION_s_fscll
%token INSTRUCTION_s_gl
%token INSTRUCTION_s_gtef
%token INSTRUCTION_s_gtei
%token INSTRUCTION_s_gtei_i
%token INSTRUCTION_s_gtes
%token INSTRUCTION_s_gtf
%token INSTRUCTION_s_gti
%token INSTRUCTION_s_gti_i
%token INSTRUCTION_s_gts
%token INSTRUCTION_s_infl
%token INSTRUCTION_s_jandi
%token INSTRUCTION_s_jeqi
%token INSTRUCTION_s_jeqi_i
%token INSTRUCTION_s_jgtei
%token INSTRUCTION_s_jgtei_i
%token INSTRUCTION_s_jgti
%token INSTRUCTION_s_jgti_i
%token INSTRUCTION_s_jltei
%token INSTRUCTION_s_jltei_i
%token INSTRUCTION_s_jlti
%token INSTRUCTION_s_jlti_i
%token INSTRUCTION_s_jnandi
%token INSTRUCTION_s_jneqi
%token INSTRUCTION_s_jneqi_i
%token INSTRUCTION_s_jnm
%token INSTRUCTION_s_jnori
%token INSTRUCTION_s_jnxori
%token INSTRUCTION_s_jnz
%token INSTRUCTION_s_jori
%token INSTRUCTION_s_jxori
%token INSTRUCTION_s_jz
%token INSTRUCTION_s_lcl
%token INSTRUCTION_s_lkp
%token INSTRUCTION_s_lkp_i
%token INSTRUCTION_s_lkpb
%token INSTRUCTION_s_ltbar
%token INSTRUCTION_s_ltef
%token INSTRUCTION_s_ltei
%token INSTRUCTION_s_ltei_i
%token INSTRUCTION_s_ltes
%token INSTRUCTION_s_ltf
%token INSTRUCTION_s_lti
%token INSTRUCTION_s_lti_i
%token INSTRUCTION_s_lts
%token INSTRUCTION_s_mka_i
%token INSTRUCTION_s_mkba_i
%token INSTRUCTION_s_modi
%token INSTRUCTION_s_modi_i
%token INSTRUCTION_s_mulf
%token INSTRUCTION_s_muli
%token INSTRUCTION_s_muli_i
%token INSTRUCTION_s_neqi
%token INSTRUCTION_s_neqi_i
%token INSTRUCTION_s_neqs
%token INSTRUCTION_s_nlcl
%token INSTRUCTION_s_nll
%token INSTRUCTION_s_nnll
%token INSTRUCTION_s_noti
%token INSTRUCTION_s_nxori
%token INSTRUCTION_s_ori
%token INSTRUCTION_s_outc
%token INSTRUCTION_s_outec
%token INSTRUCTION_s_outes
%token INSTRUCTION_s_outf
%token INSTRUCTION_s_outi
%token INSTRUCTION_s_outs
%token INSTRUCTION_s_popl
%token INSTRUCTION_s_powf
%token INSTRUCTION_s_powi
%token INSTRUCTION_s_powi_i
%token INSTRUCTION_s_pshf
%token INSTRUCTION_s_pshl
%token INSTRUCTION_s_ret
%token INSTRUCTION_s_retn
%token INSTRUCTION_s_scll
%token INSTRUCTION_s_seto
%token INSTRUCTION_s_subf
%token INSTRUCTION_s_subi
%token INSTRUCTION_s_subi_i
%token INSTRUCTION_s_swp
%token INSTRUCTION_s_thrw
%token INSTRUCTION_s_umini
%token INSTRUCTION_s_xori
%token INSTRUCTION_setfp
%token INSTRUCTION_subi
%token INSTRUCTION_subi_i
%token INSTRUCTION_swp

%%

opcode_exception: INSTRUCTION_s_thrw;

opcode_exception_label: INSTRUCTION_jde;

opcode_float: INSTRUCTION_pshcf;

opcode_global: INSTRUCTION_pshgl;
opcode_global: INSTRUCTION_s_gl;

opcode_integer: INSTRUCTION_hlt;
opcode_integer: INSTRUCTION_popm;
opcode_integer: INSTRUCTION_pshci;
opcode_integer: INSTRUCTION_s_addi_i;
opcode_integer: INSTRUCTION_s_cll;
opcode_integer: INSTRUCTION_s_divi_i;
opcode_integer: INSTRUCTION_s_eqi_i;
opcode_integer: INSTRUCTION_s_fcll;
opcode_integer: INSTRUCTION_s_fscll;
opcode_integer: INSTRUCTION_s_gtei_i;
opcode_integer: INSTRUCTION_s_gti_i;
opcode_integer: INSTRUCTION_s_lcl;
opcode_integer: INSTRUCTION_s_lkp_i;
opcode_integer: INSTRUCTION_s_ltei_i;
opcode_integer: INSTRUCTION_s_lti_i;
opcode_integer: INSTRUCTION_s_mka_i;
opcode_integer: INSTRUCTION_s_mkba_i;
opcode_integer: INSTRUCTION_s_modi_i;
opcode_integer: INSTRUCTION_s_muli_i;
opcode_integer: INSTRUCTION_s_neqi_i;
opcode_integer: INSTRUCTION_s_powi_i;
opcode_integer: INSTRUCTION_s_pshf;
opcode_integer: INSTRUCTION_s_pshl;
opcode_integer: INSTRUCTION_s_scll;
opcode_integer: INSTRUCTION_s_subi_i;

opcode_integer_integer: INSTRUCTION_s_nlcl;

opcode_integer_label: INSTRUCTION_s_jeqi_i;
opcode_integer_label: INSTRUCTION_s_jgtei_i;
opcode_integer_label: INSTRUCTION_s_jgti_i;
opcode_integer_label: INSTRUCTION_s_jltei_i;
opcode_integer_label: INSTRUCTION_s_jlti_i;
opcode_integer_label: INSTRUCTION_s_jneqi_i;
opcode_integer_label: INSTRUCTION_s_jnm;

opcode_label: INSTRUCTION_j;
opcode_label: INSTRUCTION_pshtry;
opcode_label: INSTRUCTION_s_cls;
opcode_label: INSTRUCTION_s_clsr;
opcode_label: INSTRUCTION_s_jandi;
opcode_label: INSTRUCTION_s_jeqi;
opcode_label: INSTRUCTION_s_jgtei;
opcode_label: INSTRUCTION_s_jgti;
opcode_label: INSTRUCTION_s_jltei;
opcode_label: INSTRUCTION_s_jlti;
opcode_label: INSTRUCTION_s_jnandi;
opcode_label: INSTRUCTION_s_jneqi;
opcode_label: INSTRUCTION_s_jnori;
opcode_label: INSTRUCTION_s_jnxori;
opcode_label: INSTRUCTION_s_jnz;
opcode_label: INSTRUCTION_s_jori;
opcode_label: INSTRUCTION_s_jxori;
opcode_label: INSTRUCTION_s_jz;

opcode_nullary: INSTRUCTION_clargs;
opcode_nullary: INSTRUCTION_cpy;
opcode_nullary: INSTRUCTION_dfhn;
opcode_nullary: INSTRUCTION_gcin;
opcode_nullary: INSTRUCTION_inc;
opcode_nullary: INSTRUCTION_ini;
opcode_nullary: INSTRUCTION_ins;
opcode_nullary: INSTRUCTION_lbl;
opcode_nullary: INSTRUCTION_nop;
opcode_nullary: INSTRUCTION_pop;
opcode_nullary: INSTRUCTION_popf;
opcode_nullary: INSTRUCTION_popfn;
opcode_nullary: INSTRUCTION_poptry;
opcode_nullary: INSTRUCTION_pshnll;
opcode_nullary: INSTRUCTION_psho;
opcode_nullary: INSTRUCTION_rthrw;
opcode_nullary: INSTRUCTION_s_addf;
opcode_nullary: INSTRUCTION_s_addi;
opcode_nullary: INSTRUCTION_s_andi;
opcode_nullary: INSTRUCTION_s_barlt;
opcode_nullary: INSTRUCTION_s_car;
opcode_nullary: INSTRUCTION_s_cctba;
opcode_nullary: INSTRUCTION_s_cdr;
opcode_nullary: INSTRUCTION_s_chst;
opcode_nullary: INSTRUCTION_s_cns;
opcode_nullary: INSTRUCTION_s_divf;
opcode_nullary: INSTRUCTION_s_divi;
opcode_nullary: INSTRUCTION_s_eqf;
opcode_nullary: INSTRUCTION_s_eqi;
opcode_nullary: INSTRUCTION_s_eqs;
opcode_nullary: INSTRUCTION_s_f_divi;
opcode_nullary: INSTRUCTION_s_f_modi;
opcode_nullary: INSTRUCTION_s_filec;
opcode_nullary: INSTRUCTION_s_fileor;
opcode_nullary: INSTRUCTION_s_fileow;
opcode_nullary: INSTRUCTION_s_filerc;
opcode_nullary: INSTRUCTION_s_filewc;
opcode_nullary: INSTRUCTION_s_flin;
opcode_nullary: INSTRUCTION_s_frtoba;
opcode_nullary: INSTRUCTION_s_gtef;
opcode_nullary: INSTRUCTION_s_gtei;
opcode_nullary: INSTRUCTION_s_gtes;
opcode_nullary: INSTRUCTION_s_gtf;
opcode_nullary: INSTRUCTION_s_gti;
opcode_nullary: INSTRUCTION_s_gts;
opcode_nullary: INSTRUCTION_s_infl;
opcode_nullary: INSTRUCTION_s_lkp;
opcode_nullary: INSTRUCTION_s_lkpb;
opcode_nullary: INSTRUCTION_s_ltbar;
opcode_nullary: INSTRUCTION_s_ltef;
opcode_nullary: INSTRUCTION_s_ltei;
opcode_nullary: INSTRUCTION_s_ltes;
opcode_nullary: INSTRUCTION_s_ltf;
opcode_nullary: INSTRUCTION_s_lti;
opcode_nullary: INSTRUCTION_s_lts;
opcode_nullary: INSTRUCTION_s_modi;
opcode_nullary: INSTRUCTION_s_mulf;
opcode_nullary: INSTRUCTION_s_muli;
opcode_nullary: INSTRUCTION_s_neqi;
opcode_nullary: INSTRUCTION_s_neqs;
opcode_nullary: INSTRUCTION_s_nll;
opcode_nullary: INSTRUCTION_s_nnll;
opcode_nullary: INSTRUCTION_s_noti;
opcode_nullary: INSTRUCTION_s_nxori;
opcode_nullary: INSTRUCTION_s_ori;
opcode_nullary: INSTRUCTION_s_outc;
opcode_nullary: INSTRUCTION_s_outec;
opcode_nullary: INSTRUCTION_s_outes;
opcode_nullary: INSTRUCTION_s_outf;
opcode_nullary: INSTRUCTION_s_outi;
opcode_nullary: INSTRUCTION_s_outs;
opcode_nullary: INSTRUCTION_s_popl;
opcode_nullary: INSTRUCTION_s_powf;
opcode_nullary: INSTRUCTION_s_powi;
opcode_nullary: INSTRUCTION_s_ret;
opcode_nullary: INSTRUCTION_s_retn;
opcode_nullary: INSTRUCTION_s_seto;
opcode_nullary: INSTRUCTION_s_subf;
opcode_nullary: INSTRUCTION_s_subi;
opcode_nullary: INSTRUCTION_s_swp;
opcode_nullary: INSTRUCTION_s_umini;
opcode_nullary: INSTRUCTION_s_xori;

opcode_register: INSTRUCTION_outi;

opcode_register_integer: INSTRUCTION_ldci;

opcode_register_integer_integer: INSTRUCTION_nlcl;

opcode_register_integer_register: INSTRUCTION_dummy_register_integer_register;

opcode_register_register: INSTRUCTION_swp;

opcode_register_register_integer: INSTRUCTION_addi_i;
opcode_register_register_integer: INSTRUCTION_divi_i;
opcode_register_register_integer: INSTRUCTION_muli_i;
opcode_register_register_integer: INSTRUCTION_subi_i;

opcode_register_register_register: INSTRUCTION_addi;
opcode_register_register_register: INSTRUCTION_divi;
opcode_register_register_register: INSTRUCTION_f_divi;
opcode_register_register_register: INSTRUCTION_muli;
opcode_register_register_register: INSTRUCTION_subi;

opcode_string: INSTRUCTION_pshcs;
opcode_string: INSTRUCTION_setfp;

opcode_string_string: INSTRUCTION_nln;
opcode_string_string: INSTRUCTION_s_cact;
opcode_string_string: INSTRUCTION_s_cactp;
opcode_string_string: INSTRUCTION_s_cfun;
opcode_string_string: INSTRUCTION_s_cobj;

/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Tail part of eamlas.y: rules and C code */

instruction:
  opcode_nullary
  { add_instruction(current_opcode); }

  |

  opcode_register WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }

  |

  opcode_register_register
  WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }
  WORD_REGISTER
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_word_register; }

  |

  opcode_register_integer_register
  WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }
  INTEGER_CONSTANT
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; }
  WORD_REGISTER
  { this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_word_register; }

  |

  opcode_register_register_register
  WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }
  WORD_REGISTER
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_word_register; }
  WORD_REGISTER
  { this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_word_register; }

  |

  opcode_register_integer
  WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }
  INTEGER_CONSTANT
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; }

  |

  opcode_register_register_integer
  WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }
  WORD_REGISTER
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_word_register; }
  INTEGER_CONSTANT
  { this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_integer; }

  |

  opcode_register_integer_integer
  WORD_REGISTER
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_word_register; }
  INTEGER_CONSTANT
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; }
  INTEGER_CONSTANT
  { this_module.instructions[this_module.instructions_no - 1].parameter_3 =
      (word_t)current_integer; }

  |

  opcode_integer INTEGER_CONSTANT
  { add_instruction(current_opcode); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_integer; }

  |

  opcode_integer_integer INTEGER_CONSTANT
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_integer; }
  INTEGER_CONSTANT
  { this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)current_integer; }

  |
  
  /* --------------------------------------------------------------------- */
  opcode_global STRING_CONSTANT
  { integer_t global_index;
    yytext[yyleng - 1] = '\0'; yytext++;
    add_instruction(current_opcode);
    global_index = add_global(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)global_index; }

  |

  opcode_exception STRING_CONSTANT
  { integer_t exception_index;
    yytext[yyleng - 1] = '\0'; yytext++;
    add_instruction(current_opcode);
    exception_index = add_exception(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)exception_index; }

  |

  opcode_exception_label STRING_CONSTANT
  { integer_t exception_index;
    yytext[yyleng - 1] = '\0'; yytext++;
    add_instruction(current_opcode);
    exception_index = add_exception(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)exception_index; }
  LABEL {
    memoize_label_use(this_module.instructions_no - 1, yytext);
  }
  
  |

  opcode_integer_label INTEGER_CONSTANT{
    add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)current_integer;
  }
  LABEL {
    memoize_label_use(this_module.instructions_no - 1, yytext);
  }

  |
  /* --------------------------------------------------------------------- */
  
  opcode_float FLOAT_CONSTANT
  { add_instruction(current_opcode);
    this_module.instructions[this_module.instructions_no - 1].float_parameter =
      current_float; }

  |

  opcode_string STRING_CONSTANT
  { yytext[yyleng - 1] = '\0'; yytext++;
    /* fprintf(stderr, "from eamlas.y: String constant without quotes: >%s<\n", yytext); */
    add_instruction(current_opcode);
    add_string_constant(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)(this_module.string_constants_no - 1); }

  |

  opcode_string_string STRING_CONSTANT
  { yytext[yyleng - 1] = '\0'; yytext++; /* remove quotes */
    add_instruction(current_opcode);
    add_string_constant(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_1 =
      (word_t)(this_module.string_constants_no - 1); } 
  STRING_CONSTANT
  { yytext[yyleng - 1] = '\0'; yytext++; /* remove quotes */
    add_string_constant(yytext); 
    this_module.instructions[this_module.instructions_no - 1].parameter_2 =
      (word_t)(this_module.string_constants_no - 1); 
    switch(current_opcode){
    case s_cfun: case s_cobj: case s_cact: case s_cactp: {
      /* These instructions refer C symbols */
      /* parameter_3 is used to refer the C symbol as an index: */
      this_module.instructions[this_module.instructions_no - 1].parameter_3 =
        (word_t)add_c_symbol(
	   this_module.string_constants[this_module.string_constants_no - 2],
	   this_module.string_constants[this_module.string_constants_no - 1]);
      break;
    } /* case */
    default: {
      /* normal instructions: do nothing */
    } /* default */
    } /* switch */
  }

  |

  opcode_label LABEL
  { add_instruction(current_opcode);
    memoize_label_use(this_module.instructions_no - 1, yytext); }
  ;

module:
  /* nothing */
  |
  module
  LABEL
  { add_instruction(lbl); /* See the definition of lbl; positron, 31-07-2003 */
    memoize_label(yytext, this_module.instructions_no); }
  |
  module
  instruction
  ;

%%

void yyerror(const char *s){
  fprintf(stderr,
	  "Line %i: %s in assembly file near \"%s\"\n", yylineno, s, yytext);
  exit(EXIT_FAILURE);
}

int main(int argc, char **argv){
  integer_t strlen_of_argv_1;
  integer_t i;

  set_program_name("eamlas (" PACKAGE_NAME ")");
  set_general_help_message("Assembles the eAML file FILE.eaml generating the eAM module FILE.eamo.");
  set_synopsis_string("eamlas [OPTIONS] FILE.eaml");
  set_version_string(VERSION_STRING);
  set_copyright_string(COPYRIGHT_STRING);
  set_license_message(LICENSE_STRING);
  set_bug_reporting_message(BUG_REPORTING_MESSAGE);
  
  parse_command_line(&argc, argv);
  
  /* Parse command line: */
  if(argc != 2)
    show_help(); /* this halts the program */

  /* Test for correctness of filename: */
  strlen_of_argv_1 = strlen(argv[1]);
  if(strlen_of_argv_1 < 6){
    fprintf(stderr, "The filename XXXXXX.eaml must be at least 6 characters long\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  if(strcmp(".eaml", argv[1] + strlen_of_argv_1 - 5)){
    fprintf(stderr, "The filename extension must be .eaml\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  
  /* Open input file: */
  yyin = fopen(argv[1], "r");
  if(yyin == NULL){
    fprintf(stderr, "Could not read %s\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  
  /* Initialize backpatch structures: */
  label_to_instruction_number = 
    create_string_map(MAXIMUM_REASONABLE_SIZE_OF_INTEGER);
  instructions_to_backpatch = (struct backpatch_item*)
    malloc(sizeof(struct backpatch_item) * instructions_to_backpatch_size);
  
  /* Initialize sets of globals, exceptions, C libraries and C symbols: */
  set_of_globals = create_string_map(sizeof(integer_t) /* unique index */);
  set_of_exceptions = create_string_map(sizeof(integer_t) /* unique index */);
  set_of_c_symbols_and_libraries = 
    create_string_map(sizeof(integer_t) /* unique index */);
  set_of_c_libraries = 
    create_string_map(sizeof(integer_t) /* unique index */);
  
  /* Initialize module: */

  strcpy(this_module.bytecode_version, BYTECODE_VERSION);
  this_module.name = (char*) malloc(sizeof(char) * (1 + strlen(argv[1])));
  strcpy(this_module.name, argv[1]);
  /* Replace '/' with ':' in the name of the module: */
  for(i = 0; i < strlen_of_argv_1; i++)
    if(this_module.name[i] == '/')
      this_module.name[i] = ':';
  this_module.name[strlen_of_argv_1 - 5]='\0';
  this_module.needed_modules_no = 0;
  this_module.needed_modules = (char**)malloc(sizeof(char*) * needed_modules_size);

  /* Initialize needed_modules_set: */
  needed_modules_set =
    create_string_map(sizeof(integer_t) /* not used */);

  /* We assume there are 0 registers, initially: */
  this_module.word_registers_no = 0;
  this_module.wide_integer_registers_no = 0;
  this_module.float_registers_no = 0;
  this_module.wide_float_registers_no = 0;
  this_module.wide_wide_float_registers_no = 0;
  
  this_module.instructions = (instruction_t*)
    malloc(sizeof(instruction_t) * instructions_size);
  this_module.instructions_no = 0;
  this_module.string_constants = (char**)
    malloc(sizeof(char*) * string_constants_size);
  this_module.string_constants_no = 0;
  this_module.globals = (char**)
    malloc(sizeof(char*) * globals_size);
  this_module.globals_no = 0;
  this_module.exceptions = (char**)
    malloc(sizeof(char*) * exceptions_size);
  this_module.exceptions_no = 0;
  
  this_module.c_libraries = (char**)
    malloc(sizeof(char*) * c_libraries_size);
  this_module.c_libraries_no = 0;
  this_module.c_symbols = (c_symbol_t*)
    malloc(sizeof(c_symbol_t) * c_symbols_size);
  this_module.c_symbols_no = 0;
  
  /* Parse: */
  yyparse();  

  /* Add a final nop instruction, to allow jumping to a label at the end of
     the module: */
  add_instruction(nop);

  /* Backpatch: */
  backpatch();

  /* Store the output into a file and exit: */
  strcpy(argv[1] + strlen_of_argv_1 - 5, ".eamo");
  yyout = fopen(argv[1], "w");
  if(yyout == NULL){
    fprintf(stderr, "Could not write %s\n", argv[1]);
    exit(EXIT_FAILURE);
  }
  write_epsilon_module_file(&this_module, argv[1]);

  return EXIT_SUCCESS;
}
