/* This file is automatically generated. Don't edit. */
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


%{
#include "../config.h"
#include "eam_types.h"

#include "eamlasparser.h"
#include "instructions.h"
#include "bytecode.h"
#include <stdio.h>
#include <ctype.h>

extern int yylineno;
extern char* yytext;
extern int yyleng;

void yyerror(char* message);

/* This modifies yytext and yyleng: */
void remove_escapes_from_yytext(); /* implemented in eamlas_l.tail */

/* The last scanned opcode: */
integer_t current_opcode;

/* The value of the last numeric constant tokens: */
integer_t         current_integer;
wide_integer_t    current_wide_integer;
float_t           current_float;
wide_float_t      current_wide_float;
wide_wide_float_t current_wide_wide_float;

/* The value (i.e. index) of the last register token: */
integer_t current_word_register;
integer_t current_wide_integer_register;
integer_t current_float_register;
integer_t current_wide_float_register;
integer_t current_wide_wide_float_register;

/* The module we are scanning. Defined in eamlasparser_y.head */
extern struct epsilon_module this_module;

/* An utility function to compute the number of registers: for any
   register index we found in the text we update the maximum if needed;
   for example, if we find $f3 and the current 'maximum' for float
   registers is $f1, we set this_module.float_registers_no to 4
   (we need $f0, $f1, $f2 and $f3). */
void update_maximum_if_needed(integer_t* maximum, integer_t current){
  if(current > *maximum)
    *maximum = current;
}

%}

%option yylineno
%option case-insensitive

DIGIT      [0-9]
LETTER     [a-z]|[A-Z]|"_"
SIGN       ("+"|"-")

POINTED    {DIGIT}*"."{DIGIT}+|{DIGIT}+"."{DIGIT}*

BARE_INTEGER {SIGN}?{DIGIT}+
BARE_FLOAT   {SIGN}?{POINTED}|{SIGN}?{POINTED}e{SIGN}?{DIGIT}+
INTEGER         {BARE_INTEGER}(i?)
WIDE_INTEGER    {BARE_INTEGER}w
FLOAT           {BARE_FLOAT}(f?)
WIDE_FLOAT      {BARE_FLOAT}w
WIDE_WIDE_FLOAT {BARE_FLOAT}W

CESCAPE    \\.|\\{DIGIT}|\\{DIGIT}{DIGIT}|\\{DIGIT}{DIGIT}{DIGIT}
STRING    \"([^\n\\\"]|{CESCAPE}|"/*"|"*/")*\"
LINECOMMENT \#(.)*\n
CCOMMENT    "/*"([^/]|"/"[^*])*"*/"
COMMENT    {LINECOMMENT}
WHITESPACE [ \t\r\n]+
IDENTIFIER {LETTER}({LETTER}|{DIGIT})*
LABEL      {IDENTIFIER}":"

WORD_REGISTER            \$g{DIGIT}+
WIDE_INTEGER_REGISTER    \$w{DIGIT}+
FLOAT_REGISTER           \$f{DIGIT}+
WIDE_FLOAT_REGISTER      \$wf{DIGIT}+
WIDE_WIDE_FLOAT_REGISTER \$Wf{DIGIT}+

%%

{STRING}     { remove_escapes_from_yytext();
               // fprintf(stderr, "STRING: >>>%s<<<\n", yytext);
               return STRING_CONSTANT; }

{COMMENT}    { /* Do nothing */ }
{WHITESPACE} { /* Do nothing */ }

{WORD_REGISTER} { sscanf(yytext+2, "%i", &current_word_register);
                  update_maximum_if_needed(&(this_module.word_registers_no),
					   current_word_register + 1);
                  return WORD_REGISTER; }
{WIDE_INTEGER_REGISTER} { sscanf(yytext+2, "%i", &current_wide_integer_register);
                          update_maximum_if_needed(&(this_module.wide_integer_registers_no),
						   current_wide_integer_register + 1);
                          return WIDE_INTEGER_REGISTER; }
{FLOAT_REGISTER} { sscanf(yytext+2, "%i", &current_float_register);
                   update_maximum_if_needed(&(this_module.float_registers_no),
					    current_float_register + 1);
		   return FLOAT_REGISTER; }
{WIDE_FLOAT_REGISTER} { sscanf(yytext+3, "%i", &current_wide_float_register);
                        update_maximum_if_needed(&(this_module.wide_float_registers_no),
						 current_wide_float_register + 1);
                        return WIDE_FLOAT_REGISTER; }
{WIDE_WIDE_FLOAT_REGISTER} { sscanf(yytext+3, "%i", &current_wide_wide_float_register);
                             update_maximum_if_needed(&(this_module.wide_wide_float_registers_no),
						      current_wide_wide_float_register + 1);
                             return WIDE_WIDE_FLOAT_REGISTER; }

{INTEGER}    { if(!isdigit(yytext[yyleng - 1])){
                 yytext[yyleng - 1] = '\0';
		 yyleng--;
               }
               sscanf(yytext, INTEGER_T_FORMAT, &current_integer);
               return INTEGER_CONSTANT; }

{WIDE_INTEGER} { if(!isdigit(yytext[yyleng - 1])){
                 yytext[yyleng - 1] = '\0';
		 yyleng--;
               }
               sscanf(yytext, WIDE_INTEGER_T_FORMAT, &current_wide_integer);
               return WIDE_INTEGER_CONSTANT; }

{FLOAT}        { if(!isdigit(yytext[yyleng - 1])){
                 yytext[yyleng - 1] = '\0';
                 yyleng--;
               }
               sscanf(yytext, FLOAT_T_FORMAT, &current_float);
               return FLOAT_CONSTANT; }

{WIDE_FLOAT}  { if(!isdigit(yytext[yyleng - 1])){
                 yytext[yyleng - 1] = '\0';
                 yyleng--;
               }
               sscanf(yytext, WIDE_FLOAT_T_FORMAT, &current_wide_float);
               return WIDE_FLOAT_CONSTANT; }

{WIDE_WIDE_FLOAT} { if(!isdigit(yytext[yyleng - 1])){
                 yytext[yyleng - 1] = '\0';
                 yyleng--;
               }
               sscanf(yytext, WIDE_WIDE_FLOAT_T_FORMAT, &current_wide_wide_float);
               return WIDE_WIDE_FLOAT_CONSTANT; }

{LABEL}      { return LABEL; }
addi     { current_opcode = addi; return INSTRUCTION_addi; }
addi_i     { current_opcode = addi_i; return INSTRUCTION_addi_i; }
clargs     { current_opcode = clargs; return INSTRUCTION_clargs; }
cpy     { current_opcode = cpy; return INSTRUCTION_cpy; }
dfhn     { current_opcode = dfhn; return INSTRUCTION_dfhn; }
divi     { current_opcode = divi; return INSTRUCTION_divi; }
divi_i     { current_opcode = divi_i; return INSTRUCTION_divi_i; }
dummy_register_integer_register     { current_opcode = dummy_register_integer_register; return INSTRUCTION_dummy_register_integer_register; }
f_divi     { current_opcode = f_divi; return INSTRUCTION_f_divi; }
gcin     { current_opcode = gcin; return INSTRUCTION_gcin; }
hlt     { current_opcode = hlt; return INSTRUCTION_hlt; }
inc     { current_opcode = inc; return INSTRUCTION_inc; }
ini     { current_opcode = ini; return INSTRUCTION_ini; }
ins     { current_opcode = ins; return INSTRUCTION_ins; }
j     { current_opcode = j; return INSTRUCTION_j; }
jde     { current_opcode = jde; return INSTRUCTION_jde; }
lbl     { current_opcode = lbl; return INSTRUCTION_lbl; }
ldci     { current_opcode = ldci; return INSTRUCTION_ldci; }
muli     { current_opcode = muli; return INSTRUCTION_muli; }
muli_i     { current_opcode = muli_i; return INSTRUCTION_muli_i; }
nlcl     { current_opcode = nlcl; return INSTRUCTION_nlcl; }
nln     { current_opcode = nln; return INSTRUCTION_nln; }
nop     { current_opcode = nop; return INSTRUCTION_nop; }
outi     { current_opcode = outi; return INSTRUCTION_outi; }
pop     { current_opcode = pop; return INSTRUCTION_pop; }
popf     { current_opcode = popf; return INSTRUCTION_popf; }
popfn     { current_opcode = popfn; return INSTRUCTION_popfn; }
popm     { current_opcode = popm; return INSTRUCTION_popm; }
poptry     { current_opcode = poptry; return INSTRUCTION_poptry; }
pshcf     { current_opcode = pshcf; return INSTRUCTION_pshcf; }
pshci     { current_opcode = pshci; return INSTRUCTION_pshci; }
pshcs     { current_opcode = pshcs; return INSTRUCTION_pshcs; }
pshgl     { current_opcode = pshgl; return INSTRUCTION_pshgl; }
pshnll     { current_opcode = pshnll; return INSTRUCTION_pshnll; }
psho     { current_opcode = psho; return INSTRUCTION_psho; }
pshtry     { current_opcode = pshtry; return INSTRUCTION_pshtry; }
rthrw     { current_opcode = rthrw; return INSTRUCTION_rthrw; }
s_addf     { current_opcode = s_addf; return INSTRUCTION_s_addf; }
s_addi     { current_opcode = s_addi; return INSTRUCTION_s_addi; }
s_addi_i     { current_opcode = s_addi_i; return INSTRUCTION_s_addi_i; }
s_andi     { current_opcode = s_andi; return INSTRUCTION_s_andi; }
s_barlt     { current_opcode = s_barlt; return INSTRUCTION_s_barlt; }
s_cact     { current_opcode = s_cact; return INSTRUCTION_s_cact; }
s_cactp     { current_opcode = s_cactp; return INSTRUCTION_s_cactp; }
s_car     { current_opcode = s_car; return INSTRUCTION_s_car; }
s_cctba     { current_opcode = s_cctba; return INSTRUCTION_s_cctba; }
s_cdr     { current_opcode = s_cdr; return INSTRUCTION_s_cdr; }
s_cfun     { current_opcode = s_cfun; return INSTRUCTION_s_cfun; }
s_chst     { current_opcode = s_chst; return INSTRUCTION_s_chst; }
s_cll     { current_opcode = s_cll; return INSTRUCTION_s_cll; }
s_cls     { current_opcode = s_cls; return INSTRUCTION_s_cls; }
s_clsr     { current_opcode = s_clsr; return INSTRUCTION_s_clsr; }
s_cns     { current_opcode = s_cns; return INSTRUCTION_s_cns; }
s_cobj     { current_opcode = s_cobj; return INSTRUCTION_s_cobj; }
s_divf     { current_opcode = s_divf; return INSTRUCTION_s_divf; }
s_divi     { current_opcode = s_divi; return INSTRUCTION_s_divi; }
s_divi_i     { current_opcode = s_divi_i; return INSTRUCTION_s_divi_i; }
s_eqf     { current_opcode = s_eqf; return INSTRUCTION_s_eqf; }
s_eqi     { current_opcode = s_eqi; return INSTRUCTION_s_eqi; }
s_eqi_i     { current_opcode = s_eqi_i; return INSTRUCTION_s_eqi_i; }
s_eqs     { current_opcode = s_eqs; return INSTRUCTION_s_eqs; }
s_f_divi     { current_opcode = s_f_divi; return INSTRUCTION_s_f_divi; }
s_f_modi     { current_opcode = s_f_modi; return INSTRUCTION_s_f_modi; }
s_fcll     { current_opcode = s_fcll; return INSTRUCTION_s_fcll; }
s_filec     { current_opcode = s_filec; return INSTRUCTION_s_filec; }
s_fileor     { current_opcode = s_fileor; return INSTRUCTION_s_fileor; }
s_fileow     { current_opcode = s_fileow; return INSTRUCTION_s_fileow; }
s_filerc     { current_opcode = s_filerc; return INSTRUCTION_s_filerc; }
s_filewc     { current_opcode = s_filewc; return INSTRUCTION_s_filewc; }
s_flin     { current_opcode = s_flin; return INSTRUCTION_s_flin; }
s_frtoba     { current_opcode = s_frtoba; return INSTRUCTION_s_frtoba; }
s_fscll     { current_opcode = s_fscll; return INSTRUCTION_s_fscll; }
s_gl     { current_opcode = s_gl; return INSTRUCTION_s_gl; }
s_gtef     { current_opcode = s_gtef; return INSTRUCTION_s_gtef; }
s_gtei     { current_opcode = s_gtei; return INSTRUCTION_s_gtei; }
s_gtei_i     { current_opcode = s_gtei_i; return INSTRUCTION_s_gtei_i; }
s_gtes     { current_opcode = s_gtes; return INSTRUCTION_s_gtes; }
s_gtf     { current_opcode = s_gtf; return INSTRUCTION_s_gtf; }
s_gti     { current_opcode = s_gti; return INSTRUCTION_s_gti; }
s_gti_i     { current_opcode = s_gti_i; return INSTRUCTION_s_gti_i; }
s_gts     { current_opcode = s_gts; return INSTRUCTION_s_gts; }
s_infl     { current_opcode = s_infl; return INSTRUCTION_s_infl; }
s_jandi     { current_opcode = s_jandi; return INSTRUCTION_s_jandi; }
s_jeqi     { current_opcode = s_jeqi; return INSTRUCTION_s_jeqi; }
s_jeqi_i     { current_opcode = s_jeqi_i; return INSTRUCTION_s_jeqi_i; }
s_jgtei     { current_opcode = s_jgtei; return INSTRUCTION_s_jgtei; }
s_jgtei_i     { current_opcode = s_jgtei_i; return INSTRUCTION_s_jgtei_i; }
s_jgti     { current_opcode = s_jgti; return INSTRUCTION_s_jgti; }
s_jgti_i     { current_opcode = s_jgti_i; return INSTRUCTION_s_jgti_i; }
s_jltei     { current_opcode = s_jltei; return INSTRUCTION_s_jltei; }
s_jltei_i     { current_opcode = s_jltei_i; return INSTRUCTION_s_jltei_i; }
s_jlti     { current_opcode = s_jlti; return INSTRUCTION_s_jlti; }
s_jlti_i     { current_opcode = s_jlti_i; return INSTRUCTION_s_jlti_i; }
s_jnandi     { current_opcode = s_jnandi; return INSTRUCTION_s_jnandi; }
s_jneqi     { current_opcode = s_jneqi; return INSTRUCTION_s_jneqi; }
s_jneqi_i     { current_opcode = s_jneqi_i; return INSTRUCTION_s_jneqi_i; }
s_jnm     { current_opcode = s_jnm; return INSTRUCTION_s_jnm; }
s_jnori     { current_opcode = s_jnori; return INSTRUCTION_s_jnori; }
s_jnxori     { current_opcode = s_jnxori; return INSTRUCTION_s_jnxori; }
s_jnz     { current_opcode = s_jnz; return INSTRUCTION_s_jnz; }
s_jori     { current_opcode = s_jori; return INSTRUCTION_s_jori; }
s_jxori     { current_opcode = s_jxori; return INSTRUCTION_s_jxori; }
s_jz     { current_opcode = s_jz; return INSTRUCTION_s_jz; }
s_lcl     { current_opcode = s_lcl; return INSTRUCTION_s_lcl; }
s_lkp     { current_opcode = s_lkp; return INSTRUCTION_s_lkp; }
s_lkp_i     { current_opcode = s_lkp_i; return INSTRUCTION_s_lkp_i; }
s_lkpb     { current_opcode = s_lkpb; return INSTRUCTION_s_lkpb; }
s_ltbar     { current_opcode = s_ltbar; return INSTRUCTION_s_ltbar; }
s_ltef     { current_opcode = s_ltef; return INSTRUCTION_s_ltef; }
s_ltei     { current_opcode = s_ltei; return INSTRUCTION_s_ltei; }
s_ltei_i     { current_opcode = s_ltei_i; return INSTRUCTION_s_ltei_i; }
s_ltes     { current_opcode = s_ltes; return INSTRUCTION_s_ltes; }
s_ltf     { current_opcode = s_ltf; return INSTRUCTION_s_ltf; }
s_lti     { current_opcode = s_lti; return INSTRUCTION_s_lti; }
s_lti_i     { current_opcode = s_lti_i; return INSTRUCTION_s_lti_i; }
s_lts     { current_opcode = s_lts; return INSTRUCTION_s_lts; }
s_mka_i     { current_opcode = s_mka_i; return INSTRUCTION_s_mka_i; }
s_mkba_i     { current_opcode = s_mkba_i; return INSTRUCTION_s_mkba_i; }
s_modi     { current_opcode = s_modi; return INSTRUCTION_s_modi; }
s_modi_i     { current_opcode = s_modi_i; return INSTRUCTION_s_modi_i; }
s_mulf     { current_opcode = s_mulf; return INSTRUCTION_s_mulf; }
s_muli     { current_opcode = s_muli; return INSTRUCTION_s_muli; }
s_muli_i     { current_opcode = s_muli_i; return INSTRUCTION_s_muli_i; }
s_neqi     { current_opcode = s_neqi; return INSTRUCTION_s_neqi; }
s_neqi_i     { current_opcode = s_neqi_i; return INSTRUCTION_s_neqi_i; }
s_neqs     { current_opcode = s_neqs; return INSTRUCTION_s_neqs; }
s_nlcl     { current_opcode = s_nlcl; return INSTRUCTION_s_nlcl; }
s_nll     { current_opcode = s_nll; return INSTRUCTION_s_nll; }
s_nnll     { current_opcode = s_nnll; return INSTRUCTION_s_nnll; }
s_noti     { current_opcode = s_noti; return INSTRUCTION_s_noti; }
s_nxori     { current_opcode = s_nxori; return INSTRUCTION_s_nxori; }
s_ori     { current_opcode = s_ori; return INSTRUCTION_s_ori; }
s_outc     { current_opcode = s_outc; return INSTRUCTION_s_outc; }
s_outec     { current_opcode = s_outec; return INSTRUCTION_s_outec; }
s_outes     { current_opcode = s_outes; return INSTRUCTION_s_outes; }
s_outf     { current_opcode = s_outf; return INSTRUCTION_s_outf; }
s_outi     { current_opcode = s_outi; return INSTRUCTION_s_outi; }
s_outs     { current_opcode = s_outs; return INSTRUCTION_s_outs; }
s_popl     { current_opcode = s_popl; return INSTRUCTION_s_popl; }
s_powf     { current_opcode = s_powf; return INSTRUCTION_s_powf; }
s_powi     { current_opcode = s_powi; return INSTRUCTION_s_powi; }
s_powi_i     { current_opcode = s_powi_i; return INSTRUCTION_s_powi_i; }
s_pshf     { current_opcode = s_pshf; return INSTRUCTION_s_pshf; }
s_pshl     { current_opcode = s_pshl; return INSTRUCTION_s_pshl; }
s_ret     { current_opcode = s_ret; return INSTRUCTION_s_ret; }
s_retn     { current_opcode = s_retn; return INSTRUCTION_s_retn; }
s_scll     { current_opcode = s_scll; return INSTRUCTION_s_scll; }
s_seto     { current_opcode = s_seto; return INSTRUCTION_s_seto; }
s_subf     { current_opcode = s_subf; return INSTRUCTION_s_subf; }
s_subi     { current_opcode = s_subi; return INSTRUCTION_s_subi; }
s_subi_i     { current_opcode = s_subi_i; return INSTRUCTION_s_subi_i; }
s_swp     { current_opcode = s_swp; return INSTRUCTION_s_swp; }
s_thrw     { current_opcode = s_thrw; return INSTRUCTION_s_thrw; }
s_umini     { current_opcode = s_umini; return INSTRUCTION_s_umini; }
s_xori     { current_opcode = s_xori; return INSTRUCTION_s_xori; }
setfp     { current_opcode = setfp; return INSTRUCTION_setfp; }
subi     { current_opcode = subi; return INSTRUCTION_subi; }
subi_i     { current_opcode = subi_i; return INSTRUCTION_subi_i; }
swp     { current_opcode = swp; return INSTRUCTION_swp; }
{IDENTIFIER} { /* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

/* The licensing text can not begin at the very first character, since 
   flex does not allow comments in the second section outside the actions,
   and this file will be appended after the middle of the second section. */
 yyerror("misspelled opcode, register, or label"); }
.            { yyerror("scanning error"); }

%%

/* This updates yytext and yyleng */
void remove_escapes_from_yytext(){
  integer_t left_shifts_no = 0;
  integer_t i;
  char unescaped_character;

  /* Any time we find an escape sequence we left-shift the following text: */
  for(i = 0; i < yyleng; i++){
    if(yytext[i] == '\\'){
      /* This is the beginning of an escape sequence. The lexicon rules force
	 yytext[i + 1] to exist and to be different from '\0'. */
      switch(yytext[i + 1]){
      case 'a':{
	unescaped_character = '\a';
	break;
      }
      case 't':{
	unescaped_character = '\t';
	break;
      }
      case 'n':{
	unescaped_character = '\n';
	break;
      }
      case '\\': case '\"':{
	unescaped_character = yytext[i + 1];
	break;
      }
      default:{
	unescaped_character = yytext[i + 1];
	yyerror("An unknown escape sequence was ignored");
      }
      } /* switch */

      left_shifts_no++;
      /* We already managed yytext[i + 1]; skip a character: */
      i++;
    } 
    else /* yytext[i] is a normal character */
      unescaped_character = yytext[i];      
    
    yytext[i - left_shifts_no] = unescaped_character;

  } /* for */

  /* Update yyleng and terminate the updated string with '\0': */
  yyleng -= left_shifts_no;
  yytext[yyleng] = '\0';
}

int yywrap(){
  return 1;
}
