/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef EAMLD_H_
#define EAMLD_H_

#include "bytecode.h"
#include "../common/string_map.h"

/* All the needed modules, topologically sorted by dependency (i.e. already
   in the order in which they will appear: */
extern int sorted_modules_no;
extern struct epsilon_module **sorted_modules;

/* The sets of all globals and all exceptions used in sorted_modules: */
extern struct string_map* global_to_index;
extern struct string_map* exception_to_index;

/* The linked executable to produce: */
extern struct epsilon_executable linked_executable;

/* Has --verbose, -v been set? */
extern int verbose;

#endif /* #ifndef EAMLD_H_ */
