/* This file is automatically generated. Don't edit */
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include "eam_types.h"
#include <stdio.h>
#include "bytecode.h"
#include "eamld_fix_references.h"
#include "eamld.h"
#include "../common/string_map.h"
#include "instructions.h"

integer_t index_for_module;
integer_t index_for_linked_executable = 0;
integer_t index_for_current_module;
integer_t instructions_no_before_current_module = 0;
integer_t string_constants_no_before_current_module = 0;
integer_t c_libraries_no_before_current_module = 0;
integer_t c_symbols_no_before_current_module = 0;

word_t global_in_module_to_global_in_executable(word_t reference_in_module){
  integer_t global_index_for_executable;
  char *global_name;
  
  /* Take the name of the global from the struct epsilon_module, and use the
     string_map to find its executable-relative index: */
  global_name = 
    sorted_modules[index_for_module]->globals[(integer_t)reference_in_module];
  global_index_for_executable =
    *((integer_t*) access_string_map(global_to_index, global_name));

  /* Return the index cast into a word_t: */
  return (word_t) global_index_for_executable;
}

word_t exception_in_module_to_exception_in_executable(word_t reference_in_module){
  integer_t exception_index_for_executable;
  char *exception_name;

  /* Take the name of the exception from the struct epsilon_module, and use the
     string_map to find its executable-relative index: */
  exception_name = 
    sorted_modules[index_for_module]->exceptions[(integer_t)reference_in_module];
  exception_index_for_executable =
    *((integer_t*) access_string_map(exception_to_index, exception_name));

  /* Return the index cast into a word_t: */
  return (word_t) exception_index_for_executable;
}

#define THIS_INSTRUCTION_FOR_MODULE     \
  sorted_modules[index_for_module]->instructions[index_for_current_module]
#define THIS_INSTRUCTION_FOR_EXECUTABLE \
  linked_executable.instructions[index_for_linked_executable]
#define FIX_exception_PARAMETER(NUMBER) \
  THIS_INSTRUCTION_FOR_EXECUTABLE.parameter_ ## NUMBER = \
    exception_in_module_to_exception_in_executable(THIS_INSTRUCTION_FOR_MODULE.parameter_ ## NUMBER)
#define FIX_global_PARAMETER(NUMBER) \
  THIS_INSTRUCTION_FOR_EXECUTABLE.parameter_ ## NUMBER = \
    global_in_module_to_global_in_executable(THIS_INSTRUCTION_FOR_MODULE.parameter_ ## NUMBER)
#define FIX_string_PARAMETER(NUMBER) \
  THIS_INSTRUCTION_FOR_EXECUTABLE.parameter_ ## NUMBER = \
    (word_t) ((integer_t)(THIS_INSTRUCTION_FOR_EXECUTABLE.parameter_ ## NUMBER) + \
      string_constants_no_before_current_module)

#define FIX_PARAMETER(NUMBER, TYPE) \
  FIX_ ## TYPE ## _PARAMETER(NUMBER)
/*
#define FIX_PARAMETER(NUMBER, TYPE) \
  THIS_INSTRUCTION_FOR_EXECUTABLE.parameter_ ## NUMBER = \
    TYPE ## _in_module_to_ ## TYPE ## _in_executable(THIS_INSTRUCTION_FOR_MODULE.parameter_ ## NUMBER)
*/

void
fix_globals_and_exceptions_for_current_instruction()
{
  switch(linked_executable.instructions[index_for_linked_executable].opcode){
    /* Instructions of category exception: */
    case s_thrw:
    { FIX_PARAMETER(1, exception); break; }

    /* Instructions of category exception_label: */
    case jde:
    { FIX_PARAMETER(1, exception); break; }

    /* Instructions of category float: */
    case pshcf:
    { /* Nothing to fix */ break; }

    /* Instructions of category global: */
    case pshgl:
    case s_gl:
    { FIX_PARAMETER(1, global); break; }

    /* Instructions of category integer: */
    case hlt:
    case popm:
    case pshci:
    case s_addi_i:
    case s_cll:
    case s_divi_i:
    case s_eqi_i:
    case s_fcll:
    case s_fscll:
    case s_gtei_i:
    case s_gti_i:
    case s_lcl:
    case s_lkp_i:
    case s_ltei_i:
    case s_lti_i:
    case s_mka_i:
    case s_mkba_i:
    case s_modi_i:
    case s_muli_i:
    case s_neqi_i:
    case s_powi_i:
    case s_pshf:
    case s_pshl:
    case s_scll:
    case s_subi_i:
    { /* Nothing to fix */ break; }

    /* Instructions of category integer_integer: */
    case s_nlcl:
    { /* Nothing to fix */ break; }

    /* Instructions of category integer_label: */
    case s_jeqi_i:
    case s_jgtei_i:
    case s_jgti_i:
    case s_jltei_i:
    case s_jlti_i:
    case s_jneqi_i:
    case s_jnm:
    { /* Nothing to fix */ break; }

    /* Instructions of category label: */
    case j:
    case pshtry:
    case s_cls:
    case s_clsr:
    case s_jandi:
    case s_jeqi:
    case s_jgtei:
    case s_jgti:
    case s_jltei:
    case s_jlti:
    case s_jnandi:
    case s_jneqi:
    case s_jnori:
    case s_jnxori:
    case s_jnz:
    case s_jori:
    case s_jxori:
    case s_jz:
    { /* Nothing to fix */ break; }

    /* Instructions of category nullary: */
    case clargs:
    case cpy:
    case dfhn:
    case gcin:
    case inc:
    case ini:
    case ins:
    case lbl:
    case nop:
    case pop:
    case popf:
    case popfn:
    case poptry:
    case pshnll:
    case psho:
    case rthrw:
    case s_addf:
    case s_addi:
    case s_andi:
    case s_barlt:
    case s_car:
    case s_cctba:
    case s_cdr:
    case s_chst:
    case s_cns:
    case s_divf:
    case s_divi:
    case s_eqf:
    case s_eqi:
    case s_eqs:
    case s_f_divi:
    case s_f_modi:
    case s_filec:
    case s_fileor:
    case s_fileow:
    case s_filerc:
    case s_filewc:
    case s_flin:
    case s_frtoba:
    case s_gtef:
    case s_gtei:
    case s_gtes:
    case s_gtf:
    case s_gti:
    case s_gts:
    case s_infl:
    case s_lkp:
    case s_lkpb:
    case s_ltbar:
    case s_ltef:
    case s_ltei:
    case s_ltes:
    case s_ltf:
    case s_lti:
    case s_lts:
    case s_modi:
    case s_mulf:
    case s_muli:
    case s_neqi:
    case s_neqs:
    case s_nll:
    case s_nnll:
    case s_noti:
    case s_nxori:
    case s_ori:
    case s_outc:
    case s_outec:
    case s_outes:
    case s_outf:
    case s_outi:
    case s_outs:
    case s_popl:
    case s_powf:
    case s_powi:
    case s_ret:
    case s_retn:
    case s_seto:
    case s_subf:
    case s_subi:
    case s_swp:
    case s_umini:
    case s_xori:
    { /* Nothing to fix */ break; }

    /* Instructions of category register: */
    case outi:
    { /* Nothing to fix */ break; }

    /* Instructions of category register_integer: */
    case ldci:
    { /* Nothing to fix */ break; }

    /* Instructions of category register_integer_integer: */
    case nlcl:
    { /* Nothing to fix */ break; }

    /* Instructions of category register_integer_register: */
    case dummy_register_integer_register:
    { /* Nothing to fix */ break; }

    /* Instructions of category register_register: */
    case swp:
    { /* Nothing to fix */ break; }

    /* Instructions of category register_register_integer: */
    case addi_i:
    case divi_i:
    case muli_i:
    case subi_i:
    { /* Nothing to fix */ break; }

    /* Instructions of category register_register_register: */
    case addi:
    case divi:
    case f_divi:
    case muli:
    case subi:
    { /* Nothing to fix */ break; }

    /* Instructions of category string: */
    case pshcs:
    case setfp:
    { FIX_PARAMETER(1, string); break; }

    /* Instructions of category string_string: */
    case nln:
    case s_cact:
    case s_cactp:
    case s_cfun:
    case s_cobj:
    { FIX_PARAMETER(1, string); FIX_PARAMETER(2, string); break; }

/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


  }/* switch */
}

void
fix_current_instruction ()
{
  /* Fix the label parameter (this is easy): */
  linked_executable.instructions[index_for_linked_executable].label_parameter
    += instructions_no_before_current_module;
  
  /* Fix globals and exceptions (this must be done on an
     instruction-by-instruction basis): */
  fix_globals_and_exceptions_for_current_instruction();

  /* Fix a reference to C object, if this instruction has it: */
  switch(linked_executable.instructions[index_for_linked_executable].opcode){
  case s_cobj: case s_cfun: case s_cact: case s_cactp: {
    linked_executable.instructions[index_for_linked_executable].parameter_3 = (word_t)
      (((integer_t)
        linked_executable.instructions[index_for_linked_executable].parameter_3)
       + c_symbols_no_before_current_module);
    break;
  } /* case */
  default:{ /* Do nothing */ }
  } /* switch */
}

void
fix_c_symbols ()
{
  integer_t index_for_c_symbol;
  
  /* Fix the library_index field in each C symbol: */
  for(index_for_c_symbol = 0;
      index_for_c_symbol < sorted_modules[index_for_module]->c_symbols_no;
      index_for_c_symbol++)
    linked_executable.c_symbols[c_symbols_no_before_current_module + 
				index_for_c_symbol].library_index +=
      c_libraries_no_before_current_module;
}

void
fix_foreign_references ()
{  
  for (index_for_module = 0;
       index_for_module < sorted_modules_no; index_for_module++)
    {
      if(verbose)
	fprintf(stderr, "    Fixing references for %s...\n", 
		sorted_modules[index_for_module]->name);
      for (index_for_current_module = 0;
	   index_for_current_module < sorted_modules[index_for_module]->instructions_no;
	   index_for_current_module++)
	{
	  /* Fix the current instruction: */
	  fix_current_instruction ();
	  /* We finished processing this instruction: we can increment also 
	     index_for_linked_executable: */
	  index_for_linked_executable++;
	} /* for(index_for_current_module... */

      /* Fix the library_index field in each C symbol: */
      fix_c_symbols();
      
      /* We finished processing this module */
      string_constants_no_before_current_module +=
        sorted_modules[index_for_module]->string_constants_no;
      instructions_no_before_current_module +=
	sorted_modules[index_for_module]->instructions_no;
      c_libraries_no_before_current_module +=
        sorted_modules[index_for_module]->c_libraries_no;
      c_symbols_no_before_current_module +=
        sorted_modules[index_for_module]->c_symbols_no;
    } /* for(index_for_module... */
}

/* Add two trailing instructions: the first makes the program exit with success,
   the second is the default exception handler, called when there is nothing more
   to pop on the stack: */
void add_default_exception_handler(){
  linked_executable.instructions[linked_executable.instructions_no].opcode = hlt;
  linked_executable.instructions[linked_executable.instructions_no].parameter_1 = 0;
  linked_executable.instructions[linked_executable.instructions_no + 1].opcode = dfhn;
  linked_executable.instructions_no += 2;
}
