/* This file is automatically generated. Don't edit */
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


// evm_c.head

#undef EAM_PROFILE // To do: Autoconfize (this must go into config.h)
#define __USE_POSIX199309 /* Use the POSIX runtime extension */
#define _BSD_SOURCE

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <math.h>
#include "eam_types.h"
#include "bytecode.h"
#include "instructions.h"
#include "../commontext.h"
#include "../common/command_line.h"
#include "../common/malloc.h"
#include "../common/readline_wrapper.h"
#include "runtime.h"
#include "primitive_exceptions.h"
#include "gc/gc.h"
#include "library/library.h"

/* Redefine some macros from runtime.h: in the virtual machine jumps are
   implemented as simple assignments: */
#undef  GOTO_IMMEDIATE
#define GOTO_IMMEDIATE(x) {instruction_pointer = (integer_t)x; goto out_of_switch;}//continue;}
#undef  GOTO_GENERIC
#define GOTO_GENERIC(x)   {instruction_pointer = (integer_t)x; goto out_of_switch;}//continue;}

extern integer_t gc_roots_stack_size;

/* show GC statistics if nonzero; this is driven by command line: */
integer_t verbose_gc = 0; 

#define MARK_GC_ROOTS() { \
  integer_t i; \
  /* Mark the stack: */ \
  add_gc_roots(stack, (undertop_stack_pointer + 1)); \
  add_gc_root(top); \
  /* Mark registers: */ \
  add_gc_roots(word_registers, executable->word_registers_no); \
  add_gc_root(environment); \
  add_gc_root(output_register); \
  /* Mark globals: */ \
  add_gc_roots(globals, executable->globals_no); \
  /* Mark exceptions structures: */ \
  add_gc_root(exception_value); \
  for(i = 0; i < exceptions_stack_pointer; i++) \
    add_gc_root(exceptions_stack[i].environment); \
  add_gc_roots(c_symbols, executable->c_symbols_no); \
  /* fprintf(stderr, "GC roots stack has size "INTEGER_T_FORMAT"\n", gc_roots_stack_size); fflush(stderr); */ \
}

int evm_loop(struct epsilon_executable *executable, int argc, char** argv);

/* Global runtime structures: */

/* Registers: */
word_t*            word_registers;
wide_integer_t*    wide_integer_registers;
float_t*           float_registers;
wide_float_t*      wide_float_registers;
wide_wide_float_t* wide_wide_float_registers;
word_t             failure_point_register = NULL;

/* Stack: */
word_t* stack;
integer_t stack_size;
integer_t undertop_stack_pointer;
word_t top;

/* Frame management: */
word_t* environment;
integer_t frame_pointer;

/* Support for exceptions: */
exception_t* exceptions_stack;
integer_t exceptions_stack_size;
integer_t exceptions_stack_pointer;
word_t exception_value;
integer_t exception_type;
char** exceptions_names;

/* Globals and string constants: */
word_t* globals;
integer_t** string_constants;

/* C symbols will be needed later: */
word_t* c_symbols;

void initialize_c_symbols(struct epsilon_executable *executable){
  c_library_handle_t* c_libraries;
  integer_t i;
  
  /* Initialize libraries/symbols handling: */
  initialize_dynamic_libraries();

  /* Open all C libraries: */
  c_libraries = (c_library_handle_t*)
    xmalloc(sizeof(c_library_handle_t) * executable->c_libraries_no);
  for(i = 0; i < executable->c_libraries_no; i++)
    c_libraries[i] = open_c_library(executable->c_libraries[i]);
  
  /* Load all C symbols: */
  c_symbols = (word_t*)
    xmalloc(sizeof(word_t) * executable->c_symbols_no);
  for(i = 0; i < executable->c_symbols_no; i++)
    c_symbols[i] = load_c_symbol(c_libraries[executable->c_symbols[i].library_index],
				 executable->c_symbols[i].symbol_name);

  /* We don't need c_libraries anymore: */
  free(c_libraries);
}

void initialize_string_constants(struct epsilon_executable *executable){
  integer_t i;
  for(i = 0; i < executable->string_constants_no; i++){
    integer_t length = strlen(executable->string_constants[i]);
    integer_t i2;
    /* Allocate storage for the i-th string: */
    string_constants[i] = (integer_t*)
      xmalloc(sizeof(integer_t) * (1 + length));
    /* Create the content of the i-th string*/
    string_constants[i][0] = length;
    for(i2 = 1; i2 <= length; i2++)
      string_constants[i][i2] = (integer_t)executable->string_constants[i][i2 - 1];
  }
}

void initialize_runtime_structures(struct epsilon_executable *executable){
  integer_t i;

  if(long_option_to_value("verbose"))
    fprintf(stderr, "Initializing... ");
  /* Create registers: */
  word_registers = (word_t*)
    xmalloc(sizeof(word_t) * executable->word_registers_no);
  wide_integer_registers = (wide_integer_t*)
    xmalloc(sizeof(wide_integer_t) * executable->wide_integer_registers_no);
  float_registers = (float_t*)
    xmalloc(sizeof(float_t) * executable->float_registers_no);
  wide_float_registers = (wide_float_t*)
    xmalloc(sizeof(wide_float_t) * executable->wide_float_registers_no);
  wide_wide_float_registers = (wide_wide_float_t*)
    xmalloc(sizeof(wide_wide_float_t) * executable->wide_wide_float_registers_no);

  /* Create stack and frame support: */
  stack_size = executable->instructions_no + 10; /* A safe value */
  stack = (word_t*)
    xmalloc(sizeof(word_t) * stack_size);
  stack[0] = (word_t)NULL;  /* saved environment */
  top = (word_t)(-1);  /* saved frame pointer */
  undertop_stack_pointer = 0;
  frame_pointer = 0;
  
  /* Create exception-handling structures: */
  exceptions_stack_size = 16;
  exceptions_stack = (exception_t*)
    xmalloc(sizeof(exception_t) * exceptions_stack_size);

  /* This is the outmost handler, the default one */
  exceptions_stack[0].environment =
    xmalloc(sizeof(word_t)); /* we don't care */
  exceptions_stack[0].handler_pointer =
    (word_t)(executable->instructions_no - 1);
  exceptions_stack[0].undertop_stack_pointer = 0;
  exceptions_stack[0].frame_pointer = 0;
  exceptions_stack_pointer = 0;
  exceptions_names = executable->exceptions;

  /* Create the remaining global structures: */
  globals = (word_t*)
    xmalloc(sizeof(word_t) * executable->globals_no);
  string_constants = (integer_t**)
    xmalloc(sizeof(integer_t*) * executable->string_constants_no);
  initialize_string_constants(executable);
  initialize_c_symbols(executable);
  
  if(long_option_to_value("verbose"))
    fprintf(stderr, "done.\n");
}

#ifdef EAM_PROFILE
/* Minimum number of uses for an instruction profiling to be considered valid: */
#define LOW_USES_NO_LIMIT 100000
/* Start and end time of an instruction use:*/
struct timespec instruction_begin_time, instruction_end_time, instruction_cost;
/* Cost of all uses of each instruction, in clock ticks: */
wide_wide_float_t instructions_costs[EAM_INSTRUCTIONS_NO];
/* Number of uses of each instruction: */
integer_t instructions_uses_no[EAM_INSTRUCTIONS_NO];
/* Opcode of the instruction which is being profiled: */
integer_t current_opcode;

/* Adapted fomr an exemple in the GNU libc manual: */
     /* Subtract the `struct timeval' values X and Y,
        storing the result in RESULT.
        Return 1 if the difference is negative, otherwise 0.  */

     int
     timespec_subtract (result, x, y)
          struct timespec *result, *x, *y;
     {
       /* Perform the carry for the later subtraction by updating Y. */
       if (x->tv_nsec < y->tv_nsec) {
         int nsec = (y->tv_nsec - x->tv_nsec) / 1000000000 + 1;
         y->tv_nsec -= 1000000000 * nsec;
         y->tv_sec += nsec;
       }
       if (x->tv_nsec - y->tv_nsec > 1000000000) {
         int nsec = (x->tv_nsec - y->tv_nsec) / 1000000000;
         y->tv_nsec += 1000000000 * nsec;
         y->tv_sec -= nsec;
       }

       /* Compute the time remaining to wait.
          `tv_nsec' is certainly positive. */
       result->tv_sec = x->tv_sec - y->tv_sec;
       result->tv_nsec = x->tv_nsec - y->tv_nsec;

       /* Return 1 if result is negative. */
       return x->tv_sec < y->tv_sec;
     }

/* If the number of nanoseconds is >= 1 billion then convert into
   an equivalent timespec where tv_nsec < 1 billion: */
void normalize_timespec(struct timespec* ts){
  if (ts->tv_nsec >= 1000000000){
    ts->tv_sec += (ts->tv_nsec / 1000000000);
    ts->tv_nsec %= 1000000000;
  }
}

/* Sum and normalize the result: */
void timespec_sum(struct timespec *result,
		  struct timespec *x,
		  struct timespec *y){
  result->tv_sec = x->tv_sec + y->tv_sec;
  result->tv_nsec = x->tv_nsec + y->tv_nsec;
  normalize_timespec(result);
}

void report_profiling(){
  integer_t i;
  /* Update instructions_costs to hold the average cost of each instruction: */
  for(i = 0; i < EAM_INSTRUCTIONS_NO; i++)
    if(instructions_uses_no[i] != 0)
      instructions_costs[i] /= (wide_wide_float_t)(instructions_uses_no[i]);

  /* Report: */
  for(i = 0; i < EAM_INSTRUCTIONS_NO; i++){
    /* Ignore instructions used few times: */
    if(instructions_uses_no[i] < LOW_USES_NO_LIMIT)
      continue;
    
    /* Write information about the i-th instruction, which was used: */
    printf("%-10s " WIDE_WIDE_FLOAT_T_FORMAT " (" INTEGER_T_FORMAT " uses)\n",
	   instructions_names[i],
	   instructions_costs[i],
	   instructions_uses_no[i]);
  } /* for */
}
#endif /* ifdef EAM_PROFILE */

int main(int argc, char** argv){
  struct epsilon_executable *executable;

  /* Define command line behavior: */
  set_program_name ("evm (" PACKAGE_NAME ")");
  set_general_help_message("Execute the given eAM executable XXXX.eamx with the\n"
			   "epsilon Virtual Machine.");
  set_synopsis_string ("evm XXXX.eamx [arguments]");
  set_version_string (VERSION_STRING);
  set_copyright_string (COPYRIGHT_STRING);
  set_license_message (LICENSE_STRING);
  set_bug_reporting_message (BUG_REPORTING_MESSAGE);

  add_toggle_option ("verbose", 'v', 0,
                     "Be more verbose while processing");
  add_toggle_option ("verbose-gc", 'g', 0,
                     "Show garbage-collecting statistics on stderr");
  add_toggle_option ("benchmark", 'b', 0,
                     "Report timing information after execution");
  
  /* Parse command-line and check its correctness: */
  parse_command_line(&argc, argv);

  if(argc < 2)
    command_line_fatal("There must be at least one command-line argument");
  
  if(! has_extension(argv[1], "eamx"))
    command_line_fatal("The argument must have extension eamx");
  
  /* Set global flags driven by command-line options: */
  verbose_gc = (integer_t) long_option_to_value("verbose-gc");

  /* Load executable file: */
  executable = read_epsilon_executable_file(argv[1]);
  if(executable == NULL){
    fprintf(stderr, "About %s:\n", argv[1]);
    fatal("Error while reading eAM executable file");
  }
  
  /* Ok, now executable points to the eAM program to execute. */
  
  /* Initialize run-time structures such as stacks, registers and globals: */
  initialize_runtime_structures(executable);
  
  /* Start the GC: */
  initialize_garbage_collector();
  
  /* See the comment in eam/library/use_everything.h: */
  use_everything();

  /* Run the program, (it calls exit(), so the return value will be set) */
  evm_loop(executable, argc - 2, argv + 2);

  return 0; /* Never reached; just to avoid a warning from the GCC */
} /* main */

extern integer_t allocated_words_since_last_gc; // To do: remove this

int evm_loop(struct epsilon_executable *executable, int argc, char** argv){
  instruction_t* instructions = executable->instructions;
  integer_t instructions_no = executable->instructions_no;
  integer_t instruction_pointer = 0;
  word_t output_register;
  clock_t begin_time = /* for profiling, epecially GC profiling */
	((double)clock()) * 1000.0 / (double)CLOCKS_PER_SEC; 
#ifdef EAM_PROFILE
  integer_t i;
  /* Initialize the arrays needed for profiling: */
  for(i = 0; i < EAM_INSTRUCTIONS_NO; i++){
    instructions_costs[i] = (wide_float_t)0.0;
    instructions_uses_no[i] = (integer_t)0;
  }
#endif /* #ifdef EAM_PROFILE */
  
  do{ /* loop forever, until an eAM instruction makes us exit: */
    //fprintf(stderr, "Instruction %i: >%s<\n", instruction_pointer,
    //        instructions_names[instructions[instruction_pointer].opcode]);// fflush(stderr);
    /* These macros are used in the C implementation of eAM instructions: */
    #define FLOAT_PARAMETER (instructions[instruction_pointer].float_parameter)
    #define PARAMETER_1 (instructions[instruction_pointer].parameter_1)
    #define PARAMETER_2 (instructions[instruction_pointer].parameter_2)
    #define PARAMETER_3 (instructions[instruction_pointer].parameter_3)
    #define PARAMETER_1_AS_GLOBAL (globals[(integer_t)instructions[instruction_pointer].parameter_1])
    #define PARAMETER_1_AS_STRING (string_constants[(integer_t)instructions[instruction_pointer].parameter_1])
    #define PARAMETER_2_AS_STRING (string_constants[(integer_t)instructions[instruction_pointer].parameter_2])
    #define PARAMETER_1_AS_REGISTER (word_registers[(integer_t)instructions[instruction_pointer].parameter_1])
    #define PARAMETER_2_AS_REGISTER (word_registers[(integer_t)instructions[instruction_pointer].parameter_2])
    #define PARAMETER_3_AS_REGISTER (word_registers[(integer_t)instructions[instruction_pointer].parameter_3])
    #define LABEL_PARAMETER \
       ((word_t)(instructions[instruction_pointer].label_parameter))
    #define THIS_INSTRUCTION instruction_pointer
    #define NEXT_INSTRUCTION ((word_t)(instruction_pointer + 1))
    #define PARAMETER_3_AS_C_SYMBOL (c_symbols[(integer_t)(instructions[instruction_pointer].parameter_3)])
    
#ifdef EAM_PROFILE
    /* Start measuring the time for the current instruction; this includes
       dispatching time: */
    current_opcode = instructions[instruction_pointer].opcode;
    clock_gettime(CLOCK_REALTIME, &instruction_begin_time);
    //    instruction_begin_time = clock();    
#endif /* #ifdef EAM_PROFILE */

    switch(instructions[instruction_pointer].opcode){
    case nln:{
      fatal("The eAM instruction 'nln' can not be used with evm");
      break; /* just for uniformity, to avoid wrong kill-and-yank */
    }
    case addi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the addi instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER + 
                                   (integer_t)PARAMETER_3_AS_REGISTER);
      break;
    }
    case addi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the addi_i instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER +
                                   (integer_t)PARAMETER_3);
      break;
    }
    case clargs:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the clargs instruction */

/* Copy command-line non-option arguments into output_register, as a
   list of strings: */

word_t* pointer;

/* Copy each element into a list: */
output_register = c_array_to_list(argv, (integer_t)argc);

/* Convert each string from the C format into the epsilon format: */
pointer = (word_t*)output_register;
while(pointer != NULL){
  pointer[0] = c_string_to_epsilon_string(pointer[0]); /* convert */
  pointer = (word_t*)(pointer[1]); /* advance the pointer */
}
      break;
    }
    case cpy:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the cpy instruction */

stack[++undertop_stack_pointer]=top;
      break;
    }
    case dfhn:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the dfhn instruction */

/* Default (outmost) exception handler: prints a message and exits with
    failure: */
fprintf(stderr, "Uncaugth exception %s\n",
	exceptions_names[exception_type]);
if(failure_point_register != NULL){
  int i;
  fprintf(stderr, "from ");
  for(i = 1; i <= ((integer_t*)failure_point_register)[0]; i++)
    fprintf(stderr, "%c", (char)(((integer_t*)failure_point_register)[i]));
  fprintf(stderr, "\n");
}
EXIT_EAM(EXIT_FAILURE);
      break;
    }
    case divi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the divi instruction */

if(((integer_t)PARAMETER_3_AS_REGISTER) == 0){
  fprintf(stderr, "Division by zero\n");
  exit(EXIT_FAILURE);
}

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER /
                                   (integer_t)PARAMETER_3_AS_REGISTER);
      break;
    }
    case divi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the divi_i instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER /
                                   (integer_t)PARAMETER_3);
      break;
    }
    case dummy_register_integer_register:{
      break;
    }
    case f_divi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the f_divi instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER /
                                   (integer_t)PARAMETER_3_AS_REGISTER);
      break;
    }
    case gcin:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the gcin instruction */

GC_IF_NEEDED();
      break;
    }
    case hlt:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the hlt instruction */

#ifdef EAM_PROFILE
  /* Report the cost of each instruction: */
  report_profiling();
#endif /* #ifdef EAM_PROFILE */

EXIT_EAM(PARAMETER_1);
      break;
    }
    case inc:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the inc instruction */

// To do: manage errors
char character;

/* Read a character from the terminal and place the result into
   output_register: */
output_register = (word_t)((integer_t)getchar());
      break;
    }
    case ini:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the ini instruction */

// To do: manage errors
int number;

/* Read a number from the terminal: */
scanf("%i", &number);

/* Put the result into output_register, converted into an integer_t: */
output_register = (word_t)((integer_t)number);
      break;
    }
    case ins:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the ins instruction */

// To do: manage errors
int i;
char* s;
int length_of_s;
word_t* array;

/* Read a string from the console: */
s = readline(""); /* This malloc()'s the string */

/* Throw an exception if the buffer is over */
if(s == NULL)
  THROW(interrupted_exception, NULL);

/* Create the eAM array: */
length_of_s = strlen(s);
ASSIGN_CREATE_ARRAY(array, length_of_s + 1);

/* Fill the eAM array: */
array[0] = (word_t)((integer_t)length_of_s); /* length */
for (i = 0; i < length_of_s; i++)
  array[i + 1] = (word_t)((integer_t)(s[i]));

/* Free the string allocated by readline(): */
free(s);

/* Put the result into output_register, converted into an word_t: */
output_register = (word_t)array;
      break;
    }
    case j:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the j instruction */

GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case jde:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the jde instruction */

if(exception_type != (integer_t)PARAMETER_1){ /* jump to the next handler */
  GOTO_IMMEDIATE(LABEL_PARAMETER);
}
else{
  PUSH_OBJECT(exception_value); /* push exception_value onto the stack */
  exceptions_stack_pointer--; /* we "consumed" an handler */
}
      break;
    }
    case lbl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the lbl instruction */

/* Do nothing. This instruction is output by the eAML assembler when a label is
   found, to prevent the peephole optimizer from making unsafe changes such as

      pshci   2             pshci    2
      pshci   2   |-->      s_addi_i 2
   L: s_addi             L: nop
 */
      break;
    }
    case ldci:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the ldci instruction */

PARAMETER_1_AS_REGISTER = PARAMETER_2;
      break;
    }
    case muli:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the muli instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER *
                                   (integer_t)PARAMETER_3_AS_REGISTER);
      break;
    }
    case muli_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the muli_i instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER *
                                   (integer_t)PARAMETER_3);
      break;
    }
    case nlcl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the nlcl instruction */

integer_t i;
void** temporary_environment = environment;

/* Search for the right environment where to find the object (the distance
   is of PARAMETER_2 steps on the static chain: */
for(i = 0; i < (integer_t)PARAMETER_2; i++)
  temporary_environment = (void**)(temporary_environment[0]);

/* Copy the nonlocal into the given register: */
PARAMETER_1_AS_REGISTER = (((void**)temporary_environment)[(integer_t)PARAMETER_3]);

      break;
    }
    case nop:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the nop instruction */

/* do nothing */

      break;
    }
    case outi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the outi instruction */

printf(INTEGER_T_FORMAT " ",(integer_t)PARAMETER_1_AS_REGISTER);
      break;
    }
    case pop:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pop instruction */

POP;
      break;
    }
    case popf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu
Copyright (C) 2003 Matteo Golfarini

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the popf instruction */

/* top remains the same, since it's the value to return.
   There is no need to resize the stack: the GC will do it
   when needed. */

/* Destroy the frame, reducing undertop_stack_pointer: */
undertop_stack_pointer = frame_pointer - 1;

/* Revert to the old env and FP: */
environment = stack[frame_pointer];
frame_pointer = (integer_t)(stack[frame_pointer + 1]);
      break;
    }
    case popfn:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu
Copyright (C) 2003 Matteo Golfarini

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the popfn instruction */

/* Destroy the frame, reducing undertop_stack_pointer: */
undertop_stack_pointer = frame_pointer - 2;

/* top has remained the same, but we want to return *nothing*: */
top = stack[frame_pointer - 1];

/* Revert to the old env and FP: */
environment = stack[frame_pointer];
frame_pointer = (integer_t)(stack[frame_pointer + 1]);
      break;
    }
    case popm:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the popm instruction */

POP_MULTIPLE((integer_t)PARAMETER_1);
      break;
    }
    case poptry:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the poptry instruction */

exceptions_stack_pointer--;
      break;
    }
    case pshcf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pshcf instruction */

PUSH_OBJECT(float_to_word(FLOAT_PARAMETER));
      break;
    }
    case pshci:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pshci instruction */

PUSH_OBJECT(PARAMETER_1);
      break;
    }
    case pshcs:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pshcs instruction */

PUSH_OBJECT(PARAMETER_1_AS_STRING);
      break;
    }
    case pshgl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pshgl instruction */

PUSH_OBJECT(PARAMETER_1_AS_GLOBAL);
      break;
    }
    case pshnll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pshnll instruction */

PUSH_OBJECT(NULL);
      break;
    }
    case psho:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the psho instruction */

PUSH_OBJECT(output_register);
      break;
    }
    case pshtry:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the pshtry instruction */

/* Increment exceptions stack pointer, and resize the exceptions stack if 
   needed: */
if(++exceptions_stack_pointer == exceptions_stack_size){
  exceptions_stack_size *= 2;
  exceptions_stack = realloc(exceptions_stack,
			     sizeof(exception_t) * exceptions_stack_size);
}

/* Copy relevant information into the record: */
exceptions_stack[exceptions_stack_pointer].handler_pointer = LABEL_PARAMETER;
exceptions_stack[exceptions_stack_pointer].environment = environment;
exceptions_stack[exceptions_stack_pointer].frame_pointer = frame_pointer;
exceptions_stack[exceptions_stack_pointer].undertop_stack_pointer = 
  undertop_stack_pointer;
      break;
    }
    case rthrw:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the rthrw instruction */

/* Code for the s_thrw instruction */

/* Exception type and exception value are already set: no need to	
   touch them */

/* Pop the exceptions stack: */
exceptions_stack_pointer--;

/* Update FP, SP and environment: */
frame_pointer =
  exceptions_stack[exceptions_stack_pointer].frame_pointer;
top = stack[exceptions_stack_pointer + 1];
undertop_stack_pointer =
  exceptions_stack[exceptions_stack_pointer].undertop_stack_pointer;
environment =
  exceptions_stack[exceptions_stack_pointer].environment;

/* Jump to the handler: */
GOTO_GENERIC(exceptions_stack[exceptions_stack_pointer].handler_pointer);
      break;
    }
    case s_addf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_addf instruction */

top = float_to_word(word_to_float(top) + word_to_float(UNDERTOP));
undertop_stack_pointer--;
      break;
    }
    case s_addi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_addi instruction */

top = (word_t)(((integer_t)top) + (integer_t)UNDERTOP);
undertop_stack_pointer--;
      break;
    }
    case s_addi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_addi_i instruction */

//fprintf(stderr,"Before: UTSP %i\n", undertop_stack_pointer);

top = (word_t)((integer_t)top + (integer_t)PARAMETER_1);

//fprintf(stderr,"After:  UTSP %i\n", undertop_stack_pointer);
      break;
    }
    case s_andi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_andi instruction */

top = (word_t)(integer_t)(((integer_t)UNDERTOP) && ((integer_t)top));
undertop_stack_pointer --;
      break;
    }
    case s_barlt:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_barlt instruction */

top = epsilon_array_to_list(top);
      break;
    }
    case s_cact:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

/* Code for the s_cact instruction */

/* Execute the C action, and put the result into output_register: */
word_t (*action)(void) = PARAMETER_3_AS_C_SYMBOL;

output_register = action();
      break;
    }
    case s_cactp:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

/* Code for the s_cactp instruction */

/* Execute the C action, and put the result into output_register.
   The parameter is in top. */
word_t (*action)(word_t) = PARAMETER_3_AS_C_SYMBOL;
output_register = action(top);

/* Pop the argument: */
POP;
      break;
    }
    case s_car:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_car instruction */

if(top != NULL){
  /* Ok, top := top[0] */
  top = ((word_t*)top)[0];
}
else{
  /* top is null: throw exception */
  THROW(head_of_empty_list_exception, NULL);
}
      break;
    }
    case s_cctba:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cctba instruction */

const word_t* first_array = (word_t*)UNDERTOP;
const integer_t size_of_first_array = ((integer_t*)first_array)[0];
const word_t* second_array = (word_t*)top;
const integer_t size_of_second_array = ((integer_t*)second_array)[0];
const integer_t size_of_new_array = size_of_first_array +
                                    size_of_second_array;
word_t* new_array;
integer_t i;

/* Allocate the new array: */
ASSIGN_CREATE_ARRAY(new_array, size_of_new_array + 1);

/* Set the size element: */
new_array[0] = (word_t)size_of_new_array;

/* Copy the content of arrays: */
memcpy(new_array + 1, first_array + 1, size_of_first_array * sizeof(word_t));
memcpy(new_array + 1 + size_of_first_array, second_array + 1, 
       size_of_second_array * sizeof(word_t));

/* Emulate pop, pop, push(new_array): */
top = new_array;
undertop_stack_pointer--;
      break;
    }
    case s_cdr:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cdr instruction */

if(top != NULL){
  /* Ok, top := top[1] */
  top = ((word_t*)top)[1];
}
else{
  /* top is null: throw exception */
  THROW(tail_of_empty_list_exception, NULL);
}
      break;
    }
    case s_cfun:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cfun instruction */

/* Call the C function from word_t to word_t stored in PARAMETER_3: */
//word_t (*function)(word_t) = c_symbols[(integer_t)PARAMETER_3];
word_t (*function)(word_t) = PARAMETER_3_AS_C_SYMBOL;

/*
fprintf(stderr, "s_cfun: OK1\n");
fprintf(stderr, "s_cfun: argument is "FLOAT_T_FORMAT"\n",
	word_to_float(top));
*/
top = function(top);
/*
fprintf(stderr, "s_cfun: OK2\n");
fprintf(stderr, "s_cfun: result is   "FLOAT_T_FORMAT"\n",
	word_to_float(top));
*/
      break;
    }
    case s_chst:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_chst instruction */

integer_t* new_string;

ASSIGN_MY_MALLOC(new_string, 2);
new_string[0] = (integer_t)1;
new_string[1] = (integer_t)top;

top = (word_t) new_string;
      break;
    }
    case s_cll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cll instruction */

word_t* closure;
word_t* new_environment;
integer_t i;

ASSIGN_MY_MALLOC(new_environment, ((integer_t)PARAMETER_1) + 1);

if(((integer_t)PARAMETER_1) == 0){
  closure = (word_t*)top;
  /* There are no actual parameters */
}
else{
  closure = (word_t*)(stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 1]);

  /* Copy actual parameters into the new environment: the last one
     is in the top register, the previous ones are in the stack. */
  for(i = 1; i < ((integer_t)PARAMETER_1); i++)
    new_environment[i] = stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + i + 1];
  new_environment[(integer_t)PARAMETER_1] = top;
}

/* Copy the s-link into the new environment: */
new_environment[0] = closure[1];

/* Resize the stack: */
ENLARGE_STACK(undertop_stack_pointer + instructions_no);

/* Put old_FP, old_environment and old_IP on the stack, replacing closure and
   actual parameters: */
stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 1] = (word_t)frame_pointer;
stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 2] = (word_t)environment;
top = (word_t) (NEXT_INSTRUCTION);

/* Update FP, undertop_stack_pointer, environment and IP: */
undertop_stack_pointer = undertop_stack_pointer - ((integer_t)PARAMETER_1) + 2;
frame_pointer = undertop_stack_pointer - 1;
environment = new_environment;

GOTO_GENERIC(closure[0]);
      break;
    }
    case s_cls:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cls instruction */

word_t* closure;

ASSIGN_CONS(closure, ((word_t)LABEL_PARAMETER), (word_t)environment);
PUSH_OBJECT((word_t)closure);
      break;
    }
    case s_clsr:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_clsr instruction */

/* Build a circular closure: the closure itself contains the label 
   LABEL_PARAMETER and the pointer to an environment; this environment
   has the current environment in its s-link, and the circular closure
   itself as the only local object. */
word_t* closure;
word_t* environment_for_subprogram;

ASSIGN_MY_MALLOC(environment_for_subprogram, 2);
ASSIGN_CONS(closure, ((word_t)LABEL_PARAMETER),
                     (word_t)environment_for_subprogram);
environment_for_subprogram[0] = (word_t)environment;
environment_for_subprogram[1] = (word_t)closure;

PUSH_OBJECT((word_t)closure);
      break;
    }
    case s_cns:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cns instruction */

/* This is equivalent to s_mka_i 2, but slightly more efficient */

/* Allocate the cons: */
word_t* cons = allocate_exact(2);

/* Fill the cons: */
cons[0] = UNDERTOP;
cons[1] = top;

/* Pop the arguments and push the cons: */
undertop_stack_pointer --;
top = cons;
      break;
    }
    case s_cobj:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_cobj instruction */

PUSH_OBJECT(*((word_t*)PARAMETER_3_AS_C_SYMBOL));
      break;
    }
    case s_divf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_divf instruction */

if(word_to_float(top) == 0.0)
  THROW(division_by_zero_exception, NULL);

top = float_to_word(word_to_float(UNDERTOP) / word_to_float(top));
undertop_stack_pointer--;
      break;
    }
    case s_divi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_divi instruction */

if(((integer_t)top)==0)
  THROW(division_by_zero_exception, NULL);

top = (word_t)(((integer_t)UNDERTOP) / (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_divi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_divi_i instruction */

top = (word_t)((integer_t)top / (integer_t)PARAMETER_1);
      break;
    }
    case s_eqf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_eqf instruction */

top = (word_t)(integer_t)(word_to_float(top) == word_to_float(UNDERTOP));
undertop_stack_pointer--;
      break;
    }
    case s_eqi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_eqi instruction */

top = (word_t)(integer_t)(((integer_t)top) == (integer_t)UNDERTOP);
undertop_stack_pointer--;
      break;
    }
    case s_eqi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_eqi_i instruction */

top = (word_t)(integer_t)((integer_t)top == (integer_t)PARAMETER_1);
      break;
    }
    case s_eqs:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_eqs instruction */

const integer_t size_of_undertop = ((integer_t*)UNDERTOP)[0];
const integer_t size_of_top = ((integer_t*)top)[0];
integer_t i;

if(size_of_undertop != size_of_top)
  top = (word_t)0;
else{
  integer_t are_they_equal = 1; /* initially assume that UNDERTOP =s top */
  for(i = 1; i <= size_of_top; i++){
    if( ((integer_t*)UNDERTOP)[i] != ((integer_t*)top)[i] ){
      are_they_equal = 0; /* UNDERTOP =/=s top */
      break;
    }
    /* else do nothing: iterate again */
  }
  top = (word_t)are_they_equal;
}

/* We already put the result into top: now decrease the stack pointer: */
undertop_stack_pointer--;
      break;
    }
    case s_f_divi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_f_divi instruction */

top = (word_t)(((integer_t)UNDERTOP) / (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_f_modi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_f_modi instruction */

top = (word_t)(((integer_t)UNDERTOP) % (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_fcll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_fcll instruction. This is slightly more efficient than s_cll, but only
   works when 1 <= PARAMETER_1 <= MAXIMUM_SMALL_HOMOGENEOUS_SIZE */

word_t* closure;
word_t* new_environment;
integer_t i;

new_environment = allocate_exact((integer_t)PARAMETER_1 + 1);

closure = (word_t*)(stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 1]);

/* Copy actual parameters into the new environment: the last one
   is in the top register, the previous ones are in the stack. */
for(i = 1; i < ((integer_t)PARAMETER_1); i++)
  new_environment[i] = stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + i + 1];
new_environment[(integer_t)PARAMETER_1] = top;

/* Copy the s-link into the new environment: */
new_environment[0] = closure[1];

/* Resize the stack: */
ENLARGE_STACK(undertop_stack_pointer + instructions_no);

/* Put old_FP, old_environment and old_IP on the stack, replacing closure and
   actual parameters: */
stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 1] = (word_t)frame_pointer;
stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 2] = (word_t)environment;
top = (word_t) (NEXT_INSTRUCTION);

/* Update FP, undertop_stack_pointer, environment and IP: */
undertop_stack_pointer = undertop_stack_pointer - ((integer_t)PARAMETER_1) + 2;
frame_pointer = undertop_stack_pointer - 1;
environment = new_environment;

GOTO_GENERIC(closure[0]);
      break;
    }
    case s_filec:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_filec instruction */

char* filename;
integer_t i;
integer_t size;

/* Close the FILE* found in top. */
fclose((FILE*)top);

/* remove the pointer from the stack: */
POP;
      break;
    }
    case s_fileor:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_fileor instruction */

char* filename;
integer_t i;
integer_t size;

/* Convert top (the filename) into a C string: */
size = ((integer_t*)top)[0];
filename = (char*) xmalloc(sizeof(char) * (size + 1));
for(i = 0; i < size; i++)
     filename[i] = (char)(((integer_t*)top)[i + 1]);
filename[i] = '\0';

/* Open the file and put the FILE* into the I/O register: */
if((output_register = fopen(filename, "r")) == NULL)
  /* fopen() failed: */
  switch(errno){
  case ENOENT: {
    THROW(file_not_found_exception, NULL);
    break; /* just for uniformity */
  }
  case EACCES: case EPERM: {
    THROW(permission_denied_exception, NULL);
    break; /* just for uniformity */
  }
  default: {
    fprintf(stderr, "fopen() failed (%s)\n", strerror (errno));
    fprintf(stderr, "To do: deal with this case in s_fileor\n");
    THROW(unimplemented_exception, NULL);
  }
  } /* switch */


/* remove the filename from the stack: */
POP; 
/* Free the C filename string */
free(filename);
      break;
    }
    case s_fileow:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_fileow instruction */

char* filename;
integer_t i;
integer_t size;

/* Convert top (the filename) into a C string: */
size = ((integer_t*)top)[0];
filename = (char*) xmalloc(sizeof(char) * (size + 1));
for(i = 0; i < size; i++)
     filename[i] = (char)(((integer_t*)top)[i + 1]);
filename[i] = '\0';

/* Open the file and put the FILE* into the I/O register: */
if((output_register = fopen(filename, "w")) == NULL)
  /* fopen() failed: */
  switch(errno){
//  case ENOENT: {
//    THROW(file_not_found_exception, NULL);
//    break; /* just for uniformity */
//  }
  case EACCES: case EPERM: {
    THROW(permission_denied_exception, NULL);
    break; /* just for uniformity */
  }
  default: {
    fprintf(stderr, "fopen() failed (%s)\n", strerror (errno));
    fprintf(stderr, "To do: deal with this case in s_fileow\n");
    THROW(unimplemented_exception, NULL);
  }
  } /* switch */

/* remove the filename from the stack: */
POP; 
/* Free the C filename string */
free(filename);
      break;
    }
    case s_filerc:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_filerc instruction */

char c;

/* Read a character from the FILE* on the top and place it into
   the I/O register: */
if(fread(&c, sizeof(char), 1, (FILE*)top) != 1){
  /* an error occourred. */
  if(feof((FILE*)top)){
    THROW(end_of_stream_exception, NULL);
  }
  else{ /* To do: look at errno */
    fprintf(stderr, "s_filerc: look at errno %i\n", errno);
    THROW(unimplemented_exception, NULL);
  }
}
output_register = (word_t)(integer_t)c;

/* remove the FILE* from the stack: */
POP; 
      break;
    }
    case s_filewc:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_filewc instruction */


/* The argument (in top) is a pair <FILE*, character>: */
FILE* file_star = ((word_t*)top)[0];
char c = (char) (((integer_t*)top)[1]);

/* Write the character into the FILE* in file_star. */
if(fwrite(&c, sizeof(char), 1, (FILE*)file_star) != 1){
  /* an error occourred. */
  {/* To do: look at errno */
    fprintf(stderr, "s_filewc: look at errno %i\n", errno);
    THROW(unimplemented_exception, NULL);
  }
}

/* remove the argument from the stack: */
POP; 
      break;
    }
    case s_flin:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_flin instruction */

top = (word_t)(integer_t)(word_to_float(top));
      break;
    }
    case s_frtoba:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_fttoba instruction */

const word_t* old_array = (word_t*)UNDERUNDERTOP;
const integer_t from = (integer_t)UNDERTOP;
const integer_t to = (integer_t)top;
const integer_t new_array_size = to - from + 1;
const integer_t old_array_size = ((integer_t*)old_array)[0];
word_t* new_array;

/* Check of out-of-bounds condition: */
if((to < from) || (from <= 0) || (to > old_array_size)) // fixed a bug in 2003
  THROW(out_of_bounds_exception, NULL);

/* Allocate array: */
ASSIGN_CREATE_ARRAY(new_array, new_array_size + 1);

/* Store array size: */
new_array[0] = (word_t)new_array_size;

/* Store array content: */
memcpy(new_array + 1,
       old_array + from,
       new_array_size * sizeof(word_t));

/* Emulate pop, pop, pop, push(new_array): */
top = (word_t)new_array;
undertop_stack_pointer -= 2;
      break;
    }
    case s_fscll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_fscll instruction. This is slightly more efficient than s_scll, but only
   works when 1 <= PARAMETER_1 <= MAXIMUM_SMALL_HOMOGENEOUS_SIZE */

word_t* closure;
word_t* new_environment;
integer_t i;

new_environment = allocate_exact((integer_t)PARAMETER_1 + 1);

closure = (word_t*)(stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 1]);

/* Copy actual parameters into the new environment: the last one
   is in the top register, the previous ones are in the stack. */
for(i = 1; i < ((integer_t)PARAMETER_1); i++)
  new_environment[i] = stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + i + 1];
new_environment[(integer_t)PARAMETER_1] = top;

/* Copy the s-link into the new environment: */
new_environment[0] = closure[1];

/* This is a sibling call: there is never need to resize the stack. */

/* Overwrite the current frame. The (conceptually) new frame just contains
   old_FP, old_env and old_IP.
   old_FP, old_env and old_IP do not change. */
top = (word_t)(stack[frame_pointer + 2]);

/* FP does not change. Update undertop_stack_pointer, environment and IP: */
undertop_stack_pointer = frame_pointer + 1;
environment = new_environment;

GOTO_GENERIC(closure[0]);
      break;
    }
    case s_gl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gl instruction */

PARAMETER_1_AS_GLOBAL = top;
POP;
      break;
    }
    case s_gtef:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gtef instruction */

top = (word_t)(integer_t)(word_to_float(UNDERTOP) >= word_to_float(top));
undertop_stack_pointer--;
      break;
    }
    case s_gtei:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gtei instruction */

top = (word_t)(integer_t)(((integer_t)UNDERTOP) >= (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_gtei_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gtei_i instruction */

top = (word_t)(integer_t)((integer_t)top >= (integer_t)PARAMETER_1);
      break;
    }
    case s_gtes:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gtes instruction */

const integer_t size_of_undertop = ((integer_t*)UNDERTOP)[0];
const integer_t size_of_top = ((integer_t*)top)[0];
integer_t minimum_size;
integer_t i;

/* Set minimum_size to the minimum of the lengths: */
minimum_size = size_of_undertop;
if(size_of_top < minimum_size)
  minimum_size = size_of_top;

for(i = 1; i <= minimum_size; i++)
  if( ((integer_t*)UNDERTOP)[i] < ((integer_t*)top)[i] ){
    top = (word_t)0; /* UNDERTOP <s top */
    break;
  } else if( ((integer_t*)UNDERTOP)[i] > ((integer_t*)top)[i] ){
    top = (word_t)1; /* UNDERTOP >s top */
    break;
  }
  /* else do nothing: iterate again */

if(i > minimum_size){ /* strings are equal up to and including minimum_size. */
  if(size_of_undertop == size_of_top)
    top = (word_t)1; /* UNDERTOP =s top */
  else if(size_of_undertop < size_of_top)
    top = (word_t)0; /* UNDERTOP <s top */
  else /* size_of_undertop > size_of_top */
    top = (word_t)1; /* UNDERTOP >s top */
}

/* We already put the result into top: now decrease the stack pointer: */
undertop_stack_pointer--;
      break;
    }
    case s_gtf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gtf instruction */

top = (word_t)(integer_t)(word_to_float(UNDERTOP) > word_to_float(top));
undertop_stack_pointer--;
      break;
    }
    case s_gti:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gti instruction */

top = (word_t)(integer_t)(((integer_t)UNDERTOP) > (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_gti_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gti_i instruction */

top = (word_t)(integer_t)((integer_t)top > (integer_t)PARAMETER_1);
      break;
    }
    case s_gts:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_gts instruction */

const integer_t size_of_undertop = ((integer_t*)UNDERTOP)[0];
const integer_t size_of_top = ((integer_t*)top)[0];
integer_t minimum_size;
integer_t i;

/* Set minimum_size to the minimum of the lengths: */
minimum_size = size_of_undertop;
if(size_of_top < minimum_size)
  minimum_size = size_of_top;

for(i = 1; i <= minimum_size; i++)
  if( ((integer_t*)UNDERTOP)[i] < ((integer_t*)top)[i] ){
    top = (word_t)0; /* UNDERTOP <s top */
    break;
  } else if( ((integer_t*)UNDERTOP)[i] > ((integer_t*)top)[i] ){
    top = (word_t)1; /* UNDERTOP >s top */
    break;
  }
  /* else do nothing: iterate again */

if(i > minimum_size){ /* strings are equal up to and including minimum_size. */
  if(size_of_undertop == size_of_top)
    top = (word_t)0; /* UNDERTOP =s top */
  else if(size_of_undertop < size_of_top)
    top = (word_t)0; /* UNDERTOP <s top */
  else /* size_of_undertop > size_of_top */
    top = (word_t)1; /* UNDERTOP >s top */
}

/* We already put the result into top: now decrease the stack pointer: */
undertop_stack_pointer--;
      break;
    }
    case s_infl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_infl instruction */

top = float_to_word((float_t)((integer_t)top));
      break;
    }
    case s_jandi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jandi instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) && (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jeqi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jeqi instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) == (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jeqi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jeqi_i instruction */

integer_t condition;

/* Compute condition, pop the only argument and jump if condition is
   true: */
condition = ((integer_t)top == (integer_t)PARAMETER_1);
POP;
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jgtei:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jgtei instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) >= (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jgtei_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jgtei_i instruction */

integer_t condition;

/* Compute condition, pop the only argument and jump if condition is
   true: */
condition = ((integer_t)top >= (integer_t)PARAMETER_1);
POP;
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jgti:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jgti instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) > (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jgti_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jgti_i instruction */

integer_t condition;

/* Compute condition, pop the only argument and jump if condition is
   true: */
condition = ((integer_t)top > (integer_t)PARAMETER_1);
POP;
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jltei:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jltei instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) <= (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jltei_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jltei_i instruction */

integer_t condition;

/* Compute condition, pop the only argument and jump if condition is
   true: */
condition = ((integer_t)top <= (integer_t)PARAMETER_1);
POP;
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jlti:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jlti instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) < (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jlti_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jlti_i instruction */

integer_t condition;

/* Compute condition, pop the only argument and jump if condition is
   true: */
condition = ((integer_t)top < (integer_t)PARAMETER_1);
POP;
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jnandi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jnandi instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(! (((integer_t)UNDERTOP) && (integer_t)top));

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jneqi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jneqi instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) != (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jneqi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jneqi_i instruction */

integer_t condition;

/* Compute condition, pop the only argument and jump if condition is
   true: */
condition = ((integer_t)top != (integer_t)PARAMETER_1);
POP;
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jnm:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jnm instruction */

/* This instruction is used in the compilation of pattern-matching.
   s_jnm X L: is equivalent to 
        cpy             # keep a copy for the next case
        s_lkp_i 0       # look at the constructor;
        pshci   x       # does it match with the x-th case?
        s_eqi
        s_jz    L:
   Note that this instruction is not destructive (it does not pop its stack
   argument) */

if(((word_t*)top)[0] != PARAMETER_1)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jnori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jnori instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(! (((integer_t)UNDERTOP) || (integer_t)top));

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jnxori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jnxori instruction */

/* Compute condition: */
integer_t condition;
if(top){ /* a == true */
  if(UNDERTOP) /* b == true */
    condition = (integer_t)1;
  else /* b == false */
    condition = (integer_t)0;
}
else{ /* a == false */
  if(UNDERTOP) /* b == true */
    condition = (integer_t)0;
  else /* b == false */
    condition = (integer_t)1;
}

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jnz:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jnz instruction */

integer_t x = (integer_t)top;

POP;
if(x != 0)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jori instruction */

/* Compute condition: */
integer_t condition =
  (integer_t)(((integer_t)UNDERTOP) || (integer_t)top);

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jxori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jxori instruction */

/* Compute condition: */
integer_t condition;
if(top){ /* a == true */
  if(UNDERTOP) /* b == true */
    condition = (integer_t)0;
  else /* b == false */
    condition = (integer_t)1;
}
else{ /* a == false */
  if(UNDERTOP) /* b == true */
    condition = (integer_t)1;
  else /* b == false */
    condition = (integer_t)0;
}

/* Remove the operands from the stack: */
POP_MULTIPLE(2);

/* Jump if the condition is true: */
if(condition)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_jz:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_jz instruction */

integer_t x = (integer_t)top;

POP;
if(x == 0)
  GOTO_IMMEDIATE(LABEL_PARAMETER);
      break;
    }
    case s_lcl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lcl instruction */

PUSH_OBJECT(environment[(integer_t)PARAMETER_1]);
      break;
    }
    case s_lkp:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lkp instruction */

top = ((word_t*)UNDERTOP) [(integer_t)top];
undertop_stack_pointer--;
      break;
    }
    case s_lkp_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lkp_i instruction */

top = ((word_t*)top) [(integer_t)PARAMETER_1];
      break;
    }
    case s_lkpb:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lkpb instruction */

/* Test out-of-bounds condition: */
if (((integer_t)top <= 0) || ((integer_t)top > (((integer_t*)UNDERTOP)[0])))
  THROW(out_of_bounds_exception, NULL);

/* Ok, everything is ok. */

top = ((word_t*)UNDERTOP) [(integer_t)top];
undertop_stack_pointer--;
      break;
    }
    case s_ltbar:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ltbar instruction */

top = list_to_epsilon_array(top);
      break;
    }
    case s_ltef:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ltef instruction */

top = (word_t)(integer_t)(word_to_float(UNDERTOP) <= word_to_float(top));
undertop_stack_pointer--;
      break;
    }
    case s_ltei:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ltei instruction */

top = (word_t)(integer_t)(((integer_t)UNDERTOP) <= (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_ltei_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ltei_i instruction */

top = (word_t)(integer_t)((integer_t)top <= (integer_t)PARAMETER_1);
      break;
    }
    case s_ltes:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ltes instruction */

const integer_t size_of_undertop = ((integer_t*)UNDERTOP)[0];
const integer_t size_of_top = ((integer_t*)top)[0];
integer_t minimum_size;
integer_t i;

/* Set minimum_size to the minimum of the lengths: */
minimum_size = size_of_undertop;
if(size_of_top < minimum_size)
  minimum_size = size_of_top;

for(i = 1; i <= minimum_size; i++)
  if( ((integer_t*)UNDERTOP)[i] < ((integer_t*)top)[i] ){
    top = (word_t)1; /* UNDERTOP <s top */
    break;
  } else if( ((integer_t*)UNDERTOP)[i] > ((integer_t*)top)[i] ){
    top = (word_t)0; /* UNDERTOP >s top */
    break;
  }
  /* else do nothing: iterate again */

if(i > minimum_size){ /* strings are equal up to and including minimum_size. */
  if(size_of_undertop == size_of_top)
    top = (word_t)1; /* UNDERTOP =s top */
  else if(size_of_undertop < size_of_top)
    top = (word_t)1; /* UNDERTOP <s top */
  else /* size_of_undertop > size_of_top */
    top = (word_t)0; /* UNDERTOP >s top */
}

/* We already put the result into top: now decrease the stack pointer: */
undertop_stack_pointer--;
      break;
    }
    case s_ltf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ltf instruction */

top = (word_t)(integer_t)(word_to_float(UNDERTOP) < word_to_float(top));
undertop_stack_pointer--;
      break;
    }
    case s_lti:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lti instruction */

top = (word_t)(integer_t)(((integer_t)UNDERTOP) < (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_lti_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lti_i instruction */

top = (word_t)(integer_t)((integer_t)top < (integer_t)PARAMETER_1);
      break;
    }
    case s_lts:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_lts instruction */

const integer_t size_of_undertop = ((integer_t*)UNDERTOP)[0];
const integer_t size_of_top = ((integer_t*)top)[0];
integer_t minimum_size;
integer_t i;

/* Set minimum_size to the minimum of the lengths: */
minimum_size = size_of_undertop;
if(size_of_top < minimum_size)
  minimum_size = size_of_top;

for(i = 1; i <= minimum_size; i++)
  if( ((integer_t*)UNDERTOP)[i] < ((integer_t*)top)[i] ){
    top = (word_t)1; /* UNDERTOP <s top */
    break;
  } else if( ((integer_t*)UNDERTOP)[i] > ((integer_t*)top)[i] ){
    top = (word_t)0; /* UNDERTOP >s top */
    break;
  }
  /* else do nothing: iterate again */

if(i > minimum_size){ /* strings are equal up to and including minimum_size. */
  if(size_of_undertop == size_of_top)
    top = (word_t)0; /* UNDERTOP =s top */
  else if(size_of_undertop < size_of_top)
    top = (word_t)1; /* UNDERTOP <s top */
  else /* size_of_undertop > size_of_top */
    top = (word_t)0; /* UNDERTOP >s top */
}

/* We already put the result into top: now decrease the stack pointer: */
undertop_stack_pointer--;
      break;
    }
    case s_mka_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_mka_i instruction */

/* Allocate array: */
word_t* array;
ASSIGN_CREATE_ARRAY(array, (integer_t)PARAMETER_1);

if((integer_t)PARAMETER_1 == 1){
  /* One-element array: no need to look at the stack */
  array[0] = top;
  top = (word_t) array;
}
else{
  /* The array will have more than one element */
  integer_t i;

  /* Copy the element from top: */
  array[(integer_t)PARAMETER_1 - 1] = top;

  /* Copy all elements from stack: */
  for(i = (integer_t)PARAMETER_1 - 2; i >= 0; i--)
    array[i] = stack[undertop_stack_pointer - (integer_t)PARAMETER_1 + 2 + i];

  /* Set top to the array and remove the other elements from the stack: */
  top = (word_t) array;
  undertop_stack_pointer -= ((integer_t)PARAMETER_1 - 1);
}
      break;
    }
    case s_mkba_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_mkba_i instruction */

word_t* array;

/* Allocate array: */
ASSIGN_CREATE_ARRAY(array, (integer_t)PARAMETER_1 + 1);

array[0] = PARAMETER_1; /* Store length in the first element */

/* Store the other elements, if they exist: */
if((integer_t)PARAMETER_1 == 0){
  /* Pop nothing, push the newly-created array: */
  PUSH_OBJECT(array);
}
else if((integer_t)PARAMETER_1 == 1){
  /* One-element array: no need to look at the stack */
  array[1] = top;
  top = (word_t) array;
}
else{
  /* The array will have more than one element */
  integer_t i;
  
  /* Copy the element from top: */
  array[(integer_t)PARAMETER_1] = top;
  
  /* Copy all elements from stack: */
  for(i = 1; i <= (integer_t)PARAMETER_1 - 1; i++)
    array[i] = stack[undertop_stack_pointer + i - (integer_t)PARAMETER_1 + 1];
  
  /* Set top to the array and remove the other elements from the stack: */
  top = (word_t) array;
  undertop_stack_pointer -= ((integer_t)PARAMETER_1 - 1);
}
      break;
    }
    case s_modi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_modi instruction */

if(((integer_t)top)==0)
  THROW(division_by_zero_exception, NULL);

top = (word_t)(((integer_t)UNDERTOP) % (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_modi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_modi_i instruction */

top = (word_t)((integer_t)top % (integer_t)PARAMETER_1);
      break;
    }
    case s_mulf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_addf instruction */

top = float_to_word(word_to_float(top) * word_to_float(UNDERTOP));
undertop_stack_pointer--;
      break;
    }
    case s_muli:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_muli instruction */

top = (word_t)(((integer_t)UNDERTOP) * (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_muli_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_muli_i instruction */

top = (word_t)((integer_t)top * (integer_t)PARAMETER_1);
      break;
    }
    case s_neqi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_neqi instruction */

top = (word_t)(integer_t)(((integer_t)top) != (integer_t)UNDERTOP);
undertop_stack_pointer--;
      break;
    }
    case s_neqi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_neqi_i instruction */

top = (word_t)(integer_t)((integer_t)top != (integer_t)PARAMETER_1);
      break;
    }
    case s_neqs:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_neqs instruction */

const integer_t size_of_undertop = ((integer_t*)UNDERTOP)[0];
const integer_t size_of_top = ((integer_t*)top)[0];
integer_t i;

if(size_of_undertop != size_of_top)
  top = (word_t)1;
else{
  integer_t are_they_different = 0; /* initially assume that UNDERTOP =s top */
  for(i = 1; i <= size_of_top; i++){
    if( ((integer_t*)UNDERTOP)[i] != ((integer_t*)top)[i] ){
      are_they_different = 1; /* UNDERTOP =/=s top */
      break;
    }
    /* else do nothing: iterate again */
  }
  top = (word_t)are_they_different;
}

/* We already put the result into top: now decrease the stack pointer: */
undertop_stack_pointer--;
      break;
    }
    case s_nlcl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_nlcl instruction */

integer_t i;
word_t* temporary_environment = environment;

/* Search for the right environment where to find the object (the distance
   is of PARAMETER_1 steps on the static chain: */
for(i = 0; i < (integer_t)PARAMETER_1; i++)
  temporary_environment = (word_t*)(temporary_environment[0]);

/* Push the object into the stack; it's the PARAMETER_2-th one: */
PUSH_OBJECT(temporary_environment[(integer_t)PARAMETER_2]);
      break;
    }
    case s_nll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_nll instruction */

top = (word_t)(integer_t)(top == NULL);
      break;
    }
    case s_nnll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_nnll instruction */

top = (word_t)(integer_t)(top != NULL);
      break;
    }
    case s_noti:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_noti instruction */

top = (word_t)(integer_t)!(integer_t)top;
      break;
    }
    case s_nxori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_nxori instruction */

if(top){ /* a == true */
  if(UNDERTOP) /* b == true */
    top = (word_t)1;
  else /* b == false */
    top = (word_t)0;
}
else{ /* a == false */
  if(UNDERTOP) /* b == true */
    top = (word_t)0;
  else /* b == false */
    top = (word_t)1;
}

undertop_stack_pointer --;
      break;
    }
    case s_ori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_andi instruction */

top = (word_t)(integer_t)(((integer_t)UNDERTOP) || ((integer_t)top));
undertop_stack_pointer --;
      break;
    }
    case s_outc:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_outc instruction */

putchar((int)(integer_t)top);
POP;
      break;
    }
    case s_outec:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_outec instruction */

/* Write the first \': */
putchar((int)'\'');

switch((integer_t) top){
  case '\n': { putchar((int)'\\'); putchar((int)'n'); break; }
  case '\t': { putchar((int)'\\'); putchar((int)'t'); break; }
  case '\"': { putchar((int)'\\'); putchar((int)'\"'); break; }
  case '\a': { putchar((int)'\\'); putchar((int)'a'); break; }
  default:   { putchar((int)(integer_t)top); break; }
} /* switch */

/* Write the trailing \': */
putchar((int)'\'');

/* Pop the argument: */
POP;
      break;
    }
    case s_outes:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_outes instruction */

integer_t i;

/* Write the first \": */
putchar((int)'\"');

/* Write every character: */
for(i = 1; i <= ((integer_t*)top)[0]; i++)
  switch((int) (((integer_t*)top)[i])){
  case '\n': { putchar((int)'\\'); putchar((int)'n'); break; }
  case '\t': { putchar((int)'\\'); putchar((int)'t'); break; }
  case '\"': { putchar((int)'\\'); putchar((int)'\"'); break; }
  case '\a': { putchar((int)'\\'); putchar((int)'a'); break; }
  default:   { putchar((int) (((integer_t*)top)[i])); break; }
  } /* switch */

/* Write the trailing \": */
putchar((int)'\"');

/* Pop argument: */
POP;
      break;
    }
    case s_outf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_outf instruction */

printf(FLOAT_T_FORMAT, word_to_float(top));
POP;
      break;
    }
    case s_outi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_outi instruction */

printf(INTEGER_T_FORMAT,(integer_t)top);
POP;
      break;
    }
    case s_outs:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_outs instruction */

integer_t i;

/* Write every character: */
for(i = 1; i <= ((integer_t*)top)[0]; i++)
  putchar((int) (((integer_t*)top)[i]));
//  printf(">>>%c<<<\n", (int)(((integer_t*)top)[i]));
POP;
      break;
    }
    case s_popl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_popl instruction: */

/* Remove the let bindings, by making the first environment we find thru the
   static chain the current one: */
environment = (word_t*)(environment[0]);
      break;
    }
    case s_powf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_powf instruction */

top = float_to_word(powf(word_to_float(UNDERTOP), word_to_float(top)));
undertop_stack_pointer--;
      break;
    }
    case s_powi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_powi instruction */

integer_t i, result = 1;

for(i = 0; i < (integer_t)top; i++)
  result *= (integer_t)UNDERTOP;
top = (word_t)result;
undertop_stack_pointer--;
      break;
    }
    case s_powi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_powi_i instruction */

/* Compute the power: */
integer_t i, result = 1;
for(i = 0; i < (integer_t)PARAMETER_1; i++)
  result *= (integer_t)top;

/* Assign it to top: */
top = (word_t)result;
      break;
    }
    case s_pshf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu
Copyright (C) 2003 Matteo Golfarini

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_pshf instruction */
word_t* new_environment;
integer_t i;

/* Allocate new environment:*/
ASSIGN_MY_MALLOC(new_environment, ((integer_t)PARAMETER_1) + 1);

/* Create the s-link: */
new_environment[0] = environment;

/* Fill with non-top operands: */
for(i = 0; i < (integer_t)PARAMETER_1 - 1; i++)
  new_environment[i + 1] = stack[undertop_stack_pointer + i - (integer_t)PARAMETER_1 + 2];

/* Fill with top operand, if top is an operand; else copy top to the stack,
   so that we don't lose it: */
if((integer_t)PARAMETER_1 != (integer_t)0)
  new_environment[(integer_t)PARAMETER_1] = top;
else
  stack[undertop_stack_pointer + 1] = top;

/* Enlarge stack if needed:
                (2003-07-29, positron: this is *never* needed) */
/*
int stack_size1 = stack_size;
ENLARGE_STACK(undertop_stack_pointer + instructions_no);
if(stack_size != stack_size1){
  fprintf(stderr, "--------------------------------------------------------\n");
  fprintf(stderr, "SP is       %i\n", undertop_stack_pointer + 1);
  fprintf(stderr, "old size is %i\n", stack_size1 + 1);
  fprintf(stderr, "new size is %i\n", stack_size + 1);
  fprintf(stderr, "s_pshf: We seem to really need ENLARGE_STACK() in s_pshf\n");
  fprintf(stderr, "--------------------------------------------------------\n");
}
*/

/* Delete all operands, and replace them with old_env and old_FP: */
undertop_stack_pointer -= ((integer_t)PARAMETER_1 - 2);
stack[undertop_stack_pointer] = environment;
top = (word_t)frame_pointer;

/* Update env and FP: */
environment = new_environment;
frame_pointer = undertop_stack_pointer;
      break;
    }
    case s_pshl:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_pshl instruction: */

integer_t i;
word_t* new_environment;

/* Create a new environment s-linked to the current one: */
ASSIGN_MY_MALLOC(new_environment, ((integer_t)PARAMETER_1) + 1);
new_environment[0] = environment;

/* If PARAMETER_1 is not 0 then 
     * fill the new environment with the topmost
       PARAMETER_1 stack elements (including top)
     * update top and undertop_stack_pointer popping stack arguments
   else 
     do nothing: */
if((integer_t)PARAMETER_1 > (integer_t)0){
  word_t* stack_element =
    &(stack[undertop_stack_pointer - (integer_t)PARAMETER_1 + (integer_t)2]);

  for(i = 1; i < (integer_t)PARAMETER_1; i++)
    new_environment[i] = *(stack_element++);
  new_environment[(integer_t)PARAMETER_1] = top;

  undertop_stack_pointer -= (integer_t)PARAMETER_1;
  top = stack[undertop_stack_pointer + (integer_t)1];
}

/* Make the new environment the current one: */
environment = new_environment;
      break;
    }
    case s_ret:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_ret instruction */

/* The value to be returned is already in the top register. We just need
   to update undertop_stack_pointer, frame_pointer, environment and
   instruction_pointer */

/* Take saved status from the stack: */
integer_t saved_frame_pointer = (integer_t)(stack[frame_pointer]);
word_t* saved_environment = (word_t*)(stack[frame_pointer + 1]);
void* saved_instruction_pointer = (void*)(stack[frame_pointer + 2]);

/* Update status: */
environment = saved_environment;
undertop_stack_pointer = frame_pointer - 1;
frame_pointer = saved_frame_pointer;

GOTO_GENERIC(saved_instruction_pointer);
      break;
    }
    case s_retn:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_retn instruction */

/* Take saved status from the stack: */
integer_t saved_frame_pointer = (integer_t)(stack[frame_pointer]);
word_t* saved_environment = (word_t*)(stack[frame_pointer + 1]);
void* saved_instruction_pointer;

/* saved_instruction_pointer can be either in top of in stack[FP + 2]: */
if(undertop_stack_pointer == frame_pointer + 1)
  saved_instruction_pointer = top;
else
  saved_instruction_pointer = (void*)(stack[frame_pointer + 2]);

/* Update status: */
environment = saved_environment;
undertop_stack_pointer = frame_pointer - 2;//- 1;// - 2
top = stack[undertop_stack_pointer + 1];
frame_pointer = saved_frame_pointer;

GOTO_GENERIC(saved_instruction_pointer);
      break;
    }
    case s_scll:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_scll instruction */

word_t* closure;
word_t* new_environment;
integer_t i;

ASSIGN_MY_MALLOC(new_environment, ((integer_t)PARAMETER_1) + 1);

if(((integer_t)PARAMETER_1) == 0){
  closure = (word_t*)top;
  /* There are no actual parameters */
}
else{
  closure = (word_t*)(stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + 1]);

  /* Copy actual parameters into the new environment: the last one
     is in the top register, the previous ones are in the stack. */
  for(i = 1; i < ((integer_t)PARAMETER_1); i++)
    new_environment[i] = stack[undertop_stack_pointer - ((integer_t)PARAMETER_1) + i + 1];
  new_environment[(integer_t)PARAMETER_1] = top;
}

/* Copy the s-link into the new environment: */
new_environment[0] = closure[1];

/* This is a sibling call: there is never need to resize the stack. */

/* Overwrite the current frame. The (conceptually) new frame just contains
   old_FP, old_env and old_IP.
   old_FP, old_env and old_IP do not change. */
top = (word_t)(stack[frame_pointer + 2]);

/* FP does not change. Update undertop_stack_pointer, environment and IP: */
undertop_stack_pointer = frame_pointer + 1;
environment = new_environment;

GOTO_GENERIC(closure[0]);
      break;
    }
    case s_seto:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_seto instruction */

output_register = top;
POP;
      break;
    }
    case s_subf:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_addf instruction */

top = float_to_word(word_to_float(UNDERTOP) - word_to_float(top));
undertop_stack_pointer--;
      break;
    }
    case s_subi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_subi instruction */

top = (word_t)(((integer_t)UNDERTOP) - (integer_t)top);
undertop_stack_pointer--;
      break;
    }
    case s_subi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_subi_i instruction */

top = (word_t)((integer_t)top - (integer_t)PARAMETER_1);
      break;
    }
    case s_swp:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_swp instruction */

word_t temp = top;

top = UNDERTOP;
stack[undertop_stack_pointer] = temp;
      break;
    }
    case s_thrw:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_thrw instruction */

THROW(PARAMETER_1, top);
      break;
    }
    case s_umini:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_umini instruction */

top = (word_t) (-((integer_t)top));
      break;
    }
    case s_xori:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the s_xori instruction */

if(top){ /* a == true */
  if(UNDERTOP) /* b == true */
    top = (word_t)0;
  else /* b == false */
    top = (word_t)1;
}
else{ /* a == false */
  if(UNDERTOP) /* b == true */
    top = (word_t)1;
  else /* b == false */
    top = (word_t)0;
}

undertop_stack_pointer --;
      break;
    }
    case setfp:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the setfp instruction */

/* Move the string from parameter1 into failure_point_register: */
failure_point_register = PARAMETER_1_AS_STRING;
      break;
    }
    case subi:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the subi instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER -
                                   (integer_t)PARAMETER_3_AS_REGISTER);
      break;
    }
    case subi_i:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the subi_i instruction */

PARAMETER_1_AS_REGISTER = (word_t) ((integer_t)PARAMETER_2_AS_REGISTER -
                                   (integer_t)PARAMETER_3);
      break;
    }
    case swp:{
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


/* Code for the swp instruction */

register word_t temp;

temp = PARAMETER_1_AS_REGISTER;
PARAMETER_1_AS_REGISTER = PARAMETER_2_AS_REGISTER;
PARAMETER_2_AS_REGISTER = temp;
      break;
    }
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


//evm_c.tail
    } /* switch */
    /* Go to the next instruction (this is not reached in case of jumps, since 
       their macro-expansion contains a "continue"): */
    instruction_pointer++;

out_of_switch: /* We skip the increment of instruction_pointer */

#ifdef EAM_PROFILE
    //To do: use struct timespec (see /usr/include/time.h, probably clock_gettime())
    //           CLOCK_REALTIME is an always defined clock_id object
    /* End measuring the time for the current instruction; this includes
       dispatching time: */
    clock_gettime(CLOCK_REALTIME, &instruction_end_time);
//instruction_end_time = clock();
    timespec_subtract(&instruction_cost,
                      &instruction_end_time,
                      &instruction_begin_time);
    /* Update arrays used for profiling: */
    instructions_uses_no[current_opcode]++;
    if(instruction_cost.tv_sec > 0){
      fprintf(stderr, "%s took more than 1 second.\n", instructions_names[current_opcode]);
      instructions_costs[current_opcode] +=
        (wide_wide_float_t)(instruction_cost.tv_sec * 1000000);
    }
    instructions_costs[current_opcode] +=
      (wide_wide_float_t)(instruction_cost.tv_nsec / 1000);
#endif /* #ifdef EAM_PROFILE */

  } while(1); /* main loop */
} /* evm_loop() */
