/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include "heap.h"
#include "gc.h"

/* The total number of allocated words, in all pages, since the last GC: */
integer_t allocated_words_since_last_gc = 0; /* declared in heap.h */

integer_t total_heap_size = 0; /* in words */

integer_t should_we_garbage_collect(){
  /* Synchronization is not stricly needed, and here speed is important. The
     information we get is not 100% accurate, but we can live with it. 
     Note that we *read* allocated_words_since_last_gc, but we don't
     update it. */
  return allocated_words_since_last_gc > GC_THRESHOLD / sizeof(word_t);
}

/* Only useful for debug */
void output_pointer_as_bitmap(word_t p){
  unsigned_integer_t p_as_integer = (unsigned_integer_t)p;
  integer_t i;

  for(i = CHAR_BIT * sizeof(word_t) - 1; i >= 0; i--){
    if(i == PAGE_OFFSET_WIDTH){
      if(p_as_integer & (1 << i))
        printf("u");
      else
        printf("z");
      continue;
    }
    if(p_as_integer & (1 << i))
      printf("1");
    else
      printf("0");
  }
}
