/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#ifndef HEAP_H_
#define HEAP_H_

#include <limits.h>

#include "../eam_types.h"


#define WORD_BIT (CHAR_BIT * sizeof(word_t))

#define PAGE_OFFSET_WIDTH 17//17//18 /* in bits */

/* The total number of allocated words, in all pages, since the last GC: */
extern integer_t allocated_words_since_last_gc; /* defined in heap.c */
extern integer_t total_heap_size; /* in words; defined in heap.c */

/* Call the heuristic telling whether a GC is needed */
integer_t should_we_garbage_collect();

/* Only useful for debug */
void output_pointer_as_bitmap(word_t p);

#endif /* #ifndef HEAP_H_ */
