/* This file is automatically generated. Do not edit. */
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "eam.h"
#include "output_c.h"

#include "eam_types.h"
#include "instructions.h"

void output_scheme(FILE *output_stream){
  int i;
  int instruction_pointer;
  
  /* Generate Scheme code for including the definition of instructions: */
  fprintf(output_stream, ";;; Load Definition of eAM instructions:\n");
  fprintf(output_stream, "(if (not (defined? 'eam-in-scheme-has-been-defined))\n");
  fprintf(output_stream, "  (load \"eam.scm\"))\n\n\n");

  /* Generate Scheme code for eAM registers: */
  fprintf(output_stream,";;; eAM general registers\n");
  fprintf(output_stream,"(define word-registers-number %i)\n",
    executable->word_registers_no);
  fprintf(output_stream,
	  "(define word-registers\n  (make-vector word-registers-number))\n\n");

  fprintf(output_stream,";;; eAM wide integer registers:\n");
  fprintf(output_stream,"(define wide-integer-registers-number %i)\n",
    executable->wide_integer_registers_no);
  fprintf(output_stream,
	  "(define wide-integer-registers\n  (make-vector wide-integer-registers-number))\n\n");

  fprintf(output_stream,";;; eAM float registers:\n");
  fprintf(output_stream,"(define float-registers-number %i)\n",
    executable->float_registers_no);
  fprintf(output_stream,
	  "(define float-registers\n  (make-vector float-registers-number))\n\n");

  fprintf(output_stream,";;; eAM wide float registers:\n");
  fprintf(output_stream,"(define wide-float-registers-number %i)\n",
    executable->wide_float_registers_no);
  fprintf(output_stream,
	  "(define wide-float-registers\n  (make-vector wide-float-registers-number))\n\n");

  fprintf(output_stream,";;; eAM wide wide float registers:\n");
  fprintf(output_stream,"(define wide-wide-float-registers-number %i)\n",
    executable->wide_wide_float_registers_no);
  fprintf(output_stream,
	  "(define wide-wide-float-registers\n  (make-vector wide-wide-float-registers-number))\n\n");

  fprintf(output_stream,"\n");

  /* Generate Scheme code for globals: */
  fprintf(output_stream, ";;; eAM globals array:\n");
  fprintf(output_stream, "(define globals (make-vector %i 'undefined-global))\n\n\n",
	  executable->globals_no);

  /* Generate Scheme code for eAM runtime support structures: */
  fprintf(output_stream,";;; eAM runtime support structures:\n");
  fprintf(output_stream,"(define instructions-number %i)\n",
    executable->instructions_no);
  fprintf(output_stream,"(define stack-size (+ %i 10))\n",executable->instructions_no);
  fprintf(output_stream,"(define stack\n  (make-vector stack-size))\n");
  fprintf(output_stream,"(define exceptions-stack '())\n");
  fprintf(output_stream,"(define exception-type 'nothing)\n");
  fprintf(output_stream,"(define exception-value 'nothing)\n\n\n");

  /* Generate Scheme code initializing the stack with the first frame. */
  /* Set FP and environment: */
  fprintf(output_stream,";;; Initialize the stack with the initial frame, set FP and env:\n");
  fprintf(output_stream,"(define frame-pointer 0)\n");
  fprintf(output_stream,"(define environment 'initial-empty-environment)\n");
  fprintf(output_stream,"(vector-set! stack 0 'initial-void-saved-environment)\n");
  fprintf(output_stream,"(vector-set! stack 1 'initial-void-saved-frame-pointer)\n");
  fprintf(output_stream,"(define stack-pointer 1)\n\n\n");

  fprintf(output_stream,";;; Set the return code to success, by default:\n");
  fprintf(output_stream,"(define return-code 0)\n\n\n");

  /* Generate Scheme code for the eAM program: */
  fprintf(output_stream,";;; The eAM program:\n");
  fprintf(output_stream,"(define instructions\n");
  fprintf(output_stream,"  '#(\n");
  for(instruction_pointer = 0;
      instruction_pointer < executable->instructions_no;
      instruction_pointer++){
    
    switch(executable->instructions[instruction_pointer].opcode){
    /* These first cases are special in the sense that they are defined in
       output_scheme_c.head: */
    case nln:{
      /* Execute the Scheme code held in the second string parameter: */
      integer_t string_index = (integer_t)(executable->instructions[instruction_pointer].parameter_2);
      int string_length = strlen(executable->string_constants[string_index]);

      /* Overwrite the trailing double quote (The first one will be simply skipped): */
      executable->string_constants[string_index][string_length - 1] = '\0';

      fprintf(output_stream,
	      "     (let ((instruction-pointer %i))\n       %s\n       %i) ; instr. %i\n",
	      instruction_pointer,
	      executable->string_constants[string_index] + 1,
	      instruction_pointer + 1,
	      instruction_pointer);
      break;
    }
      
    /* Here come the "normal" instructions */

/* Instructions of category exception: */
case s_thrw:{
  fprintf(output_stream, "     (s_thrw %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category exception_label: */
case jde:{
  fprintf(output_stream, "     (jde %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category float: */
case pshcf:{
  fprintf(output_stream, "     (pshcf %i ", instruction_pointer);
  fprintf(output_stream, FLOAT_T_FORMAT " ", executable->instructions[instruction_pointer].float_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category global: */
case pshgl:{
  fprintf(output_stream, "     (pshgl %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gl:{
  fprintf(output_stream, "     (s_gl %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category integer: */
case hlt:{
  fprintf(output_stream, "     (hlt %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case popm:{
  fprintf(output_stream, "     (popm %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case pshci:{
  fprintf(output_stream, "     (pshci %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_addi_i:{
  fprintf(output_stream, "     (s_addi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cll:{
  fprintf(output_stream, "     (s_cll %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_divi_i:{
  fprintf(output_stream, "     (s_divi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_eqi_i:{
  fprintf(output_stream, "     (s_eqi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_fcll:{
  fprintf(output_stream, "     (s_fcll %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_fscll:{
  fprintf(output_stream, "     (s_fscll %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gtei_i:{
  fprintf(output_stream, "     (s_gtei_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gti_i:{
  fprintf(output_stream, "     (s_gti_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lcl:{
  fprintf(output_stream, "     (s_lcl %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lkp_i:{
  fprintf(output_stream, "     (s_lkp_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ltei_i:{
  fprintf(output_stream, "     (s_ltei_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lti_i:{
  fprintf(output_stream, "     (s_lti_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_mka_i:{
  fprintf(output_stream, "     (s_mka_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_mkba_i:{
  fprintf(output_stream, "     (s_mkba_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_modi_i:{
  fprintf(output_stream, "     (s_modi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_muli_i:{
  fprintf(output_stream, "     (s_muli_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_neqi_i:{
  fprintf(output_stream, "     (s_neqi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_powi_i:{
  fprintf(output_stream, "     (s_powi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_pshf:{
  fprintf(output_stream, "     (s_pshf %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_pshl:{
  fprintf(output_stream, "     (s_pshl %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_scll:{
  fprintf(output_stream, "     (s_scll %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_subi_i:{
  fprintf(output_stream, "     (s_subi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category integer_integer: */
case s_nlcl:{
  fprintf(output_stream, "     (s_nlcl %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category integer_label: */
case s_jeqi_i:{
  fprintf(output_stream, "     (s_jeqi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jgtei_i:{
  fprintf(output_stream, "     (s_jgtei_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jgti_i:{
  fprintf(output_stream, "     (s_jgti_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jltei_i:{
  fprintf(output_stream, "     (s_jltei_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jlti_i:{
  fprintf(output_stream, "     (s_jlti_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jneqi_i:{
  fprintf(output_stream, "     (s_jneqi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jnm:{
  fprintf(output_stream, "     (s_jnm %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", (integer_t)(executable->instructions[instruction_pointer].parameter_1));
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category label: */
case j:{
  fprintf(output_stream, "     (j %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case pshtry:{
  fprintf(output_stream, "     (pshtry %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cls:{
  fprintf(output_stream, "     (s_cls %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_clsr:{
  fprintf(output_stream, "     (s_clsr %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jandi:{
  fprintf(output_stream, "     (s_jandi %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jeqi:{
  fprintf(output_stream, "     (s_jeqi %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jgtei:{
  fprintf(output_stream, "     (s_jgtei %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jgti:{
  fprintf(output_stream, "     (s_jgti %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jltei:{
  fprintf(output_stream, "     (s_jltei %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jlti:{
  fprintf(output_stream, "     (s_jlti %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jnandi:{
  fprintf(output_stream, "     (s_jnandi %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jneqi:{
  fprintf(output_stream, "     (s_jneqi %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jnori:{
  fprintf(output_stream, "     (s_jnori %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jnxori:{
  fprintf(output_stream, "     (s_jnxori %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jnz:{
  fprintf(output_stream, "     (s_jnz %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jori:{
  fprintf(output_stream, "     (s_jori %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jxori:{
  fprintf(output_stream, "     (s_jxori %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_jz:{
  fprintf(output_stream, "     (s_jz %i ", instruction_pointer);
  fprintf(output_stream, "%i", executable->instructions[instruction_pointer].label_parameter);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category nullary: */
case clargs:{
  fprintf(output_stream, "     (clargs %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case cpy:{
  fprintf(output_stream, "     (cpy %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case dfhn:{
  fprintf(output_stream, "     (dfhn %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case gcin:{
  fprintf(output_stream, "     (gcin %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case inc:{
  fprintf(output_stream, "     (inc %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case ini:{
  fprintf(output_stream, "     (ini %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case ins:{
  fprintf(output_stream, "     (ins %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case lbl:{
  fprintf(output_stream, "     (lbl %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case nop:{
  fprintf(output_stream, "     (nop %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case pop:{
  fprintf(output_stream, "     (pop %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case popf:{
  fprintf(output_stream, "     (popf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case popfn:{
  fprintf(output_stream, "     (popfn %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case poptry:{
  fprintf(output_stream, "     (poptry %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case pshnll:{
  fprintf(output_stream, "     (pshnll %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case psho:{
  fprintf(output_stream, "     (psho %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case rthrw:{
  fprintf(output_stream, "     (rthrw %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_addf:{
  fprintf(output_stream, "     (s_addf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_addi:{
  fprintf(output_stream, "     (s_addi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_andi:{
  fprintf(output_stream, "     (s_andi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_barlt:{
  fprintf(output_stream, "     (s_barlt %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_car:{
  fprintf(output_stream, "     (s_car %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cctba:{
  fprintf(output_stream, "     (s_cctba %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cdr:{
  fprintf(output_stream, "     (s_cdr %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_chst:{
  fprintf(output_stream, "     (s_chst %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cns:{
  fprintf(output_stream, "     (s_cns %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_divf:{
  fprintf(output_stream, "     (s_divf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_divi:{
  fprintf(output_stream, "     (s_divi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_eqf:{
  fprintf(output_stream, "     (s_eqf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_eqi:{
  fprintf(output_stream, "     (s_eqi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_eqs:{
  fprintf(output_stream, "     (s_eqs %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_f_divi:{
  fprintf(output_stream, "     (s_f_divi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_f_modi:{
  fprintf(output_stream, "     (s_f_modi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_filec:{
  fprintf(output_stream, "     (s_filec %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_fileor:{
  fprintf(output_stream, "     (s_fileor %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_fileow:{
  fprintf(output_stream, "     (s_fileow %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_filerc:{
  fprintf(output_stream, "     (s_filerc %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_filewc:{
  fprintf(output_stream, "     (s_filewc %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_flin:{
  fprintf(output_stream, "     (s_flin %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_frtoba:{
  fprintf(output_stream, "     (s_frtoba %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gtef:{
  fprintf(output_stream, "     (s_gtef %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gtei:{
  fprintf(output_stream, "     (s_gtei %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gtes:{
  fprintf(output_stream, "     (s_gtes %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gtf:{
  fprintf(output_stream, "     (s_gtf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gti:{
  fprintf(output_stream, "     (s_gti %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_gts:{
  fprintf(output_stream, "     (s_gts %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_infl:{
  fprintf(output_stream, "     (s_infl %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lkp:{
  fprintf(output_stream, "     (s_lkp %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lkpb:{
  fprintf(output_stream, "     (s_lkpb %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ltbar:{
  fprintf(output_stream, "     (s_ltbar %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ltef:{
  fprintf(output_stream, "     (s_ltef %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ltei:{
  fprintf(output_stream, "     (s_ltei %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ltes:{
  fprintf(output_stream, "     (s_ltes %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ltf:{
  fprintf(output_stream, "     (s_ltf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lti:{
  fprintf(output_stream, "     (s_lti %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_lts:{
  fprintf(output_stream, "     (s_lts %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_modi:{
  fprintf(output_stream, "     (s_modi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_mulf:{
  fprintf(output_stream, "     (s_mulf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_muli:{
  fprintf(output_stream, "     (s_muli %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_neqi:{
  fprintf(output_stream, "     (s_neqi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_neqs:{
  fprintf(output_stream, "     (s_neqs %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_nll:{
  fprintf(output_stream, "     (s_nll %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_nnll:{
  fprintf(output_stream, "     (s_nnll %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_noti:{
  fprintf(output_stream, "     (s_noti %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_nxori:{
  fprintf(output_stream, "     (s_nxori %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ori:{
  fprintf(output_stream, "     (s_ori %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_outc:{
  fprintf(output_stream, "     (s_outc %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_outec:{
  fprintf(output_stream, "     (s_outec %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_outes:{
  fprintf(output_stream, "     (s_outes %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_outf:{
  fprintf(output_stream, "     (s_outf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_outi:{
  fprintf(output_stream, "     (s_outi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_outs:{
  fprintf(output_stream, "     (s_outs %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_popl:{
  fprintf(output_stream, "     (s_popl %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_powf:{
  fprintf(output_stream, "     (s_powf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_powi:{
  fprintf(output_stream, "     (s_powi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_ret:{
  fprintf(output_stream, "     (s_ret %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_retn:{
  fprintf(output_stream, "     (s_retn %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_seto:{
  fprintf(output_stream, "     (s_seto %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_subf:{
  fprintf(output_stream, "     (s_subf %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_subi:{
  fprintf(output_stream, "     (s_subi %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_swp:{
  fprintf(output_stream, "     (s_swp %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_umini:{
  fprintf(output_stream, "     (s_umini %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_xori:{
  fprintf(output_stream, "     (s_xori %i ", instruction_pointer);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register: */
case outi:{
  fprintf(output_stream, "     (outi %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register_integer: */
case ldci:{
  fprintf(output_stream, "     (ldci %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register_integer_integer: */
case nlcl:{
  fprintf(output_stream, "     (nlcl %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register_integer_register: */
case dummy_register_integer_register:{
  fprintf(output_stream, "     (dummy_register_integer_register %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register_register: */
case swp:{
  fprintf(output_stream, "     (swp %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register_register_integer: */
case addi_i:{
  fprintf(output_stream, "     (addi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case divi_i:{
  fprintf(output_stream, "     (divi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case muli_i:{
  fprintf(output_stream, "     (muli_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case subi_i:{
  fprintf(output_stream, "     (subi_i %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category register_register_register: */
case addi:{
  fprintf(output_stream, "     (addi %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case divi:{
  fprintf(output_stream, "     (divi %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case f_divi:{
  fprintf(output_stream, "     (f_divi %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case muli:{
  fprintf(output_stream, "     (muli %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case subi:{
  fprintf(output_stream, "     (subi %i ", instruction_pointer);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_1);
  fprintf(output_stream, INTEGER_T_FORMAT " ", executable->instructions[instruction_pointer].parameter_2);
  fprintf(output_stream, INTEGER_T_FORMAT, executable->instructions[instruction_pointer].parameter_3);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category string: */
case pshcs:{
  fprintf(output_stream, "     (pshcs %i ", instruction_pointer);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_1)]);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case setfp:{
  fprintf(output_stream, "     (setfp %i ", instruction_pointer);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_1)]);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}

/* Instructions of category string_string: */
case s_cact:{
  fprintf(output_stream, "     (s_cact %i ", instruction_pointer);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_1)]);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_2)]);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cactp:{
  fprintf(output_stream, "     (s_cactp %i ", instruction_pointer);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_1)]);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_2)]);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cfun:{
  fprintf(output_stream, "     (s_cfun %i ", instruction_pointer);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_1)]);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_2)]);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
case s_cobj:{
  fprintf(output_stream, "     (s_cobj %i ", instruction_pointer);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_1)]);
  fprintf(output_stream, "\"%s\" ", executable->string_constants[(integer_t)(executable->instructions[instruction_pointer].parameter_2)]);
  fprintf(output_stream, ") ; instr. %i\n", instruction_pointer);
  break;
}
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

    default:{
      fprintf(stderr, "Unknown opcode at instruction #" INTEGER_T_FORMAT "\n",
	      instruction_pointer);
      exit(EXIT_FAILURE);
    }
    } /* switch */
  }
  fprintf(output_stream,"     )) ; end of instructions\n\n\n");

  /* Generate Scheme code to invoke the main program:*/
  fprintf(output_stream, ";;; Start the eAM program:\n");
  fprintf(output_stream,"(main 'no-args)\n");
}
