;;; This file is part of GNU epsilon
;;; Copyright (C) 2003 Luca Saiu
;;;
;;; GNU epsilon is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published
;;; by the Free Software Foundation; either version 2, or (at your
;;; option) any later version.
;;;
;;; GNU epsilon is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with epsilon; see the file COPYING.  If not, write to the
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;;; Boston, MA 02111-1307, USA.
;
;;; Example of mulisp definitions.
;
(defun interval (a b)
  (if (> a b)
      ()
    (cons a (interval (+ a 1) b))))

(defun mapcar (f x)
  (if (null x)
      ()
    (cons (f (car x)) (mapcar f (cdr x)))))

(defun fact (n)
  (if (= n 0)
      1
    (* n (fact (- n 1)))))

(defun sum (n)
  (if (null n)
      0
    (+ (car n) (sum (cdr n)))))

(defun apply (f x)
  (f x))

(defun apply2 (f x y)
  (f x y))

(defun apply3 (f x y z)
  (f x y z))

(defun append (x y)
  (if (null x)
      y
    (cons (car x) (append (cdr x) y))))

(defun reverse (x)
  (if (null x)
      ()
    (append (reverse (cdr x)) (cons (car x) ()))))

(defun is-prime (p known-primes)
  (if (null known-primes)
      t
    (if (= (mod p (car known-primes)) 0)
	nil
      (is-prime p (cdr known-primes)))))

(define known-primes (quote (3 2)))

(defun compute-primes1 (max x primes)
  (if (> x max)
      primes
    (if (is-prime x primes)
	(compute-primes1 max (+ x 2) (cons x primes))
      (compute-primes1 max (+ x 2) primes))))

(defun compute-primes (max)
  (compute-primes1 max 5 known-primes))

(defun zip (x y)
  (if (null x)
      ()
    (cons (cons (car x) (cons (car y) ()))
          (zip (cdr x) (cdr y)))))

(defun length (x)
  (if (null x)
      0
    (+ 1 (length (cdr x)))))

(defun 1+ (n)
  (+ n 1))

(defun 1- (n)
  (- n 1))

(defun ack (i u x)
  (if (= i 0)
      (1+ x)
    (if (= x 0)
        (if (= i 1)
            u
          (if (= i 2) 
              0
            1))
      (ack (1- i) u (ack i u (1- x))))))

(ack 3 3 7)

(quit)

