# Copyright (C) 2013,2014 The ESPResSo project
# Copyright (C) 2012 Olaf Lenz
#
# This file is part of ESPResSo.
#
# ESPResSo is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ESPResSo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# This script generates the file doxy-features
#
from __future__ import print_function
import inspect, sys, os 
# find featuredefs.py 
moduledir = os.path.dirname(inspect.getfile(inspect.currentframe()))
sys.path.append(os.path.join(moduledir, '..', '..', 'src'))
import featuredefs 
import time

if len(sys.argv) != 3:
    print("Usage: {} DEFFILE DOXYCONFIG".format(sys.argv[0]), file=sys.stderr)
    exit(2)

deffilename, configfilename = sys.argv[1:3]

print("Reading definitions from {}...".format(deffilename))
defs = featuredefs.defs(deffilename)
print("Done.")

print("Writing {}...".format(configfilename))
configfile = file(configfilename, 'w');

configfile.write("""# WARNING: This file was autogenerated by
#
#   {} 
#   on {}
#   Do not modify it or your changes will be overwritten!
#   Modify features.def instead.
#
#  This file is needed so that doxygen will generate documentation for
#  all functions of all features.
PREDEFINED = \\
""".format(sys.argv[0], time.asctime()))

for feature in sorted(defs.features):
    configfile.write("  {} \\\n".format(feature))

configfile.close()
print("Done.")

