#include <iomanip.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <string.h>

main()
{

  double x_centre=0.0;
  double y_centre=0.0;
  double rayon=1.0;
  int nseg=320; 

  ofstream out_file("halfdisk5.poly",ios::trunc);
  assert (!out_file.fail());
  double angle,x,y;
  double dl=2.0/nseg;
  double angle_base=dl/rayon;
  int n;
  n=int(3.14159265/angle_base);
  out_file << n+nseg << " " << 2 << " " << 0 << " " << 1 << endl;
  
  
  for (int i=0; i<=nseg-1; i++)
   {
   x=0.0;
   y=-1.0+i*dl;
   out_file << i+1 << "  " << x << "  " << y << "  " << "1" << endl; 
  }
  
  for (int i=0; i<=n-1; i++)
   {
   angle=(3.14159264)*i/n;
   x=x_centre+rayon*cos(angle+3.14159264/2.0);
   y=y_centre+rayon*sin(angle+3.14159264/2.0);
   out_file << nseg+i+1 << "  " << x << "  " << y << "  " << "1" << endl; 
   }
  
   out_file << endl;
   out_file << n+nseg << " " << 1 << endl;
   
    for (int i=1; i<=nseg; i++)
   {
   out_file << i << " " << i << " " << i+1 << " " << "1" << endl; 
   }
   
   for (int i=0; i<=n-2; i++)
   {
   out_file << nseg+i+1 << "  " << nseg+i+1 << "  " << nseg+i+2 << " " << "1" << endl; 
   }
   out_file << nseg+n << " " << nseg+n << " 1" << " " << "1" << endl; 
   
   out_file << 0 << endl;
   out_file << 1 << endl;
   out_file << 1 << " " << -0.5 << " " << 0.0 << " " << 1 << " " << dl*dl << endl;
}