/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.2                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006 CREUSE Emmanuel
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    generer_fichier_in2d.cpp belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <iomanip.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <string.h>

main()
{

  double x_centre=0.0;
  double y_centre=0.0;
  double rayon=1.0;
  int n=320; 
/*ATTENTION : La valeur de n doit tre suffisamment grande en fonction de la finesse du maillage dsir.
  En effet, il faut que TOUS les noeuds de la frontire du maillage final soient spcifis dans ce fichier .in2d
  Autrement dit, il ne faut pas que NETGEN aille ajouter des noeuds sur un segment de la frontire.
  Cela pour que les noeuds de la frontire puissent ensuite tre caractriss par la fonction make_convertion2dtri
  de la classe convert.h, appelant elle mme la fonction partofunitcircle_boundary2d. En effet, dans le cas contraire
  on pourrait avoir un point sur une corde, donc frontire, mais non reconnu par partofunitcircle_boundary2d car n'tant
  pas sur l'arc  de cercle !
  */

  ofstream out_file("PartOfCircle.in2d",ios::trunc);
  assert (!out_file.fail());
  
  out_file << "splinecurves2d" << endl;
  out_file << "3" << endl;
  out_file << endl;
  double angle,x,y;
  double angle_base=(3.0*3.14159264/2.0)/n;
  double dl=rayon*angle_base;
  int nseg;
  nseg=int(1.0/angle_base);
  out_file << n+2*nseg << endl;
  
  
  for (int i=0; i<=n; i++)
   {
   angle=(3.0*3.14159264/2.0)*i/n;
   x=x_centre+rayon*cos(angle);
   y=y_centre+rayon*sin(angle);
   out_file << x << "  " << y << "  " << "1" << endl; 
   }
   for (int i=1; i<=nseg-1; i++)
   {
   x=0.0;
   y=-rayon+i*dl;
   out_file << x << "  " << y << "  " << "1" << endl; 
   }
   out_file << 0 << "  " << 0 << "  " << "1" << endl;
   for (int i=1; i<=nseg-1; i++)
   {
   x=i*dl;
   y=0;
   out_file << x << "  " << y << "  " << "1" << endl; 
   }
   out_file << endl;
   out_file << n+2*nseg << endl;
   
    for (int i=0; i<=n+2*nseg-2; i++)
   {
   out_file << "1 0 2 " << i+1 << " " << i+2 << " " << "1" << endl; 
   }
   out_file << "1 0 2 " << n+2*nseg << " " << "1" << " " << "1" << endl; 
}
