/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.2                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006 CREUSE Emmanuel
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    generer_fichier_poly.cpp belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <iomanip.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <string.h>

main()
{

  double x_centre=0.0;
  double y_centre=0.0;
  double rayon=1.0;
  int n=320; 

  ofstream out_file("PartOfCircle.poly",ios::trunc);
  assert (!out_file.fail());
  double angle,x,y;
  double angle_base=(3.0*3.14159264/2.0)/n;
  double dl=rayon*angle_base;
  int nseg;
  nseg=int(1.0/angle_base);
  out_file << n+2*nseg << " " << 2 << " " << 0 << " " << 1 << endl;
  
  
  for (int i=0; i<=n; i++)
   {
   angle=(3.0*3.14159264/2.0)*i/n;
   x=x_centre+rayon*cos(angle);
   y=y_centre+rayon*sin(angle);
   out_file << i+1 << "  " << x << "  " << y << "  " << "1" << endl; 
   }
   for (int i=1; i<=nseg-1; i++)
   {
   x=0.0;
   y=-rayon+i*dl;
   out_file << n+1+i << " " << x << "  " << y << "  " << "1" << endl; 
   }
   out_file << n+nseg+1 << " " << 0 << "  " << 0 << "  " << "1" << endl;
   for (int i=1; i<=nseg-1; i++)
   {
   x=i*dl;
   y=0;
   out_file << n+nseg+1+i << " " << x << "  " << y << "  " << "1" << endl; 
   }
   out_file << endl;
   out_file << n+2*nseg << " " << 1 << endl;
   
    for (int i=0; i<=n+2*nseg-2; i++)
   {
   out_file << i+1 << " " << i+1 << " " << i+2 << " " << "1" << endl; 
   }
   out_file << n+2*nseg-1 << " " << n+2*nseg << " " << "1" << " " << "1" << endl; 
   
   out_file << 0 << endl;
   out_file << 1 << endl;
   out_file << 1 << " " << 0.5 << " " << 0.5 << " " << 1 << " " << dl*dl << endl;
}
