/* 
   Copyright (C) 2009, 2010, 2011, 2012 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <AppKit/AppKit.h>
#import "MIPizarra.h"
#import "cinematicaPuntual.h"
#import "cinematicaCircular.h"
#import "estaticaPuntual.h"
#import "estaticaRigida.h"
#import "dinamicaPuntual.h"
#import "calor_gas.h"
#import "MIInformacion.h"

@implementation MIInformacion

- (void)awakeFromNib
{
  conteoReferencia = 0;
  sistema = 0;
  [mostrarInfo setDataSource: self] ;
  [mostrarInfo setDelegate: self] ;
  listaObjetos = [NSMutableDictionary dictionary] ;
  [listaObjetos retain] ;
}

- (void) sisUnidades: (id)sender
{
 if (sistema != [sender tag])
   {
     sistema = [sender tag] ;
      
     if ([sender tag] == 0)
       {
	 [sender setState: NSOnState] ;
	 [ingles setState: NSOffState] ;
       }
     else
       {
	 [sender setState: NSOnState] ;
	 [si setState: NSOffState] ;
       } 
    
   }
 else
   {
     [sender setState: NSOnState] ;
   }

}

- (void) calcular: (id)sender
{
  /* insert your code here */
  int cod = [sender codigo: self] ;
  [mostrarInfo deselectAll: sender] ;
  
  if ([borrarVisor state] == NSOnState)
    {
      [visorRes setString: @""] ;
    }
  
  switch(cod)
    {
    case 0:
      {
	id cinemaPuntual = [cinematicaPuntual new];
	[cinemaPuntual setSistema: sistema] ;
	[cinemaPuntual setVisor: visorRes];
	[cinemaPuntual crearEcuaciones: listaObjetos] ;
	RELEASE(cinemaPuntual);
      }
      break;
    case 1:
      {
	id estatPuntual = [estaticaPuntual new];
	[estatPuntual setSistema: sistema] ;
	[estatPuntual setVisor: visorRes];
	[estatPuntual celdas: [sender subviews]] ;
	[estatPuntual crearEcuaciones: listaObjetos] ;
	RELEASE(estatPuntual);
      }
      break;
    case 2:
      {
	id dinamiPuntual = [dinamicaPuntual new];
	[dinamiPuntual setSistema: sistema] ;
	[dinamiPuntual setVisor: visorRes];
	[dinamiPuntual celdas: [sender subviews]] ;
	[dinamiPuntual crearEcuaciones: listaObjetos] ;
	RELEASE(dinamiPuntual);
      }
      break;
    case 3:
      {
	id calorGas = [calor_gas new];
	[calorGas setSistema: sistema] ;
	[calorGas setVisor: visorRes];
	[calorGas celdas: [sender subviews]] ;
	[calorGas crearEcuaciones: listaObjetos] ;
	RELEASE(calorGas);
      } 
      break;
    case 4:
      {
	id cinemaCircular = [cinematicaCircular new];
	[cinemaCircular setSistema: sistema] ;
	[cinemaCircular setVisor: visorRes];
	[cinemaCircular crearEcuaciones: listaObjetos] ;
	RELEASE(cinemaCircular);
      }
      break;
    case 5:
      {
	id estatRigida = [estaticaRigida new];
	[estatRigida setSistema: sistema];
	[estatRigida setVisor: visorRes];
	[estatRigida celdas: [sender subviews]];
	[estatRigida crearEcuaciones: listaObjetos];
	RELEASE(estatRigida);
      }
      break;
    case 6:
      {
	//[cinemaRigida setSistema: sistema] ;
	//[cinemaRigida crearEcuaciones: listaObjetos] ; 
      }
      break;
    }
}


- (void) agregarObjeto: (id)nuevo
{
  /* insert your code here */
  NSString *gravedad ;
  NSArray *listaTitulos = nil;
  NSMutableArray *listaDatos = nil;
  NSMutableArray *listaValores = [NSMutableArray array] ;
  NSMutableDictionary *datos ;
  
  NSNumber *tipo ;
  conteoReferencia = conteoReferencia + 1;
  [mostrarInfo deselectRow: [mostrarInfo selectedRow] ] ;
  
  if (sistema == 0)
    {
      gravedad = [NSString stringWithString: @"9.81"] ;
    }
  else
    {
      gravedad = [NSString stringWithString: @"32.2"] ;
    }
  
  switch ([nuevo tag])
    {
      //Objetos del 1-49 pertenecen al submodulo CinematicaPuntual
    case 1:
      {
	//Sistema de referencia
        listaTitulos = [NSArray arrayWithObjects: @"tf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break ;
    case 2:
      {
	//Sistema movil
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), _(@"Objeto"), @"xsi", @"ysi", @"vsx", @"vsy", @"xof", @"yof", @"vxof", @"vyof", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;      
    case 3:
      {
	//Movil general
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"ax", @"ay", @"xi", @"yi", @"vxi", @"vyi", @"ti", @"xf", @"yf", @"vxf", @"vyf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 4:
      {
	//Cañon
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"ax", @"ay", @"xi", @"yi", @"vi", @"angi", @"ti", @"xf", @"yf", @"vf", @"angf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 5:
      {
	//Movil en X
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"ax", @"xi", @"vxi", @"ti", @"xf", @"vxf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break; 
    case 6:
      {
	//Movil en Y
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"ay", @"yi", @"vyi", @"ti", @"yf", @"vyf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 7:
      {
	//Sistema movil en X
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), _(@"Objeto"), @"xsi", @"vsx", @"xof", @"vxof", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 8:
      {
	//Sistema movil en Y
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), _(@"Objeto"), @"ysi", @"vsy", @"yof", @"vyof", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 9:
      {
	//Movil con velocidad constante X
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"xi", @"xf", @"ti", @"vx", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 10:
      {
	//Movil con velocidad constante Y 
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"yi", @"yf", @"ti", @"vy", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 11:
      {
	//Distancia
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), @"d", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 12:
      {
	//Velocidad relativa
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), @"v", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 13:
      {
	//Movil radial
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"a", @"angf", @"xi", @"yi", @"vi", @"ti", @"xf", @"yf", @"vf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 14:
      {
	//Distancia X o Y
        listaTitulos = [NSArray arrayWithObjects: @"x1 (y1)", @"x2 (y2)", @"x1 - x2 (y1 - y2)", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 15:
      {
	//Punto
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"xf", @"yf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
      //Objetos del 50-99 pertenecen al submodulo estaticaPuntual
    case 50:
      {
	//Sistema de referencia
        listaTitulos = [NSArray arrayWithObjects: @"g", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: gravedad, nil] ;
      }
      break;
    case 51:
      {
	//Bloque
        listaTitulos = [NSArray arrayWithObjects: @"m", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 52:
    case 53:
      {
	//Bloques en un plano inclinado
        listaTitulos = [NSArray arrayWithObjects: @"m", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 54:
    case 55:
      {
	//Poleas y puntos
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break; 
    case 56 ... 59:
      {
	//Fuerzas oblicuas
        listaTitulos = [NSArray arrayWithObjects: @"f", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 60 ... 63:
      {
	//Fuerzas verticales y horizontales
        listaTitulos = [NSArray arrayWithObjects: @"f", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 64 ... 71:
      {
	//Fricciones
        listaTitulos = [NSArray arrayWithObjects: @"u", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 72:
      {
	//Resultante general
        listaTitulos = [NSArray arrayWithObjects: @"f", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 73:
    case 74:
      {
	//Resultante vertical y horizontal
        listaTitulos = [NSArray arrayWithObjects: @"f", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 75 ... 78:
      {
	//Resortes
        listaTitulos = [NSArray arrayWithObjects: @"k", @"d", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
      //Objetos del 100-149 pertenecen al submodulo dinamicaPuntual
    case 100:
      {
	//Sistema de referencia
        listaTitulos = [NSArray arrayWithObjects: @"g", @"t", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: gravedad, @"0", nil] ;
      }
      break;
    case 101:
      {
	//Movil general
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"vi", @"angi", @"vf", @"angf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 102:
      {
	//Movil en X
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"vxi", @"vxf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 103:
      {
	//Movil en Y
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"vyi", @"vyf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 104:
    case 105:
      {
	//Bloque vertical y horizontal
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"a", @"vi", @"vf", @"d", _(@"Relativo a"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"sf", nil] ;
      }
      break;        
    case 106:
    case 107:
      {
	//Bloques en un plano inclinado
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"ang", @"a", @"vi", @"vf", @"d", _(@"Relativo a"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"sf", nil] ;
      }
      break;
    case 108:
      {
	//Polea
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 109 ... 112:
      {
	//Fuerzas oblicuas
        listaTitulos = [NSArray arrayWithObjects: @"f", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 113 ... 116:
      {
	//Fuerzas verticales y horizontales
        listaTitulos = [NSArray arrayWithObjects: @"f", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 117 ... 124:
      {
	//Fricciones
        listaTitulos = [NSArray arrayWithObjects: _(@"Normal"), @"u", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 125 ... 128:
      {
	//Contactos oblicuos
        listaTitulos = [NSArray arrayWithObjects: _(@"Normal"), @"u", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 129 ... 132:
      {
	//Contactos verticales y horizontales
        listaTitulos = [NSArray arrayWithObjects: _(@"Normal"), @"u", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break; 
    case 133 ... 136:
      {
	//Resortes
        listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"k", @"xi", @"xf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;                       
    case 137:
      {
	//Relacion de aceleraciones
        listaTitulos = [NSArray arrayWithObjects: @"a1", @"a2", @"z", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"-1", nil] ;
      }
      break;
    case 138:
      {
	//Colison
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), @"e", @"angn", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 139:
      {
	//Energia
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), _(@"Objeto 3"), _(@"Objeto 4"), _(@"Trabajo"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;        
      }
      break;   
    case 140:
      {
	//Impulso
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), _(@"Impulso"), @"ang", @"fImp", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 141:
      {
	//Potencia
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), _(@"Potencia"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 143:
      {
	//Movimiento relativo
        listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"asf", @"ang_asf", @"vfsf", @"ang_vfsf", @"dsf", @"ang_dsf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;          
    case 144:
      {
	//Explosion
        listaTitulos = [NSArray arrayWithObjects: @"m", @"vi", @"ang", @"m1", @"vf1", @"ang1", @"m2", @"vf2", @"ang2", @"m3", @"vf3", @"ang3", @"m4", @"vf4", @"ang4", _(@"Energia"), nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
      //Objetos del 150-199 pertencen al submodulo calorGas
    case 150:
      {
	//Reloj
	listaTitulos = [NSArray arrayWithObjects: @"t", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 151:
    case 153:
      {
	//Calor aplicado y extraido
	listaTitulos = [NSArray arrayWithObjects: @"Q", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 152:
    case 154:
      {
	//Flujo de calor y refrigeracion
	listaTitulos = [NSArray arrayWithObjects: @"dQ/dt", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 155:
    case 156:
    case 169:
      {
	//Bloque, liquido y gas
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"c", @"Ti", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 157:
      {
	//Dilatacion lineal
	listaTitulos = [NSArray arrayWithObjects: @"k", @"Li", @"Lf", @"Ti", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 158:
      {
	//Dilatacion superficial
	listaTitulos = [NSArray arrayWithObjects: @"k", @"Si", @"Sf", @"Ti", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 159:
      {
	//Dilatacion volumetrica
	listaTitulos = [NSArray arrayWithObjects: @"k", @"Vi", @"Vf", @"Ti", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break; 
    case 160:
      {
	//Cambio de fase solido-liquido
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"cf", _(@"Sentido"), nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @">", nil] ;
      }
      break;
    case 161:
      {
	//Cambio de fase liquido-gas
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"cv", _(@"Sentido"), nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @">", nil] ;
      }
      break;
    case 162:
      {
	//Proceso
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), _(@"Objeto 1"), _(@"Objeto 2"), _(@"Objeto 3"), _(@"Objeto 4"), _(@"Objeto 5"), nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 163:
      {
	//Calorimetro
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), _(@"Objeto 3"), _(@"Objeto 4"), nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 164:
      {
	//Gas a presion constante
	listaTitulos = [NSArray arrayWithObjects: @"Vi", @"Ti", @"Vf", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 165:
      {
	//Gas a temperatura constante
	listaTitulos = [NSArray arrayWithObjects: @"Pi", @"Vi", @"Pf", @"Vf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 166:
      {
	//Gas a volumen constante
	listaTitulos = [NSArray arrayWithObjects: @"Pi", @"Ti", @"Pf", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 167:
      {
	//Gas general
	listaTitulos = [NSArray arrayWithObjects: @"Pi", @"Vi", @"Ti", @"Pf", @"Vf", @"Tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 168:
      {
	//Intercambiador
	listaTitulos = [NSArray arrayWithObjects: @"TRi", @"TRf", @"dR/dt", @"cR", @"TFi", @"TFf", @"dF/dt", @"cF", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
      //Objetos del 200-249 pertenecen al submodulo cinematicaPuntualCircular
    case 200:
      {
	//Sistema de referencia
	listaTitulos = [NSArray arrayWithObjects: @"tf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 201:
      {
	//Movil circular
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"C", @"r", @"ac", @"at", @"angi", @"vi", @"ti", @"angf", @"vf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 202:
      {
	//Movil polar
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"C", @"aa", @"ar", @"angi", @"ri", @"vai", @"vri", @"ti", @"angf", @"rf", @"vaf", @"vrf", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 203:
      {
	//Velocidad angular
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"vang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 204:
      {
	//Aceleracion angular
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"aang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 205:
      {
	//Aceleracion total
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"atot", @"ang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 206:
      {
	//Frecuencia
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"f", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 207:
      {
	//Periodo
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"T", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 208:
      {
	//Numero de vueltas
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"n", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 209:
      {
	//Centro
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"x", @"y", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 210:
      {
	//Distancia
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), @"d", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 211:
      {
	//Longitud de arco
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"s", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 212:
      {
	//Coordenada
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto"), @"x", @"y", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 213:
      {
	//Velocidad relativa
	listaTitulos = [NSArray arrayWithObjects: _(@"Objeto 1"), _(@"Objeto 2"), @"v", @"ang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
      //Objetos del 250-299 pertenecen al submodulo estaticaRigida
    case 250:
      {
	//Sistema de referencia
	listaTitulos = [NSArray arrayWithObjects: @"g", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: gravedad, nil] ;
      }
      break;
    case 251:
      {
	//Elemento punto
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"x", @"y", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 252:
      {
	//Viga
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"lc", @"ang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 253:
      {
	//Solido
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"m", @"xc", @"yc", @"ang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
      }
      break;
    case 254:
      {
	//Par
	listaTitulos = [NSArray arrayWithObjects: @"M", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 255:
      {
	//Elementos de viga
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"l", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 256:
      {
	//Elementos de solido
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), @"x", @"y", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 257 ... 260:
      {
	//Fuerzas oblicuas
	listaTitulos = [NSArray arrayWithObjects: @"f", @"ang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 261 ... 264:
      {
	//Fuerzas verticales y horizontales
	listaTitulos = [NSArray arrayWithObjects: @"f", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    case 265 ... 268:
      {
	//Fricciones oblicuas
	listaTitulos = [NSArray arrayWithObjects: _(@"Normal"), @"ang", @"u", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 269 ... 272:
      {
	//Fricciones verticales y horizontales
	listaTitulos = [NSArray arrayWithObjects: _(@"Normal"), @"u", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 273:
      {
	//Resultante general
	listaTitulos = [NSArray arrayWithObjects: @"M", @"f", @"ang", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
      }
      break;
    case 274:
    case 275:
      {
	//Resultantes con fuerza vertical y horizontal
	listaTitulos = [NSArray arrayWithObjects: @"M", @"f", nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
      }
      break;
    case 276:
      {
	//Puntos
	listaTitulos = [NSArray arrayWithObjects: _(@"Nombre"), nil] ;
	listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
      }
      break;
    }
  
  tipo = [NSNumber numberWithInt: [nuevo tag] ] ;
  datos = [NSMutableDictionary dictionaryWithObjectsAndKeys: tipo, @"Tipo", listaTitulos, @"Titulos", listaDatos, @"Datos", listaValores, @"Valores", nil] ;
  identificador = [[NSNumber alloc] initWithInt: conteoReferencia] ;
  [listaObjetos setObject: datos forKey: identificador] ;
  [nuevo setTag: [identificador intValue]] ;
  [mostrarInfo reloadData] ;  
}


- (void) borrarObjeto: (int)codigo
{
  /* insert your code here */
  identificador = [[NSNumber alloc] initWithInt: codigo] ;
  [listaObjetos removeObjectForKey: identificador] ;
  [mostrarInfo reloadData] ;
}

- (void) selecObjeto: (int)codigo
{
  /* insert your code here */
  [mostrarInfo deselectRow: [mostrarInfo selectedRow] ] ;
  identificador = [[NSNumber alloc] initWithInt: codigo] ;
  [mostrarInfo reloadData] ;
}

- (void) borrarObjetos: (BOOL) parametro
{
  conteoReferencia = 0;
  [listaObjetos removeAllObjects] ;
  [mostrarInfo reloadData] ;
}

- (int) numberOfRowsInTableView: (NSTableView*)aTableView
{
  return [[[listaObjetos objectForKey: identificador] objectForKey: @"Titulos"] count] ;
}

- (id) tableView: (NSTableView*)aTableView objectValueForTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex
{
  id imprimir ;     
  NSMutableDictionary *objeto = [listaObjetos objectForKey: identificador] ;
  NSMutableArray *lista = [objeto objectForKey: [aTableColumn identifier] ] ;
  imprimir = [lista objectAtIndex: rowIndex] ;
  
  if ([[aTableColumn identifier] isEqualToString: @"Titulos"])
    {
      imprimir = [imprimir description];
    }
  
  return imprimir ;
}

- (void) tableView: (NSTableView*)aTableView setObjectValue: (id)anObject forTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex
{
  NSMutableDictionary *objeto = [listaObjetos objectForKey: identificador] ;
  NSMutableArray *lista = [objeto objectForKey: [aTableColumn identifier] ] ;
  [lista replaceObjectAtIndex: rowIndex withObject: anObject] ;
}

- (BOOL) tableView: (NSTableView*)aTableView shouldEditTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex
{
  [pizarra controlCursor: self];
  return YES;
}

- (void) tableView: (NSTableView*)aTableView 
   willDisplayCell: (id)aCell 
    forTableColumn: (NSTableColumn*)aTableColumn 
	       row: (int)rowIndex
{
  [aCell setEditable: YES];
}

- (void) dealloc
{
  RELEASE(listaObjetos) ;
  RELEASE(identificador) ;
  [super dealloc] ;
}

@end
