/* 
   Copyright (C) 2010, 2011, 2012 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <stdlib.h>
#import <stdio.h>
#import <math.h>
#import <gsl/gsl_vector.h>
#import <gsl/gsl_multiroots.h>
#import <gsl/gsl_rng.h>
#import "estaticaRigida.h"

static int varG ;
static double gravedadDat ;
static NSMutableDictionary *diccionario ;
static NSMutableArray *variables, *fuerObj, *tipoFuer, *resultante, *codObjetos, *nomObjetos, *codSolidos, *nomSolidos, *tipoElemt, *tipoFuerSol, *codElemResul, *codResul, *codOtros;
static NSString *gravedadVar ;

int valoresEstatRig (const gsl_vector *, void *, gsl_vector *);

struct parametros
{
  double a;
  double b;
};

int sis_estaticaRig (const gsl_vector *variables, void *params, gsl_vector *funciones)
{
  valoresEstatRig (variables, params, funciones);  
  return GSL_SUCCESS;
}

int valoresEstatRig (const gsl_vector *vars, void *p, gsl_vector *func)
{
  int gIndice, codigoFuerSol = 0 ;
  int nEcu = 0 ;
  double gf ;
  NSNumber *objeto ;
  NSEnumerator *enumerador;
  
  if (varG == 1)
    {
      gIndice = [variables indexOfObject: gravedadVar] ;
      gf = gsl_vector_get (vars, gIndice) ;   
    }
  else
    {
      if (varG == 2)
	{
          gf = gravedadDat ;
	}
      else
	{
          gf = 0 ;
	}
    }
  
  
  enumerador = [codSolidos objectEnumerator] ;
  
  while ((objeto = [enumerador nextObject]))
    {
      int t, tipoFS;
      double fuerzasX = 0, fuerzasY = 0, momentos = 0, bmx = 0, bmy = 0, vang = 0, sang = 0;
      double signox, signoy, ecx = 0, ecy = 0;
      NSNumber *elemCodigo, *fuerCodigo, *tipoElem;
      NSEnumerator *elementosSol;
      NSMutableArray *elemDatosResul, *datosElem, *fuerDatos;
      
      NSNumber *tipo = [[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
      NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"];
      
      
      //Se leen los datos del elemento que tiene la resultante, si hay
      if ([codResul objectAtIndex: codigoFuerSol] != [NSNull null])
	{
	  elemDatosResul = [[diccionario objectForKey: [codResul objectAtIndex: codigoFuerSol]] objectForKey: @"Valores"];
	  
	  if ([tipo intValue] == 276)
	    {
	      if (![variables containsObject: [[elemDatosResul objectAtIndex: 1] stringByTrimmingSpaces]])
		{
		  bmx = [[elemDatosResul objectAtIndex: 1] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[elemDatosResul objectAtIndex: 1] stringByTrimmingSpaces]] ;
		  bmx = gsl_vector_get (vars, k) ;
		}
	      
	      if (![variables containsObject: [[elemDatosResul objectAtIndex: 2] stringByTrimmingSpaces]])
		{
		  bmy = [[elemDatosResul objectAtIndex: 2] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[elemDatosResul objectAtIndex: 2] stringByTrimmingSpaces]] ;
		  bmy = gsl_vector_get (vars, k) ;
		}
	    }
	  else
	    {
	      if ([tipo intValue] == 252)
		{
		  double lcr, cang ;
		  
		  if (![variables containsObject: [[elemDatosResul objectAtIndex: 1] stringByTrimmingSpaces]])
		    {
		      lcr = [[elemDatosResul objectAtIndex: 1] doubleValue] ;
		    }
		  else
		    {
		      int k = [variables indexOfObject: [[elemDatosResul objectAtIndex: 1] stringByTrimmingSpaces]] ;
		      lcr = gsl_vector_get (vars, k) ;
		    }
		  
		  if (![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]])
		    {
		      cang = [[dat objectAtIndex: 3] doubleValue] ;
		    }
		  else
		    {
		      int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
		      cang = gsl_vector_get (vars, k) ;
		    }
		  
		  bmx = lcr*cos(M_PI*cang/180);
		  bmy = lcr*sin(M_PI*cang/180);
		}
	      else
		{
		  double xs, ys, pang;
		  
		  if (![variables containsObject: [[elemDatosResul objectAtIndex: 1] stringByTrimmingSpaces]])
		    {
		      xs = [[elemDatosResul objectAtIndex: 1] doubleValue] ;
		    }
		  else
		    {
		      int k = [variables indexOfObject: [[elemDatosResul objectAtIndex: 1] stringByTrimmingSpaces]] ;
		      xs = gsl_vector_get (vars, k) ;
		    }
		  
		  if (![variables containsObject: [[elemDatosResul objectAtIndex: 2] stringByTrimmingSpaces]])
		    {
		      ys = [[elemDatosResul objectAtIndex: 2] doubleValue] ;
		    }
		  else
		    {
		      int k = [variables indexOfObject: [[elemDatosResul objectAtIndex: 2] stringByTrimmingSpaces]] ;
		      ys = gsl_vector_get (vars, k) ;
		    }
		  
		  if (![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]])
		    {
		      pang = [[dat objectAtIndex: 4] doubleValue] ;
		    }
		  else
		    {
		      int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
		      pang = gsl_vector_get (vars, k) ;
		    }
		  
		  bmx = xs*cos(M_PI*pang/180) - ys*sin(M_PI*pang/180);
		  bmy = xs*sin(M_PI*pang/180) + ys*cos(M_PI*pang/180);
		}
	    }
	}
      
      
      //Se verifica el tipo de solido
      if ([tipo intValue] == 252)
	{
	  double peso, masa, lc;
	  
	  if (![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]])
	    {
	      masa = [[dat objectAtIndex: 1] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
	      masa = gsl_vector_get (vars, k) ;
	    }
	  
	  if (![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]])
	    {
	      lc = [[dat objectAtIndex: 2] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
	      lc = gsl_vector_get (vars, k) ;
	    }
	  
	  if (![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]])
	    {
	      vang = [[dat objectAtIndex: 3] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
	      vang = gsl_vector_get (vars, k) ;
	    }
	  
	  //Se agrega la fuerza del peso a las fuerzas verticales y el momento producido
	  peso = -masa*gf;
	  fuerzasY = fuerzasY + peso;
	  momentos = momentos + (lc*cos(M_PI*vang/180) - bmx)*peso;
	}
      
      if ([tipo intValue] == 253)
	{
	  double peso, masa, cx, cy;
	  
	  if (![variables containsObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]])
	    {
	      masa = [[dat objectAtIndex: 1] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]] ;
	      masa = gsl_vector_get (vars, k) ;
	    }
	  
	  if (![variables containsObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]])
	    {
	      cx = [[dat objectAtIndex: 2] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 2] stringByTrimmingSpaces]] ;
	      cx = gsl_vector_get (vars, k) ;
	    }
	  
	  if (![variables containsObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]])
	    {
	      cy = [[dat objectAtIndex: 3] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 3] stringByTrimmingSpaces]] ;
	      cy = gsl_vector_get (vars, k) ;
	    }
	  
	  if (![variables containsObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]])
	    {
	      sang = [[dat objectAtIndex: 4] doubleValue] ;
	    }
	  else
	    {
	      int k = [variables indexOfObject: [[dat objectAtIndex: 4] stringByTrimmingSpaces]] ;
	      sang = gsl_vector_get (vars, k) ;
	    }
	  
	  //Se agrega la fuerza del peso a las fuerzas verticales y el momento producido
	  peso = -masa*gf;
	  fuerzasY = fuerzasY + peso;
	  momentos = momentos + (cx*cos(M_PI*sang/180) - cy*sin(M_PI*sang/180) - bmx)*peso;
	}
      
      
      //Se procede a buscar los elementos del solido
      elementosSol = [[tipoElemt objectAtIndex: codigoFuerSol] objectEnumerator];
      while ((elemCodigo = [elementosSol nextObject]))
	{
	  int numObj = [codObjetos indexOfObject: elemCodigo];
	  double fuerzasVigaX = 0, fuerzasVigaY = 0;
	  NSEnumerator *fuerDat = [[fuerObj objectAtIndex: numObj] objectEnumerator];
	  datosElem = [[diccionario objectForKey: elemCodigo] objectForKey: @"Valores"];
	  tipoElem = [[diccionario objectForKey: elemCodigo] objectForKey: @"Tipo"];
	  
	  //Se obtienen las coordenadas del elemento
	  if ([tipoElem intValue] == 255)
	    {
	      double l;
	      
	      if (![variables containsObject: [[datosElem objectAtIndex: 1] stringByTrimmingSpaces]])
		{
		  l = [[datosElem objectAtIndex: 1] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[datosElem objectAtIndex: 1] stringByTrimmingSpaces]] ;
		  l = gsl_vector_get (vars, k) ;
		}
	      
	      ecx = l*cos(M_PI*vang/180);
	      ecy = l*sin(M_PI*vang/180);
	    }
	  else if ([tipoElem intValue] == 256)
	    {
	      double elx, ely;
	      
	      if (![variables containsObject: [[datosElem objectAtIndex: 1] stringByTrimmingSpaces]])
		{
		  elx = [[datosElem objectAtIndex: 1] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[datosElem objectAtIndex: 1] stringByTrimmingSpaces]] ;
		  elx = gsl_vector_get (vars, k) ;
		}
	      
	      if (![variables containsObject: [[datosElem objectAtIndex: 2] stringByTrimmingSpaces]])
		{
		  ely = [[datosElem objectAtIndex: 2] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[datosElem objectAtIndex: 2] stringByTrimmingSpaces]] ;
		  ely = gsl_vector_get (vars, k) ;
		}
	      
	      ecx = elx*cos(M_PI*sang/180) - ely*sin(M_PI*sang/180);
	      ecy = elx*sin(M_PI*sang/180) + ely*cos(M_PI*sang/180);
	    }
	  else if ([tipoElem intValue] == 251)
	    {
	      if (![variables containsObject: [[datosElem objectAtIndex: 1] stringByTrimmingSpaces]])
		{
		  ecx = [[datosElem objectAtIndex: 1] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[datosElem objectAtIndex: 1] stringByTrimmingSpaces]] ;
		  ecx = gsl_vector_get (vars, k) ;
		}
	      
	      if (![variables containsObject: [[datosElem objectAtIndex: 2] stringByTrimmingSpaces]])
		{
		  ecy = [[datosElem objectAtIndex: 2] doubleValue] ;
		}
	      else
		{
		  int k = [variables indexOfObject: [[datosElem objectAtIndex: 2] stringByTrimmingSpaces]] ;
		  ecy = gsl_vector_get (vars, k) ;
		}
	    }
	  
	  
	  //Se obtienen los datos de las fuerzas aplicadas
	  while ((fuerCodigo = [fuerDat nextObject]))
	    {
	      t = [[[diccionario objectForKey: fuerCodigo] objectForKey: @"Tipo"] intValue];
	      fuerDatos = [[diccionario objectForKey: fuerCodigo] objectForKey: @"Valores"];
	      
	      switch (t)
		{
		  //Momento
		case 254:
		  {
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			momentos = momentos + [[fuerDatos objectAtIndex: 0] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			momentos = momentos + gsl_vector_get (vars, k);
		      }
		  }
		  break;
		  //Fuerza horizontal y Viga 2F horizontal
		case 261:
		case 262:
		case 281:
		case 282:
		  {
		    if ( (t == 261) || (t == 281) )
		      { signox = 1; }
		    else
		      { signox = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			if ([tipoElem intValue] == 294)
			  {
			    fuerzasVigaX = fuerzasVigaX + signox*[[fuerDatos objectAtIndex: 0] doubleValue];
			  }
			else
			  {
			    fuerzasX = fuerzasX + signox*[[fuerDatos objectAtIndex: 0] doubleValue];
			    momentos = momentos + signox*(bmy - ecy)*[[fuerDatos objectAtIndex: 0] doubleValue];
			  }
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;

			if ([tipoElem intValue] == 294)
			  {
			    fuerzasVigaX = fuerzasVigaX + signox*(gsl_vector_get (vars, k));
			  }
			else
			  {
			    fuerzasX = fuerzasX + signox*(gsl_vector_get (vars, k)) ;
			    momentos = momentos + signox*(bmy - ecy)*(gsl_vector_get (vars, k));
			  }
		      }
		  }
		  break;
		  //Fuerza vertical y Viga 2F vertical
		case 263:
		case 264:
		case 283:
		case 284:
		  {
		    if ( (t == 263) || (t == 283) )
		      { signoy = 1; }
		    else
		      { signoy = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			if ([tipoElem intValue] == 294)
			  {
			    fuerzasVigaY = fuerzasVigaY + signoy*[[fuerDatos objectAtIndex: 0] doubleValue];
			  }
			else
			  {
			    fuerzasY = fuerzasY + signoy*[[fuerDatos objectAtIndex: 0] doubleValue];
			    momentos = momentos + signoy*(ecx - bmx)*[[fuerDatos objectAtIndex: 0] doubleValue];
			  }
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;

			if ([tipoElem intValue] == 294)
			  {
			    fuerzasVigaY = fuerzasVigaY + signoy*(gsl_vector_get (vars, k));
			  }
			else
			  {
			    fuerzasY = fuerzasY + signoy*(gsl_vector_get (vars, k)) ;
			    momentos = momentos + signoy*(ecx - bmx)*(gsl_vector_get (vars, k));
			  }
		      }
		  }
		  break;
		  //Fuerzas generales y Vigas 2F generales
		case 257 ... 260:
		case 277 ... 280:
		  {
		    double ang ;
                    
		    if ( (t == 257) || (t == 260) || (t == 277) || (t == 280) )
		      { signox = 1; }
		    else
		      { signox = - 1; }
		    
		    if ( (t == 257) || (t == 259) || (t == 277) || (t == 279) )
		      { signoy = 1; }
		    else
		      { signoy = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			ang = [[fuerDatos objectAtIndex: 1] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			ang = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			if ([tipoElem intValue] == 294)
			  {
			    fuerzasVigaX = fuerzasVigaX + signox*[[fuerDatos objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
			    fuerzasVigaY = fuerzasVigaY + signoy*[[fuerDatos objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
			  }
			else
			  {
			    fuerzasX = fuerzasX + signox*[[fuerDatos objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
			    fuerzasY = fuerzasY + signoy*[[fuerDatos objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
			    momentos = momentos + signoy*(ecx - bmx)*[[fuerDatos objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) + signox*(bmy - ecy)*[[fuerDatos objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
			  }
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;

			if ([tipoElem intValue] == 294)
			  {
			    fuerzasVigaX = fuerzasVigaX + signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
			    fuerzasVigaY = fuerzasVigaY + signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
			  }
			else
			  {
			    fuerzasX = fuerzasX + signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
			    fuerzasY = fuerzasY + signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
			    momentos = momentos + signoy*(ecx - bmx)*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) + signox*(bmy - ecy)*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
			  }
		      }
		  }
		  break;
		  //Fricciones horizontales
		case 269:
		case 270:
		  {
		    double u;
		    
		    if (t == 269)
		      { signox = 1; }
		    else
		      { signox = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			u = [[fuerDatos objectAtIndex: 1] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			u = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			fuerzasX = fuerzasX + u*signox*[[fuerDatos objectAtIndex: 0] doubleValue] ;
			momentos = momentos + u*signox*(bmy - ecy)*[[fuerDatos objectAtIndex: 0] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			fuerzasX = fuerzasX + u*signox*(gsl_vector_get (vars, k)) ;
			momentos = momentos + u*signox*(bmy - ecy)*(gsl_vector_get (vars, k)) ;
		      } 
		  }
		  break;
		  //Fricciones verticales
		case 271:
		case 272:
		  {
		    double u;
		    
		    if (t == 271)
		      { signoy = 1; }
		    else
		      { signoy = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			u = [[fuerDatos objectAtIndex: 1] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			u = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			fuerzasY = fuerzasY + u*signoy*[[fuerDatos objectAtIndex: 0] doubleValue] ;
			momentos = momentos + u*signoy*(ecx - bmx)*[[fuerDatos objectAtIndex: 0] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			fuerzasY = fuerzasY + u*signoy*(gsl_vector_get (vars, k)) ;
			momentos = momentos + u*signoy*(ecx - bmx)*(gsl_vector_get (vars, k));
		      } 
		  }
		  break;
		  //Fricciones generales
		case 265 ... 268:
		  {
		    double u, ang ;
                    
		    if ( (t == 265) || (t == 268) )
		      { signox = 1; }
		    else
		      { signox = - 1; }
		    
		    if ( (t == 265) || (t == 267) )
		      { signoy = 1; }
		    else
		      { signoy = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 2] stringByTrimmingSpaces]])
		      {
			u = [[fuerDatos objectAtIndex: 2] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
			u = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			ang = [[fuerDatos objectAtIndex: 1] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			ang = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			fuerzasX = fuerzasX + u*signox*[[fuerDatos objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
			fuerzasY = fuerzasY + u*signoy*[[fuerDatos objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
			momentos = momentos + signoy*(ecx - bmx)*u*[[fuerDatos objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) + signox*(bmy - ecy)*u*[[fuerDatos objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			fuerzasX = fuerzasX + u*signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
			fuerzasY = fuerzasY + u*signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
			momentos = momentos + signoy*(ecx - bmx)*u*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) + signox*(bmy - ecy)*u*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
		      }
		  }
		  break;
		  //Resultante horizontal
		case 274:
		  {
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			momentos = momentos - [[fuerDatos objectAtIndex: 0] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			momentos = momentos - gsl_vector_get (vars, k);
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			fuerzasX = fuerzasX - [[fuerDatos objectAtIndex: 1] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			fuerzasX = fuerzasX - gsl_vector_get (vars, k);
		      }
		  }
		  break;
		  //Resultante vertical
		case 275:
		  {
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			momentos = momentos - [[fuerDatos objectAtIndex: 0] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			momentos = momentos - gsl_vector_get (vars, k);
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			fuerzasY = fuerzasY - [[fuerDatos objectAtIndex: 1] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			fuerzasY = fuerzasY - gsl_vector_get (vars, k);
		      }
		  }
		  break;
		  //Resultante general
		case 273:
		  {
		    double ang;
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			momentos = momentos - [[fuerDatos objectAtIndex: 0] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			momentos = momentos - gsl_vector_get (vars, k);
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 2] stringByTrimmingSpaces]])
		      {
			ang = [[fuerDatos objectAtIndex: 2] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 2] stringByTrimmingSpaces]] ;
			ang = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			fuerzasX = fuerzasX - [[fuerDatos objectAtIndex: 1] doubleValue]*cos(M_PI*ang/180) ;
			fuerzasY = fuerzasY - [[fuerDatos objectAtIndex: 1] doubleValue]*sin(M_PI*ang/180) ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			fuerzasX = fuerzasX - (gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
			fuerzasY = fuerzasY - (gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
		      }
		  }
		  break;
		  //Viga horizontal de armadura
		case 289:
		case 290:
		  {
		    if (t == 289)
		      { signox = 1; }
		    else
		      { signox = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			fuerzasVigaX = fuerzasVigaX + signox*[[fuerDatos objectAtIndex: 0] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			fuerzasVigaX = fuerzasVigaX + signox*(gsl_vector_get (vars, k)) ;
		      }
		  }
		  break;
		  //Viga vertical de armadura
		case 291:
		case 292:
		  {
		    if (t == 291)
		      { signoy = 1; }
		    else
		      { signoy = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			fuerzasVigaY = fuerzasVigaY + signoy*[[fuerDatos objectAtIndex: 0] doubleValue];
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			fuerzasVigaY = fuerzasVigaY + signoy*(gsl_vector_get (vars, k)) ;
		      }
		  }
		  break;
		  //Vigas de armadura generales
		case 285 ... 288:
		  {
		    double ang ;
                    
		    if ( (t == 285) || (t == 288) )
		      { signox = 1; }
		    else
		      { signox = - 1; }
		    
		    if ( (t == 285) || (t == 287) )
		      { signoy = 1; }
		    else
		      { signoy = - 1; }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]])
		      {
			ang = [[fuerDatos objectAtIndex: 1] doubleValue] ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			ang = gsl_vector_get (vars, k) ;
		      }
		    
		    if (![variables containsObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]])
		      {
			fuerzasVigaX = fuerzasVigaX + signox*[[fuerDatos objectAtIndex: 0] doubleValue]*cos(M_PI*ang/180) ;
			fuerzasVigaY = fuerzasVigaY + signoy*[[fuerDatos objectAtIndex: 0] doubleValue]*sin(M_PI*ang/180) ;
		      }
		    else
		      {
			int k = [variables indexOfObject: [[fuerDatos objectAtIndex: 0] stringByTrimmingSpaces]] ;
			fuerzasVigaX = fuerzasVigaX + signox*(gsl_vector_get (vars, k))*cos(M_PI*ang/180) ;
			fuerzasVigaY = fuerzasVigaY + signoy*(gsl_vector_get (vars, k))*sin(M_PI*ang/180) ;
		      }
		  }
		  break;
		}
	    }

	  //Equations for joint of truss
	  if ([tipoElem intValue] == 294)
	    {
	      gsl_vector_set (func, nEcu, fuerzasVigaX);
	      gsl_vector_set (func, nEcu + 1, fuerzasVigaY);

	      nEcu = nEcu + 2;
	    }
	}
      
      
      //Se establecen las ecuaciones
      tipoFS = [[tipoFuerSol objectAtIndex: codigoFuerSol] intValue];
      
      /* Do nothing for value 5, since Trusses not need equations, 
	 only its joints. */
      switch (tipoFS)
	{
	case 1:
	  {
	    gsl_vector_set (func, nEcu, fuerzasX);
	    gsl_vector_set (func, nEcu + 1, fuerzasY);
	    gsl_vector_set (func, nEcu + 2, momentos);
	    
	    nEcu = nEcu + 3;
	  }
	  break;
	case 2:
	case 3:
	case 4:
	  {
	    if (tipoFS == 2)
	      {
		gsl_vector_set (func, nEcu, fuerzasX);
		nEcu = nEcu + 1;
	      }
	    else if (tipoFS == 3)
	      {
		gsl_vector_set (func, nEcu, fuerzasY);
		nEcu = nEcu + 1;
	      }
	    
	    gsl_vector_set (func, nEcu, momentos);
	    
	    nEcu = nEcu + 1;
	  }
	  break;
	}
      
      codigoFuerSol = codigoFuerSol + 1 ;
    }

  enumerador = [codOtros objectEnumerator];
  while((objeto = [enumerador nextObject]))
    {
      NSNumber *tipo = [[diccionario objectForKey: objeto] objectForKey: @"Tipo"] ;
      NSMutableArray *dat = [[diccionario objectForKey: objeto] objectForKey: @"Valores"];
      
      switch([tipo intValue])
	{
	case 295:
	  {
	    int k;
	    double a1, a2;
	    
	    k = [variables indexOfObject: [[dat objectAtIndex: 0] stringByTrimmingSpaces]];
	    a1 = gsl_vector_get (vars, k);
	    
	    k = [variables indexOfObject: [[dat objectAtIndex: 1] stringByTrimmingSpaces]];
	    a2 = gsl_vector_get (vars, k);
	    
	    //Set the equation
	    gsl_vector_set (func, nEcu, sin(M_PI*a1/180) - cos(M_PI*a2/180));
	    
	    nEcu = nEcu + 1;
	  }
	  break;
	}
    }
  
  return 0 ;       
}

@interface estaticaRigida (Private)
- (void) crearSistema;
@end

@implementation estaticaRigida (Private)
- (void) crearSistema
{
  int aumento = 1 ;
  double nuevoValor ;
  BOOL continuar ;
  
  const gsl_multiroot_fsolver_type *T;
  gsl_multiroot_fsolver *s;
  
  int estado = 0, estadoInt, k, longitud ;
  int nvar = [variables count] ;
  const size_t n = nvar;
  double par;
  NSString *mensaje ;
  size_t iter ;
  
  struct parametros p = {1.0, 1.0};
  
  gsl_vector *x = gsl_vector_alloc (n);
  int countRes = 0 ;
  id unObj ;
  NSMutableArray *resultados = [NSMutableArray array] ;
  NSEnumerator *varCount ;
  id datoSigno ;
  NSNumber *tipoOtro ;
  NSMutableArray *verifSigno, *beamStatus;
  NSEnumerator *signoObj ;
  
  //Generador de numeros aleatorios
  const gsl_rng_type * Y;
  gsl_rng * r;
  gsl_rng_env_setup();
  Y = gsl_rng_default;
  r = gsl_rng_alloc (Y);
  
  do
    {
      gsl_multiroot_function f = {&sis_estaticaRig, n, &p};
      iter = 0 ;
      for (k = 0; k < nvar; k++)
	{
	  if ( aumento <= 30 )
	    {
	      nuevoValor = 100 ;
	    }
	  else
	    {
	      nuevoValor = 1000 ;
	    }
	  
	  par = nuevoValor*(gsl_rng_uniform (r)) ;
	  gsl_vector_set (x, k, par) ;
	}
      
      T = gsl_multiroot_fsolver_hybrids;
      s = gsl_multiroot_fsolver_alloc (T, nvar);
      gsl_multiroot_fsolver_set (s, &f, x);
      
      do
	{
	  iter++;
	  estadoInt = gsl_multiroot_fsolver_iterate (s);
	  
	  if (estadoInt)
	    break;
	  
	  estado = gsl_multiroot_test_residual (s->f, 1e-7);
	}
      while (estado == GSL_CONTINUE && iter < 1000);  
      
      //Se verifica el estado
      if ( (estadoInt) && (aumento < 60) )
	{
	  aumento = aumento + 1 ;
	  continuar = YES ;
	}
      else
	{
	  continuar = NO ;
	}
      //Se termina la verificacion
    }
  while (continuar) ;
  //se termino la busqueda de la solucion
  
  //Se pasan los datos al array Resultados
  varCount = [variables objectEnumerator] ;
  beamStatus = [NSMutableArray array];
  
  while ((unObj = [varCount nextObject]))
    {
      [resultados addObject: [NSNumber numberWithDouble: gsl_vector_get (s->x, countRes)] ] ;
      [beamStatus addObject: [NSString stringWithString: @""]];
      countRes = countRes + 1 ;
    }
  
  //Se corrigen signos en los datos
  signoObj = [diccionario objectEnumerator] ;
  
  int par1, w, g, signo;
  double nv, nf;
  while ((datoSigno = [signoObj nextObject]))
    {
      par1 = 0;
      w = 0;
      g = 0;
      signo = 1;
      nv = 0;
      nf = 0;

      tipoOtro = [datoSigno objectForKey: @"Tipo"] ;
      
      switch ([tipoOtro intValue])
	{
	case 252:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify the angle of the beam
	    if ([variables containsObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 3] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if ( nv > 180 )
		  {
		    nv = nv - floor(nv/180)*180 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/180) + 1)*180 ;                
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 253:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify the angle of the solid
	    if ([variables containsObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 4] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if ( nv > 180 )
		  {
		    nv = nv - floor(nv/180)*180 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/180) + 1)*180 ;
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 257 ... 260:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify the angle of the force
	    if ( ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]]) &&
		 ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) )
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];
		
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		if ( (nv > 180) && (nv < 270) )
		  {
		    signo = -1;
		    nv = nv - 180;
		  }
		
		[resultados replaceObjectAtIndex: g withObject: [NSNumber numberWithDouble: signo*nf]];
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];
	      }
	    else if ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]];
		nv = [[resultados objectAtIndex: w] doubleValue];
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];
	      }
	  }
	  break;
	case 265 ... 268:
	  {
	    /* We check the angle of the friction force. Although this don't have sense.
	       If the user apply a friction force we expect that the user provide the angle. */
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    if ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 273:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify the sign of the resultant
	    if ( ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) &&
		 ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]]) )
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
		
		if ( [[resultados objectAtIndex: g] doubleValue] < 0 )
		  {
		    nf = -1*[[resultados objectAtIndex: g] doubleValue];
		    [resultados replaceObjectAtIndex: g withObject: [NSNumber numberWithDouble: nf]];
		    par1 = 1;
		  }

		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]];
		nv = [[resultados objectAtIndex: w] doubleValue];
		
                if ( par1 == 1 )
		  {
		    nv = nv + 180;
		  }
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360;
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];
	      }
	    else if ([variables containsObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 2] stringByTrimmingSpaces]];
		nv = [[resultados objectAtIndex: w] doubleValue];
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]] ;
	      }
	  }
	  break;
	case 277 ... 280:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify oblique 2 forces beam
	    if ( ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]]) &&
		 ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) )
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];
		
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		if ( (nv > 180) && (nv < 270) )
		  {
		    signo = -1;
		    nv = nv - 180;
		  }
		
		[resultados replaceObjectAtIndex: g withObject: [NSNumber numberWithDouble: signo*nf]];
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];

		if (signo*nf > 0)
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[compression] ")]];
		  }
		else
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[tension] ")]];
		  }
	      }
	    else if ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]];
		nv = [[resultados objectAtIndex: w] doubleValue];
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];
	      }
	    else if ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];

		if (nf > 0)
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[compression] ")]];
		  }
		else
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[tension] ")]];
		  }
	      }
	  }
	  break;
	case 281 ... 284:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify horizontal and vertical 2 forces beam
	    if ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];
		
		if (nf > 0)
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[compression] ")]];
		  }
		else
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[tension] ")]];
		  }
	      }
	  }
	  break;
	case 285 ... 288:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify oblique truss's beam
	    if ( ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]]) &&
		 ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]]) )
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];
		
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]] ;
		nv = [[resultados objectAtIndex: w] doubleValue] ;
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
		if ( (nv > 180) && (nv < 270) )
		  {
		    signo = -1;
		    nv = nv - 180;
		  }
		
		[resultados replaceObjectAtIndex: g withObject: [NSNumber numberWithDouble: signo*nf]];
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];

		if (signo*nf > 0)
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[tension] ")]];
		  }
		else
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[compression] ")]];
		  }
	      }
	    else if ([variables containsObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]])
	      {
		w = [variables indexOfObject: [[verifSigno objectAtIndex: 1] stringByTrimmingSpaces]];
		nv = [[resultados objectAtIndex: w] doubleValue];
		
                if ( nv > 360 )
		  {
		    nv = nv - floor(nv/360)*360 ;
		  }
		
                if ( nv < 0 )
		  {
		    nv = nv + (floor(-1*nv/360) + 1)*360 ;                
		  }
		
                [resultados replaceObjectAtIndex: w withObject: [NSNumber numberWithDouble: nv]];
	      }
	    else if ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];

		if (nf > 0)
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[tension] ")]];
		  }
		else
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[compression] ")]];
		  }
	      }
	  }
	  break;
	case 289 ... 292:
	  {
	    verifSigno = [datoSigno objectForKey: @"Valores"] ;
	    
	    //Verify horizontal and vertical truss's beam
	    if ([variables containsObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		g = [variables indexOfObject: [[verifSigno objectAtIndex: 0] stringByTrimmingSpaces]] ;
		nf = [[resultados objectAtIndex: g] doubleValue];
		
		if (nf > 0)
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[tension] ")]];
		  }
		else
		  {
		    [beamStatus replaceObjectAtIndex: g withObject: [NSString stringWithString: _(@"[compression] ")]];
		  }
	      }
	  }
	  break;
	}
    } 
  
  //Se imprimen los resultados
  [self printUnknowns: variables withResults: resultados withStatus: beamStatus];
  
  //Se imprime el estado del calculo        
  mensaje = [NSString stringWithFormat: [errores objectAtIndex: 5], gsl_strerror (estado)];
  longitud = [[[self visor] textStorage] length];
  [[self visor] replaceCharactersInRange:NSMakeRange(longitud,0)withString: mensaje] ;
  
  gsl_multiroot_fsolver_free (s);
  gsl_vector_free (x);
  gsl_rng_free (r);
}
@end

@implementation estaticaRigida

- (id) init
{
  NSBundle *mensajes;
  self = [super init];
  
  variables = [NSMutableArray array] ;
  [variables retain] ;
  codObjetos = [NSMutableArray array] ;
  [codObjetos retain] ;
  nomObjetos = [NSMutableArray array] ;
  [nomObjetos retain] ;
  codSolidos = [NSMutableArray array] ;
  [codSolidos retain] ;
  nomSolidos = [NSMutableArray array] ;
  [nomSolidos retain] ;
  tipoElemt = [NSMutableArray array];
  [tipoElemt retain];
  fuerObj = [NSMutableArray array] ;
  [fuerObj retain] ;
  tipoFuer = [NSMutableArray array] ;
  [tipoFuer retain] ;
  resultante = [NSMutableArray array] ;
  [resultante retain] ;
  tipoFuerSol = [NSMutableArray array] ;
  [tipoFuerSol retain] ;
  codElemResul = [NSMutableArray array] ;
  [codElemResul retain] ;
  codResul = [NSMutableArray array] ;
  [codResul retain] ;
  codOtros = [NSMutableArray array] ;
  [codOtros retain] ;
  
  //Se crea el array de mensajes
  mensajes = [NSBundle mainBundle] ;
  errores = [[NSArray alloc] initWithContentsOfFile: [mensajes pathForResource: @"estaticaRigidaMensajes" ofType: @"plist"] ] ;
  
  return self;
}

- (void) crearEcuaciones: (NSMutableDictionary *)lista
{
  int width, height, totalCells; //For handle the chalkboard size
  int longitud, numEcuaciones = 0, numFuerzas = 0, numeroError = 0;
  NSUInteger sistema = [self system];
  BOOL error = NO;
  BOOL errorSolid = NO;
  BOOL errorNomb = NO;
  BOOL errorNombElem = NO;
  BOOL errorElement = NO;
  BOOL errorNumero = NO;
  BOOL errorEnSolido = NO;
  BOOL errorTipo = NO;
  BOOL errorFuerza = NO;
  BOOL errorResultante = NO;
  BOOL errorNudo = NO;
  BOOL errorAngles = NO;
  NSNumber *identificador, *codigo ;
  //NSString *mensaje ;
  NSMutableArray *codFuerzas = [NSMutableArray array] ;
  NSMutableArray *codFuerzasObj = [NSMutableArray array] ;
  NSArray *keys;
  NSEnumerator *cuenta;
  NSTextView *estaticaRigInfo = [self visor];
  NSArray *ordenObjetos = [self cells];
  //Para determinar las fuerzas que actuan en los objetos
  int k ; 
  NSButton *celda ;
  
  varG = 0 ;
  gravedadDat = 0 ;

  //For handle the chalkboard size
  width = [self chalkboardWidth];
  height = [self chalkboardHeight];
  totalCells = width*height - 1;
  
  diccionario = [[NSMutableDictionary alloc] initWithDictionary: lista] ;
  keys = [[NSArray alloc] initWithArray: [lista allKeys]] ;
  cuenta = [keys objectEnumerator] ;
  
  
  while ((codigo = [cuenta nextObject]) && !error)
    {
      int x ;
      NSString *key ;
      NSArray *terminos ;
      NSNumber *numero ;
      NSArray *titulos = [[diccionario objectForKey: codigo] objectForKey: @"Titulos"] ;
      NSMutableArray *datos = [[diccionario objectForKey: codigo] objectForKey: @"Datos"] ;
      NSMutableArray *valores = [[diccionario objectForKey: codigo] objectForKey: @"Valores"] ;

      //Se determinan las fuerzas que actuan en cada objeto
      int pos ;
      NSNumber *ident ;
      NSEnumerator *busq;
      
      identificador = [[diccionario objectForKey: codigo] objectForKey: @"Tipo"] ;
      [valores removeAllObjects] ;
      
      //Cuenta la cantidad de variables en el sistema
      for (x = 0; x < [datos count]; x++)
	{
	  NSString *data = [[datos objectAtIndex: x] stringByTrimmingSpaces];
	  NSString *title = [[titulos objectAtIndex: x] description];
	  
	  if (![self isNumericDataTheString: data] &&
	      ![title isEqualToString: _(@"Name")] &&
	      ![title isEqualToString: _(@"Points")] &&
	      ![title isEqualToString: _(@"Beam")] &&
	      ![title isEqualToString: _(@"Solid")] &&
	      ![title isEqualToString: _(@"Truss")])
	    {
	      if ([self hasConversionTheString: data])
		{
		  terminos = [[datos objectAtIndex: x] componentsSeparatedByString: @"@"] ;
		  key = [[terminos objectAtIndex: 1] stringByTrimmingSpaces] ;
		  
		  if ([[[self conversions] allKeys] containsObject: key])
		    {
		      
		      if ([self isNumericDataTheString: [[terminos objectAtIndex: 0] stringByTrimmingSpaces]])
                        {
			  numero = [NSNumber numberWithDouble: [[terminos objectAtIndex: 0] doubleValue]*[[[self conversions] objectForKey: key] doubleValue] ] ;
			  [valores addObject: [numero stringValue]] ;
                        }
		      else
                        {
			  NSString *var = [[terminos objectAtIndex: 0] stringByTrimmingSpaces] ;
			  var = [var stringByAppendingString: @"@"] ;
			  var = [var stringByAppendingString: [[terminos objectAtIndex: 1] stringByTrimmingSpaces]] ;
			  
			  [valores addObject: var] ;
			  if (![variables containsObject: var])
			    {
			      [variables addObject: var] ;
			    }
			  
                        }
		    }
		  else
		    {
                      NSString *anuncio = [NSString stringWithFormat: [errores objectAtIndex: 0], [key cString]] ;
                      error = YES ;
		      numeroError = 0;
		      
		      longitud = [[estaticaRigInfo textStorage] length];
                      [estaticaRigInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: anuncio] ;
		    }
		  
		}
	      else
		{
		  //Se agrega una variable simple 
		  NSString *varTit, *varFactor ;   
		  NSString *var = [[datos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  //Se determina el tipo de variable
		  varTit = [[titulos objectAtIndex: x] stringByTrimmingSpaces] ;
		  
		  if ([varTit hasPrefix: @"m"])
		    {
		      if (sistema== 0)
			{ varFactor = [NSString stringWithString: @"kg"] ; }
		      else
			{ varFactor = [NSString stringWithString: @"slug"] ; } 
		    }
		  else if ([varTit hasPrefix: @"f"] || [varTit hasPrefix: @"N"] || 
			   [varTit hasPrefix: @"t"])
		    {
		      if (sistema== 0)
			{ varFactor = [NSString stringWithString: @"N"] ; }
		      else
			{ varFactor = [NSString stringWithString: @"lb"] ; }
		    }
		  else if ([varTit hasPrefix: @"ang"])
		    {
		      varFactor = [NSString stringWithString: _(@"grados")] ;
		    }
		  else if ([varTit hasPrefix: @"g"])
		    {
		      if (sistema== 0)
			{ varFactor = [NSString stringWithString: @"m/s2"] ; }
		      else
			{ varFactor = [NSString stringWithString: @"ft/s2"] ; }
		    }
		  else if ([varTit hasPrefix: @"x"] || [varTit hasPrefix: @"y"] || 
			   [varTit hasPrefix: @"lc"] || [varTit hasPrefix: @"l"])
		    {
		      if (sistema== 0)
			{ varFactor = [NSString stringWithString: @"m"] ; }
		      else
			{ varFactor = [NSString stringWithString: @"ft"] ; }
		    }
		  else if ([varTit hasPrefix: @"M"])
		    {
		      if (sistema== 0)
			{ varFactor = [NSString stringWithString: @"N*m"] ; }
		      else
			{ varFactor = [NSString stringWithString: @"lb*ft"] ; }
		    }
		  else
		    {
		      varFactor = [NSString stringWithString: @"ad"] ; 
		    }
		  //Termina la busqueda del tipo de variable
		  
		  var = [var stringByAppendingString: @"@"] ;
		  var = [var stringByAppendingString: varFactor] ;
		  
		  [valores addObject: var] ;
		  if (![variables containsObject: var])
		    {
		      [variables addObject: var] ;
		    }
		  
		  //Se ha agregado la variable simple   
		}
	    }
          else
	    {
	      [valores addObject: [datos objectAtIndex: x]] ;
	    }
	}    
      //Fin del conteo de variables
      
      if (error)
	break ;
      
      //Determina la variable de la gravedad y el numero de ecuaciones
      switch ([identificador intValue])
	{
	case 250:
	  {
	    if (![self isNumericDataTheString: [[valores objectAtIndex: 0] stringByTrimmingSpaces]])
	      {
		gravedadVar = [[valores objectAtIndex: 0] stringByTrimmingSpaces] ;
		varG = 1 ;
	      }
	    else
	      {
		gravedadDat = [[valores objectAtIndex: 0] doubleValue] ;
		varG = 2 ;
	      }
	  }
	  break;
	case 251:
	  {
	    NSString *nombre = [[datos objectAtIndex: 0] stringByTrimmingSpaces] ;
	    if (![nombre isEqualToString: @"0"] && ![nombre isEqualToString: @""])
	      {
		[nomObjetos addObject: nombre] ;
		[codObjetos addObject: codigo] ;
	      }
	    else
	      {
		errorNombElem = YES;
		numeroError = 7;
	      }
	  }    
	  break;
	case 252:
	case 253:
	case 276:
	case 293:
	  {
	    NSString *nombre = [[datos objectAtIndex: 0] stringByTrimmingSpaces] ;

	    if ([identificador intValue] != 293)
	      {
		numEcuaciones = numEcuaciones + 3;
	      }

	    if (![nomSolidos containsObject: nombre] && ![nombre isEqualToString: @"0"] && ![nombre isEqualToString: @""])
	      {
		[nomSolidos addObject: nombre];
		[codSolidos addObject: codigo];
	      }
	    else
	      {
		errorNomb = YES;
		numeroError = 6;
	      } 
	  }
	  break;
	case 254:
	  {
	    numFuerzas = numFuerzas + 1 ;
	    [codFuerzas addObject: codigo] ;
	  }
	  break;
	case 255:
	case 256:
	case 294:
	  {
	    NSString *nombre = [[datos objectAtIndex: 0] stringByTrimmingSpaces] ;

	    if ([identificador intValue] == 294)
	      {
		numEcuaciones = numEcuaciones + 2;
	      }

	    if (![nombre isEqualToString: @"0"] && ![nombre isEqualToString: @""])
	      {
		[nomObjetos addObject: nombre] ;
		[codObjetos addObject: codigo] ;
	      }
	    else
	      {
		errorNombElem = YES;
		numeroError = 7;
	      }
	  }
	  break;
	case 257 ... 272:
	  {
	    numFuerzas = numFuerzas + 1 ;
	    [codFuerzas addObject: codigo] ;
	  }
	  break;
	case 273 ... 275:
	  {
	    numFuerzas = numFuerzas + 1 ;
	    [codFuerzas addObject: codigo] ;
	  }
	  break;
	case 277 ... 292:
	  {
	    //Elementos de 2 fuerzas y vigas de armadura
	    numFuerzas = numFuerzas + 1 ;
	    [codFuerzas addObject: codigo] ;
	  }
	  break;
	case 295:
	  {
	    //Relation of angles
	    if (![self isNumericDataTheString: [[valores objectAtIndex: 0] stringByTrimmingSpaces]] &&
		![self isNumericDataTheString: [[valores objectAtIndex: 1] stringByTrimmingSpaces]])
	      {
		numEcuaciones = numEcuaciones + 1;
		[codOtros addObject: codigo];
	      }
	    else
	      {
		errorAngles = YES;
		numeroError = 16;
	      }
	  }
	  break;
	}
      //Fin del conteo de ecuaciones
      
      if (errorNomb || errorNombElem || errorNudo || errorAngles)
	break ;
      
      busq = [ordenObjetos objectEnumerator] ;
      
      if ( ([identificador intValue] == 251) || ([identificador intValue] == 255) || ([identificador intValue] == 256) || ([identificador intValue] == 294) )
	{
	  NSMutableArray *fuerzas = [NSMutableArray array] ;
	  //Para determinar el tipo de fuerzas aplicadas al objeto
	  int tipo, fuerHoriz = 0, fuerVert = 0, pares = 0, resul = 0;   
	  NSNumber *fuerTipo ;  
	  NSEnumerator *verif ;
	  k = 0 ;
	  pos = 0 ;
	  
	  while ((celda = [busq nextObject]))
	    {
	      if ([celda tag] == [codigo intValue])
		{
		  pos = k ;
		  break ;
		}
	      k = k + 1 ;   
	    }
	  
	  
	  if ( (pos%width != 0) && (pos%width != (width - 1)) )
	    {
	      if (pos - 1 >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
		  if([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos - (width - 1) >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width - 1)] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos - width >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - width] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos - (width + 1) >= 0)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width + 1)] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos + 1 <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos + (width - 1) <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width - 1)] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos + width <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + width] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	      
	      if (pos + (width + 1) <= totalCells)
		{
		  ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width + 1)] tag]] ;
		  if ([ident intValue] != 0)
		    { [fuerzas addObject: ident] ; }
		}
	    }
	  else
	    {
	      if (pos%width == 0)
		{
		  if (pos - (width - 1) >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width - 1)] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos - width >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - width] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos + 1 <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + 1] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos + width <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + width] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos + (width + 1) <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width + 1)] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		}
	      else
		{
		  if (pos - 1 >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - 1] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos - width >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - width] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos - (width + 1) >= 0)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos - (width + 1)] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos + (width - 1) <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + (width - 1)] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		  
		  if (pos + width <= totalCells)
		    {
		      ident = [NSNumber numberWithInt: [[ordenObjetos objectAtIndex: pos + width] tag]] ;
		      if ([ident intValue] != 0)
			{ [fuerzas addObject: ident] ; }
		    }
		}
	    }
	  
	  
	  //Se determina el tipo de fuerzas aplicadas al objeto
	  if ( (([identificador intValue] == 251) || ([identificador intValue] == 255) || ([identificador intValue] == 256)) && ([fuerzas count] > 0) )
	    {
	      verif = [fuerzas objectEnumerator] ;
              while ((fuerTipo = [verif nextObject]))
		{
		  int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;
		  if ( (t == 261) || (t == 262) || (t == 269) || (t == 270) || (t == 274)
		       || (t == 281) || (t == 282) )
		    {
		      fuerHoriz = fuerHoriz + 1 ;
		    }
		  
		  if ( (t == 263) || (t == 264) || (t == 271) || (t == 272) || (t == 275) 
		       || (t == 283) || (t == 284) )
		    {
		      fuerVert = fuerVert + 1 ;
		    }
		  
		  if (t == 254)
		    {
		      pares = pares + 1;
		    }
		  
		  if ( (t >= 273) && (t <= 275) )
		    {
		      resul = resul + 1;
		    }
		}
	      
	      /* We classify the elements according with the kind 
		 of forces applied: 
		 1) Couples and general forces.
		 2) Couples and horizontal forces.
		 3) Couples and vertical forces.
		 4) Only couples. 
		 Even if there are only horizontal or vertical forces. 
		 We asume that there are couples since we assume that 
		 not all are applied along the same line.*/
              if ([fuerzas count] == pares)
		{
		  tipo = 4;
		}
              else
		{
                  if ([fuerzas count] == (fuerVert + pares))
		    {
		      tipo = 3;
		    }
                  else
		    {
		      if ([fuerzas count] == (fuerHoriz + pares))
			{
			  tipo = 2;
			}
		      else
			{
			  tipo = 1;
			}
		    }
		}
	      
	      [tipoFuer addObject: [NSNumber numberWithInt: tipo]];
	      [resultante addObject: [NSNumber numberWithInt: resul]];
	    }

	  //Se determina el tipo de fuerzas y vigas aplicadas al nudo
	  if ( ([identificador intValue] == 294) && ([fuerzas count] > 0) )
	    {
	      verif = [fuerzas objectEnumerator] ;
              while ((fuerTipo = [verif nextObject]))
		{
		  int t = [[[diccionario objectForKey: fuerTipo] objectForKey: @"Tipo"] intValue] ;

		  if ( !((t >= 285) && (t <= 292)) )
		    {
		      if ( !((t >= 257) && (t <= 264)) )
			{
			  errorNudo = YES;
			  numeroError = 14;
			  break;
			}
		    }

		  if ( (t == 261) || (t == 262) || (t == 289) || (t == 290) )
		    {
		      fuerHoriz = fuerHoriz + 1 ;
		    }

		  if ( (t == 263) || (t == 264) || (t == 291) || (t == 292) )
		    {
		      fuerVert = fuerVert + 1 ;
		    }
		}

	      /* We don't allow all forces are applied along one axis, since we 
		 require 2 equations. This is the expected in a Truss's joint. */
	      if ((fuerHoriz == [fuerzas count]) || (fuerVert == [fuerzas count]))
		{
		  errorNudo = YES;
		  numeroError = 15;
		}

	      /* Even when each joint have only two equations. We add here (1) 
		 just to be consistent with the size of arrays, but this value 
		 is not used. The equations for each joint are write 
		 automatically, since this is we expect.*/
	      [tipoFuer addObject: [NSNumber numberWithInt: 1]];
	      [resultante addObject: [NSNumber numberWithInt: 0]];
	    }
	  
	  
	  if ([fuerzas count] > 0)
	    {
	      [fuerObj addObject: fuerzas]; 
	    }
	}
    }
  
  
  if (!error && !errorNomb && !errorNombElem && !errorNudo && !errorAngles)
    {
      //Se verifica que hayan solidos definidos
      if ([codSolidos count] == 0)
	{
	  errorSolid = YES;
	  numeroError = 8;
	}
      else
	{
	  //Se verifican los elementos de cada solido
	  int j, q, cantidad;
	  id compNomb;
	  NSEnumerator *compElemt = [nomObjetos objectEnumerator];
	  NSMutableArray *conteoElemt = [NSMutableArray array];
	  
	  for (j = 0; j < [nomSolidos count]; j++)
	    {
	      [conteoElemt addObject: [NSNumber numberWithInt: 0]];
	    }
	  
	  while ((compNomb = [compElemt nextObject]))
	    {
	      if ([nomSolidos containsObject: [compNomb description]])
		{
		  q = [nomSolidos indexOfObject: [compNomb description]];
		  cantidad = [[conteoElemt objectAtIndex: q] intValue] + 1;
		  [conteoElemt replaceObjectAtIndex: q withObject: [NSNumber numberWithInt: cantidad]];
		}
	      else
		{
		  errorElement = YES;
		  numeroError = 9;
		}
	    }
	  
	  if (!errorElement)
	    {
	      //Se comprueba que los solidos esten compuestos de mas de un elemento
	      int tipoSolidoNum;
	      NSNumber *elementosSolido;
	      NSEnumerator *comprob = [conteoElemt objectEnumerator];
	      j = 0;
	      while ((elementosSolido = [comprob nextObject]))
		{
		  tipoSolidoNum = [[[diccionario objectForKey: [codSolidos objectAtIndex: j]] objectForKey: @"Tipo"] intValue];
		  
		  if ((tipoSolidoNum == 276) && ([elementosSolido intValue] <= 1))
		    {
		      errorNumero = YES;
		      numeroError = 10;
		    }
		  
		  if (((tipoSolidoNum == 252) || (tipoSolidoNum == 253)) && ([elementosSolido intValue] == 0))
		    {
		      errorNumero = YES;
		      numeroError = 10;
		    }

		  if ((tipoSolidoNum == 293) && ([elementosSolido intValue] <= 2))
		    {
		      errorNumero = YES;
		      numeroError = 10;
		    }
		  
		  j++;
		}
	      
	      if (!errorNumero)
		{
		  id tipoPunto;
		  NSNumber *tipoSolidElem;
		  NSEnumerator *verifTipo;
		  
		  /*Se comprueba que los elementos de un solido sean del mismo tipo*/
		  for (j = 0; j < [nomSolidos count]; j++)
		    {
		      [tipoElemt addObject: [NSMutableArray array]];
		    }
		  
		  j = 0;
		  comprob = [nomObjetos objectEnumerator];
		  while ((compNomb = [comprob nextObject]))
		    {
		      q = [nomSolidos indexOfObject: [compNomb description]];
		      [[tipoElemt objectAtIndex: q] addObject: [codObjetos objectAtIndex: j]];
		      j++;
		    }
		  
		  comprob = [tipoElemt objectEnumerator];
		  while ((compNomb = [comprob nextObject]))
		    {
		      j = 0;
		      verifTipo = [compNomb objectEnumerator];
		      q = [[[diccionario objectForKey: [compNomb objectAtIndex: 0]] objectForKey: @"Tipo"] intValue];
		      
		      while ((tipoPunto = [verifTipo nextObject]))
			{
			  tipoSolidElem = [[diccionario objectForKey: tipoPunto] objectForKey: @"Tipo"];
			  
			  if (q == [tipoSolidElem intValue])
			    {
			      j++;
			    }
			}
		      
		      if (j != [compNomb count])
			{
			  errorEnSolido = YES;
			  numeroError = 11;
			  break;
			}
		    }
		  
		  if (!errorEnSolido)
		    {
		      NSNumber *compTipo, *tipoSold, *tipoElem;
		      /*Se verifica que los componentes del solido correspondan a este*/
		      comprob = [codSolidos objectEnumerator];
		      j = 0;
		      
		      while ((compTipo = [comprob nextObject]))
			{
			  tipoSold = [[diccionario objectForKey: compTipo] objectForKey: @"Tipo"];
			  tipoElem = [[diccionario objectForKey: [[tipoElemt objectAtIndex: j] objectAtIndex: 0]] objectForKey: @"Tipo"];
			  
			  if ( ([tipoSold intValue] == 252) && ([tipoElem intValue] != 255) )
			    {
			      errorTipo = YES;
			      numeroError = 12;
			      break;
			    }
			  
			  if ( ([tipoSold intValue] == 253) && ([tipoElem intValue] != 256) )
			    {
			      errorTipo = YES;
			      numeroError = 12;
			      break;
			    }
			  
			  if ( ([tipoSold intValue] == 276) && ([tipoElem intValue] != 251) )
			    {
			      errorTipo = YES;
			      numeroError = 12;
			      break;
			    }

			  if ( ([tipoSold intValue] == 293) && ([tipoElem intValue] != 294) )
			    {
			      errorTipo = YES;
			      numeroError = 12;
			      break;
			    }
			  
			  j++;
			}
		      
		      if (!errorTipo)
			{
			  //Se verifica que todos los elementos tengan fuerzas aplicadas
			  if ([codObjetos count] != [fuerObj count])
			    {
			      errorFuerza = YES;
			      numeroError = 4;
			    }
			  else
			    {
			      /*Se verifica que no haya mas de una resultante aplicada a los solidos
				y si todas las fuerzas aplicadas al solido son horizontales o verticales*/
			      int numResults, elementsH, elementsV, elementsPair, tipoF, tipoSolido;
			      NSNumber *elemento, *tipoFS = nil, *codObjRes;
			      NSMutableArray *elementosSolido;
			      NSEnumerator *comprob, *compElem;
			      j = 0;
			      
			      comprob = [tipoElemt objectEnumerator];
			      while ((elementosSolido = [comprob nextObject]))
				{
				  numResults = 0;
				  elementsH = 0;
				  elementsV = 0;
				  elementsPair = 0;
				  codObjRes = nil;

				  tipoSolido = [[[diccionario objectForKey: [codSolidos objectAtIndex: j]] objectForKey: @"Tipo"] intValue];
				  
				  compElem = [elementosSolido objectEnumerator];
				  while ((elemento = [compElem nextObject]))
				    {
				      q = [codObjetos indexOfObject: elemento];
				      numResults = numResults + [[resultante objectAtIndex: q] intValue];
				      tipoF = [[tipoFuer objectAtIndex: q] intValue];
				      
				      if (tipoF == 2)
					{
					  elementsH++; 
					}
				      
				      if (tipoF == 3)
					{
					  elementsV++;
					}
				      
				      if (tipoF == 4)
					{
					  elementsPair++;
					}
				      
				      //Se guarda el codigo del elemento que tiene la resultante, si la hay
				      if ([[resultante objectAtIndex: q] intValue] == 1)
					{
					  codObjRes = elemento; 
					}
				    }
				  
				  if (numResults >= 2)
				    {
				      errorResultante = YES;
				      numeroError = 13;
				      break;
				    }
				  else
				    {
				      //Se agrega el codigo del elemento con la resultante a codResul, si hay
				      if (codObjRes != nil)
					{
					  [codResul addObject: codObjRes];
					}
				      else
					{
					  [codResul addObject: [NSNull null]];
					}
				    }
				  

				  if ( (elementsPair == [elementosSolido count]) && 
				       (tipoSolido == 276) )
				    {
				      /* If only couples are applied to the solid. Then 
					 we have one equation, since a solid made with 
					 points don't have weight. */
				      numEcuaciones = numEcuaciones - 2;
				      tipoFS = [NSNumber numberWithInt: 4];
				    }
				  else if ((elementsH + elementsPair) == [elementosSolido count])
				    {
				      /* Even if "elementsPair" is zero, we expect a moment 
					 equation, since we expect the forces aren't applied 
					 along a line. */
				      if (tipoSolido == 276)
					{
					  numEcuaciones--;
					  tipoFS = [NSNumber numberWithInt: 2];
					}
				      else
					{
					  /* We need 3 equation if is a Beam or a Solid. Since 
					     there is a weight and we need vertical forces. 2 
					     equations are only allowed in Points since there 
					     is no weight. See above. */
					  tipoFS = [NSNumber numberWithInt: 1];
					}
				    }
				  else if ((elementsV + elementsPair) == [elementosSolido count])
				    {
				      /* Even if "elementsPairs" is zero, we expect a moment equation, 
					 since we expect the forces aren't applied along a 
					 line. */
				      numEcuaciones--;
				      tipoFS = [NSNumber numberWithInt: 3];
				    }
				  else
				    {
				      if (tipoSolido == 293)
					{
					  /* The value 5 is for not write equations. 
					     A Truss not need equations, only its 
					     joints. */
					  tipoFS = [NSNumber numberWithInt: 5];
					}
				      else
					{
					  tipoFS = [NSNumber numberWithInt: 1];
					}
				    }
				  
				  [tipoFuerSol addObject: tipoFS];
				  j++;
				}
			    }
			}
		    }
		}
	    }
	}
    }
  
  //Se verifica que no hayan errores
  if (!error && !errorFuerza && !errorNomb && !errorNombElem && !errorSolid && !errorElement && !errorNumero && !errorEnSolido && !errorTipo && !errorResultante && !errorNudo && !errorAngles)
    {
      //Se realiza el conteo de las fuerzas aplicadas 
      int v ;
      int w = 0 ;
      NSEnumerator *compro;
      NSNumber *fuer ;
      for (v = 0; v < [codObjetos count]; v++)
	{
	  [codFuerzasObj addObjectsFromArray: [fuerObj objectAtIndex: v]] ;  
	}
      
      //Se verifica cuantas de las fuerzas existentes estan aplicadas a objetos
      compro = [codFuerzas objectEnumerator] ;
      while ((fuer = [compro nextObject]))
	{
	  if ([codFuerzasObj containsObject: fuer])
	    {
	      w = w + 1 ;
	    }
	}
      
      //Ultimas verificaciones        
      if ([variables count] == numEcuaciones)
	{
	  if ( (w == [codFuerzas count]) && (w == [codFuerzasObj count]) )
	    {
	      [self crearSistema] ;
	    }
	  else
	    {
	      NSString *advertencia = nil;
	      
	      if (w < [codFuerzas count])
		{
		  advertencia = [NSString stringWithString: [errores objectAtIndex: 1]] ;
		}
	      
	      if (w < [codFuerzasObj count])
		{
		  advertencia = [NSString stringWithString: [errores objectAtIndex: 2]] ;
		}
	      
	      longitud = [ [estaticaRigInfo textStorage] length];
	      [estaticaRigInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: advertencia] ;
	    }
	}
      else
	{
	  longitud = [ [estaticaRigInfo textStorage] length];
	  [estaticaRigInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: 3]] ;        
	}
    }
  else
    {
      if (!error)
	{      
	  longitud = [ [estaticaRigInfo textStorage] length];
	  [estaticaRigInfo replaceCharactersInRange:NSMakeRange(longitud,0)withString: [errores objectAtIndex: numeroError]] ; 
	}
    }
  
  RELEASE(keys);
}

- (void) dealloc
{
  RELEASE(diccionario) ;
  RELEASE(variables) ;
  RELEASE(nomObjetos) ;
  RELEASE(codObjetos) ;
  RELEASE(nomSolidos) ;
  RELEASE(codSolidos) ;
  RELEASE(tipoElemt) ;
  RELEASE(fuerObj) ;
  RELEASE(tipoFuer) ;
  RELEASE(resultante) ;
  RELEASE(tipoFuerSol) ;
  RELEASE(codElemResul);
  RELEASE(codResul);
  RELEASE(codOtros);
  RELEASE(errores) ;
  [super dealloc] ;
}

@end
