#
#   base.make
#
#   Makefile flags and configs to build with the base library.
#
#   Copyright (C) 2001 Free Software Foundation, Inc.
#
#   Author:  Nicola Pero <n.pero@mi.flashnet.it>
#   Based on code originally in the gnustep make package
#
#   This file is part of the GNUstep Base Library.
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#   
#   You should have received a copy of the GNU General Public
#   License along with this library; see the file COPYING.LIB.
#   If not, write to the Free Software Foundation,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

ifeq ($(BASE_MAKE_LOADED),)
  BASE_MAKE_LOADED=yes

  ifeq ($(FOUNDATION_LIB),gnu)
    #
    # FIXME - macro names
    #
    AUXILIARY_OBJCFLAGS += -fconstant-string-class=NSConstantString
    ifeq ($(shared),no)
      CONFIG_SYSTEM_LIBS += -lgmp   -lgnutls   -lgcrypt -lxslt -lxml2 -lffi -lnsl -lrt -ldl  -lpthread -lz -licui18n -licuuc -licudata 
      CONFIG_SYSTEM_LIB_DIR +=  -L/home/german/standalone -L/home/german/standalone -L/home/german/standalone -L/home/german/build/lib/ -L/usr/local/lib 
    endif

    GNUSTEP_BASE_VERSION = 1.23.1
    GNUSTEP_BASE_MAJOR_VERSION = 1
    GNUSTEP_BASE_MINOR_VERSION = 23
    GNUSTEP_BASE_SUBMINOR_VERSION = 1

    FND_LDFLAGS =
    FND_LIBS = -lgnustep-base
    FND_DEFINE = -DGNUSTEP_BASE_LIBRARY=1
    GNUSTEP_DEFINE = -DGNUSTEP
  else
    #
    # Not using the GNUstep foundation ... must be Apple's
    # So we need to use the base additions library.
    #
    FND_LIBS = -lgnustep-baseadd -framework Foundation
  endif

  # For literal string handling, base requires the compiler to store the
  # string as UTF-8
  AUXILIARY_OBJCFLAGS += -fexec-charset=UTF-8

  GNUSTEP_BASE_HAVE_GNUTLS=1
  GNUSTEP_BASE_HAVE_LIBXML=1
  GNUSTEP_BASE_HAVE_MDNS=0
  GNUSTEP_BASE_HAVE_AVAHI=0
  GNUSTEP_BASE_HAVE_UCI=@HAVE_UCI@

  # If we determined that the Objective-C runtime does not support
  # native Objective-C exceptions, turn them off.  This overrides
  # the USE_OBJC_EXCEPTIONS setting in gnustep-make's config.make.
  ifeq (1, 0)
    USE_OBJC_EXCEPTIONS = no
  endif

endif # BASE_MAKE_LOADED
