/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "loopmarker.h"

LoopMarker::LoopMarker(QCanvas* canvas, int lr)
 : QCanvasPolygonalItem(canvas)
{
    samplePos=0;
    side=lr;
    moving=FALSE;
    setZ(0);
}


LoopMarker::~LoopMarker()
{
}

void LoopMarker::drawShape ( QPainter & p ){
    QFont font;
    font.setPointSize(6);
    font.setBold(TRUE);
    p.setFont(font);
    if(side==LEFT_MARKER){
        if(x()>=10){
            QRect rect((int)x()-10,0,10,10);
            p.fillRect(rect,QBrush::red);
            p.setPen(QPen::black);
            p.drawRect(rect);
            p.setPen(QPen::white);
            p.drawText(rect,Qt::AlignHCenter|Qt::AlignVCenter,"L");

        }else{
            QRect rect((int)x(),0,10,10);
            p.fillRect(rect,QBrush::red);
            p.setPen(QPen::black);
            p.drawRect(rect);
            p.setPen(QPen::white);
            p.drawText(rect,Qt::AlignHCenter|Qt::AlignVCenter,"L");
        }
    }
    else if(side==RIGHT_MARKER){
        if(x()<canvas()->width()-10){
            QRect rect((int)x(),0,10,10);
            p.fillRect(rect,QBrush::red);
            p.setPen(QPen::black);
            p.drawRect(rect);
            p.setPen(QPen::white);
            p.drawText(rect,Qt::AlignHCenter|Qt::AlignVCenter,"R");
        }else{
            QRect rect((int)x()-10,0,10,10);
            p.fillRect(rect,QBrush::red);
            p.setPen(QPen::black);
            p.drawRect(rect);
            p.setPen(QPen::white);
            p.drawText(rect,Qt::AlignHCenter|Qt::AlignVCenter,"R");
        }
    }
    p.setPen(QPen::red);
    p.drawLine((int)x(),0,(int)x(),canvas()->height());
}

QPointArray  LoopMarker::areaPoints() const{
    QPointArray result(4);
    if(side==LEFT_MARKER){

        result.setPoint(0,QPoint((int)x()-11,0));
        result.setPoint(1,QPoint((int)x()+11,0));
        result.setPoint(2,QPoint((int)x()+11,canvas()->height()));
        result.setPoint(3,QPoint((int)x()-11,canvas()->height()));
        /*
        result.setPoint(0,QPoint((int)x()+1,0));
        result.setPoint(1,QPoint((int)x()-11,0));
        result.setPoint(2,QPoint((int)x()-11,11));
        result.setPoint(3,QPoint((int)x()-1,11));
        result.setPoint(4,QPoint((int)x()-1,canvas()->height()));
        result.setPoint(5,QPoint((int)x()+1,canvas()->height()));
        result.setPoint(6,QPoint((int)x()+1,11));
        */
    }else if(side==RIGHT_MARKER){

        result.setPoint(0,QPoint((int)x()-11,0));
        result.setPoint(1,QPoint((int)x()+11,0));
        result.setPoint(2,QPoint((int)x()+11,canvas()->height()));
        result.setPoint(3,QPoint((int)x()-11,canvas()->height()));
        /*
        result.setPoint(0,QPoint((int)x()-1,0));
        result.setPoint(1,QPoint((int)x()+11,0));
        result.setPoint(2,QPoint((int)x()+11,11));
        result.setPoint(3,QPoint((int)x()+1,11));
        result.setPoint(4,QPoint((int)x()+1,canvas()->height()));
        result.setPoint(5,QPoint((int)x()-1,canvas()->height()));
        result.setPoint(6,QPoint((int)x()-1,11));
        */

    }
    return result;
}




/*!
    \fn LoopMarker::setPosition(long)
 */
void LoopMarker::setSamplePosition(long _samplePos)
{
    samplePos=_samplePos;
}


/*!
    \fn LoopMarker::getSamplePosition()
 */
long LoopMarker::getSamplePosition()
{
    return samplePos;
}



/*!
    \fn LoopMarker::rtti()
 */
int LoopMarker::rtti() const
{
    return 15;
}


/*!
    \fn LoopMarker::setMoving(bool)
 */
void LoopMarker::setMoving(bool _moving)
{
    moving=_moving;
}


/*!
    \fn LoopMarker::getMoving()
 */
bool LoopMarker::getMoving()
{
    return moving;
}


/*!
    \fn LoopMarker::setSide(int)
 */
void LoopMarker::setSide(int lr)
{
    side=lr;
}

bool LoopMarker::operator<(LoopMarker* lm){
    return getSamplePosition()<lm->getSamplePosition();
}

bool LoopMarker::operator>(LoopMarker* lm){
    return getSamplePosition()>lm->getSamplePosition();
}

bool LoopMarker::operator==(LoopMarker* lm){
    return getSamplePosition()==lm->getSamplePosition();
}
