/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "soundholder.h"

SoundHolder::SoundHolder(QObject *parent, const char *name)
 : QObject(parent, name)
{
    leftChannel=0;
    rightChannel=0;
    _hasSound=FALSE;
    frames=0;
    channels=0;
    rate=0;
}


SoundHolder::~SoundHolder()
{
    if(leftChannel) zaparr(leftChannel);
    if(rightChannel) zaparr(rightChannel);
}

/*!
    \fn SoundManager::getRate()
 */
int SoundHolder::getRate()
{
    return rate;
}


/*!
    \fn SoundManager::getChannels()
 */
int SoundHolder::getChannels()
{
    return channels;
}


/*!
    \fn SoundManager::getFrames
 */
sf_count_t SoundHolder::getFrames()
{
    return frames;
}

/*!
    \fn SoundHolder::exportLeftFloatBuffer(long,long)
 */
float* SoundHolder::exportLeftBuffer(long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames());
   float* buffer=new float[(end_sample-start_sample)];
   int count=0;
   for (long i=start_sample;i<end_sample;i++){
       buffer[count++]=leftChannel[i];
   }
   return buffer;
}

/*!
    \fn SoundHolder::exportLeftFloatBuffer(long,long)
 */
float* SoundHolder::exportRightBuffer(long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames());
   float* buffer=new float[(end_sample-start_sample)];
   int count=0;
   for (long i=start_sample;i<end_sample;i++){
       buffer[count++]=rightChannel[i];
   }
   return buffer;
}

/*!
    \fn SoundHolder::exportDerivatedLeftFloatBuffer(long,long)
 */
float* SoundHolder::exportDerivatedLeftBuffer(long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames());
   float* buffer=new float[end_sample-start_sample];
   int count=0;
   for (long i=start_sample;i<end_sample-1;i++){
       if(i==0) buffer[count++]=leftChannel[i+1]-leftChannel[i];
       else if(i==getFrames()-1) buffer[count++]=leftChannel[i]-leftChannel[i-1];
       else buffer[count++]=leftChannel[i+1]-leftChannel[i-1];
   }
   return buffer;
}

/*!
    \fn SoundHolder::exportDerivatedRightFloatBuffer(long,long)
 */
float* SoundHolder::exportDerivatedRightBuffer(long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames());
   float* buffer=new float[end_sample-start_sample];
   int count=0;
   for (long i=start_sample;i<end_sample;i++){
       if(i==0) buffer[count++]=rightChannel[i+1]-rightChannel[i];
       else if(i==getFrames()-1) buffer[count++]=rightChannel[i]-rightChannel[i-1];
       else buffer[count++]=rightChannel[i+1]-rightChannel[i-1];
   }
   return buffer;
}


/*!
    \fn SoundHolder::importLeftFloatBuffer(float*)
 */
void SoundHolder::importLeftBuffer(float* buffer,long start_sample, long end_sample)
{
    assert(start_sample>=0 && end_sample<=getFrames());
    int count=0;
    for (int i=start_sample;i<end_sample;i++){
        getLeftChannel()[i]=buffer[count++];
    }
}


/*!
    \fn SoundHolder::importRightFloatBuffer(float*)
 */
void SoundHolder::importRightBuffer(float* buffer,long start_sample, long end_sample)
{
    assert(start_sample>=0 && end_sample<=getFrames());
    int count=0;
    for (int i=start_sample;i<end_sample;i++){
        getRightChannel()[i]=buffer[count++];
    }
}

/*!
    \fn SoundHolder::insertMultiplexedShortBuffer(float*,long,long)
 */
void SoundHolder::importMultiplexedBuffer(float* buffer,long length)
{
    int count=0;
    zaparr(leftChannel);
    zaparr(rightChannel);
    leftChannel=new float[length];
    rightChannel=new float[length];
    for (int i=0;i<length;i++){
            leftChannel[i]=buffer[count++];
            rightChannel[i]=buffer[count++];
    }
    setNbFrames(length);
}

void SoundHolder::importMultiplexedShortBuffer(short* buffer,long length)
{
    int count=0;
    zaparr(leftChannel);
    zaparr(rightChannel);
    leftChannel=new float[length];
    rightChannel=new float[length];
    for (int i=0;i<length;i++){
            leftChannel[i]=(float)(buffer[count++]/float(SHRT_MAX));
            rightChannel[i]=(float)(buffer[count++]/float(SHRT_MAX));
    }
    setNbFrames(length);
}

float* SoundHolder::exportMultiplexedBuffer(long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames() && end_sample>start_sample);
   float* buffer=new float[(end_sample-start_sample)*getChannels()];
   int count=0;
   for (long i=start_sample;i<end_sample;i++){
       buffer[count++]=getLeftChannel()[i];
       buffer[count++]=getRightChannel()[i];
   }
   return buffer;
}


/*!
    \fn SoundHolder::exportMuliplexedShortBuffer(long,long)
 */
void SoundHolder::exportMultiplexedBuffer(float* buffer, long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames());
   int count=0;
   for (long i=start_sample;i<end_sample;i++){
       buffer[count++]=(getLeftChannel()[i]);
       buffer[count++]=(getRightChannel()[i]);
   }
}

void SoundHolder::exportMultiplexedShortBuffer(short* buffer, long start_sample,long end_sample)
{
   assert(start_sample>=0 && end_sample<=getFrames());
   int count=0;
   for (long i=start_sample;i<end_sample;i++){
       buffer[count++]=(short)(getLeftChannel()[i]*float(SHRT_MAX));
       buffer[count++]=(short)(getRightChannel()[i]*float(SHRT_MAX));
   }
}

/*!
    \fn SoundHolder::getLeftChannel()
 */
float* SoundHolder::getLeftChannel()
{
    return leftChannel;
}


/*!
    \fn SoundHolder::getRightChannel()
 */
float* SoundHolder::getRightChannel()
{
    return rightChannel;
}

/*!
    \fn SoundHolder::setNbFrames(long)
 */
void SoundHolder::setNbFrames(long nbf)
{
    frames=nbf;
    //if(effects) effects->setNbFrames(getFrames());
    emit(nbFramesChanged(getFrames()));
}





/*!
    \fn SoundHolder::getBps()
 */
int SoundHolder::getBps()
{
     if((sfinfo.format & SF_FORMAT_SUBMASK) == SF_FORMAT_PCM_16) return 16;
    else if((sfinfo.format & SF_FORMAT_SUBMASK) == SF_FORMAT_PCM_24) return 24;
    else if((sfinfo.format & SF_FORMAT_SUBMASK) == SF_FORMAT_FLOAT) return 32;
    else return 16;
}


/*!
    \fn SoundHolder::toBpsCode(int)
 */
int SoundHolder::toBpsCode(int value)
{
    switch(value){
            case 16: return (sfinfo.format & SF_FORMAT_TYPEMASK) |
                            (sfinfo.format & SF_FORMAT_ENDMASK) |SF_FORMAT_PCM_16;break;
            case 24: return (sfinfo.format & SF_FORMAT_TYPEMASK) |
                            (sfinfo.format & SF_FORMAT_ENDMASK) |SF_FORMAT_PCM_24;break;
            case 32: return (sfinfo.format & SF_FORMAT_TYPEMASK) |
                            (sfinfo.format & SF_FORMAT_ENDMASK) |SF_FORMAT_FLOAT;break;
            default: return sfinfo.format;
    }
}
