/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "measuremarker.h"

MeasureMarker::MeasureMarker(QCanvas* canvas,LoopMarker*l,LoopMarker* r)
 : QCanvasRectangle(canvas)
{
    leftLoopMarker=l;
    rightLoopMarker=r;
    setZ(100);
    beatWidth=0;
    hide();
}


MeasureMarker::~MeasureMarker()
{
    hide();
}

void MeasureMarker::drawShape ( QPainter & p ){
    //cout<<"x: "<<x()<<" width: "<<width()<<" beatWidth: "<<beatWidth<<endl;
    if(beatWidth>10){
        setX(leftLoopMarker->x());
        setSize(rightLoopMarker->x()-x(),canvas()->height()/10);
        setY(canvas()->height()/2-canvas()->height()/20);
        RasterOp oldROP=p.rasterOp();
        p.setRasterOp(CopyROP);
        QFont font;
        font.setPixelSize(height()/3);
        font.setBold(TRUE);
        p.setFont(font);
        QBrush brushDG=QBrush::darkGray;
        QBrush brushLG=QBrush::lightGray;
        QBrush brushR=QBrush::red;
        QBrush brush=brushDG;
        int count=1;
        for (int i=x();i<x()+width();i+=beatWidth){
                if(i+beatWidth<x()+width()){
                    QRect rect(i,y(),beatWidth,height());
                    p.fillRect(rect,brush);
                    p.drawRect(rect);
                    if(brush==brushDG) brush=brushLG;
                    else brush=brushDG;
                    p.drawText(rect,Qt::AlignHCenter|Qt::AlignVCenter,QString::number(count++));
                }else{
                    p.fillRect(i,y(),x()+width()-i,height(),brushR);
                    p.drawRect(i,y(),x()+width()-i,height());
                }
        }
        p.setRasterOp(oldROP);
    }
}


/*!
    \fn MeasureMarker::swapMarkers()
 */
void MeasureMarker::swapMarkers()
{
    std::swap(leftLoopMarker,rightLoopMarker);
    setX(leftLoopMarker->x());
    setY(canvas()->height()/2-canvas()->height()/20);
    setSize(rightLoopMarker->x()-x(),canvas()->height()/10);
}


/*!
    \fn MeasureMarker::setBeatWidth(int)
 */
void MeasureMarker::setBeatWidth(int bw)
{
    beatWidth=bw;
    setX(leftLoopMarker->x());
    setY(canvas()->height()/2-canvas()->height()/20);
    setSize(rightLoopMarker->x()-x(),canvas()->height()/10);
}
