/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mysavefiledialog.h"

MySaveFileDialog::MySaveFileDialog(QWidget *parent, const char *name)
 : QFileDialog(parent, name,TRUE)
{
    QLabel* label4=new QLabel("Export bits per sample",this);
    exportBitsPerSampleDropdown=new BitsPerSampleDropdown(this);
    addWidgets(label4,exportBitsPerSampleDropdown,0);


    QLabel* label3=new QLabel("Per Chunk attack time",this);
    attackTimeSpinBox=new QSpinBox(this);
    attackTimeSpinBox->setMinValue(0);
    attackTimeSpinBox->setMaxValue(999);
    attackTimeSpinBox->setMinimumWidth(40);
    attackTimeSpinBox->setSuffix(" ms");
    addWidgets(label3,attackTimeSpinBox,0);

    exportMidifileCheckbox=new QCheckBox(this);
    QLabel* label=new QLabel("Export midifile",this);
    addWidgets(label,exportMidifileCheckbox,0);
    exportAKPCheckbox=new QCheckBox(this);
    QLabel* label2=new QLabel("Export AKP",this);
    addWidgets(label2,exportAKPCheckbox,0);

    QHButtonGroup* bgroup=new QHButtonGroup("Export range",this);
    exportAll=new QRadioButton("All",bgroup);
    exportAll->setChecked(TRUE);
    exportLoop=new QRadioButton("Loop",bgroup);
    addWidgets(0,bgroup,0);

    setMode(QFileDialog::AnyFile);
}


MySaveFileDialog::~MySaveFileDialog()
{
}




/*!
    \fn MySaveFileDialog::exportMidifile()
 */
bool MySaveFileDialog::exportMidifile()
{
    return exportMidifileCheckbox->isChecked();
}

/*!
    \fn MySaveFileDialog::exportAKP()
 */
bool MySaveFileDialog::exportAKP()
{
    return exportAKPCheckbox->isChecked();
}




/*!
    \fn MySaveFileDialog::exportMode()
 */
int MySaveFileDialog::exportMode()
{
    if(exportLoop->isChecked()) return EXPORT_LOOP;
    else if(exportAll->isChecked()) return EXPORT_ALL;
    else return -1;
}


/*!
    \fn MySaveFileDialog::getAttackTime()
 */
int MySaveFileDialog::getAttackTime()
{
    return attackTimeSpinBox->value();
}

/*!
    \fn MySaveFileDialog::getExportBitsPerSample()
 */
int MySaveFileDialog::getExportBitsPerSample()
{
    return exportBitsPerSampleDropdown->getModifier();
}

int MySaveFileDialog::exec()
{
    rereadDir();
    return QFileDialog::exec();
}


/*!
    \fn MySaveFileDialog::setBps(int)
 */
void MySaveFileDialog::setBps(int bps)
{
    exportBitsPerSampleDropdown->setBps(bps);
}
