/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "drawsoundwidgetabstract.h"

DrawSoundWidgetAbstract::DrawSoundWidgetAbstract(QWidget *parent, const char *name, SoundManager* sm)
 : QCanvasView(parent,name,WNoAutoErase)
{
    soundManager=sm;
    canvas=new WaveCanvas(this->viewport());
    canvas->setDoubleBuffering(TRUE);
    enableClipper(TRUE);
    setCanvas(canvas);
    canvas->setSoundManager(sm);
    zoomRatio=1;
    setResizePolicy(QScrollView::AutoOneFit);
    updateCanvas=true;
    //setHScrollBarMode(AlwaysOn);
}


DrawSoundWidgetAbstract::~DrawSoundWidgetAbstract()
{
}

/*!
    \fn DrawSoundWidget::canvas()
 */
WaveCanvas* DrawSoundWidgetAbstract::getCanvas()
{
    return canvas;
}





/*!
    \fn DrawSoundWidgetAbstract::getZoomRatio()
 */
long DrawSoundWidgetAbstract::getZoomRatio()
{
    return zoomRatio;
}



/*!
    \fn DrawSoundWidgetAbstract::zoomToSamplePos(long,long)
 */
long DrawSoundWidgetAbstract::zoomToSamplePos(long start,long end)
{
    long diff=end-start;
    long mid=start+diff/2;
    //long temp_zoomRatio=long(float(diff)/float(((QCanvasView*)parent())->visibleWidth()));
    long temp_zoomRatio=long(float(diff)/float(parentWidget()->width()));
std::cout<<"["<<name()<<"]: temp_zoom: "<<temp_zoomRatio<<" visibleWidth: "<<visibleWidth()<<" s-e:"<<start<<"-"<<end<<"\n";
    if(temp_zoomRatio<1) temp_zoomRatio=1;
    setZoomRatio(temp_zoomRatio,mid);
    //canvas->update();
    return zoomRatio;
}


/*!
    \fn DrawSoundWidgetAbstract::getFirstVisibleSample()
 */
long DrawSoundWidgetAbstract::getFirstVisibleSample()
{
     long sample_pos=contentsX()*getZoomRatio();
     return sample_pos<0?0:sample_pos;
}


/*!
    \fn DrawSoundWidgetAbstract::getLastVisibleSample()
 */
long DrawSoundWidgetAbstract::getLastVisibleSample()
{
    long v_Width=parentWidget()->width();
    cout<<"in "<<name()<<" width: "<<v_Width<<"\n";
                 /*
                 if(v_Width*getZoomRatio()>=soundManager->getFrames()){
                     v_Width=soundManager->getFrames()/getZoomRatio();
                 }
                */
    long end_sample=(contentsX()+v_Width)*getZoomRatio();
    return end_sample>soundManager->getFrames()?soundManager->getFrames():end_sample;
}

void DrawSoundWidgetAbstract::resizeEvent(QResizeEvent* ev){
    QCanvasView::resizeEvent(ev);
    if(soundManager->hasSound() && ev->size().width()>0){
        double proportion=double(ev->size().width())/double(ev->oldSize().width());
        //if(zoomRatio==1){
            //setZoomRatio(soundManager->getFrames()/ev->size().width()); //not yet initialized
        //}else{
            setZoomRatio(zoomRatio/proportion); //initialized
        //}
    }
}


void DrawSoundWidgetAbstract::forceRepaint(){
    //called when applying LADSPA on whole wavefile
    canvas->forceRepaint();
}

void DrawSoundWidgetAbstract::forceRepaint(long start_sample,long end_sample){
    /** \todo correct this bull***t */

    if(end_sample==start_sample){
                    if(start_sample>0) start_sample--;
                    if(end_sample<soundManager->getFrames()) end_sample++;
                }
    assert(start_sample>=0 && end_sample<=soundManager->getFrames() && end_sample>start_sample);

    canvas->forceRepaint(start_sample,end_sample);
}


/*!
    \fn DrawSoundWidgetAbstract::checkStartSample(long)
 */
long DrawSoundWidgetAbstract::checkSamplePosition(long sample_pos)
{
    if (sample_pos<0) return 0;
    else if(sample_pos>soundManager->getFrames()) return soundManager->getFrames();
    else return sample_pos;
}
/**
    setZoomRatio(long):
         1) Changes zoom ratio
         2) Resizes the canvas,
         3) Recenters the view and forces a repaint of the canvas
*/
void DrawSoundWidgetAbstract::setZoomRatio(long _zr,long mid_sample){
        bool zoomRatioIsDifferent=zoomRatio!=_zr?TRUE:FALSE;
        long old_zr_start_sample=checkSamplePosition(getFirstVisibleSample());
        long old_zr_end_sample=checkSamplePosition(getLastVisibleSample());
        int center_sample=old_zr_start_sample+(old_zr_end_sample-old_zr_start_sample)/2.0;
        zoomRatio=_zr<=0?1:_zr;
        long start_sample=checkSamplePosition(getFirstVisibleSample());
        long end_sample=checkSamplePosition(getLastVisibleSample());
        cout<<"in "<<name()<<" start_sample: "<<start_sample<<" end_sample: "<<end_sample<<"\n";
        if(soundManager->hasSound()){
            canvas->setPixmapXOrigin(contentsX());
             if (zoomRatioIsDifferent ||visibleHeight()!=contentsHeight()){
                 cout<<">>>>>>>>>>>> ["<<name()<<"] Zoom Ratio Set <<<<<<<<<<<<<<<<<<<<<\n";
                contentsSize=viewportSize((int)(soundManager->getFrames()/zoomRatio),visibleHeight());
                resizeContents((int)(soundManager->getFrames()/zoomRatio),contentsSize.height());
                canvas->setZoomRatio(zoomRatio);
                canvas->resize(contentsWidth(),contentsHeight());
            }
            if(mid_sample!=-1){
                zoomChanged();
                center(mid_sample/zoomRatio,visibleHeight()/2); //forces repaint via contentsMoving signal
            }else{
                //assert(end_sample>start_sample);
                forceRepaint(start_sample,end_sample);
                zoomChanged();
                center((old_zr_start_sample+(old_zr_end_sample-old_zr_start_sample)/2.0)/float(zoomRatio),visibleHeight()/2);
            }
        }
    }
