/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "effectframe.h"

EffectFrame::EffectFrame(LADSPAEffect* _eff, QWidget* parent,const char* name)
 : QVBox(parent,name)
{
    setBackgroundColor(red);
    effect=_eff;
    effect->initControlPortsValues();


    portsBar=new QMenuBar(this);
        QPopupMenu * portsMenu = new QPopupMenu( this );
        executeMenu = new QPopupMenu( this );

    QFont t_font=portsBar->font();
    t_font.setPointSize(8);
    t_font.setWeight(QFont::Light);
    portsMenu->setFont(t_font);
    t_font.setPointSize(9);
    t_font.setWeight(QFont::Bold);
    portsBar->setFont(t_font);
    stack=new QWidgetStack(this);

    portsBar->insertItem(effect->getName(),portsMenu);
    portsBar->insertItem("Execute",executeMenu);

    linesButton=new QPushButton("Lines",portsBar);
    linesButton->setToggleButton(TRUE);
    portsBar->insertItem(linesButton);

    applyMenuIDX=executeMenu->insertItem("Apply effect",this,SLOT(apply()),0,1);
    undoApplyMenuIDX=executeMenu->insertItem("Undo && Apply effect",this,SLOT(undoAndApply()),0,2);
    executeMenu->insertSeparator();
    onReleasePolMenuIDX=executeMenu->insertItem("Apply effect on release",
                                                this,SLOT(switchOnReleaseApplyPolicy()),0,3);
    onChangePolMenuIDX=executeMenu->insertItem("Realtime (unstable)",this,SLOT(switchOnChangeApplyPolicy()),0,4);
    executeMenu->setItemEnabled(4,FALSE);


    portsBar->show();
    portFrames.setAutoDelete(TRUE);
    for (QPtrList<LADSPAPort>::Iterator it=effect->getControlInputPorts()->begin();
            it!=effect->getControlInputPorts()->end();++it){
            QString portName=(*it)->getPortName();
            portName.append(" (").append(QString::number((*it)->getLowerBound())).
                append(" - ").
                append(QString::number((*it)->getUpperBound())).append(")");
        if((*it)->areBoundsOk()){
            EffectPortFrame* tempFrame=new EffectPortFrame(portName.copy(),*it,stack);
            portFrames.append(tempFrame);
            portsMenu->insertItem(portName,tempFrame,SLOT(raiseMe()));
            stack->addWidget(tempFrame);
            tempFrame->show();
            tempFrame->setBackgroundColor(yellow);
            connect(tempFrame,SIGNAL(valueChanged(long,long)),
                              this,SLOT(undoAndApply(long,long)));

            connect(linesButton,SIGNAL(toggled(bool)),
                              tempFrame,SLOT(linesToggled(bool)));
        }else{
            int id=portsMenu->insertItem(portName);
            portsMenu->setItemEnabled(id,FALSE);
        }
    }
    update();
    //adjustSize();
    if(portFrames.count()>0) portFrames.first()->raiseMe();
    wasEffectApplied=FALSE;
}

void EffectFrame::apply(){
    emit(applyMe(effect));
    wasEffectApplied=TRUE;
}

void EffectFrame::undoAndApply(){
    if(wasEffectApplied)
        emit(undoAndApplyMe(effect));
    else
        apply();
}

void EffectFrame::undoAndApply(long start_sample,long end_sample){
    //set PortValues here!!!
    if(wasEffectApplied)
        emit(undoAndApplyMe(effect,start_sample,end_sample));
    else
        apply();
}

void EffectFrame::show(){
    QVBox::show();
    if(portFrames.count()>0) portFrames.first()->raiseMe();
}

void EffectFrame::closeEvent( QCloseEvent* ce ){

     for (QPtrList<EffectPortFrame>::Iterator it=portFrames.begin();
            it!=portFrames.end();++it){
                stack->removeWidget(*it);
                (*it)->close();
    }
    //portFrames.clear();
    ce->accept();
}

EffectFrame::~EffectFrame()
{

}



/*!
    \fn EffectFrame::setZoomRatio(long)
 */
void EffectFrame::setZoomRatio(long _zr)
{
    for (QPtrList<EffectPortFrame>::Iterator it=portFrames.begin();
            it!=portFrames.end();++it){
                (*it)->setZoomRatio(_zr);
    }
}

void EffectFrame::visibleAreaChanged(long start_sample, long end_sample){
    //view->setStartSamplePosition(start_sample);
    //view->setEndSamplePosition(end_sample);
    //updateViewWindow();
}


/*!
    \fn EffectFrame::setContentsPos/int,int)
 */
void EffectFrame::setContentsPos(int x,int y)
{
    for (QPtrList<EffectPortFrame>::Iterator it=portFrames.begin();
            it!=portFrames.end();++it){
                (*it)->setContentsPos(x,0);
    }
}

void EffectFrame::switchOnReleaseApplyPolicy(){
    if(executeMenu->isItemChecked(onReleasePolMenuIDX)){
        executeMenu->setItemChecked(onReleasePolMenuIDX,FALSE);
        executeMenu->setItemEnabled(applyMenuIDX,TRUE);
        executeMenu->setItemEnabled(undoApplyMenuIDX,TRUE);
        setApplyPolicy(EffectPortFrame::NO_AUTO_APPLY);
    }else{
        executeMenu->setItemChecked(onReleasePolMenuIDX,TRUE);
        executeMenu->setItemChecked(onChangePolMenuIDX,FALSE);
        executeMenu->setItemEnabled(applyMenuIDX,FALSE);
        executeMenu->setItemEnabled(undoApplyMenuIDX,FALSE);
        setApplyPolicy(EffectPortFrame::APPLY_ON_RELEASE);
        undoAndApply();
    }
}
void EffectFrame::switchOnChangeApplyPolicy(){
    if(executeMenu->isItemChecked(onChangePolMenuIDX)){
        executeMenu->setItemChecked(onChangePolMenuIDX,FALSE);
        executeMenu->setItemEnabled(applyMenuIDX,TRUE);
        executeMenu->setItemEnabled(undoApplyMenuIDX,TRUE);
        setApplyPolicy(EffectPortFrame::NO_AUTO_APPLY);
    }else{
        executeMenu->setItemChecked(onChangePolMenuIDX,TRUE);
        executeMenu->setItemChecked(onReleasePolMenuIDX,FALSE);
        executeMenu->setItemEnabled(applyMenuIDX,FALSE);
        executeMenu->setItemEnabled(undoApplyMenuIDX,FALSE);
        setApplyPolicy(EffectPortFrame::APPLY_ON_CHANGE);
        undoAndApply();
    }
}




/*!
    \fn EffectFrame::setApplyPolicy(int)
 */
void EffectFrame::setApplyPolicy(int ap)
{
    for (QPtrList<EffectPortFrame>::Iterator it=portFrames.begin();
            it!=portFrames.end();++it){
                (*it)->setApplyPolicy(ap);
    }
}


/*!
    \fn EffectFrame::setEffectNotApplied()
 */
void EffectFrame::reinit()
{
    wasEffectApplied=FALSE;
}


QSize EffectFrame::sizeHint () const {
    return QSize(parentWidget()->width(),100);
}





