/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EFFECTPORTFRAME_H
#define EFFECTPORTFRAME_H

#include <iostream.h>
#include <qframe.h>
#include <ladspaport.h>
#include <qcanvas.h>
#include <controllercanvas.h>
#include <qwidgetstack.h>
#include <qwmatrix.h>
#include <qvbox.h>
#include "valueline.h"
#include "drawingline.h"
#include "polyline.h"
#include "splineline.h"
#include "defs.h"
/**
@author Predrag Viceic
*/
class EffectPortFrame : public QCanvasView
{
Q_OBJECT
public:
    EffectPortFrame(QString,LADSPAPort*,QWidget *parent = 0, const char *name = 0);

    ~EffectPortFrame();
    void setZoomRatio(long);
    long getZoomRatio();
    ControllerCanvas* getCanvas();
    QSize minimumSizeHint () const;

    enum ApplyPolicy {NO_AUTO_APPLY,APPLY_ON_RELEASE,
                                        APPLY_ON_CHANGE};
    enum DrawMode {DRAW_MODE_POINTS,DRAW_MODE_LINES,
                                    DRAW_MODE_POLYLINES,DRAW_MODE_SPLINES};

    DrawMode drawMode;
    DrawMode getDrawMode();

    struct interval{
        long start_sample;
        long end_sample;
        void add(interval i1){
            if(i1.start_sample<start_sample) start_sample=i1.start_sample;
            if(i1.end_sample>end_sample) end_sample=i1.end_sample;
        }
        void add(long start,long end){
            if(start<start_sample) start_sample=start;
            if(end>end_sample) end_sample=end;
        }
        void reset(){
            start_sample=LONG_MAX;
            end_sample=LONG_MIN;
        }
        bool isValid(){
            return start_sample<end_sample;
        }
    };

private:
    int applyPolicy;
    LADSPAPort* port;
    QString name;
    void drawValueLines();
    bool drawing;
    interval update_interval;
protected:
    ControllerCanvas* canvas;
    int c_height;
    long zoomRatio;
    bool linesCreated;
    void contentsMousePressEvent( QMouseEvent * );
    void contentsMouseMoveEvent( QMouseEvent * );
    void contentsMouseReleaseEvent( QMouseEvent * );
    void contentsWheelEvent( QWheelEvent *);
    interval updateValueAtPos(QPoint,bool,bool);
    DrawingLine* drawingLine;
    PolyLine* polyLine;
    SplineLine* spline;


public slots:
    void raiseMe();
    void setApplyPolicy(int);
    void pointsToggled();
    void linesToggled();
    void polylinesToggled();
    void splinesToggled();


protected:
    void paintEvent(QPaintEvent*);
    void resizeEvent(QResizeEvent*);
    void closeEvent( QCloseEvent*);
    float yPosToVal(int y);

signals:
    void valueChanged(long,long);
    void drawModeChanged(EffectPortFrame::DrawMode dm);

};

#endif
