/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "sortablepoint.h"

SortablePoint::SortablePoint()
 : QPoint()
{
    order=HORIZONTAL;
    size=7;
    selectedVar=FALSE;
    sample_pos=0;
}

SortablePoint::SortablePoint(QPoint p)
    : QPoint(p)
{
    order=HORIZONTAL;
    size=7;
    selectedVar=FALSE;
    sample_pos=0;
}


SortablePoint::~SortablePoint()
{
}

bool SortablePoint::operator<( const QPoint &p)
{
    if(order==HORIZONTAL){
        return x() < p.x();
    }else{
        return y() < p.y();
    }
}


bool SortablePoint::operator==( const QPoint &p)
{
    /*
    if(order==HORIZONTAL){
        return abs(x() - p.x())<=size;
    }else{
        return abs(y() - p.y())<=size;
    }
    */
    return ((abs(x() - p.x())<=size) && (abs(y() - p.y())<=size));
}

bool SortablePoint::operator!=( const QPoint &p)
{
    /*
    if(order==HORIZONTAL){
        return abs(x() - p.x())>size;
    }else{
        return abs(y() - p.y())>size;
    }
    */
    return ((abs(x() - p.x())>size) || (abs(y() - p.y())>size));

}





/*!
    \fn SortablePoint::setSelected(bool)
 */
void SortablePoint::setSelected(bool tf)
{
    selectedVar=tf;
}

/*!
    \fn bool SortablePoint::selected()
 */
bool SortablePoint::selected()
{
    return selectedVar;
}


/*!
    \fn SortablePoint::setSize(int s)
 */
void SortablePoint::setSize(int s)
{
    size=s;
}


/*!
    \fn SortablePoint::getSamplePos()
 */
long SortablePoint::getSamplePos()
{
    return sample_pos;
}


/*!
    \fn SortablePoint::setSamplePos(long sp)
 */
void SortablePoint::setSamplePos(long sp)
{
    sample_pos=sp;
}


/*!
    \fn SortablePoint::getValue()
 */
float SortablePoint::getValue()
{
    return value;
}


/*!
    \fn SortablePoint::setValue(float val)
 */
void SortablePoint::setValue(float val)
{
    value=val;
}
