/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOUNDHOLDER_H
#define SOUNDHOLDER_H

#include <qobject.h>
#include <sndfile.h>
#include <defs.h>
#include <qvaluevector.h>
#include <qprogressdialog.h>

/**
\class SoundHolder

\brief This class hold the sound as arrays of floats and provides the access to the data

@author Predrag Viceic
*/
class SoundHolder : public QObject
{
Q_OBJECT
public:
    SoundHolder(QObject *parent = 0, const char *name = 0);

    ~SoundHolder();

    enum bufferType {ANY=-1,ORIGINAL_WAVE=0,BEFORE_LADSPA=1,
                                    AFTER_LADSPA=2,BEFORE_ENVELOPE=3,
                                    AFTER_ENVELOPE=4,FOR_OUTPUT=5};
    struct leftRightBuffer{
        float* left;
        float* right;
        bufferType type;
        void init(int size, bufferType _type){
            cout<<"init buffer "<<type<<" done\n";
            zap();
            if(size>0){
                left=new float[size];
                right=new float[size];
            }
            if(_type!=ANY) type=_type;
        }
        void zap(){
            if (left) zaparr(left);
            if (right) zaparr(right);
        }
    void setRight(float*);
    void setLeft(float*);
    };



protected:
    double maxValue;
    SF_INFO sfinfo;
    sf_count_t frames;
    int rate;
    int channels;
    bool _hasSound;
    QValueList <leftRightBuffer> buffers;
    bool hasLADSPA;
    bool hasEnvelope;

    float* exportMultiplexedBuffer(long,long,bufferType type=FOR_OUTPUT);
    void exportMultiplexedBuffer(float*,long,long,bufferType type=FOR_OUTPUT);

    float* exportDerivatedLeftBuffer(long,long,bufferType type=FOR_OUTPUT);
    float* exportDerivatedRightBuffer(long,long,bufferType type=FOR_OUTPUT);
    float* exportLeftBuffer(long,long,bufferType type=FOR_OUTPUT);
    float* exportRightBuffer(long,long,bufferType type=FOR_OUTPUT);
    void importLeftBuffer(float*,long start_sample, long end_sample,
                          bufferType type=ORIGINAL_WAVE);
    void importRightBuffer(float*,long start_sample, long end_sample,
                           bufferType type=ORIGINAL_WAVE);
    void importMultiplexedBuffer(float* ,long,bufferType type=ORIGINAL_WAVE);
    void importMultiplexedShortBuffer(short* ,long,bufferType type=ORIGINAL_WAVE);
    void saveChunkToAs(QString filename,long start,long end,int format,long start_at,bufferType type=FOR_OUTPUT);
    int loadBuffer(QString,bufferType type);

public:
    int getRate();
    int getChannels();
    sf_count_t getFrames();
    void setHasLadspa(bool hl);



    float* getLeftChannel(bufferType type=FOR_OUTPUT);
    float* getRightChannel(bufferType type=FOR_OUTPUT);
    void exportMultiplexedShortBuffer(short* data, long,long,bufferType type=FOR_OUTPUT);

    void setNbFrames(long);
    int getBps();
    int toBpsCode(int);
    void cropBuffers(long start_sample, long end_sample);
    void zapBuffers();
    void zap(bufferType type);
    void initBuffer(bufferType type, long length);
    int getBufferIndex(bufferType type);
    short* insertShortArray(short* dest,short* src,
            long position,long size);
    float* insertArray(float* dest,float* src,long position,long size);
    void setHasEnvelope(bool tf);

signals:
    void nbFramesChanged(long);

};

#endif
