/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FREECYCLE_H
#define FREECYCLE_H

#include <qmainwindow.h>
#include <qlabel.h>
#include <qslider.h>
#include <qscrollview.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qcanvas.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qsplitter.h>
#include <qstring.h>
#include <qmemarray.h>
#include <sndfile.h>
#include <qmessagebox.h>
#include "drawsoundwidget.h"
#include "drawallsoundwidget.h"
#include "soundmanager.h"
#include "soundplayer.h"
#include "floatspinbox.h"
#include "ladspadialog.h"
#include "fftdialog.h"
#include "ampdomaindialog.h"
#include "effectframe.h"
#include "midimanager.h"
#include "akpmanager.h"
#include "sf2manager.h"
#include "mysavefiledialog.h"
#include "myopenfiledialog.h"
#include "spectrumview.h"
#include "scopeview.h"
#include "bpmmodifierspinbox.h"
#include "bpmmodifierdropdown.h"
#include "envelope.h"
#include "qsizepolicy.h"
#include "midioutputthread.h"
#include "volumeslider.h"
#include "mysplitter.h"
#include "envelopecontrollerwidget.h"
#include "envelopeholder.h"
#include "projectmanager.h"
#include "mysaveprojectdialog.h"
#include "myloadprojectdialog.h"

class QTextEdit;

class Freecycle: public QMainWindow
{
    Q_OBJECT

public:
    Freecycle();
    ~Freecycle();

protected:
    void closeEvent( QCloseEvent* );
public slots:
    void load( const QString &fileName );
private slots:
    void choose();
    void save();
    void saveAs();
    void saveChunks();
    void saveProject();
    void changeZoom(int value);
    void changeZoom();
    void changeTreshold(int value);
    void changeTreshold();
    void about();
    void play();
    void pause();
    void stopPlay();
    void zoomToSel();
    void zoomAll();
    void changeWindowDivider(int);
    void cropSelection();
    void undo();
    void redo();
    void addEffect();
    void configureFFT();
    void configureAmpDomain();
    void removeEffect();
    void addEffectFrame(int);
    void updateNbFramesLabel();
    void setAmplitudeDomain();
    void setFrequencyDomain();
    //aubio
            void setComplexDomain();
            void setPhaseDomain();
            void setSpectralDomain();
            void setHFCDomain();
    //end aubio
    void setDerivateSignal();
    void playFromPoint(long);
    void playFromTo(long,long);
    void toggleLoop(bool);
    void loopChanged();
    void cropped(long,long);
    void setWaveView();
    void setSpectrumView();
    void showBeatLines();
    void bpmModifierValueChanged();
    void spaceBarPressed();
    void numPad7Pressed();
    void numPad9Pressed();
    void numPad1Pressed();
    void loadProject();
private:
    DrawSoundWidget* drawSoundWidget;
    DrawAllSoundWidget* drawAllSoundWidget;
    QHBox* topBox;
    QLabel * samplerateLabel;
    QLabel * nbframesLabel;
    QLabel * channelsLabel;
    QLabel * zoomRatioLabel;
    QLabel * bpmLabel;
    //BPMModifierSpinBox * bpmModifSpin;
    BPMModifierDropDown * bpmModifDropDown;
     QVBox * centralLayout;
    VolumeSlider* zoomSlider;
    VolumeSlider* tresholdSlider;
    QScrollView* scroll;
    SpectrumView* spectrumView;
    ScopeView* scopeView;
    MyOpenFileDialog* openFileDialog;
    MySaveFileDialog* saveFileDialog;
    EnvelopeControllerWidget* envelopeControllerWidget;
    EnvelopeHolder* envelopeHolder;

protected:
    QHBox* playButtons;
    QPushButton* playButton;
    QPushButton* pauseButton;
    QPushButton* stopButton;
    QPopupMenu* configureAnalysisPopupMenu;
    QPopupMenu* configureViewPopupMenu;
    SoundPlayer* soundPlayer;
    FloatSpinBox* newBPM;
    QPushButton* resampleButton;
    SoundManager* soundManager;
    QPushButton* zoomToSelButton;
    QHBox* zoomBox;
    QPushButton* zoomAllButton;
    QHBox* beatLinesControl;
    QHBox* envelopeControl;
    QHBox* playAndBeatLinesControls;
    QPushButton* unlockBeatLinesButton;
    QPushButton* lockBeatLinesButton;
    QSlider* analyseWindowDivider;
    QPushButton* bpmLines;
    QPushButton* viewOnly;
    QPushButton* loopToggle;
    FileManager* fileManager;
    LADSPADialog* ladspaDialog;
    FFTDialog* fftDialog;
    AmpDomainDialog* ampDomainDialog;
    MySplitter* big_and_small_wave_and_effects;
    EffectFrame* effectFrame;
    MidiManager* midiManager;
    AKPManager* akpManager;
    MidiOutputThread* midiOutputThread;
    QPopupMenu* filePopupMenu;
    int idsavedialog, idsaveasdialog,idsavechunksdialog, idsaveprojectdialog,idloadprojectdialog;
    ProjectManager* projectManager;
    MySaveProjectDialog* saveProjectDialog;
    MyLoadProjectDialog* loadProjectDialog;
};


#endif
