//
// C++ Implementation: keyboardview
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "keyboardview.h"

KeyboardView::KeyboardView(QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
    rectheight=40;
    rectwidth=40;
    setSize(rectwidth,rectheight);
    setZ(10);
}


KeyboardView::~KeyboardView()
{
}

/*!
    \fn KeyboardView::setY(double y)
 */
void KeyboardView::setY(double y)
{
    int y2=y<0?0:y>canvas()->height()-rectheight?canvas()->height()-rectheight:y;
    QCanvasRectangle::setY(y2);
}


/*!
    \fn KeyboardView::setX(double x)
 */
void KeyboardView::setX(double x)
{
    QCanvasRectangle::setX(x);
}


/*!
    \fn KeyboardView::drawShape(QPainter & p)
 */
void KeyboardView::drawShape(QPainter & p)
{
    QPen oldpen=p.pen();
    p.setPen(QPen(gray,2));
    p.fillRect(rect(),QBrush(lightGray));
    p.drawRect(rect());
    drawOctave(p,rect().topLeft());
    p.setPen(oldpen);
}


/*!
    \fn KeyboardView::rtti() const
 */
int KeyboardView::rtti() const
{
    return RTTI_KEYBOARDRECT;
}





/*!
    \fn KeyboardView::drawOctave(QPainter & p, QPoint po)
 */
void KeyboardView::drawOctave(QPainter & p, QPoint po)
{
    QPen oldpen=p.pen();
    
    p.setPen(oldpen);
}
