/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "lockedbeatrect.h"

LockedBeatRect::LockedBeatRect(QCanvas* canvas,BeatLine* start,BeatLine* end)
 : QCanvasRectangle(canvas)
{
    startBL=start;
    endBL=end;
    bgColor.setRgb(255,255,200);
    if(startBL && endBL){
        setX(startBL->x());
        setSize(endBL->x()-startBL->x(),canvas->height()-20);
        setY(20);
        handle=new QRect(x()+width()/2-4,(height()/2)+20-4,8,8);
    }
    selected=FALSE;
}


LockedBeatRect::~LockedBeatRect()
{
}

int LockedBeatRect::rtti() const{
    return RTTI_LOCKEDBEATRECT;
}

void LockedBeatRect::drawShape ( QPainter & p ){
    if(startBL && endBL){


        setX(startBL->x());
        int middle=(canvas()->height()/2)+20;
        setSize(endBL->x()-startBL->x(),canvas()->height()-20);
        setY(20);
        handle->setRect(x()+width()/2-4,middle-4,8,8);

        QPointArray triangle1(3);
        triangle1.setPoint(0,QPoint(x(),middle));
        triangle1.setPoint(1,QPoint(x()+5,middle+2));
        triangle1.setPoint(2,QPoint(x()+5,middle-2));

        QPointArray triangle2(3);
        triangle2.setPoint(0,QPoint(x()+width(),middle));
        triangle2.setPoint(1,QPoint(x()+width()-5,middle+2));
        triangle2.setPoint(2,QPoint(x()+width()-5,middle-2));


        RasterOp oldROP=p.rasterOp();
        p.setRasterOp(AndROP);
        if(isSelected()){
            p.setPen(QPen(red,2));
            p.setBrush(QBrush(red));
            p.fillRect(rect(),QBrush(QColor(255,200,200)));
        }else{
            p.setPen(QPen(magenta,2));
            p.setBrush(QBrush(magenta));
            p.fillRect(rect(),QBrush(bgColor));
        }
        p.drawPolygon(triangle1);
        p.drawPolygon(triangle2);
        p.drawLine(startBL->x(),middle,endBL->x(),middle);
        p.drawPixmap(*handle,QPixmap(qembed_findImage("leftrightarrow-small")));
        p.setRasterOp(oldROP);
    }
}

QPointArray  LockedBeatRect::areaPoints() const{
    return QCanvasRectangle::areaPoints();
}


/*!
    \fn LockedBeatRect::setColor(int i)
 */
void LockedBeatRect::setColor(int i)
{
    if(i%2==0) bgColor.setRgb(255,255,220);
    else bgColor.setRgb(220,255,255);
}


/*!
    \fn LockedBeatRect::getHandle()
 */
QRect* LockedBeatRect::getHandle()
{
    return handle;
}


/*!
    \fn LockedBeatRect::setSelected(bool tf)
 */
void LockedBeatRect::setSelected(bool tf)
{
    selected=tf;
    update();
}


/*!
    \fn LockedBeatRect::isSelected()
 */
bool LockedBeatRect::isSelected()
{
    return selected;
}


/*!
    \fn LockedBeatRect::getStartSample()
 */
long LockedBeatRect::getStartSample()
{
    if(startBL) return startBL->getBeatPos();
    else return -1;
}


/*!
    \fn LockedBeatRect::getEndSample()
 */
long LockedBeatRect::getEndSample()
{
    if(endBL) return endBL->getBeatPos();
    else return -1;
}


/*!
    \fn LockedBeatRect::getNb()
 */
int LockedBeatRect::getNb()
{
    return number;
}


/*!
    \fn LockedBeatRect::setNb(int n)
 */
void LockedBeatRect::setNb(int n)
{
    number=n;
}
